/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.Queue;

public class JobQueueInfo
implements Writable {
    static final String EMPTY_INFO = "N/A";
    private String queueName = "";
    private String queueState = Queue.QueueState.RUNNING.getStateName();
    private String schedulingInfo = "N/A";

    public JobQueueInfo() {
    }

    public JobQueueInfo(String queueName, String schedulingInfo) {
        this.queueName = queueName;
        this.schedulingInfo = schedulingInfo;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void setSchedulingInfo(String schedulingInfo) {
        this.schedulingInfo = schedulingInfo != null ? schedulingInfo : EMPTY_INFO;
    }

    public String getSchedulingInfo() {
        return this.schedulingInfo;
    }

    public void setQueueState(String state) {
        this.queueState = state;
    }

    public String getQueueState() {
        return this.queueState;
    }

    public void readFields(DataInput in) throws IOException {
        this.queueName = Text.readString((DataInput)in);
        this.queueState = Text.readString((DataInput)in);
        this.schedulingInfo = Text.readString((DataInput)in);
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.queueName);
        Text.writeString((DataOutput)out, (String)this.queueState);
        Text.writeString((DataOutput)out, (String)this.schedulingInfo);
    }
}

