/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.StatusReporter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.hadoop.util.ReflectionUtils;

public class MultipleOutputs<KEYOUT, VALUEOUT> {
    private static final String MULTIPLE_OUTPUTS = "mapreduce.multipleoutputs";
    private static final String MO_PREFIX = "mapreduce.multipleoutputs.namedOutput.";
    private static final String FORMAT = ".format";
    private static final String KEY = ".key";
    private static final String VALUE = ".value";
    private static final String COUNTERS_ENABLED = "mapreduce.multipleoutputs.counters";
    private static final String COUNTERS_GROUP = MultipleOutputs.class.getName();
    private Map<String, TaskAttemptContext> taskContexts = new HashMap<String, TaskAttemptContext>();
    private TaskInputOutputContext<?, ?, KEYOUT, VALUEOUT> context;
    private Set<String> namedOutputs;
    private Map<String, RecordWriter<?, ?>> recordWriters;
    private boolean countersEnabled;

    private static void checkTokenName(String namedOutput) {
        if (namedOutput == null || namedOutput.length() == 0) {
            throw new IllegalArgumentException("Name cannot be NULL or emtpy");
        }
        for (char ch : namedOutput.toCharArray()) {
            if (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9') continue;
            throw new IllegalArgumentException("Name cannot be have a '" + ch + "' char");
        }
    }

    private static void checkBaseOutputPath(String outputPath) {
        if (outputPath.equals("part")) {
            throw new IllegalArgumentException("output name cannot be 'part'");
        }
    }

    private static void checkNamedOutputName(JobContext job, String namedOutput, boolean alreadyDefined) {
        MultipleOutputs.checkTokenName(namedOutput);
        MultipleOutputs.checkBaseOutputPath(namedOutput);
        List<String> definedChannels = MultipleOutputs.getNamedOutputsList(job);
        if (alreadyDefined && definedChannels.contains(namedOutput)) {
            throw new IllegalArgumentException("Named output '" + namedOutput + "' already alreadyDefined");
        }
        if (!alreadyDefined && !definedChannels.contains(namedOutput)) {
            throw new IllegalArgumentException("Named output '" + namedOutput + "' not defined");
        }
    }

    private static List<String> getNamedOutputsList(JobContext job) {
        ArrayList<String> names = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(job.getConfiguration().get(MULTIPLE_OUTPUTS, ""), " ");
        while (st.hasMoreTokens()) {
            names.add(st.nextToken());
        }
        return names;
    }

    private static Class<? extends OutputFormat<?, ?>> getNamedOutputFormatClass(JobContext job, String namedOutput) {
        return job.getConfiguration().getClass(MO_PREFIX + namedOutput + FORMAT, null, OutputFormat.class);
    }

    private static Class<?> getNamedOutputKeyClass(JobContext job, String namedOutput) {
        return job.getConfiguration().getClass(MO_PREFIX + namedOutput + KEY, null, WritableComparable.class);
    }

    private static Class<? extends Writable> getNamedOutputValueClass(JobContext job, String namedOutput) {
        return job.getConfiguration().getClass(MO_PREFIX + namedOutput + VALUE, null, Writable.class);
    }

    public static void addNamedOutput(Job job, String namedOutput, Class<? extends OutputFormat> outputFormatClass, Class<?> keyClass, Class<?> valueClass) {
        MultipleOutputs.checkNamedOutputName(job, namedOutput, true);
        Configuration conf = job.getConfiguration();
        conf.set(MULTIPLE_OUTPUTS, conf.get(MULTIPLE_OUTPUTS, "") + " " + namedOutput);
        conf.setClass(MO_PREFIX + namedOutput + FORMAT, outputFormatClass, OutputFormat.class);
        conf.setClass(MO_PREFIX + namedOutput + KEY, keyClass, Object.class);
        conf.setClass(MO_PREFIX + namedOutput + VALUE, valueClass, Object.class);
    }

    public static void setCountersEnabled(Job job, boolean enabled) {
        job.getConfiguration().setBoolean(COUNTERS_ENABLED, enabled);
    }

    public static boolean getCountersEnabled(JobContext job) {
        return job.getConfiguration().getBoolean(COUNTERS_ENABLED, false);
    }

    public MultipleOutputs(TaskInputOutputContext<?, ?, KEYOUT, VALUEOUT> context) {
        this.context = context;
        this.namedOutputs = Collections.unmodifiableSet(new HashSet<String>(MultipleOutputs.getNamedOutputsList(context)));
        this.recordWriters = new HashMap();
        this.countersEnabled = MultipleOutputs.getCountersEnabled(context);
    }

    public <K, V> void write(String namedOutput, K key, V value) throws IOException, InterruptedException {
        this.write(namedOutput, key, value, namedOutput);
    }

    public <K, V> void write(String namedOutput, K key, V value, String baseOutputPath) throws IOException, InterruptedException {
        MultipleOutputs.checkNamedOutputName(this.context, namedOutput, false);
        MultipleOutputs.checkBaseOutputPath(baseOutputPath);
        if (!this.namedOutputs.contains(namedOutput)) {
            throw new IllegalArgumentException("Undefined named output '" + namedOutput + "'");
        }
        TaskAttemptContext taskContext = this.getContext(namedOutput);
        this.getRecordWriter(taskContext, baseOutputPath).write(key, value);
    }

    public void write(KEYOUT key, VALUEOUT value, String baseOutputPath) throws IOException, InterruptedException {
        MultipleOutputs.checkBaseOutputPath(baseOutputPath);
        TaskAttemptContextImpl taskContext = new TaskAttemptContextImpl(this.context.getConfiguration(), this.context.getTaskAttemptID(), new WrappedStatusReporter(this.context));
        this.getRecordWriter(taskContext, baseOutputPath).write(key, value);
    }

    private synchronized RecordWriter getRecordWriter(TaskAttemptContext taskContext, String baseFileName) throws IOException, InterruptedException {
        RecordWriter writer = this.recordWriters.get(baseFileName);
        if (writer == null) {
            FileOutputFormat.setOutputName(taskContext, baseFileName);
            try {
                writer = ((OutputFormat)ReflectionUtils.newInstance(taskContext.getOutputFormatClass(), (Configuration)taskContext.getConfiguration())).getRecordWriter(taskContext);
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
            if (this.countersEnabled) {
                writer = new RecordWriterWithCounter(writer, baseFileName, this.context);
            }
            this.recordWriters.put(baseFileName, writer);
        }
        return writer;
    }

    private TaskAttemptContext getContext(String nameOutput) throws IOException {
        TaskAttemptContext taskContext = this.taskContexts.get(nameOutput);
        if (taskContext != null) {
            return taskContext;
        }
        Job job = new Job(new Configuration(this.context.getConfiguration()));
        job.setOutputFormatClass(MultipleOutputs.getNamedOutputFormatClass(this.context, nameOutput));
        job.setOutputKeyClass(MultipleOutputs.getNamedOutputKeyClass(this.context, nameOutput));
        job.setOutputValueClass(MultipleOutputs.getNamedOutputValueClass(this.context, nameOutput));
        taskContext = new TaskAttemptContextImpl(job.getConfiguration(), this.context.getTaskAttemptID(), new WrappedStatusReporter(this.context));
        this.taskContexts.put(nameOutput, taskContext);
        return taskContext;
    }

    public void close() throws IOException, InterruptedException {
        for (RecordWriter<?, ?> writer : this.recordWriters.values()) {
            writer.close(this.context);
        }
    }

    private static class WrappedStatusReporter
    extends StatusReporter {
        TaskAttemptContext context;

        public WrappedStatusReporter(TaskAttemptContext context) {
            this.context = context;
        }

        @Override
        public Counter getCounter(Enum<?> name) {
            return this.context.getCounter(name);
        }

        @Override
        public Counter getCounter(String group, String name) {
            return this.context.getCounter(group, name);
        }

        @Override
        public void progress() {
            this.context.progress();
        }

        @Override
        public void setStatus(String status) {
            this.context.setStatus(status);
        }
    }

    private static class RecordWriterWithCounter
    extends RecordWriter {
        private RecordWriter writer;
        private String counterName;
        private TaskInputOutputContext context;

        public RecordWriterWithCounter(RecordWriter writer, String counterName, TaskInputOutputContext context) {
            this.writer = writer;
            this.counterName = counterName;
            this.context = context;
        }

        public void write(Object key, Object value) throws IOException, InterruptedException {
            this.context.getCounter(COUNTERS_GROUP, this.counterName).increment(1L);
            this.writer.write(key, value);
        }

        @Override
        public void close(TaskAttemptContext context) throws IOException, InterruptedException {
            this.writer.close(context);
        }
    }
}

