/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.log;

import java.util.LinkedList;

public class LinkedStringBuffer {
    private final LinkedList<String> list;
    private final long capacity;
    private int size;

    public LinkedStringBuffer(long capacity) {
        this.capacity = capacity;
        this.list = new LinkedList();
    }

    public synchronized long size() {
        return this.size;
    }

    public synchronized void write(String data) {
        this.list.add(data);
        this.size += data.length();
        while ((long)this.size > this.capacity) {
            String evicted = this.list.remove(0);
            this.size -= evicted.length();
        }
    }

    public synchronized String read() {
        StringBuilder sb = new StringBuilder(this.size);
        for (String s : this.list) {
            sb.append(s);
        }
        return sb.toString();
    }

    public synchronized void clear() {
        this.list.clear();
        this.size = 0;
    }
}

