/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hive.service.cli.FetchOrientation;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.OperationType;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.operation.MetadataOperation;
import org.apache.hive.service.cli.operation.TableTypeMapping;
import org.apache.hive.service.cli.operation.TableTypeMappingFactory;
import org.apache.hive.service.cli.session.HiveSession;

public class GetTablesOperation
extends MetadataOperation {
    private final String catalogName;
    private final String schemaName;
    private final String tableName;
    private final List<String> tableTypes = new ArrayList<String>();
    private final RowSet rowSet = new RowSet();
    private final TableTypeMapping tableTypeMapping;
    private static final TableSchema RESULT_SET_SCHEMA = new TableSchema().addStringColumn("TABLE_CAT", "Catalog name. NULL if not applicable.").addStringColumn("TABLE_SCHEM", "Schema name.").addStringColumn("TABLE_NAME", "Table name.").addStringColumn("TABLE_TYPE", "The table type, e.g. \"TABLE\", \"VIEW\", etc.").addStringColumn("REMARKS", "Comments about the table.");

    protected GetTablesOperation(HiveSession parentSession, String catalogName, String schemaName, String tableName, List<String> tableTypes) {
        super(parentSession, OperationType.GET_TABLES);
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.tableName = tableName;
        String tableMappingStr = this.getParentSession().getHiveConf().getVar(HiveConf.ConfVars.HIVE_SERVER2_TABLE_TYPE_MAPPING);
        this.tableTypeMapping = TableTypeMappingFactory.getTableTypeMapping(tableMappingStr);
        if (tableTypes != null) {
            this.tableTypes.addAll(tableTypes);
        }
    }

    @Override
    public void run() throws HiveSQLException {
        this.setState(OperationState.RUNNING);
        try {
            IMetaStoreClient metastoreClient = this.getParentSession().getMetaStoreClient();
            String schemaPattern = this.convertSchemaPattern(this.schemaName);
            String tablePattern = this.convertIdentifierPattern(this.tableName, true);
            HiveOperation hiveOperation = HiveOperation.SHOWDATABASES;
            String currentDbName = SessionState.get().getCurrentDatabase();
            List dbNames = metastoreClient.getDatabases(schemaPattern);
            List<String> filteredDbNames = this.filterResultSet(dbNames, hiveOperation, currentDbName);
            for (String dbName : filteredDbNames) {
                List tableNames = metastoreClient.getTables(dbName, tablePattern);
                hiveOperation = HiveOperation.SHOWTABLES;
                List<String> filteredTableNames = this.filterResultSet(tableNames, hiveOperation, dbName);
                for (Table table : metastoreClient.getTableObjectsByName(dbName, filteredTableNames)) {
                    Object[] rowData = new Object[]{"", table.getDbName(), table.getTableName(), this.tableTypeMapping.mapToClientType(table.getTableType()), table.getParameters().get("comment")};
                    if (!this.tableTypes.isEmpty() && !this.tableTypes.contains(this.tableTypeMapping.mapToClientType(table.getTableType()))) continue;
                    this.rowSet.addRow(RESULT_SET_SCHEMA, rowData);
                }
            }
            this.setState(OperationState.FINISHED);
        }
        catch (Exception e) {
            this.setState(OperationState.ERROR);
            throw new HiveSQLException(e);
        }
    }

    @Override
    public TableSchema getResultSetSchema() throws HiveSQLException {
        this.assertState(OperationState.FINISHED);
        return RESULT_SET_SCHEMA;
    }

    @Override
    public RowSet getNextRowSet(FetchOrientation orientation, long maxRows) throws HiveSQLException {
        this.assertState(OperationState.FINISHED);
        this.validateDefaultFetchOrientation(orientation);
        if (orientation.equals((Object)FetchOrientation.FETCH_FIRST)) {
            this.rowSet.setStartOffset(0L);
        }
        return this.rowSet.extractSubset((int)maxRows);
    }
}

