/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping;

import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.adapter.DatastoreAdapter;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.util.Localiser;

public final class MappingFactory {
    private static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.Localisation", (ClassLoader)ClassConstants.NUCLEUS_CONTEXT_LOADER);

    private MappingFactory() {
    }

    public static JavaTypeMapping createMapping(Class mappingClass, RDBMSStoreManager storeMgr, String type) {
        JavaTypeMapping mapping = null;
        try {
            mapping = (JavaTypeMapping)mappingClass.newInstance();
        }
        catch (Exception e) {
            throw new NucleusException(LOCALISER.msg("041009", (Object)mappingClass.getName(), (Object)e), (Throwable)e).setFatal();
        }
        mapping.initialize(storeMgr, type);
        return mapping;
    }

    public static JavaTypeMapping createMapping(Class mappingClass, DatastoreAdapter dba, AbstractMemberMetaData mmd, int roleForField, Table table, ClassLoaderResolver clr) {
        JavaTypeMapping mapping = null;
        try {
            mapping = (JavaTypeMapping)mappingClass.newInstance();
        }
        catch (Exception e) {
            throw new NucleusException(LOCALISER.msg("041009", (Object)mappingClass.getName(), (Object)e), (Throwable)e).setFatal();
        }
        if (roleForField >= 0) {
            mapping.setRoleForMember(roleForField);
        }
        mapping.initialize(mmd, table, clr);
        return mapping;
    }
}

