/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public class ClassSize {
    static final Log LOG = LogFactory.getLog(ClassSize.class);
    private static int nrOfRefsPerObj = 2;
    public static final int ARRAY;
    public static final int ARRAYLIST;
    public static final int BYTE_BUFFER;
    public static final int INTEGER;
    public static final int MAP_ENTRY;
    public static final int OBJECT;
    public static final int REFERENCE;
    public static final int STRING;
    public static final int TREEMAP;
    public static final int CONCURRENT_HASHMAP;
    public static final int CONCURRENT_HASHMAP_ENTRY;
    public static final int CONCURRENT_HASHMAP_SEGMENT;
    public static final int CONCURRENT_SKIPLISTMAP;
    public static final int CONCURRENT_SKIPLISTMAP_ENTRY;
    public static final int REENTRANT_LOCK;
    public static final int ATOMIC_LONG;
    public static final int ATOMIC_INTEGER;
    public static final int ATOMIC_BOOLEAN;
    public static final int COPYONWRITE_ARRAYSET;
    public static final int COPYONWRITE_ARRAYLIST;
    public static final int TIMERANGE;
    public static final int TIMERANGE_TRACKER;
    public static final int KEYVALUE_SKIPLIST_SET;
    private static final boolean JDK7;

    private static int[] getSizeCoefficients(Class cl, boolean debug) {
        int primitives = 0;
        int arrays = 0;
        int references = nrOfRefsPerObj;
        int index = 0;
        while (null != cl) {
            Field[] field = cl.getDeclaredFields();
            if (null != field) {
                for (Field aField : field) {
                    if (Modifier.isStatic(aField.getModifiers())) continue;
                    Class<?> fieldClass = aField.getType();
                    if (fieldClass.isArray()) {
                        ++arrays;
                        ++references;
                    } else if (!fieldClass.isPrimitive()) {
                        ++references;
                    } else {
                        String name = fieldClass.getName();
                        if (name.equals("int") || name.equals("I")) {
                            primitives += 4;
                        } else if (name.equals("long") || name.equals("J")) {
                            primitives += 8;
                        } else if (name.equals("boolean") || name.equals("Z")) {
                            ++primitives;
                        } else if (name.equals("short") || name.equals("S")) {
                            primitives += 2;
                        } else if (name.equals("byte") || name.equals("B")) {
                            ++primitives;
                        } else if (name.equals("char") || name.equals("C")) {
                            primitives += 2;
                        } else if (name.equals("float") || name.equals("F")) {
                            primitives += 4;
                        } else if (name.equals("double") || name.equals("D")) {
                            primitives += 8;
                        }
                    }
                    if (debug && LOG.isDebugEnabled()) {
                        LOG.debug((Object)("" + index + " " + aField.getName() + " " + aField.getType()));
                    }
                    ++index;
                }
            }
            cl = cl.getSuperclass();
        }
        return new int[]{primitives, arrays, references};
    }

    private static long estimateBaseFromCoefficients(int[] coeff, boolean debug) {
        long prealign_size = coeff[0] + ClassSize.align(coeff[1] * ARRAY) + coeff[2] * REFERENCE;
        long size = ClassSize.align(prealign_size);
        if (debug && LOG.isDebugEnabled()) {
            LOG.debug((Object)("Primitives=" + coeff[0] + ", arrays=" + coeff[1] + ", references(includes " + nrOfRefsPerObj + " for object overhead)=" + coeff[2] + ", refSize " + REFERENCE + ", size=" + size + ", prealign_size=" + prealign_size));
        }
        return size;
    }

    public static long estimateBase(Class cl, boolean debug) {
        return ClassSize.estimateBaseFromCoefficients(ClassSize.getSizeCoefficients(cl, debug), debug);
    }

    public static int align(int num) {
        return (int)ClassSize.align((long)num);
    }

    public static long align(long num) {
        return num + 7L >> 3 << 3;
    }

    public static boolean is32BitJVM() {
        return System.getProperty("sun.arch.data.model").equals("32");
    }

    static {
        String version = System.getProperty("java.version");
        if (!version.matches("\\d\\.\\d\\..*")) {
            throw new RuntimeException("Unexpected version format: " + version);
        }
        int major = version.charAt(0) - 48;
        int minor = version.charAt(2) - 48;
        JDK7 = major == 1 && minor == 7;
        REFERENCE = ClassSize.is32BitJVM() ? 4 : 8;
        OBJECT = 2 * REFERENCE;
        ARRAY = ClassSize.align(3 * REFERENCE);
        ARRAYLIST = ClassSize.align(OBJECT + ClassSize.align(REFERENCE) + ClassSize.align(ARRAY) + 8);
        BYTE_BUFFER = ClassSize.align(OBJECT + ClassSize.align(REFERENCE) + ClassSize.align(ARRAY) + 20 + 3 + 8);
        INTEGER = ClassSize.align(OBJECT + 4);
        MAP_ENTRY = ClassSize.align(OBJECT + 5 * REFERENCE + 1);
        TREEMAP = ClassSize.align(OBJECT + 8 + ClassSize.align(7 * REFERENCE));
        STRING = (int)ClassSize.estimateBase(String.class, false);
        CONCURRENT_HASHMAP = (int)ClassSize.estimateBase(ConcurrentHashMap.class, false);
        CONCURRENT_HASHMAP_ENTRY = ClassSize.align(REFERENCE + OBJECT + 3 * REFERENCE + 8);
        CONCURRENT_HASHMAP_SEGMENT = ClassSize.align(REFERENCE + OBJECT + 12 + 4 + ARRAY);
        CONCURRENT_SKIPLISTMAP = ClassSize.align(4 + OBJECT + 8 * REFERENCE);
        CONCURRENT_SKIPLISTMAP_ENTRY = ClassSize.align(ClassSize.align(OBJECT + 3 * REFERENCE) + ClassSize.align((OBJECT + 3 * REFERENCE) / 2));
        REENTRANT_LOCK = ClassSize.align(OBJECT + 3 * REFERENCE);
        ATOMIC_LONG = ClassSize.align(OBJECT + 8);
        ATOMIC_INTEGER = ClassSize.align(OBJECT + 4);
        ATOMIC_BOOLEAN = ClassSize.align(OBJECT + 1);
        COPYONWRITE_ARRAYSET = ClassSize.align(OBJECT + REFERENCE);
        COPYONWRITE_ARRAYLIST = ClassSize.align(OBJECT + 2 * REFERENCE + ARRAY);
        TIMERANGE = ClassSize.align(OBJECT + 16 + 1);
        TIMERANGE_TRACKER = ClassSize.align(OBJECT + 16);
        KEYVALUE_SKIPLIST_SET = ClassSize.align(OBJECT + REFERENCE);
    }
}

