/*
 * Decompiled with CFR 0.152.
 */
package org.cloudera.htrace.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.cloudera.htrace.Span;
import org.cloudera.htrace.TimelineAnnotation;

public class MilliSpan
implements Span {
    private static Random rand = new Random();
    private long start;
    private long stop;
    private final String description;
    private final long traceId;
    private final long parentSpanId;
    private final long spanId;
    private Map<byte[], byte[]> traceInfo = null;
    private final String processId;
    private List<TimelineAnnotation> timeline = null;

    @Override
    public Span child(String description) {
        return new MilliSpan(description, this.traceId, this.spanId, rand.nextLong(), this.processId);
    }

    public MilliSpan(String description, long traceId, long parentSpanId, long spanId, String processId) {
        this.description = description;
        this.traceId = traceId;
        this.parentSpanId = parentSpanId;
        this.spanId = spanId;
        this.start = System.currentTimeMillis();
        this.stop = 0L;
        this.processId = processId;
    }

    @Override
    public synchronized void stop() {
        if (this.start == 0L) {
            throw new IllegalStateException("Span for " + this.description + " has not been started");
        }
        this.stop = System.currentTimeMillis();
    }

    protected long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    @Override
    public synchronized boolean isRunning() {
        return this.start != 0L && this.stop == 0L;
    }

    @Override
    public synchronized long getAccumulatedMillis() {
        if (this.start == 0L) {
            return 0L;
        }
        if (this.stop > 0L) {
            return this.stop - this.start;
        }
        return this.currentTimeMillis() - this.start;
    }

    @Override
    public String toString() {
        return "start=" + this.start + "\nstop=" + this.stop + "\nparentId=" + this.parentSpanId + "\ndescription=" + this.description + "\nspanId=" + this.spanId + "\ntraceId=" + this.traceId + "\ntraceInfo=" + this.traceInfo + "\nprocessId=" + this.processId + "\ntimeline=" + this.timeline;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public long getSpanId() {
        return this.spanId;
    }

    @Override
    public long getParentId() {
        return this.parentSpanId;
    }

    @Override
    public long getTraceId() {
        return this.traceId;
    }

    @Override
    public long getStartTimeMillis() {
        return this.start;
    }

    @Override
    public long getStopTimeMillis() {
        return this.stop;
    }

    @Override
    public void addKVAnnotation(byte[] key, byte[] value) {
        if (this.traceInfo == null) {
            this.traceInfo = new HashMap<byte[], byte[]>();
        }
        this.traceInfo.put(key, value);
    }

    @Override
    public void addTimelineAnnotation(String msg) {
        if (this.timeline == null) {
            this.timeline = new ArrayList<TimelineAnnotation>();
        }
        this.timeline.add(new TimelineAnnotation(System.currentTimeMillis(), msg));
    }

    @Override
    public Map<byte[], byte[]> getKVAnnotations() {
        if (this.traceInfo == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.traceInfo);
    }

    @Override
    public List<TimelineAnnotation> getTimelineAnnotations() {
        if (this.timeline == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.timeline);
    }

    @Override
    public String getProcessId() {
        return this.processId;
    }
}

