/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SchedulerApplication {
    private Queue queue;
    private final String user;
    private SchedulerApplicationAttempt currentAttempt;

    public SchedulerApplication(Queue queue, String user) {
        this.queue = queue;
        this.user = user;
    }

    public Queue getQueue() {
        return this.queue;
    }

    public void setQueue(Queue queue) {
        this.queue = queue;
    }

    public String getUser() {
        return this.user;
    }

    public SchedulerApplicationAttempt getCurrentAppAttempt() {
        return this.currentAttempt;
    }

    public void setCurrentAppAttempt(SchedulerApplicationAttempt currentAttempt) {
        this.currentAttempt = currentAttempt;
    }

    public void stop(RMAppState rmAppFinalState) {
        this.queue.getMetrics().finishApp(this.user, rmAppFinalState);
    }
}

