/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerReservedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeCleanContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ActiveUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AppSchedulingInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SchedulerApplicationAttempt {
    private static final Log LOG = LogFactory.getLog(SchedulerApplicationAttempt.class);
    protected final AppSchedulingInfo appSchedulingInfo;
    protected Map<ContainerId, RMContainer> liveContainers = new HashMap<ContainerId, RMContainer>();
    protected final Map<Priority, Map<NodeId, RMContainer>> reservedContainers = new HashMap<Priority, Map<NodeId, RMContainer>>();
    private final Multiset<Priority> reReservations = HashMultiset.create();
    protected final Resource currentReservation = Resource.newInstance((int)0, (int)0);
    private Resource resourceLimit = Resource.newInstance((int)0, (int)0);
    protected Resource currentConsumption = Resource.newInstance((int)0, (int)0);
    protected List<RMContainer> newlyAllocatedContainers = new ArrayList<RMContainer>();
    Multiset<Priority> schedulingOpportunities = HashMultiset.create();
    protected Map<Priority, Long> lastScheduledContainer = new HashMap<Priority, Long>();
    protected Queue queue;
    protected boolean isStopped = false;
    protected final RMContext rmContext;

    public SchedulerApplicationAttempt(ApplicationAttemptId applicationAttemptId, String user, Queue queue, ActiveUsersManager activeUsersManager, RMContext rmContext) {
        this.rmContext = rmContext;
        this.appSchedulingInfo = new AppSchedulingInfo(applicationAttemptId, user, queue, activeUsersManager);
        this.queue = queue;
    }

    public synchronized Collection<RMContainer> getLiveContainers() {
        return new ArrayList<RMContainer>(this.liveContainers.values());
    }

    public boolean isPending() {
        return this.appSchedulingInfo.isPending();
    }

    public ApplicationAttemptId getApplicationAttemptId() {
        return this.appSchedulingInfo.getApplicationAttemptId();
    }

    public ApplicationId getApplicationId() {
        return this.appSchedulingInfo.getApplicationId();
    }

    public String getUser() {
        return this.appSchedulingInfo.getUser();
    }

    public Map<String, ResourceRequest> getResourceRequests(Priority priority) {
        return this.appSchedulingInfo.getResourceRequests(priority);
    }

    public int getNewContainerId() {
        return this.appSchedulingInfo.getNewContainerId();
    }

    public Collection<Priority> getPriorities() {
        return this.appSchedulingInfo.getPriorities();
    }

    public ResourceRequest getResourceRequest(Priority priority, String resourceName) {
        return this.appSchedulingInfo.getResourceRequest(priority, resourceName);
    }

    public synchronized int getTotalRequiredResources(Priority priority) {
        return this.getResourceRequest(priority, "*").getNumContainers();
    }

    public Resource getResource(Priority priority) {
        return this.appSchedulingInfo.getResource(priority);
    }

    public String getQueueName() {
        return this.appSchedulingInfo.getQueueName();
    }

    public synchronized RMContainer getRMContainer(ContainerId id) {
        return this.liveContainers.get(id);
    }

    protected synchronized void resetReReservations(Priority priority) {
        this.reReservations.setCount((Object)priority, 0);
    }

    protected synchronized void addReReservation(Priority priority) {
        this.reReservations.add((Object)priority);
    }

    public synchronized int getReReservations(Priority priority) {
        return this.reReservations.count((Object)priority);
    }

    @InterfaceStability.Stable
    @InterfaceAudience.Private
    public synchronized Resource getCurrentReservation() {
        return this.currentReservation;
    }

    public Queue getQueue() {
        return this.queue;
    }

    public synchronized void updateResourceRequests(List<ResourceRequest> requests) {
        if (!this.isStopped) {
            this.appSchedulingInfo.updateResourceRequests(requests);
        }
    }

    public synchronized void stop(RMAppAttemptState rmAppAttemptFinalState) {
        this.isStopped = true;
        this.appSchedulingInfo.stop(rmAppAttemptFinalState);
    }

    public synchronized boolean isStopped() {
        return this.isStopped;
    }

    public synchronized List<RMContainer> getReservedContainers() {
        ArrayList<RMContainer> reservedContainers = new ArrayList<RMContainer>();
        for (Map.Entry<Priority, Map<NodeId, RMContainer>> e : this.reservedContainers.entrySet()) {
            reservedContainers.addAll(e.getValue().values());
        }
        return reservedContainers;
    }

    public synchronized RMContainer reserve(SchedulerNode node, Priority priority, RMContainer rmContainer, Container container) {
        if (rmContainer == null) {
            rmContainer = new RMContainerImpl(container, this.getApplicationAttemptId(), node.getNodeID(), this.rmContext.getDispatcher().getEventHandler(), this.rmContext.getContainerAllocationExpirer());
            Resources.addTo((Resource)this.currentReservation, (Resource)container.getResource());
            this.resetReReservations(priority);
        } else {
            this.addReReservation(priority);
        }
        rmContainer.handle((Event)new RMContainerReservedEvent(container.getId(), container.getResource(), node.getNodeID(), priority));
        Map<NodeId, RMContainer> reservedContainers = this.reservedContainers.get(priority);
        if (reservedContainers == null) {
            reservedContainers = new HashMap<NodeId, RMContainer>();
            this.reservedContainers.put(priority, reservedContainers);
        }
        reservedContainers.put(node.getNodeID(), rmContainer);
        LOG.info((Object)("Application " + this.getApplicationId() + " reserved container " + rmContainer + " on node " + node + ", currently has " + reservedContainers.size() + " at priority " + priority + "; currentReservation " + this.currentReservation.getMemory()));
        return rmContainer;
    }

    public synchronized boolean isReserved(SchedulerNode node, Priority priority) {
        Map<NodeId, RMContainer> reservedContainers = this.reservedContainers.get(priority);
        if (reservedContainers != null) {
            return reservedContainers.containsKey(node.getNodeID());
        }
        return false;
    }

    public synchronized void setHeadroom(Resource globalLimit) {
        this.resourceLimit = globalLimit;
    }

    public synchronized Resource getHeadroom() {
        if (this.resourceLimit.getMemory() < 0) {
            this.resourceLimit.setMemory(0);
        }
        return this.resourceLimit;
    }

    public synchronized int getNumReservedContainers(Priority priority) {
        Map<NodeId, RMContainer> reservedContainers = this.reservedContainers.get(priority);
        return reservedContainers == null ? 0 : reservedContainers.size();
    }

    public synchronized void containerLaunchedOnNode(ContainerId containerId, NodeId nodeId) {
        RMContainer rmContainer = this.getRMContainer(containerId);
        if (rmContainer == null) {
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMNodeCleanContainerEvent(nodeId, containerId));
            return;
        }
        rmContainer.handle((Event)new RMContainerEvent(containerId, RMContainerEventType.LAUNCHED));
    }

    public synchronized void showRequests() {
        if (LOG.isDebugEnabled()) {
            for (Priority priority : this.getPriorities()) {
                Map<String, ResourceRequest> requests = this.getResourceRequests(priority);
                if (requests == null) continue;
                LOG.debug((Object)("showRequests: application=" + this.getApplicationId() + " headRoom=" + this.getHeadroom() + " currentConsumption=" + this.currentConsumption.getMemory()));
                for (ResourceRequest request : requests.values()) {
                    LOG.debug((Object)("showRequests: application=" + this.getApplicationId() + " request=" + request));
                }
            }
        }
    }

    public Resource getCurrentConsumption() {
        return this.currentConsumption;
    }

    public synchronized List<Container> pullNewlyAllocatedContainers() {
        ArrayList<Container> returnContainerList = new ArrayList<Container>(this.newlyAllocatedContainers.size());
        for (RMContainer rmContainer : this.newlyAllocatedContainers) {
            rmContainer.handle((Event)new RMContainerEvent(rmContainer.getContainerId(), RMContainerEventType.ACQUIRED));
            Container container = rmContainer.getContainer();
            rmContainer.getContainer().setContainerToken(this.rmContext.getContainerTokenSecretManager().createContainerToken(rmContainer.getContainerId(), container.getNodeId(), this.getUser(), container.getResource()));
            returnContainerList.add(rmContainer.getContainer());
        }
        this.newlyAllocatedContainers.clear();
        return returnContainerList;
    }

    public synchronized void updateBlacklist(List<String> blacklistAdditions, List<String> blacklistRemovals) {
        if (!this.isStopped) {
            this.appSchedulingInfo.updateBlacklist(blacklistAdditions, blacklistRemovals);
        }
    }

    public boolean isBlacklisted(String resourceName) {
        return this.appSchedulingInfo.isBlacklisted(resourceName);
    }

    public synchronized void addSchedulingOpportunity(Priority priority) {
        this.schedulingOpportunities.setCount((Object)priority, this.schedulingOpportunities.count((Object)priority) + 1);
    }

    public synchronized void subtractSchedulingOpportunity(Priority priority) {
        int count = this.schedulingOpportunities.count((Object)priority) - 1;
        this.schedulingOpportunities.setCount((Object)priority, Math.max(count, 0));
    }

    public synchronized int getSchedulingOpportunities(Priority priority) {
        return this.schedulingOpportunities.count((Object)priority);
    }

    public synchronized void resetSchedulingOpportunities(Priority priority) {
        this.resetSchedulingOpportunities(priority, System.currentTimeMillis());
    }

    public synchronized void resetSchedulingOpportunities(Priority priority, long currentTimeMs) {
        this.lastScheduledContainer.put(priority, currentTimeMs);
        this.schedulingOpportunities.setCount((Object)priority, 0);
    }

    public synchronized ApplicationResourceUsageReport getResourceUsageReport() {
        return ApplicationResourceUsageReport.newInstance((int)this.liveContainers.size(), (int)this.reservedContainers.size(), (Resource)Resources.clone((Resource)this.currentConsumption), (Resource)Resources.clone((Resource)this.currentReservation), (Resource)Resources.add((Resource)this.currentConsumption, (Resource)this.currentReservation));
    }

    public synchronized Map<ContainerId, RMContainer> getLiveContainersMap() {
        return this.liveContainers;
    }

    public synchronized Resource getResourceLimit() {
        return this.resourceLimit;
    }

    public synchronized Map<Priority, Long> getLastScheduledContainer() {
        return this.lastScheduledContainer;
    }

    public synchronized void transferStateFromPreviousAttempt(SchedulerApplicationAttempt appAttempt) {
        this.liveContainers = appAttempt.getLiveContainersMap();
        this.currentConsumption = appAttempt.getCurrentConsumption();
        this.resourceLimit = appAttempt.getResourceLimit();
        this.lastScheduledContainer = appAttempt.getLastScheduledContainer();
        this.appSchedulingInfo.transferStateFromPreviousAppSchedulingInfo(appAttempt.appSchedulingInfo);
    }

    public void move(Queue newQueue) {
        QueueMetrics oldMetrics = this.queue.getMetrics();
        QueueMetrics newMetrics = newQueue.getMetrics();
        String user = this.getUser();
        for (RMContainer rMContainer : this.liveContainers.values()) {
            Resource resource = rMContainer.getContainer().getResource();
            oldMetrics.releaseResources(user, 1, resource);
            newMetrics.allocateResources(user, 1, resource, false);
        }
        for (Map map : this.reservedContainers.values()) {
            for (RMContainer reservedContainer : map.values()) {
                Resource resource = reservedContainer.getReservedResource();
                oldMetrics.unreserveResource(user, resource);
                newMetrics.reserveResource(user, resource);
            }
        }
        this.appSchedulingInfo.move(newQueue);
        this.queue = newQueue;
    }
}

