/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.http.HtmlQuoting;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebApp;
import org.apache.hadoop.yarn.webapp.Dispatcher;
import org.apache.hadoop.yarn.webapp.Router;
import org.apache.hadoop.yarn.webapp.WebApp;

@Singleton
@InterfaceAudience.LimitedPrivate(value={"YARN", "MapReduce"})
public class RMDispatcher
extends Dispatcher {
    private static final long serialVersionUID = 1L;

    @Inject
    RMDispatcher(WebApp webApp, Injector injector, Router router) {
        super(webApp, injector, router);
    }

    public void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String redirectPath;
        res.setCharacterEncoding("UTF-8");
        String uri = HtmlQuoting.quoteHtmlChars((String)req.getRequestURI());
        if (uri == null) {
            uri = "/";
        }
        RMWebApp rmWebApp = (RMWebApp)this.webApp;
        rmWebApp.checkIfStandbyRM();
        if (rmWebApp.isStandby() && !uri.equals("/" + rmWebApp.name() + "/cluster") && (redirectPath = rmWebApp.getRedirectPath() + uri) != null && !redirectPath.isEmpty()) {
            String redirectMsg = "This is standby RM. Redirecting to the current active RM: " + redirectPath;
            res.addHeader("Refresh", "3; url=" + redirectPath);
            PrintWriter out = res.getWriter();
            out.println(redirectMsg);
            return;
        }
        super.service(req, res);
    }
}

