/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.StorageType;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockCollection;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementStatus;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementStatusDefault;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.namenode.FSClusterStats;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.net.NodeBase;
import org.apache.hadoop.util.Time;

@InterfaceAudience.Private
public class BlockPlacementPolicyDefault
extends BlockPlacementPolicy {
    private static final String enableDebugLogging = "For more information, please enable DEBUG log level on " + BlockPlacementPolicy.class.getName();
    private static final ThreadLocal<StringBuilder> debugLoggingBuilder = new ThreadLocal<StringBuilder>(){

        @Override
        protected StringBuilder initialValue() {
            return new StringBuilder();
        }
    };
    protected boolean considerLoad;
    private boolean preferLocalNode = true;
    protected NetworkTopology clusterMap;
    private FSClusterStats stats;
    protected long heartbeatInterval;
    private long staleInterval;
    protected int tolerateHeartbeatMultiplier;

    protected BlockPlacementPolicyDefault(Configuration conf, FSClusterStats stats, NetworkTopology clusterMap) {
        this.initialize(conf, stats, clusterMap);
    }

    protected BlockPlacementPolicyDefault() {
    }

    @Override
    public void initialize(Configuration conf, FSClusterStats stats, NetworkTopology clusterMap) {
        this.considerLoad = conf.getBoolean("dfs.namenode.replication.considerLoad", true);
        this.stats = stats;
        this.clusterMap = clusterMap;
        this.heartbeatInterval = conf.getLong("dfs.heartbeat.interval", 3L) * 1000L;
        this.tolerateHeartbeatMultiplier = conf.getInt("dfs.namenode.tolerate.heartbeat.multiplier", 4);
        this.staleInterval = conf.getLong("dfs.namenode.stale.datanode.interval", 30000L);
    }

    @Override
    public DatanodeStorageInfo[] chooseTarget(String srcPath, int numOfReplicas, Node writer, List<DatanodeStorageInfo> chosenNodes, boolean returnChosenNodes, Set<Node> excludedNodes, long blocksize, StorageType storageType) {
        return this.chooseTarget(numOfReplicas, writer, chosenNodes, returnChosenNodes, excludedNodes, blocksize, storageType);
    }

    @Override
    DatanodeStorageInfo[] chooseTarget(String src, int numOfReplicas, Node writer, Set<Node> excludedNodes, long blocksize, List<DatanodeDescriptor> favoredNodes, StorageType storageType) {
        try {
            if (favoredNodes == null || favoredNodes.size() == 0) {
                return this.chooseTarget(src, numOfReplicas, writer, new ArrayList<DatanodeStorageInfo>(numOfReplicas), false, excludedNodes, blocksize, storageType);
            }
            HashSet<Node> favoriteAndExcludedNodes = excludedNodes == null ? new HashSet<Node>() : new HashSet<Node>(excludedNodes);
            ArrayList<DatanodeStorageInfo> results = new ArrayList<DatanodeStorageInfo>();
            boolean avoidStaleNodes = this.stats != null && this.stats.isAvoidingStaleDataNodesForWrite();
            for (int i = 0; i < Math.min(favoredNodes.size(), numOfReplicas); ++i) {
                DatanodeDescriptor favoredNode = favoredNodes.get(i);
                DatanodeStorageInfo target = this.chooseLocalStorage(favoredNode, favoriteAndExcludedNodes, blocksize, this.getMaxNodesPerRack(results.size(), numOfReplicas)[1], results, avoidStaleNodes, storageType);
                if (target == null) {
                    LOG.warn((Object)("Could not find a target for file " + src + " with favored node " + favoredNode));
                    continue;
                }
                favoriteAndExcludedNodes.add(target.getDatanodeDescriptor());
            }
            if (results.size() < numOfReplicas) {
                DatanodeStorageInfo[] remainingTargets = this.chooseTarget(src, numOfReplicas -= results.size(), writer, results, false, favoriteAndExcludedNodes, blocksize, storageType);
                for (int i = 0; i < remainingTargets.length; ++i) {
                    results.add(remainingTargets[i]);
                }
            }
            return this.getPipeline(writer, results.toArray(new DatanodeStorageInfo[results.size()]));
        }
        catch (BlockPlacementPolicy.NotEnoughReplicasException nr) {
            return this.chooseTarget(src, numOfReplicas, writer, new ArrayList<DatanodeStorageInfo>(numOfReplicas), false, excludedNodes, blocksize, storageType);
        }
    }

    private DatanodeStorageInfo[] chooseTarget(int numOfReplicas, Node writer, List<DatanodeStorageInfo> chosenStorage, boolean returnChosenNodes, Set<Node> excludedNodes, long blocksize, StorageType storageType) {
        if (numOfReplicas == 0 || this.clusterMap.getNumOfLeaves() == 0) {
            return DatanodeStorageInfo.EMPTY_ARRAY;
        }
        if (excludedNodes == null) {
            excludedNodes = new HashSet<Node>();
        }
        int[] result = this.getMaxNodesPerRack(chosenStorage.size(), numOfReplicas);
        numOfReplicas = result[0];
        int maxNodesPerRack = result[1];
        ArrayList<DatanodeStorageInfo> results = new ArrayList<DatanodeStorageInfo>(chosenStorage);
        for (DatanodeStorageInfo storage : chosenStorage) {
            this.addToExcludedNodes(storage.getDatanodeDescriptor(), excludedNodes);
        }
        if (!this.clusterMap.contains(writer)) {
            writer = null;
        }
        boolean avoidStaleNodes = this.stats != null && this.stats.isAvoidingStaleDataNodesForWrite();
        Node localNode = this.chooseTarget(numOfReplicas, writer, excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageType);
        if (!returnChosenNodes) {
            results.removeAll(chosenStorage);
        }
        return this.getPipeline(writer == null ? localNode : writer, results.toArray(new DatanodeStorageInfo[results.size()]));
    }

    private int[] getMaxNodesPerRack(int numOfChosen, int numOfReplicas) {
        int totalNumOfReplicas = numOfChosen + numOfReplicas;
        int clusterSize = this.clusterMap.getNumOfLeaves();
        if (totalNumOfReplicas > clusterSize) {
            numOfReplicas -= totalNumOfReplicas - clusterSize;
            totalNumOfReplicas = clusterSize;
        }
        int maxNodesPerRack = (totalNumOfReplicas - 1) / this.clusterMap.getNumOfRacks() + 2;
        return new int[]{numOfReplicas, maxNodesPerRack};
    }

    private Node chooseTarget(int numOfReplicas, Node writer, Set<Node> excludedNodes, long blocksize, int maxNodesPerRack, List<DatanodeStorageInfo> results, boolean avoidStaleNodes, StorageType storageType) {
        block17: {
            boolean newBlock;
            if (numOfReplicas == 0 || this.clusterMap.getNumOfLeaves() == 0) {
                return writer;
            }
            int totalReplicasExpected = numOfReplicas + results.size();
            int numOfResults = results.size();
            boolean bl = newBlock = numOfResults == 0;
            if (!(writer != null && writer instanceof DatanodeDescriptor || newBlock)) {
                writer = results.get(0).getDatanodeDescriptor();
            }
            HashSet<Node> oldExcludedNodes = avoidStaleNodes ? new HashSet<Node>(excludedNodes) : null;
            try {
                if (numOfResults == 0) {
                    writer = this.chooseLocalStorage(writer, excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageType).getDatanodeDescriptor();
                    if (--numOfReplicas == 0) {
                        return writer;
                    }
                }
                DatanodeDescriptor dn0 = results.get(0).getDatanodeDescriptor();
                if (numOfResults <= 1) {
                    this.chooseRemoteRack(1, dn0, excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageType);
                    if (--numOfReplicas == 0) {
                        return writer;
                    }
                }
                if (numOfResults <= 2) {
                    DatanodeDescriptor dn1 = results.get(1).getDatanodeDescriptor();
                    if (this.clusterMap.isOnSameRack((Node)dn0, (Node)dn1)) {
                        this.chooseRemoteRack(1, dn0, excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageType);
                    } else if (newBlock) {
                        this.chooseLocalRack(dn1, excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageType);
                    } else {
                        this.chooseLocalRack(writer, excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageType);
                    }
                    if (--numOfReplicas == 0) {
                        return writer;
                    }
                }
                this.chooseRandom(numOfReplicas, "", excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageType);
            }
            catch (BlockPlacementPolicy.NotEnoughReplicasException e) {
                String message = "Failed to place enough replicas, still in need of " + (totalReplicasExpected - results.size()) + " to reach " + totalReplicasExpected + ".";
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)message, (Throwable)e);
                } else {
                    LOG.warn((Object)(message + " " + e.getMessage()));
                }
                if (!avoidStaleNodes) break block17;
                for (DatanodeStorageInfo resultStorage : results) {
                    this.addToExcludedNodes(resultStorage.getDatanodeDescriptor(), oldExcludedNodes);
                }
                numOfReplicas = totalReplicasExpected - results.size();
                return this.chooseTarget(numOfReplicas, writer, oldExcludedNodes, blocksize, maxNodesPerRack, results, false, storageType);
            }
        }
        return writer;
    }

    protected DatanodeStorageInfo chooseLocalStorage(Node localMachine, Set<Node> excludedNodes, long blocksize, int maxNodesPerRack, List<DatanodeStorageInfo> results, boolean avoidStaleNodes, StorageType storageType) throws BlockPlacementPolicy.NotEnoughReplicasException {
        if (localMachine == null) {
            return this.chooseRandom("", excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageType);
        }
        if (this.preferLocalNode && localMachine instanceof DatanodeDescriptor) {
            DatanodeDescriptor localDatanode = (DatanodeDescriptor)localMachine;
            if (excludedNodes.add(localMachine)) {
                for (DatanodeStorageInfo localStorage : DFSUtil.shuffle(localDatanode.getStorageInfos())) {
                    if (this.addIfIsGoodTarget(localStorage, excludedNodes, blocksize, maxNodesPerRack, false, results, avoidStaleNodes, storageType) < 0) continue;
                    return localStorage;
                }
            }
        }
        return this.chooseLocalRack(localMachine, excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageType);
    }

    protected int addToExcludedNodes(DatanodeDescriptor localMachine, Set<Node> excludedNodes) {
        return excludedNodes.add(localMachine) ? 1 : 0;
    }

    protected DatanodeStorageInfo chooseLocalRack(Node localMachine, Set<Node> excludedNodes, long blocksize, int maxNodesPerRack, List<DatanodeStorageInfo> results, boolean avoidStaleNodes, StorageType storageType) throws BlockPlacementPolicy.NotEnoughReplicasException {
        if (localMachine == null) {
            return this.chooseRandom("", excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageType);
        }
        try {
            return this.chooseRandom(localMachine.getNetworkLocation(), excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageType);
        }
        catch (BlockPlacementPolicy.NotEnoughReplicasException e1) {
            DatanodeInfo newLocal = null;
            for (DatanodeStorageInfo resultStorage : results) {
                DatanodeDescriptor nextNode = resultStorage.getDatanodeDescriptor();
                if (nextNode == localMachine) continue;
                newLocal = nextNode;
                break;
            }
            if (newLocal != null) {
                try {
                    return this.chooseRandom(newLocal.getNetworkLocation(), excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageType);
                }
                catch (BlockPlacementPolicy.NotEnoughReplicasException e2) {
                    return this.chooseRandom("", excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageType);
                }
            }
            return this.chooseRandom("", excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageType);
        }
    }

    protected void chooseRemoteRack(int numOfReplicas, DatanodeDescriptor localMachine, Set<Node> excludedNodes, long blocksize, int maxReplicasPerRack, List<DatanodeStorageInfo> results, boolean avoidStaleNodes, StorageType storageType) throws BlockPlacementPolicy.NotEnoughReplicasException {
        int oldNumOfReplicas = results.size();
        try {
            this.chooseRandom(numOfReplicas, "~" + localMachine.getNetworkLocation(), excludedNodes, blocksize, maxReplicasPerRack, results, avoidStaleNodes, storageType);
        }
        catch (BlockPlacementPolicy.NotEnoughReplicasException e) {
            this.chooseRandom(numOfReplicas - (results.size() - oldNumOfReplicas), localMachine.getNetworkLocation(), excludedNodes, blocksize, maxReplicasPerRack, results, avoidStaleNodes, storageType);
        }
    }

    protected DatanodeStorageInfo chooseRandom(String scope, Set<Node> excludedNodes, long blocksize, int maxNodesPerRack, List<DatanodeStorageInfo> results, boolean avoidStaleNodes, StorageType storageType) throws BlockPlacementPolicy.NotEnoughReplicasException {
        return this.chooseRandom(1, scope, excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageType);
    }

    protected DatanodeStorageInfo chooseRandom(int numOfReplicas, String scope, Set<Node> excludedNodes, long blocksize, int maxNodesPerRack, List<DatanodeStorageInfo> results, boolean avoidStaleNodes, StorageType storageType) throws BlockPlacementPolicy.NotEnoughReplicasException {
        int numOfAvailableNodes = this.clusterMap.countNumOfAvailableNodes(scope, excludedNodes);
        StringBuilder builder = null;
        if (LOG.isDebugEnabled()) {
            builder = debugLoggingBuilder.get();
            builder.setLength(0);
            builder.append("[");
        }
        boolean badTarget = false;
        DatanodeStorageInfo firstChosen = null;
        while (numOfReplicas > 0 && numOfAvailableNodes > 0) {
            int i;
            DatanodeDescriptor chosenNode = (DatanodeDescriptor)this.clusterMap.chooseRandom(scope);
            if (!excludedNodes.add(chosenNode)) continue;
            --numOfAvailableNodes;
            DatanodeStorageInfo[] storages = DFSUtil.shuffle(chosenNode.getStorageInfos());
            for (i = 0; i < storages.length; ++i) {
                int newExcludedNodes = this.addIfIsGoodTarget(storages[i], excludedNodes, blocksize, maxNodesPerRack, this.considerLoad, results, avoidStaleNodes, storageType);
                if (newExcludedNodes < 0) continue;
                --numOfReplicas;
                if (firstChosen == null) {
                    firstChosen = storages[i];
                }
                numOfAvailableNodes -= newExcludedNodes;
                break;
            }
            badTarget = i == storages.length;
        }
        if (numOfReplicas > 0) {
            String detail = enableDebugLogging;
            if (LOG.isDebugEnabled()) {
                if (badTarget && builder != null) {
                    detail = builder.append("]").toString();
                    builder.setLength(0);
                } else {
                    detail = "";
                }
            }
            throw new BlockPlacementPolicy.NotEnoughReplicasException(detail);
        }
        return firstChosen;
    }

    int addIfIsGoodTarget(DatanodeStorageInfo storage, Set<Node> excludedNodes, long blockSize, int maxNodesPerRack, boolean considerLoad, List<DatanodeStorageInfo> results, boolean avoidStaleNodes, StorageType storageType) {
        if (this.isGoodTarget(storage, blockSize, maxNodesPerRack, considerLoad, results, avoidStaleNodes, storageType)) {
            results.add(storage);
            return this.addToExcludedNodes(storage.getDatanodeDescriptor(), excludedNodes);
        }
        return -1;
    }

    private static void logNodeIsNotChosen(DatanodeStorageInfo storage, String reason) {
        if (LOG.isDebugEnabled()) {
            DatanodeDescriptor node = storage.getDatanodeDescriptor();
            debugLoggingBuilder.get().append(node).append(": ").append("Storage ").append(storage).append("at node ").append(NodeBase.getPath((Node)node)).append(" is not chosen because ").append(reason);
        }
    }

    private boolean isGoodTarget(DatanodeStorageInfo storage, long blockSize, int maxTargetPerRack, boolean considerLoad, List<DatanodeStorageInfo> results, boolean avoidStaleNodes, StorageType storageType) {
        if (storage.getStorageType() != storageType) {
            BlockPlacementPolicyDefault.logNodeIsNotChosen(storage, "storage types do not match, where the expected storage type is " + (Object)((Object)storageType));
            return false;
        }
        if (storage.getState() == DatanodeStorage.State.READ_ONLY_SHARED) {
            BlockPlacementPolicyDefault.logNodeIsNotChosen(storage, "storage is read-only");
            return false;
        }
        DatanodeDescriptor node = storage.getDatanodeDescriptor();
        if (node.isDecommissionInProgress() || node.isDecommissioned()) {
            BlockPlacementPolicyDefault.logNodeIsNotChosen(storage, "the node is (being) decommissioned ");
            return false;
        }
        if (avoidStaleNodes && node.isStale(this.staleInterval)) {
            BlockPlacementPolicyDefault.logNodeIsNotChosen(storage, "the node is stale ");
            return false;
        }
        long requiredSize = blockSize * (long)HdfsConstants.MIN_BLOCKS_FOR_WRITE;
        long scheduledSize = blockSize * (long)node.getBlocksScheduled();
        if (requiredSize > node.getRemaining() - scheduledSize) {
            BlockPlacementPolicyDefault.logNodeIsNotChosen(storage, "the node does not have enough space ");
            return false;
        }
        if (considerLoad) {
            int size;
            double avgLoad = 0.0;
            if (this.stats != null && (size = this.stats.getNumDatanodesInService()) != 0) {
                avgLoad = (double)this.stats.getTotalLoad() / (double)size;
            }
            if ((double)node.getXceiverCount() > 2.0 * avgLoad) {
                BlockPlacementPolicyDefault.logNodeIsNotChosen(storage, "the node is too busy ");
                return false;
            }
        }
        String rackname = node.getNetworkLocation();
        int counter = 1;
        for (DatanodeStorageInfo resultStorage : results) {
            if (!rackname.equals(resultStorage.getDatanodeDescriptor().getNetworkLocation())) continue;
            ++counter;
        }
        if (counter > maxTargetPerRack) {
            BlockPlacementPolicyDefault.logNodeIsNotChosen(storage, "the rack has too many chosen nodes ");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatanodeStorageInfo[] getPipeline(Node writer, DatanodeStorageInfo[] storages) {
        if (storages.length == 0) {
            return storages;
        }
        NetworkTopology networkTopology = this.clusterMap;
        synchronized (networkTopology) {
            int index = 0;
            if (writer == null || !this.clusterMap.contains(writer)) {
                writer = storages[0].getDatanodeDescriptor();
            }
            while (index < storages.length) {
                DatanodeStorageInfo shortestStorage = storages[index];
                int shortestDistance = this.clusterMap.getDistance(writer, (Node)shortestStorage.getDatanodeDescriptor());
                int shortestIndex = index;
                for (int i = index + 1; i < storages.length; ++i) {
                    int currentDistance = this.clusterMap.getDistance(writer, (Node)storages[i].getDatanodeDescriptor());
                    if (shortestDistance <= currentDistance) continue;
                    shortestDistance = currentDistance;
                    shortestStorage = storages[i];
                    shortestIndex = i;
                }
                if (index != shortestIndex) {
                    storages[shortestIndex] = storages[index];
                    storages[index] = shortestStorage;
                }
                writer = shortestStorage.getDatanodeDescriptor();
                ++index;
            }
        }
        return storages;
    }

    @Override
    public BlockPlacementStatus verifyBlockPlacement(String srcPath, LocatedBlock lBlk, int numberOfReplicas) {
        int numRacks;
        DatanodeInfo[] locs = lBlk.getLocations();
        if (locs == null) {
            locs = DatanodeDescriptor.EMPTY_ARRAY;
        }
        if ((numRacks = this.clusterMap.getNumOfRacks()) <= 1) {
            return new BlockPlacementStatusDefault(Math.min(numRacks, numberOfReplicas), numRacks);
        }
        int minRacks = Math.min(2, numberOfReplicas);
        TreeSet<String> racks = new TreeSet<String>();
        for (DatanodeInfo dn : locs) {
            racks.add(dn.getNetworkLocation());
        }
        return new BlockPlacementStatusDefault(racks.size(), minRacks);
    }

    @Override
    public DatanodeDescriptor chooseReplicaToDelete(BlockCollection bc, Block block, short replicationFactor, Collection<DatanodeDescriptor> first, Collection<DatanodeDescriptor> second) {
        long oldestHeartbeat = Time.now() - this.heartbeatInterval * (long)this.tolerateHeartbeatMultiplier;
        DatanodeDescriptor oldestHeartbeatNode = null;
        long minSpace = Long.MAX_VALUE;
        DatanodeDescriptor minSpaceNode = null;
        for (DatanodeDescriptor node : this.pickupReplicaSet(first, second)) {
            long free = node.getRemaining();
            long lastHeartbeat = node.getLastUpdate();
            if (lastHeartbeat < oldestHeartbeat) {
                oldestHeartbeat = lastHeartbeat;
                oldestHeartbeatNode = node;
            }
            if (minSpace <= free) continue;
            minSpace = free;
            minSpaceNode = node;
        }
        return oldestHeartbeatNode != null ? oldestHeartbeatNode : minSpaceNode;
    }

    protected Collection<DatanodeDescriptor> pickupReplicaSet(Collection<DatanodeDescriptor> first, Collection<DatanodeDescriptor> second) {
        return first.isEmpty() ? second : first;
    }

    @VisibleForTesting
    void setPreferLocalNode(boolean prefer) {
        this.preferLocalNode = prefer;
    }
}

