/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;

abstract class NNUpgradeUtil {
    private static final Log LOG = LogFactory.getLog(NNUpgradeUtil.class);

    NNUpgradeUtil() {
    }

    static boolean canRollBack(Storage.StorageDirectory sd, StorageInfo storage, StorageInfo prevStorage, int targetLayoutVersion) throws IOException {
        File prevDir = sd.getPreviousDir();
        if (!prevDir.exists()) {
            LOG.info((Object)("Storage directory " + sd.getRoot() + " does not contain previous fs state."));
            storage.readProperties(sd);
            return false;
        }
        prevStorage.readPreviousVersionProperties(sd);
        if (prevStorage.getLayoutVersion() != targetLayoutVersion) {
            throw new IOException("Cannot rollback to storage version " + prevStorage.getLayoutVersion() + " using this version of the NameNode, which uses storage version " + targetLayoutVersion + ". " + "Please use the previous version of HDFS to perform the rollback.");
        }
        return true;
    }

    static void doFinalize(Storage.StorageDirectory sd) throws IOException {
        File prevDir = sd.getPreviousDir();
        if (!prevDir.exists()) {
            LOG.info((Object)("Directory " + prevDir + " does not exist."));
            LOG.info((Object)("Finalize upgrade for " + sd.getRoot() + " is not required."));
            return;
        }
        LOG.info((Object)("Finalizing upgrade of storage directory " + sd.getRoot()));
        assert (sd.getCurrentDir().exists()) : "Current directory must exist.";
        File tmpDir = sd.getFinalizedTmp();
        NNStorage.rename(prevDir, tmpDir);
        NNStorage.deleteDir(tmpDir);
        LOG.info((Object)("Finalize upgrade for " + sd.getRoot() + " is complete."));
    }

    static void doPreUpgrade(Storage.StorageDirectory sd) throws IOException {
        LOG.info((Object)("Starting upgrade of storage directory " + sd.getRoot()));
        File curDir = sd.getCurrentDir();
        File prevDir = sd.getPreviousDir();
        File tmpDir = sd.getPreviousTmp();
        assert (curDir.exists()) : "Current directory must exist.";
        assert (!prevDir.exists()) : "previous directory must not exist.";
        assert (!tmpDir.exists()) : "previous.tmp directory must not exist.";
        NNStorage.rename(curDir, tmpDir);
        if (!curDir.mkdir()) {
            throw new IOException("Cannot create directory " + curDir);
        }
    }

    static void doUpgrade(Storage.StorageDirectory sd, Storage storage) throws IOException {
        LOG.info((Object)("Performing upgrade of storage directory " + sd.getRoot()));
        try {
            storage.writeProperties(sd);
            File prevDir = sd.getPreviousDir();
            File tmpDir = sd.getPreviousTmp();
            NNStorage.rename(tmpDir, prevDir);
        }
        catch (IOException ioe) {
            LOG.error((Object)("Unable to rename temp to previous for " + sd.getRoot()), (Throwable)ioe);
            throw ioe;
        }
    }

    static void doRollBack(Storage.StorageDirectory sd) throws IOException {
        File prevDir = sd.getPreviousDir();
        if (!prevDir.exists()) {
            return;
        }
        File tmpDir = sd.getRemovedTmp();
        assert (!tmpDir.exists()) : "removed.tmp directory must not exist.";
        File curDir = sd.getCurrentDir();
        assert (curDir.exists()) : "Current directory must exist.";
        NNStorage.rename(curDir, tmpDir);
        NNStorage.rename(prevDir, curDir);
        NNStorage.deleteDir(tmpDir);
        LOG.info((Object)("Rollback of " + sd.getRoot() + " is complete."));
    }
}

