/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.cli.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.kitesdk.cli.commands.BaseDatasetCommand;
import org.kitesdk.data.Datasets;
import org.kitesdk.data.spi.DatasetRepository;
import org.slf4j.Logger;

@Parameters(commandDescription="Delete a dataset and its metadata")
public class DeleteDatasetCommand
extends BaseDatasetCommand {
    @Parameter(description="<dataset names>")
    List<String> datasets;

    public DeleteDatasetCommand(Logger console) {
        super(console);
    }

    @Override
    public int run() throws IOException {
        DatasetRepository repo = this.getDatasetRepository();
        if (this.datasets == null || this.datasets.isEmpty()) {
            throw new IllegalArgumentException("No dataset names were specified.");
        }
        for (String datasetUriOrName : this.datasets) {
            if (this.isDataUri(this.datasets.get(0))) {
                Datasets.delete((String)datasetUriOrName);
            } else {
                repo.delete(this.namespace, datasetUriOrName);
            }
            this.console.debug("Deleted dataset {}", (Object)datasetUriOrName);
        }
        return 0;
    }

    @Override
    public List<String> getExamples() {
        return Lists.newArrayList((Object[])new String[]{"# Delete all data and metadata for the dataset \"users\":", "users", "# Delete all data and metadata for a dataset by URI:", "dataset:hbase:zk1,zk2/users"});
    }
}

