/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.cli.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.apache.avro.generic.GenericData;
import org.kitesdk.cli.commands.BaseDatasetCommand;
import org.kitesdk.data.DatasetReader;
import org.kitesdk.data.View;
import org.slf4j.Logger;

@Parameters(commandDescription="Print the first n records in a Dataset")
public class ShowRecordsCommand
extends BaseDatasetCommand {
    @Parameter(description="<dataset name>")
    List<String> datasets;
    @Parameter(names={"-n", "--num-records"}, description="The number of records to print")
    int numRecords = 10;

    public ShowRecordsCommand(Logger console) {
        super(console);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int run() throws IOException {
        Preconditions.checkArgument((this.datasets != null && !this.datasets.isEmpty() ? 1 : 0) != 0, (Object)"Missing dataset name");
        Preconditions.checkArgument((this.datasets.size() == 1 ? 1 : 0) != 0, (Object)"Only one dataset name can be given");
        View<GenericData.Record> dataset = this.load(this.datasets.get(0), GenericData.Record.class);
        DatasetReader reader = null;
        boolean threw = true;
        try {
            reader = dataset.newReader();
            int i = 0;
            for (GenericData.Record record : reader) {
                if (i >= this.numRecords) break;
                this.console.info(record.toString());
                ++i;
            }
            threw = false;
        }
        finally {
            Closeables.close((Closeable)reader, (boolean)threw);
        }
        return 0;
    }

    @Override
    public List<String> getExamples() {
        return Lists.newArrayList((Object[])new String[]{"# Show the first 10 records in dataset \"users\":", "users", "# Show the first 50 records in dataset \"users\":", "users -n 50", "# Show the first 10 records for dataset URI:", "dataset:hbase:zk1,zk2/users", "# Show the first 10 records for view URI:", "view:hbase:zk1,zk2/users?username=u1"});
    }
}

