/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.cli.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.apache.avro.generic.GenericData;
import org.apache.crunch.DoFn;
import org.apache.crunch.PipelineResult;
import org.kitesdk.cli.commands.BaseDatasetCommand;
import org.kitesdk.compat.DynConstructors;
import org.kitesdk.data.DatasetException;
import org.kitesdk.data.View;
import org.kitesdk.tools.CopyTask;
import org.kitesdk.tools.TaskUtil;
import org.kitesdk.tools.TransformTask;
import org.slf4j.Logger;

@Parameters(commandDescription="Transform records from one Dataset and store them in another")
public class TransformCommand
extends BaseDatasetCommand {
    @Parameter(description="<source dataset> <destination dataset>")
    List<String> datasets;
    @Parameter(names={"--no-compaction"}, description="Copy to output directly, without compacting the data")
    boolean noCompaction = false;
    @Parameter(names={"--num-writers"}, description="The number of writer processes to use")
    int numWriters = -1;
    @Parameter(names={"--transform"}, description="A transform DoFn class name")
    String transform = null;
    @Parameter(names={"--jar"}, description="Add a jar to the runtime classpath")
    List<String> jars;

    public TransformCommand(Logger console) {
        super(console);
    }

    @Override
    public int run() throws IOException {
        PipelineResult result;
        TransformTask task;
        Preconditions.checkArgument((this.datasets != null && this.datasets.size() > 1 ? 1 : 0) != 0, (Object)"Source and target datasets are required");
        Preconditions.checkArgument((this.datasets.size() == 2 ? 1 : 0) != 0, (Object)"Cannot copy multiple datasets");
        View<GenericData.Record> source = this.load(this.datasets.get(0), GenericData.Record.class);
        View<GenericData.Record> dest = this.load(this.datasets.get(1), GenericData.Record.class);
        TaskUtil.configure(this.getConf()).addJars(this.jars);
        if (this.transform != null) {
            DoFn transformFn;
            try {
                DynConstructors.Ctor ctor = new DynConstructors.Builder(DoFn.class).loader(TransformCommand.loaderForJars(this.jars)).impl(this.transform, new Class[0]).buildChecked();
                transformFn = (DoFn)ctor.newInstance(new Object[0]);
            }
            catch (NoSuchMethodException e) {
                throw new DatasetException("Cannot find no-arg constructor for class: " + this.transform, (Throwable)e);
            }
            task = new TransformTask<GenericData.Record, GenericData.Record>(source, dest, transformFn);
        } else {
            task = new CopyTask<GenericData.Record>(source, dest);
        }
        task.setConf(this.getConf());
        if (this.noCompaction) {
            task.noCompaction();
        }
        if (this.numWriters >= 0) {
            task.setNumWriters(this.numWriters);
        }
        if ((result = task.run()).succeeded()) {
            this.console.info("Added {} records to \"{}\"", (Object)task.getCount(), (Object)this.datasets.get(1));
            return 0;
        }
        return 1;
    }

    @Override
    public List<String> getExamples() {
        return Lists.newArrayList((Object[])new String[]{"# Transform the contents of movies_src using com.example.TransformFn", "movies_src movies --transform com.example.TransformFn --jar fns.jar"});
    }
}

