/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.tools;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

class JarFinder {
    static final String TMP_HADOOP = "tmp__hadoop-";

    JarFinder() {
    }

    private static void zipDir(File dir, String relativePath, ZipOutputStream zos) throws IOException {
        Preconditions.checkNotNull((Object)relativePath, (Object)"relativePath");
        Preconditions.checkNotNull((Object)zos, (Object)"zos");
        JarFinder.zipDir(dir, relativePath, zos, true);
        zos.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zipDir(File dir, String relativePath, ZipOutputStream zos, boolean start) throws IOException {
        String[] dirList;
        for (String aDirList : dirList = dir.list()) {
            File f = new File(dir, aDirList);
            if (f.isHidden()) continue;
            if (f.isDirectory()) {
                if (!start) {
                    ZipEntry dirEntry = new ZipEntry(relativePath + f.getName() + "/");
                    zos.putNextEntry(dirEntry);
                    zos.write(new byte[0]);
                    zos.closeEntry();
                }
                String filePath = f.getPath();
                File file = new File(filePath);
                JarFinder.zipDir(file, relativePath + f.getName() + "/", zos, false);
                continue;
            }
            ZipEntry anEntry = new ZipEntry(relativePath + f.getName());
            zos.putNextEntry(anEntry);
            FileInputStream is = null;
            try {
                is = new FileInputStream(f);
                byte[] arr = new byte[4096];
                int read = ((InputStream)is).read(arr);
                while (read > -1) {
                    zos.write(arr, 0, read);
                    read = ((InputStream)is).read(arr);
                }
            }
            finally {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            zos.closeEntry();
        }
    }

    private static void createJar(File dir, File jarFile) throws IOException {
        Preconditions.checkNotNull((Object)dir, (Object)"dir");
        Preconditions.checkNotNull((Object)jarFile, (Object)"jarFile");
        File jarDir = jarFile.getParentFile();
        if (!jarDir.exists() && !jarDir.mkdirs()) {
            throw new IOException(MessageFormat.format("could not create dir [{0}]", jarDir));
        }
        JarOutputStream zos = new JarOutputStream(new FileOutputStream(jarFile));
        JarFinder.zipDir(dir, "", zos);
    }

    public static String getJar(Class<?> klass) {
        Preconditions.checkNotNull(klass, (Object)"klass");
        ClassLoader loader = klass.getClassLoader();
        if (loader != null) {
            String class_file = klass.getName().replaceAll("\\.", "/") + ".class";
            try {
                Enumeration<URL> itr = loader.getResources(class_file);
                while (itr.hasMoreElements()) {
                    URL url = itr.nextElement();
                    String path = url.getPath();
                    if (path.startsWith("file:")) {
                        path = path.substring("file:".length());
                    }
                    path = URLDecoder.decode(path, "UTF-8");
                    if ("jar".equals(url.getProtocol())) {
                        path = URLDecoder.decode(path, "UTF-8");
                        return path.replaceAll("!.*$", "");
                    }
                    if (!"file".equals(url.getProtocol())) continue;
                    String klassName = klass.getName();
                    klassName = klassName.replace(".", "/") + ".class";
                    path = path.substring(0, path.length() - klassName.length());
                    File baseDir = new File(path);
                    File testDir = new File(System.getProperty("test.build.dir", "target/test-dir"));
                    if (!(testDir = testDir.getAbsoluteFile()).exists() && !testDir.mkdirs()) {
                        throw new IOException("Unable to create directory :" + testDir.toString());
                    }
                    File tempJar = File.createTempFile(TMP_HADOOP, "", testDir);
                    tempJar = new File(tempJar.getAbsolutePath() + ".jar");
                    JarFinder.createJar(baseDir, tempJar);
                    return tempJar.getAbsolutePath();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }
}

