/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.tools;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.List;
import org.apache.crunch.util.DistCache;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.kitesdk.compat.Hadoop;
import org.kitesdk.data.DatasetException;
import org.kitesdk.data.DatasetIOException;

public class TaskUtil {
    public static ConfigBuilder configure(Job job) {
        return new ConfigBuilder(job);
    }

    public static ConfigBuilder configure(Configuration conf) {
        return new ConfigBuilder(conf);
    }

    private static File findJarForClass(Class<?> requiredClass) {
        ProtectionDomain domain = AccessController.doPrivileged(new GetProtectionDomain(requiredClass));
        CodeSource codeSource = domain.getCodeSource();
        if (codeSource != null) {
            try {
                return new File(codeSource.getLocation().toURI());
            }
            catch (URISyntaxException e) {
                throw new DatasetException("Cannot locate " + requiredClass.getName() + " jar", (Throwable)e);
            }
        }
        throw new DatasetException("Cannot locate " + requiredClass.getName() + " jar");
    }

    private static class GetProtectionDomain
    implements PrivilegedAction<ProtectionDomain> {
        private final Class<?> requiredClass;

        public GetProtectionDomain(Class<?> requiredClass) {
            this.requiredClass = requiredClass;
        }

        @Override
        public ProtectionDomain run() {
            return this.requiredClass.getProtectionDomain();
        }
    }

    public static class ConfigBuilder {
        private final Configuration conf;
        private final boolean skipDistributedCache;

        private ConfigBuilder(Job job) {
            this((Configuration)Hadoop.JobContext.getConfiguration.invoke((Object)job, new Object[0]));
        }

        private ConfigBuilder(Configuration conf) {
            this.conf = conf;
            this.skipDistributedCache = conf.getBoolean("kite.testing", false);
        }

        public ConfigBuilder addJars(List<String> jars) {
            if (!this.skipDistributedCache && jars != null) {
                for (String jar : jars) {
                    try {
                        File path = new File(jar);
                        Preconditions.checkArgument((boolean)path.exists(), (Object)("Jar files does not exist: " + jar));
                        Preconditions.checkArgument((boolean)path.isFile(), (Object)("Not a file: " + jar));
                        Preconditions.checkArgument((boolean)path.canRead(), (Object)("Cannot read jar file: " + jar));
                        DistCache.addJarToDistributedCache((Configuration)this.conf, (File)path);
                    }
                    catch (IOException e) {
                        throw new DatasetIOException("Cannot add jar to distributed cache: " + jar, e);
                    }
                }
            }
            return this;
        }

        public ConfigBuilder addJarForClass(Class<?> requiredClass) {
            if (!this.skipDistributedCache) {
                File jar = TaskUtil.findJarForClass(requiredClass);
                try {
                    DistCache.addJarToDistributedCache((Configuration)this.conf, (File)jar);
                }
                catch (IOException e) {
                    throw new DatasetIOException("Cannot add jar to distributed cache: " + jar, e);
                }
            }
            return this;
        }

        public ConfigBuilder addJarPathForClass(Class<?> requiredClass) {
            if (!this.skipDistributedCache) {
                String jarPath = TaskUtil.findJarForClass(requiredClass).getParent();
                try {
                    DistCache.addJarDirToDistributedCache((Configuration)this.conf, (String)jarPath);
                }
                catch (IOException e) {
                    throw new DatasetIOException("Cannot add jar path to distributed cache: " + jarPath, e);
                }
            }
            return this;
        }
    }
}

