/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.minicluster;

import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.flume.node.Application;
import org.apache.flume.node.PropertiesFileConfigurationProvider;
import org.apache.hadoop.conf.Configuration;
import org.kitesdk.minicluster.HdfsService;
import org.kitesdk.minicluster.HiveService;
import org.kitesdk.minicluster.MiniCluster;
import org.kitesdk.minicluster.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlumeService
implements Service {
    private static final Logger LOG = LoggerFactory.getLogger(FlumeService.class);
    private Configuration hadoopConf;
    private String workDir;
    private String bindIP = "127.0.0.1";
    private String flumeConfiguration;
    private String agentName;
    private Application flumeApplication;

    @Override
    public void configure(Service.ServiceConfig serviceConfig) {
        Preconditions.checkState((boolean)serviceConfig.contains("flume-configuration"), (Object)"Missing configuration for Flume minicluster: flume-configuration");
        Preconditions.checkState((boolean)serviceConfig.contains("flume-agent-name"), (Object)"Missing configuration for Flume minicluster: flume-agent-name");
        this.workDir = serviceConfig.get("directory");
        if (serviceConfig.contains("bind-ip")) {
            this.bindIP = serviceConfig.get("bind-ip");
        }
        this.flumeConfiguration = serviceConfig.get("flume-configuration");
        this.agentName = serviceConfig.get("flume-agent-name");
        this.hadoopConf = serviceConfig.getHadoopConf();
    }

    @Override
    public Configuration getHadoopConf() {
        return this.hadoopConf;
    }

    @Override
    public void start() throws IOException {
        File newFlumeConfiguration = this.configureBindIp(this.flumeConfiguration);
        PropertiesFileConfigurationProvider configurationProvider = new PropertiesFileConfigurationProvider(this.agentName, newFlumeConfiguration);
        this.flumeApplication = new Application();
        this.flumeApplication.handleConfigurationEvent(configurationProvider.getConfiguration());
        this.flumeApplication.start();
        LOG.info("Flume Minicluster service started.");
    }

    private File configureBindIp(String flumeConfiguration) throws IOException {
        Properties properties = this.readFromUrl(flumeConfiguration);
        this.fixBindAddresses(properties, this.bindIP);
        File flumeWorkDir = new File(this.workDir, "flume");
        flumeWorkDir.mkdirs();
        File newFlumeConfiguration = new File(flumeWorkDir, "flume.properties");
        this.writeToFile(properties, newFlumeConfiguration);
        return newFlumeConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties readFromUrl(String flumeConfiguration) throws IOException {
        BufferedReader reader = null;
        try {
            URL url = new URL(flumeConfiguration);
            reader = new BufferedReader(new InputStreamReader(url.openStream()));
            Properties properties = new Properties();
            properties.load(reader);
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    LOG.warn("Unable to close reader for: " + flumeConfiguration, (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(Properties properties, File file) throws IOException {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(file));
            properties.store(writer, null);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ex) {
                    LOG.warn("Unable to close file writer for file: " + file, (Throwable)ex);
                }
            }
        }
    }

    void fixBindAddresses(Properties properties, String bindIP) {
        for (String name : properties.stringPropertyNames()) {
            if (!name.endsWith(".bind")) continue;
            properties.setProperty(name, bindIP);
        }
    }

    @Override
    public void stop() throws IOException {
        this.flumeApplication.stop();
        LOG.info("Flume Minicluster service shut down.");
    }

    @Override
    public List<Class<? extends Service>> dependencies() {
        ArrayList<Class<? extends Service>> services = new ArrayList<Class<? extends Service>>();
        services.add(HdfsService.class);
        services.add(HiveService.class);
        return services;
    }

    static {
        MiniCluster.registerService(FlumeService.class);
    }
}

