/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.minicluster;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.kitesdk.minicluster.MiniCluster;
import org.kitesdk.minicluster.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsService
implements Service {
    private static final Logger logger = LoggerFactory.getLogger(HdfsService.class);
    public static final String NAMENODE_HTTP_PORT = "hdfs-namenode-http-port";
    public static final String DATANODE_PORT = "hdfs-datanode-port";
    public static final String DATANODE_IPC_PORT = "hdfs-datanode-ipc-port";
    public static final String DATANODE_HTTP_PORT = "hdfs-datanode-http-port";
    private Configuration hadoopConf;
    private String workDir;
    private String bindIP = "127.0.0.1";
    private int namenodeRpcPort = 8020;
    private int namenodeHttpPort = 50070;
    private int datanodePort = 50010;
    private int datanodeIpcPort = 50020;
    private int datanodeHttpPort = 50075;
    private boolean clean = false;
    private MiniDFSCluster miniDfsCluster;

    @Override
    public void configure(Service.ServiceConfig serviceConfig) {
        this.workDir = serviceConfig.get("directory");
        if (serviceConfig.contains("bind-ip")) {
            this.bindIP = serviceConfig.get("bind-ip");
        }
        if (serviceConfig.contains("clean")) {
            this.clean = Boolean.parseBoolean(serviceConfig.get("clean"));
        }
        if (serviceConfig.contains("hdfs-namenode-rpc-port")) {
            this.namenodeRpcPort = Integer.parseInt(serviceConfig.get("hdfs-namenode-rpc-port"));
        }
        if (serviceConfig.contains(NAMENODE_HTTP_PORT)) {
            this.namenodeHttpPort = Integer.parseInt(serviceConfig.get(NAMENODE_HTTP_PORT));
        }
        if (serviceConfig.contains(DATANODE_PORT)) {
            this.datanodePort = Integer.parseInt(serviceConfig.get(DATANODE_PORT));
        }
        if (serviceConfig.contains(DATANODE_IPC_PORT)) {
            this.datanodeIpcPort = Integer.parseInt(serviceConfig.get(DATANODE_IPC_PORT));
        }
        if (serviceConfig.contains(DATANODE_HTTP_PORT)) {
            this.datanodeHttpPort = Integer.parseInt(serviceConfig.get(DATANODE_HTTP_PORT));
        }
        this.hadoopConf = serviceConfig.getHadoopConf();
    }

    @Override
    public Configuration getHadoopConf() {
        return this.hadoopConf;
    }

    @Override
    public void start() throws IOException {
        Preconditions.checkState((this.workDir != null ? 1 : 0) != 0, (Object)"The work dir must be set before starting cluster.");
        if (this.hadoopConf == null) {
            this.hadoopConf = new Configuration();
        }
        String localDFSLocation = HdfsService.getDFSLocation(this.workDir);
        if (this.clean) {
            logger.info("Cleaning HDFS cluster data at: " + localDFSLocation + " and starting fresh.");
            File file = new File(localDFSLocation);
            FileUtils.deleteDirectory((File)file);
        }
        boolean format = HdfsService.shouldFormatDFSCluster(localDFSLocation, this.clean);
        this.hadoopConf = HdfsService.configureDFSCluster(this.hadoopConf, localDFSLocation, this.bindIP, this.namenodeRpcPort, this.namenodeHttpPort, this.datanodePort, this.datanodeIpcPort, this.datanodeHttpPort);
        this.miniDfsCluster = new MiniDFSCluster.Builder(this.hadoopConf).numDataNodes(1).format(format).checkDataNodeAddrConfig(true).checkDataNodeHostConfig(true).build();
        logger.info("HDFS Minicluster service started.");
    }

    @Override
    public void stop() throws IOException {
        this.miniDfsCluster.shutdown();
        logger.info("HDFS Minicluster service shut down.");
        this.miniDfsCluster = null;
        this.hadoopConf = null;
    }

    private static String getDFSLocation(String baseFsLocation) {
        return baseFsLocation + "/" + "dfs";
    }

    private static boolean shouldFormatDFSCluster(String localDFSLocation, boolean clean) {
        boolean format = true;
        File f = new File(localDFSLocation);
        if (f.exists() && f.isDirectory() && !clean) {
            format = false;
        }
        return format;
    }

    private static Configuration configureDFSCluster(Configuration config, String localDFSLocation, String bindIP, int namenodeRpcPort, int namenodeHttpPort, int datanodePort, int datanodeIpcPort, int datanodeHttpPort) {
        logger.info("HDFS force binding to ip: " + bindIP);
        config = new KiteCompatibleConfiguration(config, bindIP, namenodeRpcPort, namenodeHttpPort);
        config.set("fs.defaultFS", "hdfs://" + bindIP + ":" + namenodeRpcPort);
        config.set("dfs.datanode.address", bindIP + ":" + datanodePort);
        config.set("dfs.datanode.ipc.address", bindIP + ":" + datanodeIpcPort);
        config.set("dfs.datanode.http.address", bindIP + ":" + datanodeHttpPort);
        config.setBoolean("dfs.namenode.datanode.registration.ip-hostname-check", false);
        config.set("hdfs.minidfs.basedir", localDFSLocation);
        String user = System.getProperty("user.name");
        config.set("hadoop.proxyuser." + user + ".groups", "*");
        config.set("hadoop.proxyuser." + user + ".hosts", "*");
        return config;
    }

    @Override
    public List<Class<? extends Service>> dependencies() {
        return null;
    }

    static {
        MiniCluster.registerService(HdfsService.class);
    }

    private static class KiteCompatibleConfiguration
    extends Configuration {
        public KiteCompatibleConfiguration(Configuration config, String bindAddress, int namenodeRpcPort, int namenodeHttpPort) {
            super(config);
            super.set("dfs.namenode.rpc-address", bindAddress + ":" + namenodeRpcPort);
            super.set("dfs.namenode.http-address", bindAddress + ":" + namenodeHttpPort);
        }

        public void set(String key, String value) {
            if (!key.equals("dfs.namenode.http-address") && !key.equals("dfs.namenode.rpc-address")) {
                super.set(key, value);
            }
        }
    }
}

