/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.minicluster;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IHMSHandler;
import org.apache.hadoop.hive.metastore.TSetIpAddressProcessor;
import org.apache.hadoop.hive.metastore.TUGIBasedProcessor;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.ThriftHiveMetastore;
import org.apache.hadoop.hive.thrift.TUGIContainingTransport;
import org.apache.hive.service.server.HiveServer2;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;
import org.kitesdk.minicluster.MiniCluster;
import org.kitesdk.minicluster.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveService
implements Service {
    private static final Logger LOG = LoggerFactory.getLogger(HiveService.class);
    private static final int CONNECTION_TIMEOUT = 30000;
    private Configuration hadoopConf;
    private String workDir;
    private String bindIP = "127.0.0.1";
    private int metastorePort = 9083;
    private int serverPort = 10000;
    private boolean clean = false;
    private Map<String, String> sysProps = Maps.newHashMap();
    private ExecutorService executorService;
    private TServer tServer;
    private HiveServer2 hiveServer;

    @Override
    public void configure(Service.ServiceConfig serviceConfig) {
        this.workDir = serviceConfig.get("directory");
        if (serviceConfig.contains("bind-ip")) {
            this.bindIP = serviceConfig.get("bind-ip");
        }
        if (serviceConfig.contains("clean")) {
            this.clean = Boolean.parseBoolean(serviceConfig.get("clean"));
        }
        if (serviceConfig.contains("hive-metastore-port")) {
            this.metastorePort = Integer.parseInt(serviceConfig.get("hive-metastore-port"));
        }
        if (serviceConfig.contains("hive-server-port")) {
            this.serverPort = Integer.parseInt(serviceConfig.get("hive-server-port"));
        }
        this.hadoopConf = serviceConfig.getHadoopConf();
    }

    @Override
    public Configuration getHadoopConf() {
        return this.hadoopConf;
    }

    @Override
    public void start() throws IOException {
        Preconditions.checkState((this.workDir != null ? 1 : 0) != 0, (Object)"The work dir must be set before starting cluster.");
        if (this.hadoopConf == null) {
            this.hadoopConf = new Configuration();
        }
        String localHiveLocation = HiveService.getHiveLocation(this.workDir);
        if (this.clean) {
            LOG.info("Cleaning Hive cluster data at: " + localHiveLocation + " and starting fresh.");
            File file = new File(localHiveLocation);
            FileUtils.deleteDirectory((File)file);
        }
        HiveConf serverConf = this.configureHive(this.hadoopConf, localHiveLocation);
        this.executorService = Executors.newSingleThreadExecutor();
        this.tServer = this.startMetaStore(this.bindIP, this.metastorePort, serverConf);
        this.hiveServer = this.startHiveServer(serverConf);
        String serverHostname = this.bindIP.equals("0.0.0.0") ? "localhost" : this.bindIP;
        if (!this.waitForServerUp(serverConf, serverHostname, this.metastorePort, 30000)) {
            throw new IOException("Waiting for startup of standalone server");
        }
        LOG.info("Hive Minicluster service started.");
    }

    @Override
    public void stop() throws IOException {
        this.resetSystemProperties();
        if (this.tServer != null) {
            this.tServer.stop();
        }
        if (this.hiveServer != null) {
            this.hiveServer.stop();
        }
        LOG.info("Hive Minicluster service shut down.");
        this.tServer = null;
        this.hiveServer = null;
        this.hadoopConf = null;
    }

    @Override
    public List<Class<? extends Service>> dependencies() {
        return null;
    }

    private HiveConf configureHive(Configuration conf, String localHiveLocation) throws IOException {
        conf.set("hive.metastore.local", "false");
        conf.set(HiveConf.ConfVars.METASTOREURIS.varname, "thrift://" + this.bindIP + ":" + this.metastorePort);
        conf.set(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_BIND_HOST.varname, this.bindIP);
        conf.setInt(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_PORT.varname, this.serverPort);
        File localHiveDir = new File(localHiveLocation);
        localHiveDir.mkdirs();
        File metastoreDbDir = new File(localHiveDir, "metastore_db");
        conf.set(HiveConf.ConfVars.METASTORECONNECTURLKEY.varname, "jdbc:derby:" + metastoreDbDir.getPath() + ";create=true");
        File derbyLogFile = new File(localHiveDir, "derby.log");
        derbyLogFile.createNewFile();
        this.setSystemProperty("derby.stream.error.file", derbyLogFile.getPath());
        return new HiveConf(conf, this.getClass());
    }

    private boolean waitForServerUp(HiveConf serverConf, String hostname, int port, int timeout) {
        long start = System.currentTimeMillis();
        while (true) {
            try {
                new HiveMetaStoreClient(serverConf);
                return true;
            }
            catch (MetaException e) {
                LOG.info("server " + hostname + ":" + port + " not up " + (Object)((Object)e));
                if (System.currentTimeMillis() <= start + (long)timeout) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException e2) {}
                    continue;
                }
                return false;
            }
            break;
        }
    }

    private void setSystemProperty(String name, String value) {
        if (!this.sysProps.containsKey(name)) {
            String currentValue = System.getProperty(name);
            this.sysProps.put(name, currentValue);
        }
        if (value != null) {
            System.setProperty(name, value);
        } else {
            System.getProperties().remove(name);
        }
    }

    private void resetSystemProperties() {
        for (Map.Entry<String, String> entry : this.sysProps.entrySet()) {
            if (entry.getValue() != null) {
                System.setProperty(entry.getKey(), entry.getValue());
                continue;
            }
            System.getProperties().remove(entry.getKey());
        }
        this.sysProps.clear();
    }

    private static String getHiveLocation(String baseLocation) {
        return baseLocation + "/" + "hive";
    }

    private HiveServer2 startHiveServer(HiveConf serverConf) {
        HiveServer2 hiveServer = new HiveServer2();
        hiveServer.init(serverConf);
        hiveServer.start();
        return hiveServer;
    }

    public TServer startMetaStore(String forceBindIP, int port, HiveConf conf) throws IOException {
        try {
            TUGIBasedProcessor processor;
            ChainedTTransportFactory transFactory;
            TServerSocketKeepAlive serverTransport;
            int minWorkerThreads = conf.getIntVar(HiveConf.ConfVars.METASTORESERVERMINTHREADS);
            int maxWorkerThreads = conf.getIntVar(HiveConf.ConfVars.METASTORESERVERMAXTHREADS);
            boolean tcpKeepAlive = conf.getBoolVar(HiveConf.ConfVars.METASTORE_TCP_KEEP_ALIVE);
            boolean useFramedTransport = conf.getBoolVar(HiveConf.ConfVars.METASTORE_USE_THRIFT_FRAMED_TRANSPORT);
            if (forceBindIP != null) {
                InetSocketAddress address = new InetSocketAddress(forceBindIP, port);
                serverTransport = tcpKeepAlive ? new TServerSocketKeepAlive(address) : new TServerSocket(address);
            } else {
                serverTransport = tcpKeepAlive ? new TServerSocketKeepAlive(port) : new TServerSocket(port);
            }
            IHMSHandler handler = HiveMetaStore.newHMSHandler((String)"new db based metaserver", (HiveConf)conf);
            if (conf.getBoolVar(HiveConf.ConfVars.METASTORE_EXECUTE_SET_UGI)) {
                transFactory = useFramedTransport ? new ChainedTTransportFactory((TTransportFactory)new TFramedTransport.Factory(), (TTransportFactory)new TUGIContainingTransport.Factory()) : new TUGIContainingTransport.Factory();
                processor = new TUGIBasedProcessor((ThriftHiveMetastore.Iface)handler);
                LOG.info("Starting DB backed MetaStore Server with SetUGI enabled");
            } else {
                transFactory = useFramedTransport ? new TFramedTransport.Factory() : new TTransportFactory();
                processor = new TSetIpAddressProcessor((ThriftHiveMetastore.Iface)handler);
                LOG.info("Starting DB backed MetaStore Server");
            }
            TThreadPoolServer.Args args = ((TThreadPoolServer.Args)((TThreadPoolServer.Args)((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)serverTransport).processor((TProcessor)processor)).transportFactory((TTransportFactory)transFactory)).protocolFactory((TProtocolFactory)new TBinaryProtocol.Factory())).minWorkerThreads(minWorkerThreads).maxWorkerThreads(maxWorkerThreads);
            TThreadPoolServer tServer = new TThreadPoolServer(args);
            this.executorService.submit(new Runnable((TServer)tServer){
                final /* synthetic */ TServer val$tServer;
                {
                    this.val$tServer = tServer;
                }

                @Override
                public void run() {
                    this.val$tServer.serve();
                }
            });
            return tServer;
        }
        catch (Throwable x) {
            throw new IOException(x);
        }
    }

    static {
        MiniCluster.registerService(HiveService.class);
    }

    private static final class TServerSocketKeepAlive
    extends TServerSocket {
        public TServerSocketKeepAlive(int port) throws TTransportException {
            super(port, 0);
        }

        public TServerSocketKeepAlive(InetSocketAddress address) throws TTransportException {
            super(address, 0);
        }

        protected TSocket acceptImpl() throws TTransportException {
            TSocket ts = super.acceptImpl();
            try {
                ts.getSocket().setKeepAlive(true);
            }
            catch (SocketException e) {
                throw new TTransportException((Throwable)e);
            }
            return ts;
        }
    }

    private static final class ChainedTTransportFactory
    extends TTransportFactory {
        private final TTransportFactory parentTransFactory;
        private final TTransportFactory childTransFactory;

        private ChainedTTransportFactory(TTransportFactory parentTransFactory, TTransportFactory childTransFactory) {
            this.parentTransFactory = parentTransFactory;
            this.childTransFactory = childTransFactory;
        }

        public TTransport getTransport(TTransport trans) {
            return this.childTransFactory.getTransport(this.parentTransFactory.getTransport(trans));
        }
    }
}

