/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.minicluster;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.conf.Configuration;
import org.kitesdk.data.spi.DefaultConfiguration;
import org.kitesdk.minicluster.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiniCluster {
    private static final Logger logger = LoggerFactory.getLogger(MiniCluster.class);
    public static final String BIND_IP_KEY = "bind-ip";
    public static final String CLEAN_KEY = "clean";
    public static final String WORK_DIR_KEY = "directory";
    public static final String NAMENODE_RPC_PORT = "hdfs-namenode-rpc-port";
    public static final String ZK_PORT_KEY = "zk-port";
    public static final String HIVE_METASTORE_PORT = "hive-metastore-port";
    public static final String HIVE_SERVER_PORT = "hive-server-port";
    public static final String FLUME_CONFIGURATION = "flume-configuration";
    public static final String FLUME_AGENT_NAME = "flume-agent-name";
    static final String RESOURCE_URI_SCHEME = "resource";
    private static final Map<String, Service> registeredServices = new ConcurrentHashMap<String, Service>();
    private final List<Service> services;
    private final Service.ServiceConfig serviceConfig;

    public static void registerService(Class<? extends Service> klass) {
        Service service;
        try {
            service = klass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            logger.error("Could not get default class constructor for: " + klass.getName());
            throw new RuntimeException(e);
        }
        registeredServices.put(klass.getName(), service);
    }

    private MiniCluster(List<Service> services, Service.ServiceConfig serviceConfig) {
        this.services = services;
        this.serviceConfig = serviceConfig;
    }

    public void start() throws IOException, InterruptedException {
        for (Service service : this.services) {
            service.configure(this.serviceConfig);
            logger.info("Running Minicluster Service: " + service.getClass().getName());
            service.start();
            this.serviceConfig.setHadoopConf(service.getHadoopConf());
            DefaultConfiguration.set((Configuration)this.serviceConfig.getHadoopConf());
        }
        logger.info("All Minicluster Services running.");
    }

    public void stop() throws IOException, InterruptedException {
        for (int i = this.services.size() - 1; i >= 0; --i) {
            Service service = this.services.get(i);
            logger.info("Stopping Minicluster Service: " + service.getClass().getName());
            service.stop();
        }
        logger.info("All Minicluster Services stopped.");
    }

    public static class Builder {
        private Configuration hadoopConf;
        private List<Service> services = Lists.newArrayList();
        private Service.ServiceConfig serviceConfig = new Service.ServiceConfig();

        public Builder hadoopConf(Configuration hadoopConf) {
            this.serviceConfig.setHadoopConf(hadoopConf);
            return this;
        }

        public Builder workDir(String workDir) {
            this.serviceConfig.set(MiniCluster.WORK_DIR_KEY, workDir);
            return this;
        }

        public Builder clean(boolean clean) {
            this.serviceConfig.set(MiniCluster.CLEAN_KEY, Boolean.toString(clean));
            return this;
        }

        public Builder bindIP(String bindIP) {
            this.serviceConfig.set(MiniCluster.BIND_IP_KEY, bindIP);
            return this;
        }

        public Builder namenodeRpcPort(int namenodeRpcPort) {
            this.serviceConfig.set(MiniCluster.NAMENODE_RPC_PORT, Integer.toString(namenodeRpcPort));
            return this;
        }

        public Builder zkPort(int zkPort) {
            this.serviceConfig.set(MiniCluster.ZK_PORT_KEY, Integer.toString(zkPort));
            return this;
        }

        public Builder hiveMetastorePort(int port) {
            this.serviceConfig.set(MiniCluster.HIVE_METASTORE_PORT, Integer.toString(port));
            return this;
        }

        public Builder hiveServerPort(int port) {
            this.serviceConfig.set(MiniCluster.HIVE_SERVER_PORT, Integer.toString(port));
            return this;
        }

        public Builder flumeConfiguration(String resource) {
            this.serviceConfig.set(MiniCluster.FLUME_CONFIGURATION, this.toUrl(resource).toExternalForm());
            return this;
        }

        public Builder flumeAgentName(String name) {
            this.serviceConfig.set(MiniCluster.FLUME_AGENT_NAME, name);
            return this;
        }

        private URL toUrl(String resource) {
            URI resourceUri = URI.create(resource);
            if (MiniCluster.RESOURCE_URI_SCHEME.equals(resourceUri.getScheme())) {
                return Resources.getResource((String)resourceUri.getRawSchemeSpecificPart());
            }
            File file = new File(resource);
            if (!file.exists()) {
                throw new IllegalArgumentException(String.format("File %s not found.", file));
            }
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public Builder setServiceConfig(String name, String value) {
            this.serviceConfig.set(name, value);
            return this;
        }

        public Builder addService(Class<? extends Service> klass) {
            Preconditions.checkState((!this.serviceImplExists(klass) ? 1 : 0) != 0, (Object)("A service implementation already exists for: " + klass.getName()));
            try {
                Class.forName(klass.getName());
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            Service service = (Service)registeredServices.get(klass.getName());
            Preconditions.checkState((service != null ? 1 : 0) != 0, (Object)("Unknown service (maybe not registered): " + klass.getName()));
            this.services.add(service);
            return this;
        }

        public MiniCluster build() {
            Preconditions.checkState((this.serviceConfig.get(MiniCluster.WORK_DIR_KEY) != null ? 1 : 0) != 0, (Object)"Must provide a path on the local filesystem to store cluster data");
            if (this.hadoopConf == null) {
                this.hadoopConf = new Configuration();
            }
            this.services = this.getServicesInRunOrder(this.services);
            return new MiniCluster(this.services, this.serviceConfig);
        }

        private List<Service> getServicesInRunOrder(List<Service> services) {
            ArrayList<Service> orderedServices = new ArrayList<Service>();
            ArrayList<Service> serviceQueue = new ArrayList<Service>(services);
            while (orderedServices.size() < services.size()) {
                ArrayList<Integer> serviceQueueIndexesToRemove = new ArrayList<Integer>();
                for (int i = 0; i < serviceQueue.size(); ++i) {
                    Service service = (Service)serviceQueue.get(i);
                    boolean allDependenciesIn = true;
                    if (service.dependencies() != null) {
                        for (Class<? extends Service> serviceClass : service.dependencies()) {
                            if (this.serviceImplExists(orderedServices, serviceClass)) continue;
                            allDependenciesIn = false;
                            break;
                        }
                    }
                    if (!allDependenciesIn) continue;
                    serviceQueueIndexesToRemove.add(i);
                    orderedServices.add(service);
                }
                if (serviceQueueIndexesToRemove.size() == 0) {
                    throw new IllegalStateException("Required service dependencies haven't been added as services.");
                }
                int numRemoved = 0;
                Iterator i$ = serviceQueueIndexesToRemove.iterator();
                while (i$.hasNext()) {
                    int idx = (Integer)i$.next();
                    serviceQueue.remove(idx - numRemoved++);
                }
            }
            return orderedServices;
        }

        private <T extends Service> T getServiceImpl(List<Service> services, Class<T> klass) {
            for (Service service : services) {
                if (service.getClass() != klass) continue;
                return (T)service;
            }
            return null;
        }

        private boolean serviceImplExists(Class<? extends Service> klass) {
            return this.serviceImplExists(this.services, klass);
        }

        private boolean serviceImplExists(List<Service> services, Class<? extends Service> klass) {
            return this.getServiceImpl(services, klass) != null;
        }
    }
}

