/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.minicluster;

import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnLog;
import org.kitesdk.minicluster.MiniCluster;
import org.kitesdk.minicluster.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperService
implements Service {
    private static final Logger logger = LoggerFactory.getLogger(ZookeeperService.class);
    private static final int TICK_TIME = 2000;
    private static final int CONNECTION_TIMEOUT = 30000;
    private Configuration hadoopConf;
    private String workDir;
    private Integer clientPort = 2828;
    private String bindIP = "127.0.0.1";
    private Boolean clean = false;
    private int tickTime = 0;
    private NIOServerCnxnFactory standaloneServerFactory;
    private ZooKeeperServer zooKeeperServer;
    private boolean started = false;

    @Override
    public void configure(Service.ServiceConfig serviceConfig) {
        this.workDir = serviceConfig.get("directory");
        if (serviceConfig.contains("bind-ip")) {
            this.bindIP = serviceConfig.get("bind-ip");
        }
        if (serviceConfig.contains("clean")) {
            this.clean = Boolean.parseBoolean(serviceConfig.get("clean"));
        }
        if (serviceConfig.contains("zk-port")) {
            this.clientPort = Integer.parseInt(serviceConfig.get("zk-port"));
        }
        this.hadoopConf = serviceConfig.getHadoopConf();
    }

    @Override
    public Configuration getHadoopConf() {
        return this.hadoopConf;
    }

    @Override
    public void start() throws IOException, InterruptedException {
        Preconditions.checkState((this.workDir != null ? 1 : 0) != 0, (Object)"The localBaseFsLocation must be set before starting cluster.");
        ZookeeperService.setupTestEnv();
        this.stop();
        File dir = new File(this.workDir, "zookeeper").getAbsoluteFile();
        this.recreateDir(dir, this.clean);
        int tickTimeToUse = this.tickTime > 0 ? this.tickTime : 2000;
        this.zooKeeperServer = new ZooKeeperServer(dir, dir, tickTimeToUse);
        this.standaloneServerFactory = new NIOServerCnxnFactory();
        logger.info("Zookeeper force binding to: " + this.bindIP);
        this.standaloneServerFactory.configure(new InetSocketAddress(this.bindIP, (int)this.clientPort), 1000);
        this.standaloneServerFactory.startup(this.zooKeeperServer);
        String serverHostname = this.bindIP.equals("0.0.0.0") ? "localhost" : this.bindIP;
        if (!ZookeeperService.waitForServerUp(serverHostname, this.clientPort, 30000L)) {
            throw new IOException("Waiting for startup of standalone server");
        }
        this.started = true;
        logger.info("Zookeeper Minicluster service started on client port: " + this.clientPort);
    }

    @Override
    public void stop() throws IOException {
        if (!this.started) {
            return;
        }
        this.standaloneServerFactory.shutdown();
        if (!ZookeeperService.waitForServerDown(this.clientPort, 30000L)) {
            throw new IOException("Waiting for shutdown of standalone server");
        }
        this.started = false;
        this.standaloneServerFactory = null;
        this.zooKeeperServer = null;
        logger.info("Zookeeper Minicluster service shut down.");
    }

    @Override
    public List<Class<? extends Service>> dependencies() {
        return null;
    }

    private void recreateDir(File dir, boolean clean) throws IOException {
        if (dir.exists() && clean) {
            FileUtil.fullyDelete((File)dir);
        } else if (dir.exists() && !clean) {
            return;
        }
        try {
            dir.mkdirs();
        }
        catch (SecurityException e) {
            throw new IOException("creating dir: " + dir, e);
        }
    }

    private static void setupTestEnv() {
        System.setProperty("zookeeper.preAllocSize", "100");
        FileTxnLog.setPreallocSize((long)102400L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean waitForServerDown(int port, long timeout) {
        long start = System.currentTimeMillis();
        while (true) {
            try {
                Socket sock = new Socket("localhost", port);
                try {
                    OutputStream outstream = sock.getOutputStream();
                    outstream.write("stat".getBytes());
                    outstream.flush();
                }
                finally {
                    sock.close();
                }
            }
            catch (IOException e) {
                return true;
            }
            if (System.currentTimeMillis() > start + timeout) break;
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {}
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean waitForServerUp(String hostname, int port, long timeout) {
        long start = System.currentTimeMillis();
        while (true) {
            try {
                Socket sock = new Socket(hostname, port);
                BufferedReader reader = null;
                try {
                    OutputStream outstream = sock.getOutputStream();
                    outstream.write("stat".getBytes());
                    outstream.flush();
                    InputStreamReader isr = new InputStreamReader(sock.getInputStream());
                    reader = new BufferedReader(isr);
                    String line = reader.readLine();
                    if (line != null && line.startsWith("Zookeeper version:")) {
                        boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    sock.close();
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
            catch (IOException e) {
                logger.info("server " + hostname + ":" + port + " not up " + e);
            }
            if (System.currentTimeMillis() > start + timeout) {
                return false;
            }
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
            }
        }
    }

    static {
        MiniCluster.registerService(ZookeeperService.class);
    }
}

