/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink.hdfs;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.flume.Clock;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.SystemClock;
import org.apache.flume.instrumentation.SinkCounter;
import org.apache.flume.sink.hdfs.BucketClosedException;
import org.apache.flume.sink.hdfs.HDFSEventSink;
import org.apache.flume.sink.hdfs.HDFSWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BucketWriter {
    private static final Logger LOG = LoggerFactory.getLogger(BucketWriter.class);
    private static final Integer staticLock = new Integer(1);
    private final HDFSWriter writer;
    private final long rollInterval;
    private final long rollSize;
    private final long rollCount;
    private final long batchSize;
    private final CompressionCodec codeC;
    private final SequenceFile.CompressionType compType;
    private final ScheduledExecutorService timedRollerPool;
    private final UserGroupInformation user;
    private final AtomicLong fileExtensionCounter;
    private long eventCounter;
    private long processSize;
    private FileSystem fileSystem;
    private volatile String filePath;
    private volatile String fileName;
    private volatile String inUsePrefix;
    private volatile String inUseSuffix;
    private volatile String fileSuffix;
    private volatile String bucketPath;
    private volatile String targetPath;
    private volatile long batchCounter;
    private volatile boolean isOpen;
    private volatile boolean isUnderReplicated;
    private volatile int consecutiveUnderReplRotateCount = 0;
    private volatile ScheduledFuture<Void> timedRollFuture;
    private SinkCounter sinkCounter;
    private final int idleTimeout;
    private volatile ScheduledFuture<Void> idleFuture;
    private final HDFSEventSink.WriterCallback onCloseCallback;
    private final String onCloseCallbackPath;
    private final long callTimeout;
    private final ExecutorService callTimeoutPool;
    private final int maxConsecUnderReplRotations = 30;
    private Clock clock = new SystemClock();
    protected boolean closed = false;

    BucketWriter(long rollInterval, long rollSize, long rollCount, long batchSize, Context context, String filePath, String fileName, String inUsePrefix, String inUseSuffix, String fileSuffix, CompressionCodec codeC, SequenceFile.CompressionType compType, HDFSWriter writer, ScheduledExecutorService timedRollerPool, UserGroupInformation user, SinkCounter sinkCounter, int idleTimeout, HDFSEventSink.WriterCallback onCloseCallback, String onCloseCallbackPath, long callTimeout, ExecutorService callTimeoutPool) {
        this.rollInterval = rollInterval;
        this.rollSize = rollSize;
        this.rollCount = rollCount;
        this.batchSize = batchSize;
        this.filePath = filePath;
        this.fileName = fileName;
        this.inUsePrefix = inUsePrefix;
        this.inUseSuffix = inUseSuffix;
        this.fileSuffix = fileSuffix;
        this.codeC = codeC;
        this.compType = compType;
        this.writer = writer;
        this.timedRollerPool = timedRollerPool;
        this.user = user;
        this.sinkCounter = sinkCounter;
        this.idleTimeout = idleTimeout;
        this.onCloseCallback = onCloseCallback;
        this.onCloseCallbackPath = onCloseCallbackPath;
        this.callTimeout = callTimeout;
        this.callTimeoutPool = callTimeoutPool;
        this.fileExtensionCounter = new AtomicLong(this.clock.currentTimeMillis());
        this.isOpen = false;
        this.isUnderReplicated = false;
        this.writer.configure(context);
    }

    private <T> T runPrivileged(PrivilegedExceptionAction<T> action) throws IOException, InterruptedException {
        if (this.user != null) {
            return (T)this.user.doAs(action);
        }
        try {
            return action.run();
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (InterruptedException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException("Unexpected exception.", ex);
        }
    }

    private void resetCounters() {
        this.eventCounter = 0L;
        this.processSize = 0L;
        this.batchCounter = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void open() throws IOException, InterruptedException {
        if (this.filePath == null || this.writer == null) {
            throw new IOException("Invalid file settings");
        }
        final Configuration config = new Configuration();
        config.setBoolean("fs.automatic.close", false);
        Integer n = staticLock;
        synchronized (n) {
            BucketWriter.checkAndThrowInterruptedException();
            try {
                long counter = this.fileExtensionCounter.incrementAndGet();
                String fullFileName = this.fileName + "." + counter;
                if (this.fileSuffix != null && this.fileSuffix.length() > 0) {
                    fullFileName = fullFileName + this.fileSuffix;
                } else if (this.codeC != null) {
                    fullFileName = fullFileName + this.codeC.getDefaultExtension();
                }
                this.bucketPath = this.filePath + "/" + this.inUsePrefix + fullFileName + this.inUseSuffix;
                this.targetPath = this.filePath + "/" + fullFileName;
                LOG.info("Creating " + this.bucketPath);
                this.callWithTimeout(new CallRunner<Void>(){

                    @Override
                    public Void call() throws Exception {
                        if (BucketWriter.this.codeC == null) {
                            BucketWriter.this.fileSystem = new Path(BucketWriter.this.bucketPath).getFileSystem(config);
                            BucketWriter.this.writer.open(BucketWriter.this.bucketPath);
                        } else {
                            BucketWriter.this.fileSystem = new Path(BucketWriter.this.bucketPath).getFileSystem(config);
                            BucketWriter.this.writer.open(BucketWriter.this.bucketPath, BucketWriter.this.codeC, BucketWriter.this.compType);
                        }
                        return null;
                    }
                });
            }
            catch (Exception ex) {
                this.sinkCounter.incrementConnectionFailedCount();
                if (ex instanceof IOException) {
                    throw (IOException)ex;
                }
                throw Throwables.propagate((Throwable)ex);
            }
        }
        this.sinkCounter.incrementConnectionCreatedCount();
        this.resetCounters();
        if (this.rollInterval > 0L) {
            Callable<Void> action = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    LOG.debug("Rolling file ({}): Roll scheduled after {} sec elapsed.", (Object)BucketWriter.this.bucketPath, (Object)BucketWriter.this.rollInterval);
                    try {
                        BucketWriter.this.close(true);
                    }
                    catch (Throwable t) {
                        LOG.error("Unexpected error", t);
                    }
                    return null;
                }
            };
            this.timedRollFuture = this.timedRollerPool.schedule(action, this.rollInterval, TimeUnit.SECONDS);
        }
        this.isOpen = true;
    }

    public synchronized void close() throws IOException, InterruptedException {
        this.close(false);
    }

    public synchronized void close(boolean callCloseCallback) throws IOException, InterruptedException {
        BucketWriter.checkAndThrowInterruptedException();
        this.flush();
        LOG.debug("Closing {}", (Object)this.bucketPath);
        if (this.isOpen) {
            try {
                this.callWithTimeout(new CallRunner<Void>(){

                    @Override
                    public Void call() throws Exception {
                        BucketWriter.this.writer.close();
                        return null;
                    }
                });
                this.sinkCounter.incrementConnectionClosedCount();
            }
            catch (IOException e) {
                LOG.warn("failed to close() HDFSWriter for file (" + this.bucketPath + "). Exception follows.", (Throwable)e);
                this.sinkCounter.incrementConnectionFailedCount();
            }
            this.isOpen = false;
        } else {
            LOG.info("HDFSWriter is already closed: {}", (Object)this.bucketPath);
        }
        if (this.timedRollFuture != null && !this.timedRollFuture.isDone()) {
            this.timedRollFuture.cancel(false);
            this.timedRollFuture = null;
        }
        if (this.idleFuture != null && !this.idleFuture.isDone()) {
            this.idleFuture.cancel(false);
            this.idleFuture = null;
        }
        if (this.bucketPath != null && this.fileSystem != null) {
            this.renameBucket();
            this.fileSystem = null;
        }
        if (callCloseCallback) {
            this.runCloseAction();
            this.closed = true;
        }
    }

    public synchronized void flush() throws IOException, InterruptedException {
        BucketWriter.checkAndThrowInterruptedException();
        if (!this.isBatchComplete()) {
            this.doFlush();
            if (this.idleTimeout > 0 && (this.idleFuture == null || this.idleFuture.cancel(false))) {
                Callable<Void> idleAction = new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        LOG.info("Closing idle bucketWriter {} at {}", (Object)BucketWriter.this.bucketPath, (Object)System.currentTimeMillis());
                        if (BucketWriter.this.isOpen) {
                            BucketWriter.this.close(true);
                        }
                        return null;
                    }
                };
                this.idleFuture = this.timedRollerPool.schedule(idleAction, (long)this.idleTimeout, TimeUnit.SECONDS);
            }
        }
    }

    private void runCloseAction() {
        try {
            if (this.onCloseCallback != null) {
                this.onCloseCallback.run(this.onCloseCallbackPath);
            }
        }
        catch (Throwable t) {
            LOG.error("Unexpected error", t);
        }
    }

    private void doFlush() throws IOException, InterruptedException {
        this.callWithTimeout(new CallRunner<Void>(){

            @Override
            public Void call() throws Exception {
                BucketWriter.this.writer.sync();
                return null;
            }
        });
        this.batchCounter = 0L;
    }

    public synchronized void append(final Event event) throws IOException, InterruptedException {
        BucketWriter.checkAndThrowInterruptedException();
        if (this.idleFuture != null) {
            this.idleFuture.cancel(false);
            if (!this.idleFuture.isDone()) {
                try {
                    this.idleFuture.get(this.callTimeout, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException ex) {
                    LOG.warn("Timeout while trying to cancel closing of idle file. Idle file close may have failed", (Throwable)ex);
                }
                catch (Exception ex) {
                    LOG.warn("Error while trying to cancel closing of idle file. ", (Throwable)ex);
                }
            }
            this.idleFuture = null;
        }
        if (!this.isOpen) {
            if (this.closed) {
                throw new BucketClosedException("This bucket writer was closed and this handle is thus no longer valid");
            }
            this.open();
        }
        if (this.shouldRotate()) {
            boolean doRotate = true;
            if (this.isUnderReplicated) {
                if (this.consecutiveUnderReplRotateCount >= 30) {
                    doRotate = false;
                    if (this.consecutiveUnderReplRotateCount == 30) {
                        LOG.error("Hit max consecutive under-replication rotations ({}); will not continue rolling files under this path due to under-replication", (Object)30);
                    }
                } else {
                    LOG.warn("Block Under-replication detected. Rotating file.");
                }
                ++this.consecutiveUnderReplRotateCount;
            } else {
                this.consecutiveUnderReplRotateCount = 0;
            }
            if (doRotate) {
                this.close();
                this.open();
            }
        }
        try {
            this.sinkCounter.incrementEventDrainAttemptCount();
            this.callWithTimeout(new CallRunner<Void>(){

                @Override
                public Void call() throws Exception {
                    BucketWriter.this.writer.append(event);
                    return null;
                }
            });
        }
        catch (IOException e) {
            LOG.warn("Caught IOException writing to HDFSWriter ({}). Closing file (" + this.bucketPath + ") and rethrowing exception.", (Object)e.getMessage());
            try {
                this.close(true);
            }
            catch (IOException e2) {
                LOG.warn("Caught IOException while closing file (" + this.bucketPath + "). Exception follows.", (Throwable)e2);
            }
            throw e;
        }
        this.processSize += (long)event.getBody().length;
        ++this.eventCounter;
        ++this.batchCounter;
        if (this.batchCounter == this.batchSize) {
            this.flush();
        }
    }

    private boolean shouldRotate() {
        boolean doRotate = false;
        if (this.writer.isUnderReplicated()) {
            this.isUnderReplicated = true;
            doRotate = true;
        } else {
            this.isUnderReplicated = false;
        }
        if (this.rollCount > 0L && this.rollCount <= this.eventCounter) {
            LOG.debug("rolling: rollCount: {}, events: {}", (Object)this.rollCount, (Object)this.eventCounter);
            doRotate = true;
        }
        if (this.rollSize > 0L && this.rollSize <= this.processSize) {
            LOG.debug("rolling: rollSize: {}, bytes: {}", (Object)this.rollSize, (Object)this.processSize);
            doRotate = true;
        }
        return doRotate;
    }

    private void renameBucket() throws IOException, InterruptedException {
        if (this.bucketPath.equals(this.targetPath)) {
            return;
        }
        final Path srcPath = new Path(this.bucketPath);
        final Path dstPath = new Path(this.targetPath);
        this.callWithTimeout(new CallRunner<Object>(){

            @Override
            public Object call() throws Exception {
                if (BucketWriter.this.fileSystem.exists(srcPath)) {
                    LOG.info("Renaming " + srcPath + " to " + dstPath);
                    BucketWriter.this.fileSystem.rename(srcPath, dstPath);
                }
                return null;
            }
        });
    }

    public String toString() {
        return "[ " + this.getClass().getSimpleName() + " targetPath = " + this.targetPath + ", bucketPath = " + this.bucketPath + " ]";
    }

    private boolean isBatchComplete() {
        return this.batchCounter == 0L;
    }

    void setClock(Clock clock) {
        this.clock = clock;
    }

    private static void checkAndThrowInterruptedException() throws InterruptedException {
        Thread.currentThread();
        if (Thread.interrupted()) {
            throw new InterruptedException("Timed out before HDFS call was made. Your hdfs.callTimeout might be set too low or HDFS calls are taking too long.");
        }
    }

    private <T> T callWithTimeout(final CallRunner<T> callRunner) throws IOException, InterruptedException {
        Future future = this.callTimeoutPool.submit(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return BucketWriter.this.runPrivileged(new PrivilegedExceptionAction<T>(){

                    @Override
                    public T run() throws Exception {
                        return callRunner.call();
                    }
                });
            }
        });
        try {
            if (this.callTimeout > 0L) {
                return future.get(this.callTimeout, TimeUnit.MILLISECONDS);
            }
            return future.get();
        }
        catch (TimeoutException eT) {
            future.cancel(true);
            this.sinkCounter.incrementConnectionFailedCount();
            throw new IOException("Callable timed out after " + this.callTimeout + " ms" + " on file: " + this.bucketPath, eT);
        }
        catch (ExecutionException e1) {
            this.sinkCounter.incrementConnectionFailedCount();
            Throwable cause = e1.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof InterruptedException) {
                throw (InterruptedException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new RuntimeException(e1);
        }
        catch (CancellationException ce) {
            throw new InterruptedException("Blocked callable interrupted by rotation event");
        }
        catch (InterruptedException ex) {
            LOG.warn("Unexpected Exception " + ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    private static interface CallRunner<T> {
        public T call() throws Exception;
    }
}

