/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.qjournal.client;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.qjournal.QJMTestUtil;
import org.apache.hadoop.hdfs.qjournal.client.AsyncLogger;
import org.apache.hadoop.hdfs.qjournal.client.QuorumException;
import org.apache.hadoop.hdfs.qjournal.client.QuorumJournalManager;
import org.apache.hadoop.hdfs.qjournal.client.QuorumOutputStream;
import org.apache.hadoop.hdfs.qjournal.protocol.QJournalProtocolProtos;
import org.apache.hadoop.hdfs.server.namenode.EditLogOutputStream;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Stubber;

public class TestQuorumJournalManagerUnit {
    private static final NamespaceInfo FAKE_NSINFO;
    private Configuration conf = new Configuration();
    private List<AsyncLogger> spyLoggers;
    private QuorumJournalManager qjm;

    @Before
    public void setup() throws Exception {
        this.spyLoggers = ImmutableList.of((Object)this.mockLogger(), (Object)this.mockLogger(), (Object)this.mockLogger());
        this.qjm = new QuorumJournalManager(this.conf, new URI("qjournal://host/jid"), FAKE_NSINFO){

            protected List<AsyncLogger> createLoggers(AsyncLogger.Factory factory) {
                return TestQuorumJournalManagerUnit.this.spyLoggers;
            }
        };
        for (AsyncLogger logger : this.spyLoggers) {
            ((AsyncLogger)TestQuorumJournalManagerUnit.futureReturns(QJournalProtocolProtos.GetJournalStateResponseProto.newBuilder().setLastPromisedEpoch(0L).setHttpPort(-1).build()).when((Object)logger)).getJournalState();
            ((AsyncLogger)TestQuorumJournalManagerUnit.futureReturns(QJournalProtocolProtos.NewEpochResponseProto.newBuilder().build()).when((Object)logger)).newEpoch(Mockito.anyLong());
            ((AsyncLogger)TestQuorumJournalManagerUnit.futureReturns(null).when((Object)logger)).format((NamespaceInfo)Mockito.any());
        }
        this.qjm.recoverUnfinalizedSegments();
    }

    private AsyncLogger mockLogger() {
        return (AsyncLogger)Mockito.mock(AsyncLogger.class);
    }

    static <V> Stubber futureReturns(V value) {
        ListenableFuture ret = Futures.immediateFuture(value);
        return Mockito.doReturn((Object)ret);
    }

    static Stubber futureThrows(Throwable t) {
        ListenableFuture ret = Futures.immediateFailedFuture((Throwable)t);
        return Mockito.doReturn((Object)ret);
    }

    @Test
    public void testAllLoggersStartOk() throws Exception {
        ((AsyncLogger)TestQuorumJournalManagerUnit.futureReturns(null).when((Object)this.spyLoggers.get(0))).startLogSegment(Mockito.anyLong());
        ((AsyncLogger)TestQuorumJournalManagerUnit.futureReturns(null).when((Object)this.spyLoggers.get(1))).startLogSegment(Mockito.anyLong());
        ((AsyncLogger)TestQuorumJournalManagerUnit.futureReturns(null).when((Object)this.spyLoggers.get(2))).startLogSegment(Mockito.anyLong());
        this.qjm.startLogSegment(1L);
    }

    @Test
    public void testQuorumOfLoggersStartOk() throws Exception {
        ((AsyncLogger)TestQuorumJournalManagerUnit.futureReturns(null).when((Object)this.spyLoggers.get(0))).startLogSegment(Mockito.anyLong());
        ((AsyncLogger)TestQuorumJournalManagerUnit.futureReturns(null).when((Object)this.spyLoggers.get(1))).startLogSegment(Mockito.anyLong());
        ((AsyncLogger)TestQuorumJournalManagerUnit.futureThrows(new IOException("logger failed")).when((Object)this.spyLoggers.get(2))).startLogSegment(Mockito.anyLong());
        this.qjm.startLogSegment(1L);
    }

    @Test
    public void testQuorumOfLoggersFail() throws Exception {
        ((AsyncLogger)TestQuorumJournalManagerUnit.futureReturns(null).when((Object)this.spyLoggers.get(0))).startLogSegment(Mockito.anyLong());
        ((AsyncLogger)TestQuorumJournalManagerUnit.futureThrows(new IOException("logger failed")).when((Object)this.spyLoggers.get(1))).startLogSegment(Mockito.anyLong());
        ((AsyncLogger)TestQuorumJournalManagerUnit.futureThrows(new IOException("logger failed")).when((Object)this.spyLoggers.get(2))).startLogSegment(Mockito.anyLong());
        try {
            this.qjm.startLogSegment(1L);
            Assert.fail((String)"Did not throw when quorum failed");
        }
        catch (QuorumException qe) {
            GenericTestUtils.assertExceptionContains((String)"logger failed", (Throwable)qe);
        }
    }

    @Test
    public void testQuorumOutputStreamReport() throws Exception {
        ((AsyncLogger)TestQuorumJournalManagerUnit.futureReturns(null).when((Object)this.spyLoggers.get(0))).startLogSegment(Mockito.anyLong());
        ((AsyncLogger)TestQuorumJournalManagerUnit.futureReturns(null).when((Object)this.spyLoggers.get(1))).startLogSegment(Mockito.anyLong());
        ((AsyncLogger)TestQuorumJournalManagerUnit.futureReturns(null).when((Object)this.spyLoggers.get(2))).startLogSegment(Mockito.anyLong());
        QuorumOutputStream os = (QuorumOutputStream)this.qjm.startLogSegment(1L);
        String report = os.generateReport();
        junit.framework.Assert.assertFalse((String)"Report should be plain text", (boolean)report.contains("<"));
    }

    @Test
    public void testWriteEdits() throws Exception {
        EditLogOutputStream stm = this.createLogSegment();
        QJMTestUtil.writeOp(stm, 1L);
        QJMTestUtil.writeOp(stm, 2L);
        stm.setReadyToFlush();
        QJMTestUtil.writeOp(stm, 3L);
        ((AsyncLogger)TestQuorumJournalManagerUnit.futureReturns(null).when((Object)this.spyLoggers.get(0))).sendEdits(Matchers.anyLong(), Matchers.eq((long)1L), Matchers.eq((int)2), (byte[])Mockito.any());
        ((AsyncLogger)TestQuorumJournalManagerUnit.futureReturns(null).when((Object)this.spyLoggers.get(1))).sendEdits(Matchers.anyLong(), Matchers.eq((long)1L), Matchers.eq((int)2), (byte[])Mockito.any());
        ((AsyncLogger)TestQuorumJournalManagerUnit.futureReturns(null).when((Object)this.spyLoggers.get(2))).sendEdits(Matchers.anyLong(), Matchers.eq((long)1L), Matchers.eq((int)2), (byte[])Mockito.any());
        stm.flush();
        stm.setReadyToFlush();
        ((AsyncLogger)TestQuorumJournalManagerUnit.futureReturns(null).when((Object)this.spyLoggers.get(0))).sendEdits(Matchers.anyLong(), Matchers.eq((long)3L), Matchers.eq((int)1), (byte[])Mockito.any());
        ((AsyncLogger)TestQuorumJournalManagerUnit.futureReturns(null).when((Object)this.spyLoggers.get(1))).sendEdits(Matchers.anyLong(), Matchers.eq((long)3L), Matchers.eq((int)1), (byte[])Mockito.any());
        ((AsyncLogger)TestQuorumJournalManagerUnit.futureReturns(null).when((Object)this.spyLoggers.get(2))).sendEdits(Matchers.anyLong(), Matchers.eq((long)3L), Matchers.eq((int)1), (byte[])Mockito.any());
        stm.flush();
    }

    @Test
    public void testWriteEditsOneSlow() throws Exception {
        EditLogOutputStream stm = this.createLogSegment();
        QJMTestUtil.writeOp(stm, 1L);
        stm.setReadyToFlush();
        ((AsyncLogger)TestQuorumJournalManagerUnit.futureReturns(null).when((Object)this.spyLoggers.get(0))).sendEdits(Matchers.anyLong(), Matchers.eq((long)1L), Matchers.eq((int)1), (byte[])Mockito.any());
        ((AsyncLogger)TestQuorumJournalManagerUnit.futureReturns(null).when((Object)this.spyLoggers.get(1))).sendEdits(Matchers.anyLong(), Matchers.eq((long)1L), Matchers.eq((int)1), (byte[])Mockito.any());
        SettableFuture slowLog = SettableFuture.create();
        ((AsyncLogger)Mockito.doReturn((Object)slowLog).when((Object)this.spyLoggers.get(2))).sendEdits(Matchers.anyLong(), Matchers.eq((long)1L), Matchers.eq((int)1), (byte[])Mockito.any());
        stm.flush();
        ((AsyncLogger)Mockito.verify((Object)this.spyLoggers.get(0))).setCommittedTxId(1L);
    }

    private EditLogOutputStream createLogSegment() throws IOException {
        ((AsyncLogger)TestQuorumJournalManagerUnit.futureReturns(null).when((Object)this.spyLoggers.get(0))).startLogSegment(Mockito.anyLong());
        ((AsyncLogger)TestQuorumJournalManagerUnit.futureReturns(null).when((Object)this.spyLoggers.get(1))).startLogSegment(Mockito.anyLong());
        ((AsyncLogger)TestQuorumJournalManagerUnit.futureReturns(null).when((Object)this.spyLoggers.get(2))).startLogSegment(Mockito.anyLong());
        EditLogOutputStream stm = this.qjm.startLogSegment(1L);
        return stm;
    }

    static {
        ((Log4JLogger)QuorumJournalManager.LOG).getLogger().setLevel(Level.ALL);
        FAKE_NSINFO = new NamespaceInfo(12345, "mycluster", "my-bp", 0L);
    }
}

