/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NamenodeJspHelper;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.Phase;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StartupProgress;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.VersionInfo;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.znerd.xmlenc.XMLOutputter;

public class TestNameNodeJspHelper {
    private static final int DATA_NODES_AMOUNT = 2;
    private static MiniDFSCluster cluster;
    private static Configuration conf;
    private static final String NAMENODE_ATTRIBUTE_KEY = "name.node";

    @BeforeClass
    public static void setUp() throws Exception {
        conf = new HdfsConfiguration();
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).build();
        cluster.waitClusterUp();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Test
    public void testDelegationToken() throws IOException, InterruptedException {
        NamenodeProtocols nn = cluster.getNameNodeRpc();
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"auser");
        String tokenString = NamenodeJspHelper.getDelegationToken((NamenodeProtocols)nn, (HttpServletRequest)request, (Configuration)conf, (UserGroupInformation)ugi);
        Assert.assertEquals(null, (Object)tokenString);
    }

    @Test
    public void testSecurityModeText() {
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        String securityOnOff = NamenodeJspHelper.getSecurityModeText();
        Assert.assertTrue((String)"security mode doesn't match. Should be ON", (boolean)securityOnOff.contains("ON"));
        conf.set("hadoop.security.authentication", "simple");
        UserGroupInformation.setConfiguration((Configuration)conf);
        securityOnOff = NamenodeJspHelper.getSecurityModeText();
        Assert.assertTrue((String)"security mode doesn't match. Should be OFF", (boolean)securityOnOff.contains("OFF"));
    }

    @Test
    public void testGenerateStartupProgress() throws Exception {
        cluster.waitClusterUp();
        NamenodeJspHelper.HealthJsp jsp = new NamenodeJspHelper.HealthJsp();
        StartupProgress prog = NameNode.getStartupProgress();
        JspWriter out = (JspWriter)Mockito.mock(JspWriter.class);
        jsp.generateStartupProgress(out, prog);
        ArgumentCaptor captor = ArgumentCaptor.forClass(String.class);
        ((JspWriter)Mockito.verify((Object)out, (VerificationMode)Mockito.atLeastOnce())).println((String)captor.capture());
        List contents = captor.getAllValues();
        Assert.assertTrue((boolean)TestNameNodeJspHelper.containsMatch(contents, "Elapsed Time\\:"));
        Assert.assertTrue((boolean)TestNameNodeJspHelper.containsMatch(contents, "Percent Complete\\:.*?100\\.00%"));
        Assert.assertTrue((boolean)TestNameNodeJspHelper.containsMatch(contents, Phase.LOADING_FSIMAGE.getDescription()));
        Assert.assertTrue((boolean)TestNameNodeJspHelper.containsMatch(contents, Phase.LOADING_EDITS.getDescription()));
        Assert.assertTrue((boolean)TestNameNodeJspHelper.containsMatch(contents, Phase.SAVING_CHECKPOINT.getDescription()));
        Assert.assertTrue((boolean)TestNameNodeJspHelper.containsMatch(contents, Phase.SAFEMODE.getDescription()));
    }

    @Test
    public void testGetRollingUpgradeText() {
        Assert.assertEquals((Object)"", (Object)NamenodeJspHelper.getRollingUpgradeText(null));
    }

    @Test
    public void testGetNameNodeLabel() {
        String nameNodeLabel = NamenodeJspHelper.getNameNodeLabel((NameNode)cluster.getNameNode());
        Assert.assertNotNull((Object)nameNodeLabel);
        Assert.assertFalse((boolean)nameNodeLabel.isEmpty());
    }

    @Test
    public void testGetNameNodeLabelNullRpcServer() {
        NameNode nn = (NameNode)Mockito.mock(NameNode.class);
        Mockito.when((Object)nn.getRpcServer()).thenReturn(null);
        String nameNodeLabel = NamenodeJspHelper.getNameNodeLabel((NameNode)cluster.getNameNode());
        Assert.assertNotNull((Object)nameNodeLabel);
        Assert.assertFalse((boolean)nameNodeLabel.isEmpty());
    }

    @Test
    public void testGenerateSnapshotReportNullNamesystem() throws Exception {
        NamenodeJspHelper.generateSnapshotReport((JspWriter)((JspWriter)Mockito.mock(JspWriter.class)), null);
    }

    @Test(expected=IOException.class)
    public void testRedirectToRandomDataNodeNullNamesystem() throws Exception {
        NameNode nn = (NameNode)Mockito.mock(NameNode.class);
        Mockito.when((Object)nn.getNamesystem()).thenReturn(null);
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        Mockito.when((Object)context.getAttribute(NAMENODE_ATTRIBUTE_KEY)).thenReturn((Object)nn);
        NamenodeJspHelper.redirectToRandomDataNode((ServletContext)context, (HttpServletRequest)((HttpServletRequest)Mockito.mock(HttpServletRequest.class)), (HttpServletResponse)((HttpServletResponse)Mockito.mock(HttpServletResponse.class)));
    }

    @Test
    public void testXMLBlockInfoNullNamesystem() throws IOException {
        XMLOutputter doc = new XMLOutputter((Writer)Mockito.mock(JspWriter.class), "UTF-8");
        new NamenodeJspHelper.XMLBlockInfo(null, Long.valueOf(1L)).toXML(doc);
    }

    @Test
    public void testXMLCorruptBlockInfoNullNamesystem() throws IOException {
        XMLOutputter doc = new XMLOutputter((Writer)Mockito.mock(JspWriter.class), "UTF-8");
        new NamenodeJspHelper.XMLCorruptBlockInfo(null, (Configuration)Mockito.mock(Configuration.class), 10, Long.valueOf(1L)).toXML(doc);
    }

    private static boolean containsMatch(List<String> list, String regex) {
        Pattern pattern = Pattern.compile(regex);
        for (String str : list) {
            if (!pattern.matcher(str).find()) continue;
            return true;
        }
        return false;
    }

    @Test(timeout=15000L)
    public void testGetRandomDatanode() {
        ImmutableSet set = ImmutableSet.of();
        NameNode nameNode = cluster.getNameNode();
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (DataNode dataNode : cluster.getDataNodes()) {
            builder.add((Object)dataNode.getDisplayName());
        }
        set = builder.build();
        for (int i = 0; i < 10; ++i) {
            DatanodeDescriptor dnDescriptor = NamenodeJspHelper.getRandomDatanode((NameNode)nameNode);
            Assert.assertTrue((String)"testGetRandomDatanode error", (boolean)set.contains((Object)dnDescriptor.toString()));
        }
    }

    @Test(timeout=15000L)
    public void testNamenodeJspHelperRedirectToRandomDataNode() throws IOException, InterruptedException {
        String urlPart = "browseDirectory.jsp?namenodeInfoPort=";
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse resp = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)request.getScheme()).thenReturn((Object)"http");
        Mockito.when((Object)request.getParameter("user.name")).thenReturn((Object)"localuser");
        Mockito.when((Object)context.getAttribute(NAMENODE_ATTRIBUTE_KEY)).thenReturn((Object)cluster.getNameNode());
        Mockito.when((Object)context.getAttribute("current.conf")).thenReturn((Object)conf);
        ArgumentCaptor captor = ArgumentCaptor.forClass(String.class);
        ((HttpServletResponse)Mockito.doAnswer((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocation) throws Throwable {
                return null;
            }
        }).when((Object)resp)).sendRedirect((String)captor.capture());
        NamenodeJspHelper.redirectToRandomDataNode((ServletContext)context, (HttpServletRequest)request, (HttpServletResponse)resp);
        Assert.assertTrue((boolean)((String)captor.getValue()).contains("browseDirectory.jsp?namenodeInfoPort="));
    }

    private void checkDeadLiveNodes(NameNode nameNode, int deadCount, int lifeCount) {
        FSNamesystem ns = nameNode.getNamesystem();
        DatanodeManager dm = ns.getBlockManager().getDatanodeManager();
        ArrayList live = new ArrayList();
        ArrayList dead = new ArrayList();
        dm.fetchDatanodes(live, dead, true);
        Assert.assertTrue((String)"checkDeadLiveNodes error !!!", (live.size() == lifeCount && dead.size() == deadCount ? 1 : 0) != 0);
    }

    @Test(timeout=15000L)
    public void testNodeListJspGenerateNodesList() throws IOException {
        NameNode nameNode = cluster.getNameNode();
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        Mockito.when((Object)context.getAttribute(NAMENODE_ATTRIBUTE_KEY)).thenReturn((Object)nameNode);
        Mockito.when((Object)context.getAttribute("name.node.address")).thenReturn((Object)cluster.getNameNode().getHttpAddress());
        this.checkDeadLiveNodes(nameNode, 0, 2);
        String output = this.getOutputFromGeneratedNodesList(context, DataNodeStatus.LIVE);
        this.assertCounts(DataNodeStatus.LIVE, output, 2);
        output = this.getOutputFromGeneratedNodesList(context, DataNodeStatus.DEAD);
        this.assertCounts(DataNodeStatus.DEAD, output, 0);
    }

    private void assertCounts(DataNodeStatus dataNodeStatus, String output, int expectedCount) {
        Matcher matcher = DataNodeStatus.LIVE.getPattern().matcher(output);
        if (matcher.find()) {
            String digitLine = output.substring(matcher.start(), matcher.end()).trim();
            Assert.assertTrue((String)"assertCounts error. actual != expected", (Integer.valueOf(digitLine) == expectedCount ? 1 : 0) != 0);
        } else {
            Assert.fail((String)"assertCount matcher error");
        }
    }

    private String getOutputFromGeneratedNodesList(ServletContext context, DataNodeStatus dnStatus) throws IOException {
        JspWriter out = (JspWriter)Mockito.mock(JspWriter.class);
        ArgumentCaptor captor = ArgumentCaptor.forClass(String.class);
        NamenodeJspHelper.NodeListJsp nodelistjsp = new NamenodeJspHelper.NodeListJsp();
        final StringBuffer buffer = new StringBuffer();
        ((JspWriter)Mockito.doAnswer((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invok) {
                Object[] args = invok.getArguments();
                buffer.append((String)args[0]);
                return null;
            }
        }).when((Object)out)).print((String)captor.capture());
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getScheme()).thenReturn((Object)"http");
        Mockito.when((Object)request.getParameter("whatNodes")).thenReturn((Object)dnStatus.name());
        nodelistjsp.generateNodesList(context, out, request);
        return buffer.toString();
    }

    @Test(timeout=15000L)
    public void testGetInodeLimitText() {
        NameNode nameNode = cluster.getNameNode();
        FSNamesystem fsn = nameNode.getNamesystem();
        ImmutableSet patterns = ImmutableSet.of((Object)"files and directories", (Object)"Heap Memory used", (Object)"Non Heap Memory used");
        String line = NamenodeJspHelper.getInodeLimitText((FSNamesystem)fsn);
        for (String pattern : patterns) {
            Assert.assertTrue((String)("testInodeLimitText error " + pattern), (boolean)line.contains(pattern));
        }
    }

    @Test(timeout=15000L)
    public void testGetVersionTable() {
        NameNode nameNode = cluster.getNameNode();
        FSNamesystem fsn = nameNode.getNamesystem();
        ImmutableSet patterns = ImmutableSet.of((Object)VersionInfo.getVersion(), (Object)VersionInfo.getRevision(), (Object)VersionInfo.getUser(), (Object)VersionInfo.getBranch(), (Object)fsn.getClusterId(), (Object)fsn.getBlockPoolId(), (Object[])new String[0]);
        String line = NamenodeJspHelper.getVersionTable((FSNamesystem)fsn);
        for (String pattern : patterns) {
            Assert.assertTrue((String)("testGetVersionTable error " + pattern), (boolean)line.contains(pattern));
        }
    }

    private static enum DataNodeStatus {
        LIVE("[Live Datanodes(| +):(| +)]\\d"),
        DEAD("[Dead Datanodes(| +):(| +)]\\d");

        private Pattern pattern;

        public Pattern getPattern() {
            return this.pattern;
        }

        private DataNodeStatus(String line) {
            this.pattern = Pattern.compile(line);
        }
    }
}

