/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.SnapshotAccessControlException;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotTestHelper;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestDisallowModifyROSnapshot {
    private static final Path dir = new Path("/TestSnapshot");
    private static final Path sub1 = new Path(dir, "sub1");
    private static final Path sub2 = new Path(dir, "sub2");
    protected static Configuration conf;
    protected static MiniDFSCluster cluster;
    protected static FSNamesystem fsn;
    protected static DistributedFileSystem fs;
    protected static ArrayList<Path> snapshotList;
    static Path objInSnapshot;

    @BeforeClass
    public static void setUp() throws Exception {
        conf = new Configuration();
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        cluster.waitActive();
        fsn = cluster.getNamesystem();
        fs = cluster.getFileSystem();
        Path path1 = new Path(sub1, "dir1");
        Assert.assertTrue((boolean)fs.mkdirs(path1));
        Path path2 = new Path(sub2, "dir2");
        Assert.assertTrue((boolean)fs.mkdirs(path2));
        SnapshotTestHelper.createSnapshot(fs, sub1, "testSnapshot");
        objInSnapshot = SnapshotTestHelper.getSnapshotPath(sub1, "testSnapshot", "dir1");
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Test(timeout=60000L, expected=SnapshotAccessControlException.class)
    public void testSetReplication() throws Exception {
        fs.setReplication(objInSnapshot, (short)1);
    }

    @Test(timeout=60000L, expected=SnapshotAccessControlException.class)
    public void testSetPermission() throws Exception {
        fs.setPermission(objInSnapshot, new FsPermission("777"));
    }

    @Test(timeout=60000L, expected=SnapshotAccessControlException.class)
    public void testSetOwner() throws Exception {
        fs.setOwner(objInSnapshot, "username", "groupname");
    }

    @Test(timeout=60000L)
    public void testRename() throws Exception {
        try {
            fs.rename(objInSnapshot, new Path("/invalid/path"));
            Assert.fail((String)"Didn't throw SnapshotAccessControlException");
        }
        catch (SnapshotAccessControlException e) {
            // empty catch block
        }
        try {
            fs.rename(sub2, objInSnapshot);
            Assert.fail((String)"Didn't throw SnapshotAccessControlException");
        }
        catch (SnapshotAccessControlException e) {
            // empty catch block
        }
        try {
            fs.rename(sub2, objInSnapshot, new Options.Rename[]{null});
            Assert.fail((String)"Didn't throw SnapshotAccessControlException");
        }
        catch (SnapshotAccessControlException snapshotAccessControlException) {
            // empty catch block
        }
    }

    @Test(timeout=60000L, expected=SnapshotAccessControlException.class)
    public void testDelete() throws Exception {
        fs.delete(objInSnapshot, true);
    }

    @Test(timeout=60000L, expected=SnapshotAccessControlException.class)
    public void testQuota() throws Exception {
        fs.setQuota(objInSnapshot, 100L, 100L);
    }

    @Test(timeout=60000L, expected=SnapshotAccessControlException.class)
    public void testSetTime() throws Exception {
        fs.setTimes(objInSnapshot, 100L, 100L);
    }

    @Test(timeout=60000L, expected=SnapshotAccessControlException.class)
    public void testCreate() throws Exception {
        DFSClient dfsclient = new DFSClient(conf);
        dfsclient.create(objInSnapshot.toString(), true);
    }

    @Test(timeout=60000L, expected=SnapshotAccessControlException.class)
    public void testAppend() throws Exception {
        fs.append(objInSnapshot, 65535, null);
    }

    @Test(timeout=60000L, expected=SnapshotAccessControlException.class)
    public void testMkdir() throws Exception {
        fs.mkdirs(objInSnapshot, new FsPermission("777"));
    }

    @Test(timeout=60000L, expected=SnapshotAccessControlException.class)
    public void testCreateSymlink() throws Exception {
        DFSClient dfsclient = new DFSClient(conf);
        dfsclient.createSymlink(sub2.toString(), "/TestSnapshot/sub1/.snapshot", false);
    }

    static {
        snapshotList = new ArrayList();
        objInSnapshot = null;
    }
}

