/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.mapreduce;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.reflect.ReflectData;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.kitesdk.compat.Hadoop;
import org.kitesdk.data.Dataset;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetException;
import org.kitesdk.data.DatasetWriter;
import org.kitesdk.data.Datasets;
import org.kitesdk.data.PartitionStrategy;
import org.kitesdk.data.TypeNotFoundException;
import org.kitesdk.data.View;
import org.kitesdk.data.spi.AbstractDataset;
import org.kitesdk.data.spi.Constraints;
import org.kitesdk.data.spi.DataModelUtil;
import org.kitesdk.data.spi.DatasetRepositories;
import org.kitesdk.data.spi.DatasetRepository;
import org.kitesdk.data.spi.Mergeable;
import org.kitesdk.data.spi.PartitionKey;
import org.kitesdk.data.spi.PartitionedDataset;
import org.kitesdk.data.spi.Registration;
import org.kitesdk.data.spi.TemporaryDatasetRepository;
import org.kitesdk.data.spi.TemporaryDatasetRepositoryAccessor;
import org.kitesdk.data.spi.filesystem.FileSystemDataset;

public class DatasetKeyOutputFormat<E>
extends OutputFormat<E, Void> {
    public static final String KITE_OUTPUT_URI = "kite.outputUri";
    public static final String KITE_PARTITION_DIR = "kite.outputPartitionDir";
    public static final String KITE_TYPE = "kite.outputEntityType";
    private static final String KITE_WRITE_MODE = "kite.outputMode";
    private static final String TEMP_NAMESPACE = "mr";

    public static ConfigBuilder configure(Job job) {
        job.setOutputFormatClass(DatasetKeyOutputFormat.class);
        return new ConfigBuilder(job);
    }

    public static ConfigBuilder configure(Configuration conf) {
        return new ConfigBuilder(conf);
    }

    public RecordWriter<E, Void> getRecordWriter(TaskAttemptContext taskAttemptContext) {
        Configuration conf = (Configuration)Hadoop.TaskAttemptContext.getConfiguration.invoke((Object)taskAttemptContext, new Object[0]);
        PartitionedDataset target = DatasetKeyOutputFormat.load((JobContext)taskAttemptContext);
        Object working = DatasetKeyOutputFormat.usePerTaskAttemptDatasets(target) ? DatasetKeyOutputFormat.loadOrCreateTaskAttemptView(taskAttemptContext) : target;
        String partitionDir = conf.get(KITE_PARTITION_DIR);
        if (working.getDataset().getDescriptor().isPartitioned() && partitionDir != null) {
            if (!(target instanceof FileSystemDataset)) {
                throw new UnsupportedOperationException("Partitions only supported for FileSystemDataset. Dataset: " + target);
            }
            FileSystemDataset fsDataset = (FileSystemDataset)target;
            PartitionKey key = fsDataset.keyFromDirectory(new Path(partitionDir));
            if (key != null) {
                working = fsDataset.getPartition(key, true);
            }
            return new DatasetRecordWriter<E>(working);
        }
        return new DatasetRecordWriter<E>(working);
    }

    public void checkOutputSpecs(JobContext jobContext) {
        View<E> target = DatasetKeyOutputFormat.load(jobContext);
        Configuration conf = (Configuration)Hadoop.JobContext.getConfiguration.invoke((Object)jobContext, new Object[0]);
        switch ((WriteMode)conf.getEnum(KITE_WRITE_MODE, (Enum)WriteMode.DEFAULT)) {
            case APPEND: {
                break;
            }
            case OVERWRITE: {
                if (target.isEmpty()) break;
                target.deleteAll();
                break;
            }
            default: {
                if (target.isEmpty()) break;
                throw new DatasetException("View is not empty: " + target);
            }
        }
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext taskAttemptContext) {
        View<E> view = DatasetKeyOutputFormat.load((JobContext)taskAttemptContext);
        return DatasetKeyOutputFormat.usePerTaskAttemptDatasets(view) ? new MergeOutputCommitter() : new NullOutputCommitter();
    }

    private static <E> boolean usePerTaskAttemptDatasets(View<E> target) {
        return !Hadoop.isHadoop1() && target.getDataset() instanceof Mergeable;
    }

    private static DatasetRepository getDatasetRepository(JobContext jobContext) {
        Configuration conf = (Configuration)Hadoop.JobContext.getConfiguration.invoke((Object)jobContext, new Object[0]);
        DatasetRepository repo = DatasetRepositories.repositoryFor((String)conf.get(KITE_OUTPUT_URI));
        if (repo instanceof TemporaryDatasetRepositoryAccessor) {
            Dataset dataset = DatasetKeyOutputFormat.load(jobContext).getDataset();
            String namespace = dataset.getNamespace();
            repo = ((TemporaryDatasetRepositoryAccessor)repo).getTemporaryRepository(namespace, DatasetKeyOutputFormat.getJobDatasetName(jobContext));
        }
        return repo;
    }

    private static String getJobDatasetName(JobContext jobContext) {
        return jobContext.getJobID().toString();
    }

    private static String getTaskAttemptDatasetName(TaskAttemptContext taskContext) {
        return taskContext.getTaskAttemptID().toString();
    }

    private static <E> View<E> load(JobContext jobContext) {
        Configuration conf = (Configuration)Hadoop.JobContext.getConfiguration.invoke((Object)jobContext, new Object[0]);
        Class<E> type = DatasetKeyOutputFormat.getType(jobContext);
        String outputUri = conf.get(KITE_OUTPUT_URI);
        return Datasets.load((String)outputUri, type);
    }

    private static <E> Class<E> getType(JobContext jobContext) {
        Class type;
        Configuration conf = (Configuration)Hadoop.JobContext.getConfiguration.invoke((Object)jobContext, new Object[0]);
        try {
            type = conf.getClass(KITE_TYPE, GenericData.Record.class);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof ClassNotFoundException) {
                throw new TypeNotFoundException(String.format("The Java class %s for the entity type could not be found", conf.get(KITE_TYPE)), e.getCause());
            }
            throw e;
        }
        return type;
    }

    private static <E> Dataset<E> createJobDataset(JobContext jobContext) {
        Dataset dataset = DatasetKeyOutputFormat.load(jobContext).getDataset();
        String jobDatasetName = DatasetKeyOutputFormat.getJobDatasetName(jobContext);
        DatasetRepository repo = DatasetKeyOutputFormat.getDatasetRepository(jobContext);
        return repo.create(TEMP_NAMESPACE, jobDatasetName, DatasetKeyOutputFormat.copy(dataset.getDescriptor()), DatasetKeyOutputFormat.getType(jobContext));
    }

    private static <E> Dataset<E> loadJobDataset(JobContext jobContext) {
        DatasetRepository repo = DatasetKeyOutputFormat.getDatasetRepository(jobContext);
        return repo.load(TEMP_NAMESPACE, DatasetKeyOutputFormat.getJobDatasetName(jobContext));
    }

    private static void deleteJobDataset(JobContext jobContext) {
        DatasetRepository repo = DatasetKeyOutputFormat.getDatasetRepository(jobContext);
        repo.delete(TEMP_NAMESPACE, DatasetKeyOutputFormat.getJobDatasetName(jobContext));
    }

    private static <E> Dataset<E> loadOrCreateTaskAttemptDataset(TaskAttemptContext taskContext) {
        String taskAttemptDatasetName = DatasetKeyOutputFormat.getTaskAttemptDatasetName(taskContext);
        DatasetRepository repo = DatasetKeyOutputFormat.getDatasetRepository((JobContext)taskContext);
        Dataset<E> jobDataset = DatasetKeyOutputFormat.loadJobDataset((JobContext)taskContext);
        if (repo.exists(TEMP_NAMESPACE, taskAttemptDatasetName)) {
            return repo.load(TEMP_NAMESPACE, taskAttemptDatasetName);
        }
        return repo.create(TEMP_NAMESPACE, taskAttemptDatasetName, DatasetKeyOutputFormat.copy(jobDataset.getDescriptor()));
    }

    private static <E> View<E> loadOrCreateTaskAttemptView(TaskAttemptContext taskContext) {
        Configuration conf = (Configuration)Hadoop.JobContext.getConfiguration.invoke((Object)taskContext, new Object[0]);
        Map uriOptions = (Map)Registration.lookupDatasetUri((URI)URI.create(URI.create(conf.get(KITE_OUTPUT_URI)).getSchemeSpecificPart())).second();
        Dataset<E> dataset = DatasetKeyOutputFormat.loadOrCreateTaskAttemptDataset(taskContext);
        if (dataset instanceof AbstractDataset) {
            DatasetDescriptor descriptor = dataset.getDescriptor();
            Schema schema = descriptor.getSchema();
            PartitionStrategy strategy = null;
            if (descriptor.isPartitioned()) {
                strategy = descriptor.getPartitionStrategy();
            }
            Constraints constraints = Constraints.fromQueryMap((Schema)schema, (PartitionStrategy)strategy, (Map)uriOptions);
            return ((AbstractDataset)dataset).filter(constraints);
        }
        return dataset;
    }

    private static void deleteTaskAttemptDataset(TaskAttemptContext taskContext) {
        String taskAttemptDatasetName;
        DatasetRepository repo = DatasetKeyOutputFormat.getDatasetRepository((JobContext)taskContext);
        if (repo.exists(TEMP_NAMESPACE, taskAttemptDatasetName = DatasetKeyOutputFormat.getTaskAttemptDatasetName(taskContext))) {
            repo.delete(TEMP_NAMESPACE, taskAttemptDatasetName);
        }
    }

    private static DatasetDescriptor copy(DatasetDescriptor descriptor) {
        return new DatasetDescriptor.Builder(descriptor).property("kite.parquet.non-durable-writes", "true").location((URI)null).build();
    }

    static class MergeOutputCommitter<E>
    extends OutputCommitter {
        MergeOutputCommitter() {
        }

        public void setupJob(JobContext jobContext) {
            DatasetKeyOutputFormat.createJobDataset(jobContext);
        }

        public void commitJob(JobContext jobContext) throws IOException {
            DatasetRepository repo = DatasetKeyOutputFormat.getDatasetRepository(jobContext);
            boolean isTemp = repo instanceof TemporaryDatasetRepository;
            String jobDatasetName = DatasetKeyOutputFormat.getJobDatasetName(jobContext);
            View targetView = DatasetKeyOutputFormat.load(jobContext);
            Dataset jobDataset = repo.load(DatasetKeyOutputFormat.TEMP_NAMESPACE, jobDatasetName);
            ((Mergeable)targetView.getDataset()).merge((Object)jobDataset);
            if (isTemp) {
                ((TemporaryDatasetRepository)repo).delete();
            } else {
                repo.delete(DatasetKeyOutputFormat.TEMP_NAMESPACE, jobDatasetName);
            }
        }

        public void abortJob(JobContext jobContext, JobStatus.State state) {
            DatasetKeyOutputFormat.deleteJobDataset(jobContext);
        }

        public void setupTask(TaskAttemptContext taskContext) {
        }

        public boolean needsTaskCommit(TaskAttemptContext taskContext) {
            return true;
        }

        public void commitTask(TaskAttemptContext taskContext) throws IOException {
            DatasetRepository repo = DatasetKeyOutputFormat.getDatasetRepository((JobContext)taskContext);
            boolean inTempRepo = repo instanceof TemporaryDatasetRepository;
            Dataset jobDataset = repo.load(DatasetKeyOutputFormat.TEMP_NAMESPACE, DatasetKeyOutputFormat.getJobDatasetName((JobContext)taskContext));
            String taskAttemptDatasetName = DatasetKeyOutputFormat.getTaskAttemptDatasetName(taskContext);
            if (repo.exists(DatasetKeyOutputFormat.TEMP_NAMESPACE, taskAttemptDatasetName)) {
                Dataset taskAttemptDataset = repo.load(DatasetKeyOutputFormat.TEMP_NAMESPACE, taskAttemptDatasetName);
                ((Mergeable)jobDataset).merge((Object)taskAttemptDataset);
                if (!inTempRepo) {
                    repo.delete(DatasetKeyOutputFormat.TEMP_NAMESPACE, taskAttemptDatasetName);
                }
            }
        }

        public void abortTask(TaskAttemptContext taskContext) {
            DatasetKeyOutputFormat.deleteTaskAttemptDataset(taskContext);
        }
    }

    static class NullOutputCommitter
    extends OutputCommitter {
        NullOutputCommitter() {
        }

        public void setupJob(JobContext jobContext) {
        }

        public void setupTask(TaskAttemptContext taskContext) {
        }

        public boolean needsTaskCommit(TaskAttemptContext taskContext) {
            return false;
        }

        public void commitTask(TaskAttemptContext taskContext) {
        }

        public void abortTask(TaskAttemptContext taskContext) {
        }
    }

    static class DatasetRecordWriter<E>
    extends RecordWriter<E, Void> {
        private DatasetWriter<E> datasetWriter;
        private GenericData dataModel;
        private boolean copyEntities;
        private Schema schema;

        public DatasetRecordWriter(View<E> view) {
            this.datasetWriter = view.newWriter();
            this.schema = view.getDataset().getDescriptor().getSchema();
            this.dataModel = DataModelUtil.getDataModelForType((Class)view.getType());
            if (this.dataModel.getClass() != ReflectData.class) {
                this.copyEntities = true;
            }
        }

        public void write(E key, Void v) {
            if (this.copyEntities) {
                key = this.copy(key);
            }
            this.datasetWriter.write(key);
        }

        private <E> E copy(E key) {
            return (E)this.dataModel.deepCopy(this.schema, key);
        }

        public void close(TaskAttemptContext taskAttemptContext) {
            this.datasetWriter.close();
        }
    }

    public static class ConfigBuilder {
        private final Configuration conf;

        private ConfigBuilder(Job job) {
            this((Configuration)Hadoop.JobContext.getConfiguration.invoke((Object)job, new Object[0]));
        }

        private ConfigBuilder(Configuration conf) {
            this.conf = conf;
            conf.setBoolean("mapred.reducer.new-api", true);
        }

        public ConfigBuilder writeTo(URI uri) {
            this.conf.set(DatasetKeyOutputFormat.KITE_OUTPUT_URI, uri.toString());
            return this;
        }

        public ConfigBuilder overwrite(URI uri) {
            this.setOverwrite();
            return this.writeTo(uri);
        }

        public ConfigBuilder appendTo(URI uri) {
            this.setAppend();
            return this.writeTo(uri);
        }

        public ConfigBuilder writeTo(View<?> view) {
            if (view instanceof FileSystemDataset) {
                FileSystemDataset dataset = (FileSystemDataset)view;
                this.conf.set(DatasetKeyOutputFormat.KITE_PARTITION_DIR, String.valueOf(dataset.getDescriptor().getLocation()));
            }
            this.withType(view.getType());
            return this.writeTo(view.getUri());
        }

        public ConfigBuilder overwrite(View<?> view) {
            this.setOverwrite();
            return this.writeTo(view);
        }

        public ConfigBuilder appendTo(View<?> view) {
            this.setAppend();
            return this.writeTo(view);
        }

        public ConfigBuilder writeTo(String uri) {
            return this.writeTo(URI.create(uri));
        }

        public ConfigBuilder overwrite(String uri) {
            this.setOverwrite();
            return this.writeTo(uri);
        }

        public ConfigBuilder appendTo(String uri) {
            this.setAppend();
            return this.writeTo(uri);
        }

        public <E> ConfigBuilder withType(Class<E> type) {
            this.conf.setClass(DatasetKeyOutputFormat.KITE_TYPE, type, type);
            return this;
        }

        private void setOverwrite() {
            String mode = this.conf.get(DatasetKeyOutputFormat.KITE_WRITE_MODE);
            Preconditions.checkState((mode == null ? 1 : 0) != 0, (Object)("Cannot replace existing write mode: " + mode));
            this.conf.setEnum(DatasetKeyOutputFormat.KITE_WRITE_MODE, (Enum)WriteMode.OVERWRITE);
        }

        private void setAppend() {
            String mode = this.conf.get(DatasetKeyOutputFormat.KITE_WRITE_MODE);
            Preconditions.checkState((mode == null ? 1 : 0) != 0, (Object)("Cannot replace existing write mode: " + mode));
            this.conf.setEnum(DatasetKeyOutputFormat.KITE_WRITE_MODE, (Enum)WriteMode.APPEND);
        }
    }

    private static enum WriteMode {
        DEFAULT,
        APPEND,
        OVERWRITE;

    }
}

