/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.pipes;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.pipes.PipesNonJavaInputFormat;
import org.apache.hadoop.mapred.pipes.TestPipeApplication;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestPipesNonJavaInputFormat {
    private static File workSpace = new File("target", TestPipesNonJavaInputFormat.class.getName() + "-workSpace");

    @Test
    public void testFormat() throws IOException {
        File input2;
        PipesNonJavaInputFormat inputFormat = new PipesNonJavaInputFormat();
        JobConf conf = new JobConf();
        Reporter reporter = (Reporter)Mockito.mock(Reporter.class);
        RecordReader reader = inputFormat.getRecordReader((InputSplit)new TestPipeApplication.FakeSplit(), conf, reporter);
        Assert.assertEquals((double)0.0, (double)reader.getProgress(), (double)0.001);
        File input1 = new File(workSpace + File.separator + "input1");
        if (!input1.getParentFile().exists()) {
            Assert.assertTrue((boolean)input1.getParentFile().mkdirs());
        }
        if (!input1.exists()) {
            Assert.assertTrue((boolean)input1.createNewFile());
        }
        if (!(input2 = new File(workSpace + File.separator + "input2")).exists()) {
            Assert.assertTrue((boolean)input2.createNewFile());
        }
        conf.set("mapreduce.input.fileinputformat.inputdir", input1.getAbsolutePath() + "," + input2.getAbsolutePath());
        InputSplit[] splits = inputFormat.getSplits(conf, 2);
        Assert.assertEquals((long)2L, (long)splits.length);
        PipesNonJavaInputFormat.PipesDummyRecordReader dummyRecordReader = new PipesNonJavaInputFormat.PipesDummyRecordReader((Configuration)conf, splits[0]);
        Assert.assertNull((Object)dummyRecordReader.createKey());
        Assert.assertNull((Object)dummyRecordReader.createValue());
        Assert.assertEquals((long)0L, (long)dummyRecordReader.getPos());
        Assert.assertEquals((double)0.0, (double)dummyRecordReader.getProgress(), (double)0.001);
        Assert.assertTrue((boolean)dummyRecordReader.next(new FloatWritable(2.0f), NullWritable.get()));
        Assert.assertEquals((double)2.0, (double)dummyRecordReader.getProgress(), (double)0.001);
        dummyRecordReader.close();
    }
}

