/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskState;
import org.apache.hadoop.mapreduce.v2.app.ControlledClock;
import org.apache.hadoop.mapreduce.v2.app.MRApp;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptStatusUpdateEvent;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.junit.Test;

public class TestSpeculativeExecutionWithMRApp {
    private static final int NUM_MAPPERS = 5;
    private static final int NUM_REDUCERS = 0;

    @Test(timeout=60000L)
    public void testSpeculateSuccessfulWithoutUpdateEvents() throws Exception {
        SystemClock actualClock = new SystemClock();
        ControlledClock clock = new ControlledClock((Clock)actualClock);
        clock.setTime(System.currentTimeMillis());
        MRApp app = new MRApp(5, 0, false, "test", true, (Clock)clock);
        Job job = app.submit(new Configuration(), true, true);
        app.waitForState(job, JobState.RUNNING);
        Map tasks = job.getTasks();
        Assert.assertEquals((String)"Num tasks is not correct", (int)5, (int)tasks.size());
        Iterator taskIter = tasks.values().iterator();
        while (taskIter.hasNext()) {
            app.waitForState((Task)taskIter.next(), TaskState.RUNNING);
        }
        clock.setTime(System.currentTimeMillis() + 2000L);
        EventHandler appEventHandler = app.getContext().getEventHandler();
        for (Map.Entry mapTask : tasks.entrySet()) {
            for (Map.Entry taskAttempt : ((Task)mapTask.getValue()).getAttempts().entrySet()) {
                TaskAttemptStatusUpdateEvent.TaskAttemptStatus status = this.createTaskAttemptStatus((TaskAttemptId)taskAttempt.getKey(), 0.8f, TaskAttemptState.RUNNING);
                TaskAttemptStatusUpdateEvent event = new TaskAttemptStatusUpdateEvent((TaskAttemptId)taskAttempt.getKey(), status);
                appEventHandler.handle((Event)event);
            }
        }
        Random generator = new Random();
        Object[] taskValues = tasks.values().toArray();
        Task taskToBeSpeculated = (Task)taskValues[generator.nextInt(taskValues.length)];
        for (Map.Entry mapTask : tasks.entrySet()) {
            for (Map.Entry taskAttempt : ((Task)mapTask.getValue()).getAttempts().entrySet()) {
                if (mapTask.getKey() == taskToBeSpeculated.getID()) continue;
                appEventHandler.handle((Event)new TaskAttemptEvent((TaskAttemptId)taskAttempt.getKey(), TaskAttemptEventType.TA_DONE));
                appEventHandler.handle((Event)new TaskAttemptEvent((TaskAttemptId)taskAttempt.getKey(), TaskAttemptEventType.TA_CONTAINER_CLEANED));
                app.waitForState((TaskAttempt)taskAttempt.getValue(), TaskAttemptState.SUCCEEDED);
            }
        }
        boolean successfullySpeculated = false;
        TaskAttempt[] ta = null;
        for (int maxTimeWait = 10; maxTimeWait > 0 && !successfullySpeculated; --maxTimeWait) {
            if (taskToBeSpeculated.getAttempts().size() != 2) {
                Thread.sleep(1000L);
                clock.setTime(System.currentTimeMillis() + 20000L);
                continue;
            }
            successfullySpeculated = true;
            ta = TestSpeculativeExecutionWithMRApp.makeFirstAttemptWin(appEventHandler, taskToBeSpeculated);
        }
        Assert.assertTrue((String)"Couldn't speculate successfully", (boolean)successfullySpeculated);
        TestSpeculativeExecutionWithMRApp.verifySpeculationMessage(app, ta);
    }

    @Test(timeout=60000L)
    public void testSepculateSuccessfulWithUpdateEvents() throws Exception {
        TaskAttemptStatusUpdateEvent event;
        TaskAttemptStatusUpdateEvent.TaskAttemptStatus status;
        SystemClock actualClock = new SystemClock();
        ControlledClock clock = new ControlledClock((Clock)actualClock);
        clock.setTime(System.currentTimeMillis());
        MRApp app = new MRApp(5, 0, false, "test", true, (Clock)clock);
        Job job = app.submit(new Configuration(), true, true);
        app.waitForState(job, JobState.RUNNING);
        Map tasks = job.getTasks();
        Assert.assertEquals((String)"Num tasks is not correct", (int)5, (int)tasks.size());
        Iterator taskIter = tasks.values().iterator();
        while (taskIter.hasNext()) {
            app.waitForState((Task)taskIter.next(), TaskState.RUNNING);
        }
        clock.setTime(System.currentTimeMillis() + 1000L);
        EventHandler appEventHandler = app.getContext().getEventHandler();
        for (Map.Entry mapTask : tasks.entrySet()) {
            for (Map.Entry taskAttempt : ((Task)mapTask.getValue()).getAttempts().entrySet()) {
                TaskAttemptStatusUpdateEvent.TaskAttemptStatus status2 = this.createTaskAttemptStatus((TaskAttemptId)taskAttempt.getKey(), 0.5f, TaskAttemptState.RUNNING);
                TaskAttemptStatusUpdateEvent event2 = new TaskAttemptStatusUpdateEvent((TaskAttemptId)taskAttempt.getKey(), status2);
                appEventHandler.handle((Event)event2);
            }
        }
        Task speculatedTask = null;
        int numTasksToFinish = 4;
        clock.setTime(System.currentTimeMillis() + 1000L);
        for (Map.Entry task : tasks.entrySet()) {
            for (Map.Entry taskAttempt : ((Task)task.getValue()).getAttempts().entrySet()) {
                if (numTasksToFinish > 0) {
                    appEventHandler.handle((Event)new TaskAttemptEvent((TaskAttemptId)taskAttempt.getKey(), TaskAttemptEventType.TA_DONE));
                    appEventHandler.handle((Event)new TaskAttemptEvent((TaskAttemptId)taskAttempt.getKey(), TaskAttemptEventType.TA_CONTAINER_CLEANED));
                    --numTasksToFinish;
                    app.waitForState((TaskAttempt)taskAttempt.getValue(), TaskAttemptState.SUCCEEDED);
                    continue;
                }
                status = this.createTaskAttemptStatus((TaskAttemptId)taskAttempt.getKey(), 0.75f, TaskAttemptState.RUNNING);
                speculatedTask = (Task)task.getValue();
                event = new TaskAttemptStatusUpdateEvent((TaskAttemptId)taskAttempt.getKey(), status);
                appEventHandler.handle((Event)event);
            }
        }
        clock.setTime(System.currentTimeMillis() + 15000L);
        for (Map.Entry task : tasks.entrySet()) {
            for (Map.Entry taskAttempt : ((Task)task.getValue()).getAttempts().entrySet()) {
                if (((TaskAttempt)taskAttempt.getValue()).getState() == TaskAttemptState.SUCCEEDED) continue;
                status = this.createTaskAttemptStatus((TaskAttemptId)taskAttempt.getKey(), 0.75f, TaskAttemptState.RUNNING);
                event = new TaskAttemptStatusUpdateEvent((TaskAttemptId)taskAttempt.getKey(), status);
                appEventHandler.handle((Event)event);
            }
        }
        boolean successfullySpeculated = false;
        TaskAttempt[] ta = null;
        for (int maxTimeWait = 5; maxTimeWait > 0 && !successfullySpeculated; --maxTimeWait) {
            if (speculatedTask.getAttempts().size() != 2) {
                Thread.sleep(1000L);
                continue;
            }
            successfullySpeculated = true;
            ta = TestSpeculativeExecutionWithMRApp.makeFirstAttemptWin(appEventHandler, speculatedTask);
        }
        Assert.assertTrue((String)"Couldn't speculate successfully", (boolean)successfullySpeculated);
        TestSpeculativeExecutionWithMRApp.verifySpeculationMessage(app, ta);
    }

    private static TaskAttempt[] makeFirstAttemptWin(EventHandler appEventHandler, Task speculatedTask) {
        Collection attempts = speculatedTask.getAttempts().values();
        TaskAttempt[] ta = new TaskAttempt[attempts.size()];
        attempts.toArray(ta);
        appEventHandler.handle((Event)new TaskAttemptEvent(ta[0].getID(), TaskAttemptEventType.TA_DONE));
        appEventHandler.handle((Event)new TaskAttemptEvent(ta[0].getID(), TaskAttemptEventType.TA_CONTAINER_CLEANED));
        return ta;
    }

    private static void verifySpeculationMessage(MRApp app, TaskAttempt[] ta) throws Exception {
        app.waitForState(ta[0], TaskAttemptState.SUCCEEDED);
        app.waitForState(ta[1], TaskAttemptState.KILLED);
        boolean foundSpecMsg = false;
        for (String msg : ta[1].getDiagnostics()) {
            if (!msg.contains("Speculation")) continue;
            foundSpecMsg = true;
            break;
        }
        Assert.assertTrue((String)"No speculation diagnostics!", (boolean)foundSpecMsg);
    }

    private TaskAttemptStatusUpdateEvent.TaskAttemptStatus createTaskAttemptStatus(TaskAttemptId id, float progress, TaskAttemptState state) {
        TaskAttemptStatusUpdateEvent.TaskAttemptStatus status = new TaskAttemptStatusUpdateEvent.TaskAttemptStatus();
        status.id = id;
        status.progress = progress;
        status.taskState = state;
        return status;
    }
}

