/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import javax.jdo.Transaction;
import javax.jdo.datastore.JDOConnection;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.model.MDatabase;
import org.apache.hadoop.hive.metastore.parser.ExpressionTree;
import org.apache.hadoop.hive.serde.serdeConstants;

class MetaStoreDirectSql {
    private static final Log LOG = LogFactory.getLog(MetaStoreDirectSql.class);
    private final PersistenceManager pm;
    private final boolean isMySql;
    private final boolean isCompatibleDatastore;

    public MetaStoreDirectSql(PersistenceManager pm) {
        this.pm = pm;
        Transaction tx = pm.currentTransaction();
        tx.begin();
        boolean isMySql = false;
        try {
            this.trySetAnsiQuotesForMysql();
            isMySql = true;
        }
        catch (SQLException sqlEx) {
            LOG.info((Object)("MySQL check failed, assuming we are not on mysql: " + sqlEx.getMessage()));
            tx.rollback();
            tx = pm.currentTransaction();
            tx.begin();
        }
        pm.newQuery(MDatabase.class, "name == ''").execute();
        boolean isCompatibleDatastore = false;
        String selfTestQuery = "select \"DB_ID\" from \"DBS\"";
        try {
            pm.newQuery("javax.jdo.query.SQL", (Object)selfTestQuery).execute();
            isCompatibleDatastore = true;
            tx.commit();
        }
        catch (Exception ex) {
            LOG.error((Object)("Self-test query [" + selfTestQuery + "] failed; direct SQL is disabled"), (Throwable)ex);
            tx.rollback();
        }
        this.isCompatibleDatastore = isCompatibleDatastore;
        this.isMySql = isMySql;
    }

    public boolean isCompatibleDatastore() {
        return this.isCompatibleDatastore;
    }

    private void setAnsiQuotesForMysql() throws MetaException {
        try {
            this.trySetAnsiQuotesForMysql();
        }
        catch (SQLException sqlEx) {
            throw new MetaException("Error setting ansi quotes: " + sqlEx.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trySetAnsiQuotesForMysql() throws SQLException {
        String queryText = "SET @@session.sql_mode=ANSI_QUOTES";
        JDOConnection jdoConn = this.pm.getDataStoreConnection();
        boolean doTrace = LOG.isDebugEnabled();
        try {
            long start = doTrace ? System.nanoTime() : 0L;
            ((Connection)jdoConn.getNativeConnection()).createStatement().execute("SET @@session.sql_mode=ANSI_QUOTES");
            this.timingTrace(doTrace, "SET @@session.sql_mode=ANSI_QUOTES", start, doTrace ? System.nanoTime() : 0L);
        }
        finally {
            jdoConn.close();
        }
    }

    public List<Partition> getPartitionsViaSqlFilter(String dbName, String tblName, List<String> partNames, Integer max) throws MetaException {
        if (partNames.isEmpty()) {
            return new ArrayList<Partition>();
        }
        String list = StringUtils.repeat((String)",?", (int)partNames.size()).substring(1);
        return this.getPartitionsViaSqlFilterInternal(dbName, tblName, null, "\"PARTITIONS\".\"PART_NAME\" in (" + list + ")", partNames, new ArrayList<String>(), max);
    }

    public List<Partition> getPartitionsViaSqlFilter(Table table, ExpressionTree tree, Integer max) throws MetaException {
        assert (tree != null);
        ArrayList<Object> params = new ArrayList<Object>();
        ArrayList<String> joins = new ArrayList<String>();
        String sqlFilter = PartitionFilterGenerator.generateSqlFilter(table, tree, params, joins);
        if (sqlFilter == null) {
            return null;
        }
        return this.getPartitionsViaSqlFilterInternal(table.getDbName(), table.getTableName(), MetaStoreDirectSql.isViewTable(table), sqlFilter, params, joins, max);
    }

    public List<Partition> getPartitions(String dbName, String tblName, Integer max) throws MetaException {
        return this.getPartitionsViaSqlFilterInternal(dbName, tblName, null, null, new ArrayList(), new ArrayList<String>(), max);
    }

    private static Boolean isViewTable(Table t) {
        return t.isSetTableType() ? Boolean.valueOf(t.getTableType().equals(TableType.VIRTUAL_VIEW.toString())) : null;
    }

    private boolean isViewTable(String dbName, String tblName) throws MetaException {
        String queryText = "select \"TBL_TYPE\" from \"TBLS\" inner join \"DBS\" on \"TBLS\".\"DB_ID\" = \"DBS\".\"DB_ID\"  where \"TBLS\".\"TBL_NAME\" = ? and \"DBS\".\"NAME\" = ?";
        Object[] params = new Object[]{tblName, dbName};
        Query query = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
        query.setUnique(true);
        Object result = query.executeWithArray(params);
        return result != null && result.toString().equals(TableType.VIRTUAL_VIEW.toString());
    }

    private List<Partition> getPartitionsViaSqlFilterInternal(String dbName, String tblName, Boolean isView, String sqlFilter, List<? extends Object> paramsForFilter, List<String> joinsForFilter, Integer max) throws MetaException {
        boolean hasSkewedColumns;
        long queryTime;
        String orderForFilter;
        boolean doTrace = LOG.isDebugEnabled();
        dbName = dbName.toLowerCase();
        tblName = tblName.toLowerCase();
        String string = orderForFilter = max != null ? " order by \"PART_NAME\" asc" : "";
        if (this.isMySql) {
            assert (this.pm.currentTransaction().isActive());
            this.setAnsiQuotesForMysql();
        }
        String queryText = "select \"PARTITIONS\".\"PART_ID\" from \"PARTITIONS\"  inner join \"TBLS\" on \"PARTITIONS\".\"TBL_ID\" = \"TBLS\".\"TBL_ID\"     and \"TBLS\".\"TBL_NAME\" = ?   inner join \"DBS\" on \"TBLS\".\"DB_ID\" = \"DBS\".\"DB_ID\"      and \"DBS\".\"NAME\" = ? " + StringUtils.join(joinsForFilter, (char)' ') + (sqlFilter == null ? "" : " where " + sqlFilter) + orderForFilter;
        Object[] params = new Object[paramsForFilter.size() + 2];
        params[0] = tblName;
        params[1] = dbName;
        for (int i = 0; i < paramsForFilter.size(); ++i) {
            params[i + 2] = paramsForFilter.get(i);
        }
        long start = doTrace ? System.nanoTime() : 0L;
        Query query = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
        if (max != null) {
            query.setRange(0L, (long)max.shortValue());
        }
        List sqlResult = (List)query.executeWithArray(params);
        long l = queryTime = doTrace ? System.nanoTime() : 0L;
        if (sqlResult.isEmpty()) {
            this.timingTrace(doTrace, queryText, start, queryTime);
            return new ArrayList<Partition>();
        }
        int sbCapacity = sqlResult.size() * 7;
        StringBuilder partSb = new StringBuilder(sbCapacity);
        for (Object partitionId : sqlResult) {
            partSb.append((Long)partitionId).append(",");
        }
        String partIds = MetaStoreDirectSql.trimCommaList(partSb);
        this.timingTrace(doTrace, queryText, start, queryTime);
        queryText = "select \"PARTITIONS\".\"PART_ID\", \"SDS\".\"SD_ID\", \"SDS\".\"CD_ID\", \"SERDES\".\"SERDE_ID\", \"PARTITIONS\".\"CREATE_TIME\", \"PARTITIONS\".\"LAST_ACCESS_TIME\", \"SDS\".\"INPUT_FORMAT\", \"SDS\".\"IS_COMPRESSED\", \"SDS\".\"IS_STOREDASSUBDIRECTORIES\", \"SDS\".\"LOCATION\", \"SDS\".\"NUM_BUCKETS\", \"SDS\".\"OUTPUT_FORMAT\", \"SERDES\".\"NAME\", \"SERDES\".\"SLIB\" from \"PARTITIONS\"  left outer join \"SDS\" on \"PARTITIONS\".\"SD_ID\" = \"SDS\".\"SD_ID\"   left outer join \"SERDES\" on \"SDS\".\"SERDE_ID\" = \"SERDES\".\"SERDE_ID\" where \"PART_ID\" in (" + partIds + ") order by \"PART_NAME\" asc";
        start = doTrace ? System.nanoTime() : 0L;
        query = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
        List sqlResult2 = (List)query.executeWithArray(params);
        queryTime = doTrace ? System.nanoTime() : 0L;
        TreeMap<Long, Partition> partitions = new TreeMap<Long, Partition>();
        TreeMap<Long, StorageDescriptor> sds = new TreeMap<Long, StorageDescriptor>();
        TreeMap<Long, SerDeInfo> serdes = new TreeMap<Long, SerDeInfo>();
        TreeMap colss = new TreeMap();
        ArrayList<Partition> orderedResult = new ArrayList<Partition>(sqlResult.size());
        StringBuilder sdSb = new StringBuilder(sbCapacity);
        StringBuilder serdeSb = new StringBuilder(sbCapacity);
        StringBuilder colsSb = new StringBuilder(7);
        tblName = tblName.toLowerCase();
        dbName = dbName.toLowerCase();
        for (Object[] fields : sqlResult2) {
            long partitionId = (Long)fields[0];
            Long sdId = (Long)fields[1];
            Long colId = (Long)fields[2];
            Long serdeId = (Long)fields[3];
            if (sdId == null || colId == null || serdeId == null) {
                if (isView == null) {
                    isView = this.isViewTable(dbName, tblName);
                }
                if (sdId != null || colId != null || serdeId != null || !isView.booleanValue()) {
                    throw new MetaException("Unexpected null for one of the IDs, SD " + sdId + ", column " + colId + ", serde " + serdeId + " for a " + (isView != false ? "" : "non-") + " view");
                }
            }
            Partition part = new Partition();
            orderedResult.add(part);
            part.setParameters(new HashMap<String, String>());
            part.setValues(new ArrayList<String>());
            part.setDbName(dbName);
            part.setTableName(tblName);
            if (fields[4] != null) {
                part.setCreateTime(this.extractSqlInt(fields[4]));
            }
            if (fields[5] != null) {
                part.setLastAccessTime(this.extractSqlInt(fields[5]));
            }
            partitions.put(partitionId, part);
            if (sdId == null) continue;
            assert (colId != null && serdeId != null);
            StorageDescriptor sd = new StorageDescriptor();
            StorageDescriptor oldSd = sds.put(sdId, sd);
            if (oldSd != null) {
                throw new MetaException("Partitions reuse SDs; we don't expect that");
            }
            sd.setSortCols(new ArrayList<Order>());
            sd.setBucketCols(new ArrayList<String>());
            sd.setParameters(new HashMap<String, String>());
            sd.setSkewedInfo(new SkewedInfo(new ArrayList<String>(), new ArrayList<List<String>>(), new HashMap<List<String>, String>()));
            sd.setInputFormat((String)fields[6]);
            Boolean tmpBoolean = MetaStoreDirectSql.extractSqlBoolean(fields[7]);
            if (tmpBoolean != null) {
                sd.setCompressed(tmpBoolean);
            }
            if ((tmpBoolean = MetaStoreDirectSql.extractSqlBoolean(fields[8])) != null) {
                sd.setStoredAsSubDirectories(tmpBoolean);
            }
            sd.setLocation((String)fields[9]);
            if (fields[10] != null) {
                sd.setNumBuckets(this.extractSqlInt(fields[10]));
            }
            sd.setOutputFormat((String)fields[11]);
            sdSb.append(sdId).append(",");
            part.setSd(sd);
            ArrayList cols = (ArrayList)colss.get(colId);
            if (cols == null) {
                cols = new ArrayList();
                colss.put(colId, cols);
                colsSb.append(colId).append(",");
            }
            sd.setCols(cols);
            SerDeInfo serde = new SerDeInfo();
            SerDeInfo oldSerde = serdes.put(serdeId, serde);
            if (oldSerde != null) {
                throw new MetaException("SDs reuse serdes; we don't expect that");
            }
            serde.setParameters(new HashMap<String, String>());
            serde.setName((String)fields[12]);
            serde.setSerializationLib((String)fields[13]);
            serdeSb.append(serdeId).append(",");
            sd.setSerdeInfo(serde);
        }
        query.closeAll();
        this.timingTrace(doTrace, queryText, start, queryTime);
        queryText = "select \"PART_ID\", \"PARAM_KEY\", \"PARAM_VALUE\" from \"PARTITION_PARAMS\" where \"PART_ID\" in (" + partIds + ") and \"PARAM_KEY\" is not null" + " order by \"PART_ID\" asc";
        this.loopJoinOrderedResult(partitions, queryText, 0, new ApplyFunc<Partition>(){

            @Override
            public void apply(Partition t, Object[] fields) {
                t.putToParameters((String)fields[1], (String)fields[2]);
            }
        });
        queryText = "select \"PART_ID\", \"PART_KEY_VAL\" from \"PARTITION_KEY_VALS\" where \"PART_ID\" in (" + partIds + ") and \"INTEGER_IDX\" >= 0" + " order by \"PART_ID\" asc, \"INTEGER_IDX\" asc";
        this.loopJoinOrderedResult(partitions, queryText, 0, new ApplyFunc<Partition>(){

            @Override
            public void apply(Partition t, Object[] fields) {
                t.addToValues((String)fields[1]);
            }
        });
        if (sdSb.length() == 0) {
            assert (serdeSb.length() == 0 && colsSb.length() == 0);
            return orderedResult;
        }
        String sdIds = MetaStoreDirectSql.trimCommaList(sdSb);
        String serdeIds = MetaStoreDirectSql.trimCommaList(serdeSb);
        String colIds = MetaStoreDirectSql.trimCommaList(colsSb);
        queryText = "select \"SD_ID\", \"PARAM_KEY\", \"PARAM_VALUE\" from \"SD_PARAMS\" where \"SD_ID\" in (" + sdIds + ") and \"PARAM_KEY\" is not null" + " order by \"SD_ID\" asc";
        this.loopJoinOrderedResult(sds, queryText, 0, new ApplyFunc<StorageDescriptor>(){

            @Override
            public void apply(StorageDescriptor t, Object[] fields) {
                t.putToParameters((String)fields[1], (String)fields[2]);
            }
        });
        queryText = "select \"SD_ID\", \"COLUMN_NAME\", \"SORT_COLS\".\"ORDER\" from \"SORT_COLS\" where \"SD_ID\" in (" + sdIds + ") and \"INTEGER_IDX\" >= 0" + " order by \"SD_ID\" asc, \"INTEGER_IDX\" asc";
        this.loopJoinOrderedResult(sds, queryText, 0, new ApplyFunc<StorageDescriptor>(){

            @Override
            public void apply(StorageDescriptor t, Object[] fields) {
                if (fields[2] == null) {
                    return;
                }
                t.addToSortCols(new Order((String)fields[1], MetaStoreDirectSql.this.extractSqlInt(fields[2])));
            }
        });
        queryText = "select \"SD_ID\", \"BUCKET_COL_NAME\" from \"BUCKETING_COLS\" where \"SD_ID\" in (" + sdIds + ") and \"INTEGER_IDX\" >= 0" + " order by \"SD_ID\" asc, \"INTEGER_IDX\" asc";
        this.loopJoinOrderedResult(sds, queryText, 0, new ApplyFunc<StorageDescriptor>(){

            @Override
            public void apply(StorageDescriptor t, Object[] fields) {
                t.addToBucketCols((String)fields[1]);
            }
        });
        queryText = "select \"SD_ID\", \"SKEWED_COL_NAME\" from \"SKEWED_COL_NAMES\" where \"SD_ID\" in (" + sdIds + ") and \"INTEGER_IDX\" >= 0" + " order by \"SD_ID\" asc, \"INTEGER_IDX\" asc";
        boolean bl = hasSkewedColumns = this.loopJoinOrderedResult(sds, queryText, 0, new ApplyFunc<StorageDescriptor>(){

            @Override
            public void apply(StorageDescriptor t, Object[] fields) {
                if (!t.isSetSkewedInfo()) {
                    t.setSkewedInfo(new SkewedInfo());
                }
                t.getSkewedInfo().addToSkewedColNames((String)fields[1]);
            }
        }) > 0;
        if (hasSkewedColumns) {
            queryText = "select \"SKEWED_VALUES\".\"SD_ID_OID\",  \"SKEWED_STRING_LIST_VALUES\".\"STRING_LIST_ID\",  \"SKEWED_STRING_LIST_VALUES\".\"STRING_LIST_VALUE\" from \"SKEWED_VALUES\"   left outer join \"SKEWED_STRING_LIST_VALUES\" on \"SKEWED_VALUES\".\"STRING_LIST_ID_EID\" = \"SKEWED_STRING_LIST_VALUES\".\"STRING_LIST_ID\" where \"SKEWED_VALUES\".\"SD_ID_OID\" in (" + sdIds + ") " + "  and \"SKEWED_VALUES\".\"STRING_LIST_ID_EID\" is not null " + "  and \"SKEWED_VALUES\".\"INTEGER_IDX\" >= 0 " + "order by \"SKEWED_VALUES\".\"SD_ID_OID\" asc, \"SKEWED_VALUES\".\"INTEGER_IDX\" asc," + "  \"SKEWED_STRING_LIST_VALUES\".\"INTEGER_IDX\" asc";
            this.loopJoinOrderedResult(sds, queryText, 0, new ApplyFunc<StorageDescriptor>(){
                private Long currentListId;
                private List<String> currentList;

                @Override
                public void apply(StorageDescriptor t, Object[] fields) {
                    if (!t.isSetSkewedInfo()) {
                        t.setSkewedInfo(new SkewedInfo());
                    }
                    if (fields[1] == null) {
                        this.currentList = null;
                        this.currentListId = null;
                        t.getSkewedInfo().addToSkewedColValues(new ArrayList<String>());
                    } else {
                        long fieldsListId = (Long)fields[1];
                        if (this.currentListId == null || fieldsListId != this.currentListId) {
                            this.currentList = new ArrayList<String>();
                            this.currentListId = fieldsListId;
                            t.getSkewedInfo().addToSkewedColValues(this.currentList);
                        }
                        this.currentList.add((String)fields[2]);
                    }
                }
            });
            queryText = "select \"SKEWED_COL_VALUE_LOC_MAP\".\"SD_ID\", \"SKEWED_STRING_LIST_VALUES\".STRING_LIST_ID, \"SKEWED_COL_VALUE_LOC_MAP\".\"LOCATION\", \"SKEWED_STRING_LIST_VALUES\".\"STRING_LIST_VALUE\" from \"SKEWED_COL_VALUE_LOC_MAP\"  left outer join \"SKEWED_STRING_LIST_VALUES\" on \"SKEWED_COL_VALUE_LOC_MAP\".\"STRING_LIST_ID_KID\" = \"SKEWED_STRING_LIST_VALUES\".\"STRING_LIST_ID\" where \"SKEWED_COL_VALUE_LOC_MAP\".\"SD_ID\" in (" + sdIds + ")" + "  and \"SKEWED_COL_VALUE_LOC_MAP\".\"STRING_LIST_ID_KID\" is not null " + "order by \"SKEWED_COL_VALUE_LOC_MAP\".\"SD_ID\" asc," + "  \"SKEWED_STRING_LIST_VALUES\".\"STRING_LIST_ID\" asc," + "  \"SKEWED_STRING_LIST_VALUES\".\"INTEGER_IDX\" asc";
            this.loopJoinOrderedResult(sds, queryText, 0, new ApplyFunc<StorageDescriptor>(){
                private Long currentListId;
                private List<String> currentList;

                @Override
                public void apply(StorageDescriptor t, Object[] fields) {
                    if (!t.isSetSkewedInfo()) {
                        SkewedInfo skewedInfo = new SkewedInfo();
                        skewedInfo.setSkewedColValueLocationMaps(new HashMap<List<String>, String>());
                        t.setSkewedInfo(skewedInfo);
                    }
                    Map<List<String>, String> skewMap = t.getSkewedInfo().getSkewedColValueLocationMaps();
                    if (fields[1] == null) {
                        this.currentList = new ArrayList<String>();
                        this.currentListId = null;
                    } else {
                        long fieldsListId = (Long)fields[1];
                        if (this.currentListId == null || fieldsListId != this.currentListId) {
                            this.currentList = new ArrayList<String>();
                            this.currentListId = fieldsListId;
                        } else {
                            skewMap.remove(this.currentList);
                        }
                        this.currentList.add((String)fields[3]);
                    }
                    skewMap.put(this.currentList, (String)fields[2]);
                }
            });
        }
        if (!colss.isEmpty()) {
            queryText = "select \"CD_ID\", \"COMMENT\", \"COLUMN_NAME\", \"TYPE_NAME\" from \"COLUMNS_V2\" where \"CD_ID\" in (" + colIds + ") and \"INTEGER_IDX\" >= 0" + " order by \"CD_ID\" asc, \"INTEGER_IDX\" asc";
            this.loopJoinOrderedResult(colss, queryText, 0, new ApplyFunc<List<FieldSchema>>(){

                @Override
                public void apply(List<FieldSchema> t, Object[] fields) {
                    t.add(new FieldSchema((String)fields[2], (String)fields[3], (String)fields[1]));
                }
            });
        }
        queryText = "select \"SERDE_ID\", \"PARAM_KEY\", \"PARAM_VALUE\" from \"SERDE_PARAMS\" where \"SERDE_ID\" in (" + serdeIds + ") and \"PARAM_KEY\" is not null" + " order by \"SERDE_ID\" asc";
        this.loopJoinOrderedResult(serdes, queryText, 0, new ApplyFunc<SerDeInfo>(){

            @Override
            public void apply(SerDeInfo t, Object[] fields) {
                t.putToParameters((String)fields[1], (String)fields[2]);
            }
        });
        return orderedResult;
    }

    private void timingTrace(boolean doTrace, String queryText, long start, long queryTime) {
        if (!doTrace) {
            return;
        }
        LOG.debug((Object)("Direct SQL query in " + (double)(queryTime - start) / 1000000.0 + "ms + " + (double)(System.nanoTime() - queryTime) / 1000000.0 + "ms, the query is [" + queryText + "]"));
    }

    private static Boolean extractSqlBoolean(Object value) throws MetaException {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        Character c = null;
        if (value instanceof String && ((String)value).length() == 1) {
            c = Character.valueOf(((String)value).charAt(0));
        }
        if (c.charValue() == 'Y') {
            return true;
        }
        if (c.charValue() == 'N') {
            return false;
        }
        throw new MetaException("Cannot extrace boolean from column value " + value);
    }

    private int extractSqlInt(Object field) {
        return ((Number)field).intValue();
    }

    private static String trimCommaList(StringBuilder sb) {
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    private <T> int loopJoinOrderedResult(TreeMap<Long, T> tree, String queryText, int keyIndex, ApplyFunc<T> func) throws MetaException {
        long queryTime;
        boolean doTrace = LOG.isDebugEnabled();
        long start = doTrace ? System.nanoTime() : 0L;
        Query query = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
        Object result = query.execute();
        long l = queryTime = doTrace ? System.nanoTime() : 0L;
        if (result == null) {
            query.closeAll();
            return 0;
        }
        if (!(result instanceof List)) {
            throw new MetaException("Wrong result type " + result.getClass());
        }
        List list = (List)result;
        Iterator iter = list.iterator();
        Object[] fields = null;
        block0: for (Map.Entry<Long, T> entry : tree.entrySet()) {
            if (fields == null && !iter.hasNext()) break;
            long id = entry.getKey();
            while (fields != null || iter.hasNext()) {
                long nestedId;
                if (fields == null) {
                    fields = (Object[])iter.next();
                }
                if ((nestedId = ((Long)fields[keyIndex]).longValue()) < id) {
                    throw new MetaException("Found entries for unknown ID " + nestedId);
                }
                if (nestedId > id) continue block0;
                func.apply(entry.getValue(), fields);
                fields = null;
            }
        }
        int rv = list.size();
        query.closeAll();
        this.timingTrace(doTrace, queryText, start, queryTime);
        return rv;
    }

    private static class PartitionFilterGenerator
    extends ExpressionTree.TreeVisitor {
        private final Table table;
        private final ExpressionTree.FilterBuilder filterBuffer;
        private final List<Object> params;
        private final List<String> joins;

        private PartitionFilterGenerator(Table table, List<Object> params, List<String> joins) {
            this.table = table;
            this.params = params;
            this.joins = joins;
            this.filterBuffer = new ExpressionTree.FilterBuilder(false);
        }

        public static String generateSqlFilter(Table table, ExpressionTree tree, List<Object> params, List<String> joins) throws MetaException {
            assert (table != null);
            if (tree.getRoot() == null) {
                return "";
            }
            PartitionFilterGenerator visitor = new PartitionFilterGenerator(table, params, joins);
            tree.accept(visitor);
            if (visitor.filterBuffer.hasError()) {
                LOG.info((Object)("Unable to push down SQL filter: " + visitor.filterBuffer.getErrorMessage()));
                return null;
            }
            for (int i = 0; i < joins.size(); ++i) {
                if (joins.get(i) != null) continue;
                joins.remove(i--);
            }
            return "(" + visitor.filterBuffer.getFilter() + ")";
        }

        @Override
        protected void beginTreeNode(ExpressionTree.TreeNode node) throws MetaException {
            this.filterBuffer.append(" (");
        }

        @Override
        protected void midTreeNode(ExpressionTree.TreeNode node) throws MetaException {
            this.filterBuffer.append(node.getAndOr() == ExpressionTree.LogicalOperator.AND ? " and " : " or ");
        }

        @Override
        protected void endTreeNode(ExpressionTree.TreeNode node) throws MetaException {
            this.filterBuffer.append(") ");
        }

        @Override
        protected boolean shouldStop() {
            return this.filterBuffer.hasError();
        }

        @Override
        public void visit(ExpressionTree.LeafNode node) throws MetaException {
            boolean forceStringEq;
            if (node.operator == ExpressionTree.Operator.LIKE) {
                this.filterBuffer.setError("LIKE is not supported for SQL filter pushdown");
                return;
            }
            int partColCount = this.table.getPartitionKeys().size();
            int partColIndex = node.getPartColIndexForFilter(this.table, this.filterBuffer);
            if (this.filterBuffer.hasError()) {
                return;
            }
            String colType = this.table.getPartitionKeys().get(partColIndex).getType();
            boolean isStringCol = colType.equals("string");
            if (!isStringCol && !serdeConstants.IntegralTypes.contains(colType)) {
                this.filterBuffer.setError("Filter pushdown is only supported for string or integral columns");
                return;
            }
            boolean isStringVal = node.value instanceof String;
            if (!isStringVal && !(node.value instanceof Long)) {
                this.filterBuffer.setError("Filter pushdown is only supported for string or integral values");
                return;
            }
            if (isStringCol != isStringVal) {
                this.filterBuffer.setError("Cannot push down filter for " + (isStringCol ? "string" : "integral") + " column and value " + node.value);
                return;
            }
            boolean bl = forceStringEq = !isStringCol && node.canJdoUseStringsWithIntegral();
            if (this.joins.isEmpty()) {
                for (int i = 0; i < partColCount; ++i) {
                    this.joins.add(null);
                }
            }
            if (this.joins.get(partColIndex) == null) {
                this.joins.set(partColIndex, "inner join \"PARTITION_KEY_VALS\" as \"FILTER" + partColIndex + "\" on \"FILTER" + partColIndex + "\".\"PART_ID\" = \"PARTITIONS\".\"PART_ID\"" + " and \"FILTER" + partColIndex + "\".\"INTEGER_IDX\" = " + partColIndex);
            }
            String tableValue = "\"FILTER" + partColIndex + "\".\"PART_KEY_VAL\"";
            if (!isStringCol && !forceStringEq) {
                tableValue = "cast(" + tableValue + " as decimal(21,0))";
                tableValue = "(case when \"TBLS\".\"TBL_NAME\" = ? and \"DBS\".\"NAME\" = ? then " + tableValue + " else null end)";
                this.params.add(this.table.getTableName().toLowerCase());
                this.params.add(this.table.getDbName().toLowerCase());
            }
            this.params.add(forceStringEq ? node.value.toString() : node.value);
            this.filterBuffer.append(node.isReverseOrder ? "(? " + node.operator.getSqlOp() + " " + tableValue + ")" : "(" + tableValue + " " + node.operator.getSqlOp() + " ?)");
        }
    }

    private abstract class ApplyFunc<Target> {
        private ApplyFunc() {
        }

        public abstract void apply(Target var1, Object[] var2);
    }
}

