/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestCellUtil {
    @Test
    public void testOverlappingKeys() {
        byte[] empty = HConstants.EMPTY_BYTE_ARRAY;
        byte[] a = Bytes.toBytes((String)"a");
        byte[] b = Bytes.toBytes((String)"b");
        byte[] c = Bytes.toBytes((String)"c");
        byte[] d = Bytes.toBytes((String)"d");
        Assert.assertTrue((boolean)CellUtil.overlappingKeys((byte[])a, (byte[])b, (byte[])a, (byte[])b));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys((byte[])a, (byte[])c, (byte[])a, (byte[])b));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys((byte[])a, (byte[])b, (byte[])a, (byte[])c));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys((byte[])b, (byte[])c, (byte[])a, (byte[])c));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys((byte[])a, (byte[])c, (byte[])b, (byte[])c));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys((byte[])a, (byte[])d, (byte[])b, (byte[])c));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys((byte[])b, (byte[])c, (byte[])a, (byte[])d));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys((byte[])empty, (byte[])b, (byte[])a, (byte[])b));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys((byte[])empty, (byte[])b, (byte[])a, (byte[])c));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys((byte[])a, (byte[])b, (byte[])empty, (byte[])b));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys((byte[])a, (byte[])b, (byte[])empty, (byte[])c));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys((byte[])a, (byte[])empty, (byte[])a, (byte[])b));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys((byte[])a, (byte[])empty, (byte[])a, (byte[])c));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys((byte[])a, (byte[])b, (byte[])empty, (byte[])empty));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys((byte[])empty, (byte[])empty, (byte[])a, (byte[])b));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys((byte[])a, (byte[])b, (byte[])c, (byte[])d));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys((byte[])c, (byte[])d, (byte[])a, (byte[])b));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys((byte[])b, (byte[])c, (byte[])c, (byte[])d));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys((byte[])b, (byte[])c, (byte[])c, (byte[])empty));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys((byte[])b, (byte[])c, (byte[])d, (byte[])empty));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys((byte[])c, (byte[])d, (byte[])b, (byte[])c));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys((byte[])c, (byte[])empty, (byte[])b, (byte[])c));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys((byte[])d, (byte[])empty, (byte[])b, (byte[])c));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys((byte[])b, (byte[])c, (byte[])a, (byte[])b));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys((byte[])b, (byte[])c, (byte[])empty, (byte[])b));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys((byte[])b, (byte[])c, (byte[])empty, (byte[])a));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys((byte[])a, (byte[])b, (byte[])b, (byte[])c));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys((byte[])empty, (byte[])b, (byte[])b, (byte[])c));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys((byte[])empty, (byte[])a, (byte[])b, (byte[])c));
    }
}

