/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel.file;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.flume.ChannelException;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.annotations.Disposable;
import org.apache.flume.annotations.InterfaceAudience;
import org.apache.flume.annotations.InterfaceStability;
import org.apache.flume.channel.BasicChannelSemantics;
import org.apache.flume.channel.BasicTransactionSemantics;
import org.apache.flume.channel.file.FlumeEvent;
import org.apache.flume.channel.file.FlumeEventPointer;
import org.apache.flume.channel.file.FlumeEventQueue;
import org.apache.flume.channel.file.Log;
import org.apache.flume.channel.file.TransactionIDOracle;
import org.apache.flume.channel.file.encryption.KeyProvider;
import org.apache.flume.channel.file.encryption.KeyProviderFactory;
import org.apache.flume.instrumentation.ChannelCounter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Disposable
@InterfaceAudience.Private
@InterfaceStability.Stable
public class FileChannel
extends BasicChannelSemantics {
    private static final Logger LOG = LoggerFactory.getLogger(FileChannel.class);
    private Integer capacity = 0;
    private int keepAlive;
    private Integer transactionCapacity = 0;
    private Long checkpointInterval = 0L;
    private long maxFileSize;
    private long minimumRequiredSpace;
    private File checkpointDir;
    private File backupCheckpointDir;
    private File[] dataDirs;
    private Log log;
    private volatile boolean open;
    private volatile Throwable startupError;
    private Semaphore queueRemaining;
    private final ThreadLocal<FileBackedTransaction> transactions = new ThreadLocal();
    private String channelNameDescriptor = "[channel=unknown]";
    private ChannelCounter channelCounter;
    private boolean useLogReplayV1;
    private boolean useFastReplay = false;
    private KeyProvider encryptionKeyProvider;
    private String encryptionActiveKey;
    private String encryptionCipherProvider;
    private boolean useDualCheckpoints;

    public synchronized void setName(String name) {
        this.channelNameDescriptor = "[channel=" + name + "]";
        super.setName(name);
    }

    public void configure(Context context) {
        this.useDualCheckpoints = context.getBoolean("useDualCheckpoints", Boolean.valueOf(false));
        String homePath = System.getProperty("user.home").replace('\\', '/');
        String strCheckpointDir = context.getString("checkpointDir", homePath + "/.flume/file-channel/checkpoint");
        String strBackupCheckpointDir = context.getString("backupCheckpointDir", "").trim();
        String[] strDataDirs = context.getString("dataDirs", homePath + "/.flume/file-channel/data").split(",");
        this.checkpointDir = new File(strCheckpointDir);
        if (this.useDualCheckpoints) {
            Preconditions.checkState((!strBackupCheckpointDir.isEmpty() ? 1 : 0) != 0, (Object)"Dual checkpointing is enabled, but the backup directory is not set. Please set backupCheckpointDir to enable dual checkpointing");
            this.backupCheckpointDir = new File(strBackupCheckpointDir);
            Preconditions.checkState((!this.backupCheckpointDir.equals(this.checkpointDir) ? 1 : 0) != 0, (Object)("Could not configure " + this.getName() + ". The checkpoint backup " + "directory and the checkpoint directory are " + "configured to be the same."));
        }
        this.dataDirs = new File[strDataDirs.length];
        for (int i = 0; i < strDataDirs.length; ++i) {
            this.dataDirs[i] = new File(strDataDirs[i]);
        }
        this.capacity = context.getInteger("capacity", Integer.valueOf(1000000));
        if (this.capacity <= 0) {
            this.capacity = 1000000;
            LOG.warn("Invalid capacity specified, initializing channel to default capacity of {}", (Object)this.capacity);
        }
        this.keepAlive = context.getInteger("keep-alive", Integer.valueOf(3));
        this.transactionCapacity = context.getInteger("transactionCapacity", Integer.valueOf(10000));
        if (this.transactionCapacity <= 0) {
            this.transactionCapacity = 10000;
            LOG.warn("Invalid transaction capacity specified, initializing channel to default capacity of {}", (Object)this.transactionCapacity);
        }
        Preconditions.checkState((this.transactionCapacity <= this.capacity ? 1 : 0) != 0, (Object)"File Channel transaction capacity cannot be greater than the capacity of the channel.");
        this.checkpointInterval = context.getLong("checkpointInterval", Long.valueOf(30000L));
        if (this.checkpointInterval <= 0L) {
            LOG.warn("Checkpoint interval is invalid: " + this.checkpointInterval + ", using default: " + 30000L);
            this.checkpointInterval = 30000L;
        }
        this.maxFileSize = Math.min(context.getLong("maxFileSize", Long.valueOf(1623195647L)), 1623195647L);
        this.minimumRequiredSpace = Math.max(context.getLong("minimumRequiredSpace", Long.valueOf(524288000L)), 0x100000L);
        this.useLogReplayV1 = context.getBoolean("use-log-replay-v1", Boolean.valueOf(false));
        this.useFastReplay = context.getBoolean("use-fast-replay", Boolean.valueOf(false));
        Context encryptionContext = new Context((Map)context.getSubProperties("encryption."));
        String encryptionKeyProviderName = encryptionContext.getString("keyProvider");
        this.encryptionActiveKey = encryptionContext.getString("activeKey");
        this.encryptionCipherProvider = encryptionContext.getString("cipherProvider");
        if (encryptionKeyProviderName != null) {
            Preconditions.checkState((!Strings.isNullOrEmpty((String)this.encryptionActiveKey) ? 1 : 0) != 0, (Object)"Encryption configuration problem: activeKey is missing");
            Preconditions.checkState((!Strings.isNullOrEmpty((String)this.encryptionCipherProvider) ? 1 : 0) != 0, (Object)"Encryption configuration problem: cipherProvider is missing");
            Context keyProviderContext = new Context((Map)encryptionContext.getSubProperties("keyProvider."));
            this.encryptionKeyProvider = KeyProviderFactory.getInstance(encryptionKeyProviderName, keyProviderContext);
        } else {
            Preconditions.checkState((this.encryptionActiveKey == null ? 1 : 0) != 0, (Object)"Encryption configuration problem: activeKey is present while key provider name is not.");
            Preconditions.checkState((this.encryptionCipherProvider == null ? 1 : 0) != 0, (Object)"Encryption configuration problem: cipherProvider is present while key provider name is not.");
        }
        if (this.queueRemaining == null) {
            this.queueRemaining = new Semaphore(this.capacity, true);
        }
        if (this.log != null) {
            this.log.setCheckpointInterval(this.checkpointInterval);
            this.log.setMaxFileSize(this.maxFileSize);
        }
        if (this.channelCounter == null) {
            this.channelCounter = new ChannelCounter(this.getName());
        }
    }

    public synchronized void start() {
        block3: {
            LOG.info("Starting {}...", (Object)this);
            try {
                Log.Builder builder = new Log.Builder();
                builder.setCheckpointInterval(this.checkpointInterval);
                builder.setMaxFileSize(this.maxFileSize);
                builder.setMinimumRequiredSpace(this.minimumRequiredSpace);
                builder.setQueueSize(this.capacity);
                builder.setCheckpointDir(this.checkpointDir);
                builder.setLogDirs(this.dataDirs);
                builder.setChannelName(this.getName());
                builder.setUseLogReplayV1(this.useLogReplayV1);
                builder.setUseFastReplay(this.useFastReplay);
                builder.setEncryptionKeyProvider(this.encryptionKeyProvider);
                builder.setEncryptionKeyAlias(this.encryptionActiveKey);
                builder.setEncryptionCipherProvider(this.encryptionCipherProvider);
                builder.setUseDualCheckpoints(this.useDualCheckpoints);
                builder.setBackupCheckpointDir(this.backupCheckpointDir);
                this.log = builder.build();
                this.log.replay();
                this.open = true;
                int depth = this.getDepth();
                Preconditions.checkState((boolean)this.queueRemaining.tryAcquire(depth), (Object)("Unable to acquire " + depth + " permits " + this.channelNameDescriptor));
                LOG.info("Queue Size after replay: " + depth + " " + this.channelNameDescriptor);
            }
            catch (Throwable t) {
                this.open = false;
                this.startupError = t;
                LOG.error("Failed to start the file channel " + this.channelNameDescriptor, t);
                if (!(t instanceof Error)) break block3;
                throw (Error)t;
            }
        }
        if (this.open) {
            this.channelCounter.start();
            this.channelCounter.setChannelSize((long)this.getDepth());
            this.channelCounter.setChannelCapacity((long)this.capacity.intValue());
        }
        super.start();
    }

    public synchronized void stop() {
        LOG.info("Stopping {}...", (Object)this);
        this.startupError = null;
        int size = this.getDepth();
        this.close();
        if (!this.open) {
            this.channelCounter.setChannelSize((long)size);
            this.channelCounter.stop();
        }
        super.stop();
    }

    public String toString() {
        return "FileChannel " + this.getName() + " { dataDirs: " + Arrays.toString(this.dataDirs) + " }";
    }

    protected BasicTransactionSemantics createTransaction() {
        if (!this.open) {
            String msg = "Channel closed " + this.channelNameDescriptor;
            if (this.startupError != null) {
                msg = msg + ". Due to " + this.startupError.getClass().getName() + ": " + this.startupError.getMessage();
                throw new IllegalStateException(msg, this.startupError);
            }
            throw new IllegalStateException(msg);
        }
        FileBackedTransaction trans = this.transactions.get();
        if (trans != null && !trans.isClosed()) {
            Preconditions.checkState((boolean)false, (Object)("Thread has transaction which is still open: " + trans.getStateAsString() + this.channelNameDescriptor));
        }
        trans = new FileBackedTransaction(this.log, TransactionIDOracle.next(), this.transactionCapacity, this.keepAlive, this.queueRemaining, this.getName(), this.channelCounter);
        this.transactions.set(trans);
        return trans;
    }

    int getDepth() {
        Preconditions.checkState((boolean)this.open, (Object)("Channel closed" + this.channelNameDescriptor));
        Preconditions.checkNotNull((Object)this.log, (Object)"log");
        FlumeEventQueue queue = this.log.getFlumeEventQueue();
        Preconditions.checkNotNull((Object)queue, (Object)"queue");
        return queue.getSize();
    }

    void close() {
        if (this.open) {
            this.open = false;
            try {
                this.log.close();
            }
            catch (Exception e) {
                LOG.error("Error while trying to close the log.", (Throwable)e);
                Throwables.propagate((Throwable)e);
            }
            this.log = null;
            this.queueRemaining = null;
        }
    }

    @VisibleForTesting
    boolean didFastReplay() {
        return this.log.didFastReplay();
    }

    @VisibleForTesting
    boolean didFullReplayDueToBadCheckpointException() {
        return this.log.didFullReplayDueToBadCheckpointException();
    }

    public boolean isOpen() {
        return this.open;
    }

    @VisibleForTesting
    boolean checkpointBackupRestored() {
        if (this.log != null) {
            return this.log.backupRestored();
        }
        return false;
    }

    @VisibleForTesting
    Log getLog() {
        return this.log;
    }

    static class FileBackedTransaction
    extends BasicTransactionSemantics {
        private final LinkedBlockingDeque<FlumeEventPointer> takeList;
        private final LinkedBlockingDeque<FlumeEventPointer> putList;
        private final long transactionID;
        private final int keepAlive;
        private final Log log;
        private final FlumeEventQueue queue;
        private final Semaphore queueRemaining;
        private final String channelNameDescriptor;
        private final ChannelCounter channelCounter;

        public FileBackedTransaction(Log log, long transactionID, int transCapacity, int keepAlive, Semaphore queueRemaining, String name, ChannelCounter counter) {
            this.log = log;
            this.queue = log.getFlumeEventQueue();
            this.transactionID = transactionID;
            this.keepAlive = keepAlive;
            this.queueRemaining = queueRemaining;
            this.putList = new LinkedBlockingDeque(transCapacity);
            this.takeList = new LinkedBlockingDeque(transCapacity);
            this.channelNameDescriptor = "[channel=" + name + "]";
            this.channelCounter = counter;
        }

        private boolean isClosed() {
            return BasicTransactionSemantics.State.CLOSED.equals((Object)this.getState());
        }

        private String getStateAsString() {
            return String.valueOf(this.getState());
        }

        protected void doPut(Event event) throws InterruptedException {
            this.channelCounter.incrementEventPutAttemptCount();
            if (this.putList.remainingCapacity() == 0) {
                throw new ChannelException("Put queue for FileBackedTransaction of capacity " + this.putList.size() + " full, consider " + "committing more frequently, increasing capacity or " + "increasing thread count. " + this.channelNameDescriptor);
            }
            if (!this.queueRemaining.tryAcquire(this.keepAlive, TimeUnit.SECONDS)) {
                throw new ChannelException("The channel has reached it's capacity. This might be the result of a sink on the channel having too low of batch size, a downstream system running slower than normal, or that the channel capacity is just too low. " + this.channelNameDescriptor);
            }
            boolean success = false;
            this.log.lockShared();
            try {
                FlumeEventPointer ptr = this.log.put(this.transactionID, event);
                Preconditions.checkState((boolean)this.putList.offer(ptr), (Object)("putList offer failed " + this.channelNameDescriptor));
                this.queue.addWithoutCommit(ptr, this.transactionID);
                success = true;
            }
            catch (IOException e) {
                throw new ChannelException("Put failed due to IO error " + this.channelNameDescriptor, (Throwable)e);
            }
            finally {
                this.log.unlockShared();
                if (!success) {
                    this.queueRemaining.release();
                }
            }
        }

        protected Event doTake() throws InterruptedException {
            this.channelCounter.incrementEventTakeAttemptCount();
            if (this.takeList.remainingCapacity() == 0) {
                throw new ChannelException("Take list for FileBackedTransaction, capacity " + this.takeList.size() + " full, consider committing more frequently, " + "increasing capacity, or increasing thread count. " + this.channelNameDescriptor);
            }
            this.log.lockShared();
            try {
                FlumeEvent event;
                FlumeEventPointer ptr = this.queue.removeHead(this.transactionID);
                if (ptr == null) {
                    Event event2 = null;
                    return event2;
                }
                Preconditions.checkState((boolean)this.takeList.offer(ptr), (Object)("takeList offer failed " + this.channelNameDescriptor));
                this.log.take(this.transactionID, ptr);
                FlumeEvent flumeEvent = event = this.log.get(ptr);
                return flumeEvent;
            }
            finally {
                this.log.unlockShared();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doCommit() throws InterruptedException {
            block16: {
                int puts = this.putList.size();
                int takes = this.takeList.size();
                if (puts > 0) {
                    Preconditions.checkState((takes == 0 ? 1 : 0) != 0, (Object)("nonzero puts and takes " + this.channelNameDescriptor));
                    this.log.lockShared();
                    try {
                        this.log.commitPut(this.transactionID);
                        this.channelCounter.addToEventPutSuccessCount((long)puts);
                        FlumeEventQueue flumeEventQueue = this.queue;
                        synchronized (flumeEventQueue) {
                            while (!this.putList.isEmpty()) {
                                if (this.queue.addTail(this.putList.removeFirst())) continue;
                                StringBuilder msg = new StringBuilder();
                                msg.append("Queue add failed, this shouldn't be able to ");
                                msg.append("happen. A portion of the transaction has been ");
                                msg.append("added to the queue but the remaining portion ");
                                msg.append("cannot be added. Those messages will be consumed ");
                                msg.append("despite this transaction failing. Please report.");
                                msg.append(this.channelNameDescriptor);
                                LOG.error(msg.toString());
                                Preconditions.checkState((boolean)false, (Object)msg.toString());
                            }
                            this.queue.completeTransaction(this.transactionID);
                            break block16;
                        }
                    }
                    catch (IOException e) {
                        throw new ChannelException("Commit failed due to IO error " + this.channelNameDescriptor, (Throwable)e);
                    }
                    finally {
                        this.log.unlockShared();
                    }
                }
                if (takes > 0) {
                    this.log.lockShared();
                    try {
                        this.log.commitTake(this.transactionID);
                        this.queue.completeTransaction(this.transactionID);
                        this.channelCounter.addToEventTakeSuccessCount((long)takes);
                    }
                    catch (IOException e) {
                        throw new ChannelException("Commit failed due to IO error " + this.channelNameDescriptor, (Throwable)e);
                    }
                    finally {
                        this.log.unlockShared();
                    }
                    this.queueRemaining.release(takes);
                }
            }
            this.putList.clear();
            this.takeList.clear();
            this.channelCounter.setChannelSize((long)this.queue.getSize());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doRollback() throws InterruptedException {
            int puts = this.putList.size();
            int takes = this.takeList.size();
            this.log.lockShared();
            try {
                if (takes > 0) {
                    Preconditions.checkState((puts == 0 ? 1 : 0) != 0, (Object)("nonzero puts and takes " + this.channelNameDescriptor));
                    FlumeEventQueue flumeEventQueue = this.queue;
                    synchronized (flumeEventQueue) {
                        while (!this.takeList.isEmpty()) {
                            Preconditions.checkState((boolean)this.queue.addHead(this.takeList.removeLast()), (Object)("Queue add failed, this shouldn't be able to happen " + this.channelNameDescriptor));
                        }
                    }
                }
                this.putList.clear();
                this.takeList.clear();
                this.queue.completeTransaction(this.transactionID);
                this.channelCounter.setChannelSize((long)this.queue.getSize());
                this.log.rollback(this.transactionID);
            }
            catch (IOException e) {
                throw new ChannelException("Commit failed due to IO error " + this.channelNameDescriptor, (Throwable)e);
            }
            finally {
                this.log.unlockShared();
                this.queueRemaining.release(puts);
            }
        }
    }
}

