/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel.file;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.flume.channel.file.LogFile;
import org.apache.flume.channel.file.LogRecord;
import org.apache.flume.channel.file.TransactionEventRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
class LogFileV2
extends LogFile {
    protected static final Logger LOGGER = LoggerFactory.getLogger(LogFileV2.class);
    private static final long OFFSET_CHECKPOINT = 8L;

    private LogFileV2() {
    }

    static class SequentialReader
    extends LogFile.SequentialReader {
        SequentialReader(File file) throws EOFException, IOException {
            super(file, null);
            RandomAccessFile fileHandle = this.getFileHandle();
            int version = fileHandle.readInt();
            if (version != this.getVersion()) {
                throw new IOException("Version is " + Integer.toHexString(version) + " expected " + Integer.toHexString(this.getVersion()) + " file: " + file.getCanonicalPath());
            }
            this.setLogFileID(fileHandle.readInt());
            this.setLastCheckpointPosition(fileHandle.readLong());
            this.setLastCheckpointWriteOrderID(fileHandle.readLong());
        }

        @Override
        public int getVersion() {
            return 2;
        }

        @Override
        LogRecord doNext(int offset) throws IOException {
            TransactionEventRecord event = TransactionEventRecord.fromDataInputV2(this.getFileHandle());
            return new LogRecord(this.getLogFileID(), offset, event);
        }
    }

    static class RandomReader
    extends LogFile.RandomReader {
        RandomReader(File file) throws IOException {
            super(file, null);
        }

        @Override
        int getVersion() {
            return 2;
        }

        @Override
        protected TransactionEventRecord doGet(RandomAccessFile fileHandle) throws IOException {
            return TransactionEventRecord.fromDataInputV2(fileHandle);
        }
    }

    static class Writer
    extends LogFile.Writer {
        Writer(File file, int logFileID, long maxFileSize, long usableSpaceRefreshInterval) throws IOException {
            super(file, logFileID, maxFileSize, null, usableSpaceRefreshInterval);
            RandomAccessFile writeFileHandle = this.getFileHandle();
            writeFileHandle.writeInt(this.getVersion());
            writeFileHandle.writeInt(logFileID);
            writeFileHandle.writeLong(0L);
            writeFileHandle.writeLong(0L);
            this.getFileChannel().force(true);
        }

        @Override
        int getVersion() {
            return 2;
        }
    }

    static class MetaDataWriter
    extends LogFile.MetaDataWriter {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected MetaDataWriter(File file, int logFileID) throws IOException {
            super(file, logFileID);
            boolean error = true;
            try {
                RandomAccessFile writeFileHandle = this.getFileHandle();
                int version = writeFileHandle.readInt();
                if (version != this.getVersion()) {
                    throw new IOException("The version of log file: " + file.getCanonicalPath() + " is different from expected " + " version: expected = " + this.getVersion() + ", found = " + version);
                }
                int fid = writeFileHandle.readInt();
                if (fid != logFileID) {
                    throw new IOException("The file id of log file: " + file.getCanonicalPath() + " is different from expected " + " id: expected = " + logFileID + ", found = " + fid);
                }
                this.setLastCheckpointOffset(writeFileHandle.readLong());
                this.setLastCheckpointWriteOrderID(writeFileHandle.readLong());
                LOGGER.info("File: " + file.getCanonicalPath() + " was last checkpointed " + "at position: " + this.getLastCheckpointOffset() + ", logWriteOrderID: " + this.getLastCheckpointWriteOrderID());
                error = false;
            }
            finally {
                if (error) {
                    this.close();
                }
            }
        }

        @Override
        int getVersion() {
            return 2;
        }

        @Override
        void markCheckpoint(long currentPosition, long logWriteOrderID) throws IOException {
            RandomAccessFile writeFileHandle = this.getFileHandle();
            writeFileHandle.seek(8L);
            writeFileHandle.writeLong(currentPosition);
            writeFileHandle.writeLong(logWriteOrderID);
            writeFileHandle.getChannel().force(true);
            LOGGER.info("Noted checkpoint for file: " + this.getFile() + ", id: " + this.getLogFileID() + ", checkpoint position: " + currentPosition + ", logWriteOrderID: " + logWriteOrderID);
        }
    }
}

