/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel.file;

import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import com.google.protobuf.GeneratedMessage;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.security.Key;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import javax.annotation.Nullable;
import org.apache.flume.annotations.InterfaceAudience;
import org.apache.flume.annotations.InterfaceStability;
import org.apache.flume.channel.file.CorruptEventException;
import org.apache.flume.channel.file.LogFile;
import org.apache.flume.channel.file.LogRecord;
import org.apache.flume.channel.file.Serialization;
import org.apache.flume.channel.file.TransactionEventRecord;
import org.apache.flume.channel.file.encryption.CipherProvider;
import org.apache.flume.channel.file.encryption.CipherProviderFactory;
import org.apache.flume.channel.file.encryption.KeyProvider;
import org.apache.flume.channel.file.proto.ProtosFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class LogFileV3
extends LogFile {
    protected static final Logger LOGGER = LoggerFactory.getLogger(LogFileV3.class);

    private LogFileV3() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDelimitedTo(GeneratedMessage msg, File file) throws IOException {
        File tmp = Serialization.getMetaDataTempFile(file);
        FileOutputStream outputStream = new FileOutputStream(tmp);
        boolean closed = false;
        try {
            msg.writeDelimitedTo((OutputStream)outputStream);
            outputStream.getChannel().force(true);
            outputStream.close();
            closed = true;
            if (!tmp.renameTo(file)) {
                File oldFile = Serialization.getOldMetaDataFile(file);
                if (!file.renameTo(oldFile)) {
                    throw new IOException("Unable to rename " + file + " to " + oldFile);
                }
                if (!tmp.renameTo(file)) {
                    throw new IOException("Unable to rename " + tmp + " over " + file);
                }
                oldFile.delete();
            }
        }
        finally {
            if (!closed) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Unable to close " + tmp, (Throwable)e);
                }
            }
        }
    }

    public static class SequentialReader
    extends LogFile.SequentialReader {
        private CipherProvider.Decryptor decryptor;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SequentialReader(File file, @Nullable KeyProvider encryptionKeyProvider) throws EOFException, IOException {
            super(file, encryptionKeyProvider);
            File metaDataFile = Serialization.getMetaDataFile(file);
            FileInputStream inputStream = new FileInputStream(metaDataFile);
            try {
                ProtosFactory.LogFileMetaData metaData = (ProtosFactory.LogFileMetaData)Preconditions.checkNotNull((Object)ProtosFactory.LogFileMetaData.parseDelimitedFrom(inputStream), (Object)"MetaData cannot be null");
                int version = metaData.getVersion();
                if (version != this.getVersion()) {
                    throw new IOException("Version is " + Integer.toHexString(version) + " expected " + Integer.toHexString(this.getVersion()) + " file: " + file.getCanonicalPath());
                }
                if (metaData.hasEncryption()) {
                    if (this.getKeyProvider() == null) {
                        throw new IllegalStateException("Data file is encrypted but no  provider was specified");
                    }
                    ProtosFactory.LogFileEncryption encryption = metaData.getEncryption();
                    Key key = this.getKeyProvider().getKey(encryption.getKeyAlias());
                    this.decryptor = CipherProviderFactory.getDecrypter(encryption.getCipherProvider(), key, encryption.getParameters().toByteArray());
                }
                this.setLogFileID(metaData.getLogFileID());
                this.setLastCheckpointPosition(metaData.getCheckpointPosition());
                this.setLastCheckpointWriteOrderID(metaData.getCheckpointWriteOrderID());
                this.setPreviousCheckpointPosition(metaData.getBackupCheckpointPosition());
                this.setPreviousCheckpointWriteOrderID(metaData.getBackupCheckpointWriteOrderID());
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Unable to close " + metaDataFile, (Throwable)e);
                }
            }
        }

        @Override
        public int getVersion() {
            return 3;
        }

        @Override
        LogRecord doNext(int offset) throws IOException, CorruptEventException {
            byte[] buffer = LogFile.readDelimitedBuffer(this.getFileHandle());
            if (this.decryptor != null) {
                buffer = this.decryptor.decrypt(buffer);
            }
            TransactionEventRecord event = TransactionEventRecord.fromByteArray(buffer);
            return new LogRecord(this.getLogFileID(), offset, event);
        }
    }

    static class RandomReader
    extends LogFile.RandomReader {
        private volatile boolean initialized;
        private volatile boolean encryptionEnabled;
        private volatile Key key;
        private volatile String cipherProvider;
        private volatile byte[] parameters;
        private BlockingQueue<CipherProvider.Decryptor> decryptors = new LinkedBlockingDeque<CipherProvider.Decryptor>();

        RandomReader(File file, @Nullable KeyProvider encryptionKeyProvider) throws IOException {
            super(file, encryptionKeyProvider);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initialize() throws IOException {
            File metaDataFile = Serialization.getMetaDataFile(this.getFile());
            FileInputStream inputStream = new FileInputStream(metaDataFile);
            try {
                ProtosFactory.LogFileMetaData metaData = (ProtosFactory.LogFileMetaData)Preconditions.checkNotNull((Object)ProtosFactory.LogFileMetaData.parseDelimitedFrom(inputStream), (Object)"MetaData cannot be null");
                int version = metaData.getVersion();
                if (version != this.getVersion()) {
                    throw new IOException("Version is " + Integer.toHexString(version) + " expected " + Integer.toHexString(this.getVersion()) + " file: " + this.getFile().getCanonicalPath());
                }
                this.encryptionEnabled = false;
                if (metaData.hasEncryption()) {
                    if (this.getKeyProvider() == null) {
                        throw new IllegalStateException("Data file is encrypted but no  provider was specified");
                    }
                    ProtosFactory.LogFileEncryption encryption = metaData.getEncryption();
                    this.key = this.getKeyProvider().getKey(encryption.getKeyAlias());
                    this.cipherProvider = encryption.getCipherProvider();
                    this.parameters = encryption.getParameters().toByteArray();
                    this.encryptionEnabled = true;
                }
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Unable to close " + metaDataFile, (Throwable)e);
                }
            }
        }

        private CipherProvider.Decryptor getDecryptor() {
            CipherProvider.Decryptor decryptor = (CipherProvider.Decryptor)this.decryptors.poll();
            if (decryptor == null) {
                decryptor = CipherProviderFactory.getDecrypter(this.cipherProvider, this.key, this.parameters);
            }
            return decryptor;
        }

        @Override
        int getVersion() {
            return 3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected TransactionEventRecord doGet(RandomAccessFile fileHandle) throws IOException, CorruptEventException {
            RandomReader randomReader = this;
            synchronized (randomReader) {
                if (!this.initialized) {
                    this.initialized = true;
                    this.initialize();
                }
            }
            byte[] buffer = LogFile.readDelimitedBuffer(fileHandle);
            CipherProvider.Decryptor decryptor = null;
            boolean success = false;
            try {
                if (this.encryptionEnabled) {
                    decryptor = this.getDecryptor();
                    buffer = decryptor.decrypt(buffer);
                }
                TransactionEventRecord event = TransactionEventRecord.fromByteArray(buffer);
                success = true;
                TransactionEventRecord transactionEventRecord = event;
                return transactionEventRecord;
            }
            finally {
                if (success && this.encryptionEnabled && decryptor != null) {
                    this.decryptors.offer(decryptor);
                }
            }
        }
    }

    static class Writer
    extends LogFile.Writer {
        Writer(File file, int logFileID, long maxFileSize, @Nullable Key encryptionKey, @Nullable String encryptionKeyAlias, @Nullable String encryptionCipherProvider, long usableSpaceRefreshInterval) throws IOException {
            super(file, logFileID, maxFileSize, CipherProviderFactory.getEncrypter(encryptionCipherProvider, encryptionKey), usableSpaceRefreshInterval);
            ProtosFactory.LogFileMetaData.Builder metaDataBuilder = ProtosFactory.LogFileMetaData.newBuilder();
            if (encryptionKey != null) {
                Preconditions.checkNotNull((Object)encryptionKeyAlias, (Object)"encryptionKeyAlias");
                Preconditions.checkNotNull((Object)encryptionCipherProvider, (Object)"encryptionCipherProvider");
                ProtosFactory.LogFileEncryption.Builder logFileEncryptionBuilder = ProtosFactory.LogFileEncryption.newBuilder();
                logFileEncryptionBuilder.setCipherProvider(encryptionCipherProvider);
                logFileEncryptionBuilder.setKeyAlias(encryptionKeyAlias);
                logFileEncryptionBuilder.setParameters(ByteString.copyFrom((byte[])this.getEncryptor().getParameters()));
                metaDataBuilder.setEncryption(logFileEncryptionBuilder);
            }
            metaDataBuilder.setVersion(this.getVersion());
            metaDataBuilder.setLogFileID(logFileID);
            metaDataBuilder.setCheckpointPosition(0L);
            metaDataBuilder.setCheckpointWriteOrderID(0L);
            metaDataBuilder.setBackupCheckpointPosition(0L);
            metaDataBuilder.setBackupCheckpointWriteOrderID(0L);
            File metaDataFile = Serialization.getMetaDataFile(file);
            LogFileV3.writeDelimitedTo(metaDataBuilder.build(), metaDataFile);
        }

        @Override
        int getVersion() {
            return 3;
        }
    }

    static class MetaDataReader {
        private final File logFile;
        private final File metaDataFile;
        private final int logFileID;

        protected MetaDataReader(File logFile, int logFileID) throws IOException {
            this.logFile = logFile;
            this.metaDataFile = Serialization.getMetaDataFile(logFile);
            this.logFileID = logFileID;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ProtosFactory.LogFileMetaData read() throws IOException {
            FileInputStream inputStream = new FileInputStream(this.metaDataFile);
            try {
                ProtosFactory.LogFileMetaData metaData = (ProtosFactory.LogFileMetaData)Preconditions.checkNotNull((Object)ProtosFactory.LogFileMetaData.parseDelimitedFrom(inputStream), (Object)"Metadata cannot be null");
                if (metaData.getLogFileID() != this.logFileID) {
                    throw new IOException("The file id of log file: " + this.logFile + " is different from expected " + " id: expected = " + this.logFileID + ", found = " + metaData.getLogFileID());
                }
                ProtosFactory.LogFileMetaData logFileMetaData = metaData;
                return logFileMetaData;
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Unable to close " + this.metaDataFile, (Throwable)e);
                }
            }
        }
    }

    static class MetaDataWriter
    extends LogFile.MetaDataWriter {
        private ProtosFactory.LogFileMetaData logFileMetaData;
        private final File metaDataFile;

        protected MetaDataWriter(File logFile, int logFileID) throws IOException {
            super(logFile, logFileID);
            this.metaDataFile = Serialization.getMetaDataFile(logFile);
            MetaDataReader metaDataReader = new MetaDataReader(logFile, logFileID);
            this.logFileMetaData = metaDataReader.read();
            int version = this.logFileMetaData.getVersion();
            if (version != this.getVersion()) {
                throw new IOException("Version is " + Integer.toHexString(version) + " expected " + Integer.toHexString(this.getVersion()) + " file: " + logFile);
            }
            this.setLastCheckpointOffset(this.logFileMetaData.getCheckpointPosition());
            this.setLastCheckpointWriteOrderID(this.logFileMetaData.getCheckpointWriteOrderID());
        }

        @Override
        int getVersion() {
            return 3;
        }

        @Override
        void markCheckpoint(long currentPosition, long logWriteOrderID) throws IOException {
            ProtosFactory.LogFileMetaData.Builder metaDataBuilder = ProtosFactory.LogFileMetaData.newBuilder(this.logFileMetaData);
            metaDataBuilder.setCheckpointPosition(currentPosition);
            metaDataBuilder.setCheckpointWriteOrderID(logWriteOrderID);
            metaDataBuilder.setBackupCheckpointPosition(this.logFileMetaData.getCheckpointPosition());
            metaDataBuilder.setBackupCheckpointWriteOrderID(this.logFileMetaData.getCheckpointWriteOrderID());
            this.logFileMetaData = metaDataBuilder.build();
            LogFileV3.writeDelimitedTo(this.logFileMetaData, this.metaDataFile);
        }
    }
}

