/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.MathContext;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.filter.WhileMatchFilter;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Hash;
import org.apache.hadoop.hbase.util.MurmurHash;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.mapreduce.lib.reduce.LongSumReducer;
import org.apache.hadoop.util.LineReader;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class PerformanceEvaluation
extends Configured
implements Tool {
    protected static final Log LOG = LogFactory.getLog((String)PerformanceEvaluation.class.getName());
    public static final TableName TABLE_NAME = TableName.valueOf((String)"TestTable");
    public static final byte[] FAMILY_NAME = Bytes.toBytes((String)"info");
    public static final byte[] QUALIFIER_NAME = Bytes.toBytes((String)"data");
    public static final int VALUE_LENGTH = 1000;
    public static final int ROW_LENGTH = 26;
    private static final int ONE_GB = 1048576000;
    private static final int ROWS_PER_GB = 0x100000;
    private static final DecimalFormat FMT = new DecimalFormat("0.##");
    private static final MathContext CXT = MathContext.DECIMAL64;
    private static final BigDecimal MS_PER_SEC = BigDecimal.valueOf(1000L);
    private static final BigDecimal BYTES_PER_MB = BigDecimal.valueOf(0x100000L);
    protected HTableDescriptor TABLE_DESCRIPTOR;
    protected Map<String, CmdDescriptor> commands = new TreeMap<String, CmdDescriptor>();
    private boolean nomapred = false;
    private int N = 1;
    private int R = 0x100000;
    private float sampleRate = 1.0f;
    private TableName tableName = TABLE_NAME;
    private Compression.Algorithm compression = Compression.Algorithm.NONE;
    private DataBlockEncoding blockEncoding = DataBlockEncoding.NONE;
    private boolean flushCommits = true;
    private boolean writeToWAL = true;
    private boolean inMemoryCF = false;
    private boolean reportLatency = false;
    private int presplitRegions = 0;
    private HConnection connection;
    private static final Path PERF_EVAL_DIR = new Path("performance_evaluation");
    public static final Pattern LINE_PATTERN = Pattern.compile("tableName=(\\w+),\\s+startRow=(\\d+),\\s+perClientRunRows=(\\d+),\\s+totalRows=(\\d+),\\s+sampleRate=([-+]?[0-9]*\\.?[0-9]+),\\s+clients=(\\d+),\\s+flushCommits=(\\w+),\\s+writeToWAL=(\\w+),\\s+reportLatency=(\\w+)");

    public PerformanceEvaluation(Configuration conf) {
        super(conf);
        this.addCommandDescriptor(RandomReadTest.class, "randomRead", "Run random read test");
        this.addCommandDescriptor(RandomSeekScanTest.class, "randomSeekScan", "Run random seek and scan 100 test");
        this.addCommandDescriptor(RandomScanWithRange10Test.class, "scanRange10", "Run random seek scan with both start and stop row (max 10 rows)");
        this.addCommandDescriptor(RandomScanWithRange100Test.class, "scanRange100", "Run random seek scan with both start and stop row (max 100 rows)");
        this.addCommandDescriptor(RandomScanWithRange1000Test.class, "scanRange1000", "Run random seek scan with both start and stop row (max 1000 rows)");
        this.addCommandDescriptor(RandomScanWithRange10000Test.class, "scanRange10000", "Run random seek scan with both start and stop row (max 10000 rows)");
        this.addCommandDescriptor(RandomWriteTest.class, "randomWrite", "Run random write test");
        this.addCommandDescriptor(SequentialReadTest.class, "sequentialRead", "Run sequential read test");
        this.addCommandDescriptor(SequentialWriteTest.class, "sequentialWrite", "Run sequential write test");
        this.addCommandDescriptor(ScanTest.class, "scan", "Run scan test (read every row)");
        this.addCommandDescriptor(FilteredScanTest.class, "filterScan", "Run scan test using a filter to find a specific row based on it's value (make sure to use --rows=20)");
    }

    protected void addCommandDescriptor(Class<? extends Test> cmdClass, String name, String description) {
        CmdDescriptor cmdDescriptor = new CmdDescriptor(cmdClass, name, description);
        this.commands.put(name, cmdDescriptor);
    }

    private boolean checkTable(HBaseAdmin admin) throws IOException {
        HTableDescriptor tableDescriptor = this.getTableDescriptor();
        if (this.presplitRegions > 0) {
            if (admin.tableExists(tableDescriptor.getTableName())) {
                admin.disableTable(tableDescriptor.getTableName());
                admin.deleteTable(tableDescriptor.getTableName());
            }
            byte[][] splits = this.getSplits();
            for (int i = 0; i < splits.length; ++i) {
                LOG.debug((Object)(" split " + i + ": " + Bytes.toStringBinary((byte[])splits[i])));
            }
            admin.createTable(tableDescriptor, splits);
            LOG.info((Object)("Table created with " + this.presplitRegions + " splits"));
        } else {
            boolean tableExists = admin.tableExists(tableDescriptor.getTableName());
            if (!tableExists) {
                admin.createTable(tableDescriptor);
                LOG.info((Object)("Table " + tableDescriptor + " created"));
            }
        }
        return admin.tableExists(tableDescriptor.getTableName());
    }

    protected HTableDescriptor getTableDescriptor() {
        if (this.TABLE_DESCRIPTOR == null) {
            this.TABLE_DESCRIPTOR = new HTableDescriptor(this.tableName);
            HColumnDescriptor family = new HColumnDescriptor(FAMILY_NAME);
            family.setDataBlockEncoding(this.blockEncoding);
            family.setCompressionType(this.compression);
            if (this.inMemoryCF) {
                family.setInMemory(true);
            }
            this.TABLE_DESCRIPTOR.addFamily(family);
        }
        return this.TABLE_DESCRIPTOR;
    }

    protected byte[][] getSplits() {
        if (this.presplitRegions == 0) {
            return new byte[0][];
        }
        int numSplitPoints = this.presplitRegions - 1;
        byte[][] splits = new byte[numSplitPoints][];
        int jump = this.R / this.presplitRegions;
        for (int i = 0; i < numSplitPoints; ++i) {
            int rowkey = jump * (1 + i);
            splits[i] = PerformanceEvaluation.format(rowkey);
        }
        return splits;
    }

    private void runNIsMoreThanOne(Class<? extends Test> cmd) throws IOException, InterruptedException, ClassNotFoundException {
        this.checkTable(new HBaseAdmin(this.getConf()));
        if (this.nomapred) {
            this.doMultipleClients(cmd);
        } else {
            this.doMapReduce(cmd);
        }
    }

    private void doMultipleClients(final Class<? extends Test> cmd) throws IOException {
        ArrayList<1> threads = new ArrayList<1>(this.N);
        final long[] timings = new long[this.N];
        final int perClientRows = this.R / this.N;
        final float sampleRate = this.sampleRate;
        final TableName tableName = this.tableName;
        final DataBlockEncoding encoding = this.blockEncoding;
        final boolean flushCommits = this.flushCommits;
        final Compression.Algorithm compression = this.compression;
        final boolean writeToWal = this.writeToWAL;
        final boolean reportLatency = this.reportLatency;
        final int preSplitRegions = this.presplitRegions;
        final HConnection connection = HConnectionManager.createConnection((Configuration)this.getConf());
        for (int i = 0; i < this.N; ++i) {
            final int n = i;
            Thread t = new Thread("TestClient-" + i){

                @Override
                public void run() {
                    super.run();
                    PerformanceEvaluation pe = new PerformanceEvaluation(PerformanceEvaluation.this.getConf());
                    pe.tableName = tableName;
                    pe.blockEncoding = encoding;
                    pe.flushCommits = flushCommits;
                    pe.compression = compression;
                    pe.writeToWAL = writeToWal;
                    pe.presplitRegions = preSplitRegions;
                    pe.N = PerformanceEvaluation.this.N;
                    pe.sampleRate = sampleRate;
                    pe.reportLatency = reportLatency;
                    pe.connection = connection;
                    try {
                        long elapsedTime;
                        timings[n] = elapsedTime = pe.runOneClient(cmd, n * perClientRows, perClientRows, PerformanceEvaluation.this.R, sampleRate, flushCommits, PerformanceEvaluation.this.writeToWAL, reportLatency, connection, new Status(){

                            @Override
                            public void setStatus(String msg) throws IOException {
                                LOG.info((Object)("client-" + this.getName() + " " + msg));
                            }
                        });
                        LOG.info((Object)("Finished " + this.getName() + " in " + elapsedTime + "ms writing " + perClientRows + " rows"));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            threads.add(t);
        }
        for (Thread thread : threads) {
            thread.start();
        }
        for (Thread thread : threads) {
            while (thread.isAlive()) {
                try {
                    thread.join();
                }
                catch (InterruptedException e) {
                    LOG.debug((Object)("Interrupted, continuing" + e.toString()));
                }
            }
        }
        String test = cmd.getSimpleName();
        LOG.info((Object)("[" + test + "] Summary of timings (ms): " + Arrays.toString(timings)));
        Arrays.sort(timings);
        long l = 0L;
        for (int i = 0; i < this.N; ++i) {
            l += timings[i];
        }
        LOG.info((Object)("[" + test + "]" + "\tMin: " + timings[0] + "ms" + "\tMax: " + timings[this.N - 1] + "ms" + "\tAvg: " + l / (long)this.N + "ms"));
    }

    private void doMapReduce(Class<? extends Test> cmd) throws IOException, InterruptedException, ClassNotFoundException {
        Configuration conf = this.getConf();
        Path inputDir = this.writeInputFile(conf);
        conf.set("EvaluationMapTask.command", cmd.getName());
        conf.set("EvaluationMapTask.performanceEvalImpl", ((Object)((Object)this)).getClass().getName());
        Job job = new Job(conf);
        job.setJarByClass(PerformanceEvaluation.class);
        job.setJobName("HBase Performance Evaluation");
        job.setInputFormatClass(PeInputFormat.class);
        PeInputFormat.setInputPaths((Job)job, (Path[])new Path[]{inputDir});
        job.setOutputKeyClass(LongWritable.class);
        job.setOutputValueClass(LongWritable.class);
        job.setMapperClass(EvaluationMapTask.class);
        job.setReducerClass(LongSumReducer.class);
        job.setNumReduceTasks(1);
        job.setOutputFormatClass(TextOutputFormat.class);
        TextOutputFormat.setOutputPath((Job)job, (Path)new Path(inputDir.getParent(), "outputs"));
        TableMapReduceUtil.addDependencyJars((Job)job);
        TableMapReduceUtil.addDependencyJars((Configuration)job.getConfiguration(), (Class[])new Class[]{Bytes.class});
        TableMapReduceUtil.initCredentials((Job)job);
        job.waitForCompletion(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Path writeInputFile(Configuration c) throws IOException {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        Path jobdir = new Path(PERF_EVAL_DIR, formatter.format(new Date()));
        Path inputDir = new Path(jobdir, "inputs");
        FileSystem fs = FileSystem.get((Configuration)c);
        fs.mkdirs(inputDir);
        Path inputFile = new Path(inputDir, "input.txt");
        PrintStream out = new PrintStream((OutputStream)fs.create(inputFile));
        TreeMap<Integer, String> m = new TreeMap<Integer, String>();
        Hash h = MurmurHash.getInstance();
        int perClientRows = this.R / this.N;
        try {
            for (int i = 0; i < 10; ++i) {
                for (int j = 0; j < this.N; ++j) {
                    String s = "tableName=" + this.tableName + ", startRow=" + (j * perClientRows + i * (perClientRows / 10)) + ", perClientRunRows=" + perClientRows / 10 + ", totalRows=" + this.R + ", sampleRate=" + this.sampleRate + ", clients=" + this.N + ", flushCommits=" + this.flushCommits + ", writeToWAL=" + this.writeToWAL + ", reportLatency=" + this.reportLatency;
                    int hash = h.hash(Bytes.toBytes((String)s));
                    m.put(hash, s);
                }
            }
            for (Map.Entry e : m.entrySet()) {
                out.println((String)e.getValue());
            }
        }
        finally {
            out.close();
        }
        return inputDir;
    }

    private static String calculateMbps(int rows, long timeMs) {
        BigDecimal rowSize = BigDecimal.valueOf(1026 + FAMILY_NAME.length + QUALIFIER_NAME.length);
        BigDecimal mbps = BigDecimal.valueOf(rows).multiply(rowSize, CXT).divide(BigDecimal.valueOf(timeMs), CXT).multiply(MS_PER_SEC, CXT).divide(BYTES_PER_MB, CXT);
        return FMT.format(mbps) + " MB/s";
    }

    public static byte[] format(int number) {
        byte[] b = new byte[26];
        int d = Math.abs(number);
        for (int i = b.length - 1; i >= 0; --i) {
            b[i] = (byte)(d % 10 + 48);
            d /= 10;
        }
        return b;
    }

    public static byte[] generateValue(Random r) {
        byte[] b = new byte[1000];
        int i = 0;
        for (i = 0; i < 992; i += 8) {
            b[i] = (byte)(65 + r.nextInt(26));
            b[i + 1] = b[i];
            b[i + 2] = b[i];
            b[i + 3] = b[i];
            b[i + 4] = b[i];
            b[i + 5] = b[i];
            b[i + 6] = b[i];
            b[i + 7] = b[i];
        }
        byte a = (byte)(65 + r.nextInt(26));
        while (i < 1000) {
            b[i] = a;
            ++i;
        }
        return b;
    }

    static byte[] getRandomRow(Random random, int totalRows) {
        return PerformanceEvaluation.format(random.nextInt(Integer.MAX_VALUE) % totalRows);
    }

    long runOneClient(Class<? extends Test> cmd, int startRow, int perClientRunRows, int totalRows, float sampleRate, boolean flushCommits, boolean writeToWAL, boolean reportLatency, HConnection connection, Status status) throws IOException {
        Test t;
        status.setStatus("Start " + cmd + " at offset " + startRow + " for " + perClientRunRows + " rows");
        long totalElapsedTime = 0L;
        TestOptions options = new TestOptions(startRow, perClientRunRows, totalRows, sampleRate, this.N, this.tableName, flushCommits, writeToWAL, reportLatency, connection);
        try {
            Constructor<? extends Test> constructor = cmd.getDeclaredConstructor(Configuration.class, TestOptions.class, Status.class);
            t = constructor.newInstance(this.getConf(), options, status);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Invalid command class: " + cmd.getName() + ".  It does not provide a constructor as described by" + "the javadoc comment.  Available constructors are: " + Arrays.toString(cmd.getConstructors()));
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to construct command class", e);
        }
        totalElapsedTime = t.test();
        status.setStatus("Finished " + cmd + " in " + totalElapsedTime + "ms at offset " + startRow + " for " + perClientRunRows + " rows" + " (" + PerformanceEvaluation.calculateMbps((int)((float)perClientRunRows * sampleRate), totalElapsedTime) + ")");
        return totalElapsedTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runNIsOne(Class<? extends Test> cmd) throws IOException {
        Status status = new Status(){

            @Override
            public void setStatus(String msg) throws IOException {
                LOG.info((Object)msg);
            }
        };
        HBaseAdmin admin = null;
        try {
            admin = new HBaseAdmin(this.getConf());
            this.checkTable(admin);
            this.runOneClient(cmd, 0, this.R, this.R, this.sampleRate, this.flushCommits, this.writeToWAL, this.reportLatency, this.connection, status);
        }
        catch (Exception e) {
            LOG.error((Object)"Failed", (Throwable)e);
        }
        finally {
            if (admin != null) {
                admin.close();
            }
        }
    }

    private void runTest(Class<? extends Test> cmd) throws IOException, InterruptedException, ClassNotFoundException {
        if (this.N == 1) {
            this.runNIsOne(cmd);
        } else {
            this.runNIsMoreThanOne(cmd);
        }
    }

    protected void printUsage() {
        this.printUsage(null);
    }

    protected void printUsage(String message) {
        if (message != null && message.length() > 0) {
            System.err.println(message);
        }
        System.err.println("Usage: java " + ((Object)((Object)this)).getClass().getName() + " \\");
        System.err.println("  [--nomapred] [--rows=ROWS] [--table=NAME] \\");
        System.err.println("  [--compress=TYPE] [--blockEncoding=TYPE] [-D<property=value>]* <command> <nclients>");
        System.err.println();
        System.err.println("Options:");
        System.err.println(" nomapred        Run multiple clients using threads (rather than use mapreduce)");
        System.err.println(" rows            Rows each client runs. Default: One million");
        System.err.println(" sampleRate      Execute test on a sample of total rows. Only supported by randomRead. Default: 1.0");
        System.err.println(" table           Alternate table name. Default: 'TestTable'");
        System.err.println(" compress        Compression type to use (GZ, LZO, ...). Default: 'NONE'");
        System.err.println(" flushCommits    Used to determine if the test should flush the table. Default: false");
        System.err.println(" writeToWAL      Set writeToWAL on puts. Default: True");
        System.err.println(" presplit        Create presplit table. Recommended for accurate perf analysis (see guide).  Default: disabled");
        System.err.println(" inmemory        Tries to keep the HFiles of the CF inmemory as far as possible. Not guaranteed that reads are always served from memory.  Default: false");
        System.err.println(" latency         Set to report operation latencies. Currently only supported by randomRead test. Default: False");
        System.err.println();
        System.err.println(" Note: -D properties will be applied to the conf used. ");
        System.err.println("  For example: ");
        System.err.println("   -Dmapred.output.compress=true");
        System.err.println("   -Dmapreduce.task.timeout=60000");
        System.err.println();
        System.err.println("Command:");
        for (CmdDescriptor command : this.commands.values()) {
            System.err.println(String.format(" %-15s %s", command.getName(), command.getDescription()));
        }
        System.err.println();
        System.err.println("Args:");
        System.err.println(" nclients        Integer. Required. Total number of clients (and HRegionServers)");
        System.err.println("                 running: 1 <= value <= 500");
        System.err.println("Examples:");
        System.err.println(" To run a single evaluation client:");
        System.err.println(" $ bin/hbase " + ((Object)((Object)this)).getClass().getName() + " sequentialWrite 1");
    }

    private void getArgs(int start, String[] args) {
        if (start + 1 > args.length) {
            throw new IllegalArgumentException("must supply the number of clients");
        }
        this.N = Integer.parseInt(args[start]);
        if (this.N < 1) {
            throw new IllegalArgumentException("Number of clients must be > 1");
        }
        this.R *= this.N;
    }

    public int run(String[] args) throws Exception {
        int errCode = -1;
        if (args.length < 1) {
            this.printUsage();
            return errCode;
        }
        try {
            for (int i = 0; i < args.length; ++i) {
                String cmd = args[i];
                if (cmd.equals("-h") || cmd.startsWith("--h")) {
                    this.printUsage();
                    errCode = 0;
                } else {
                    String nmr = "--nomapred";
                    if (cmd.startsWith("--nomapred")) {
                        this.nomapred = true;
                        continue;
                    }
                    String rows = "--rows=";
                    if (cmd.startsWith("--rows=")) {
                        this.R = Integer.parseInt(cmd.substring("--rows=".length()));
                        continue;
                    }
                    String sampleRate = "--sampleRate=";
                    if (cmd.startsWith("--sampleRate=")) {
                        this.sampleRate = Float.parseFloat(cmd.substring("--sampleRate=".length()));
                        continue;
                    }
                    String table = "--table=";
                    if (cmd.startsWith("--table=")) {
                        this.tableName = TableName.valueOf((String)cmd.substring("--table=".length()));
                        continue;
                    }
                    String compress = "--compress=";
                    if (cmd.startsWith("--compress=")) {
                        this.compression = Compression.Algorithm.valueOf((String)cmd.substring("--compress=".length()));
                        continue;
                    }
                    String blockEncoding = "--blockEncoding=";
                    if (cmd.startsWith("--blockEncoding=")) {
                        this.blockEncoding = DataBlockEncoding.valueOf((String)cmd.substring("--blockEncoding=".length()));
                        continue;
                    }
                    String flushCommits = "--flushCommits=";
                    if (cmd.startsWith("--flushCommits=")) {
                        this.flushCommits = Boolean.parseBoolean(cmd.substring("--flushCommits=".length()));
                        continue;
                    }
                    String writeToWAL = "--writeToWAL=";
                    if (cmd.startsWith("--writeToWAL=")) {
                        this.writeToWAL = Boolean.parseBoolean(cmd.substring("--writeToWAL=".length()));
                        continue;
                    }
                    String presplit = "--presplit=";
                    if (cmd.startsWith("--presplit=")) {
                        this.presplitRegions = Integer.parseInt(cmd.substring("--presplit=".length()));
                        continue;
                    }
                    String inMemory = "--inmemory=";
                    if (cmd.startsWith("--inmemory=")) {
                        this.inMemoryCF = Boolean.parseBoolean(cmd.substring("--inmemory=".length()));
                        continue;
                    }
                    String latency = "--latency";
                    if (cmd.startsWith("--latency")) {
                        this.reportLatency = true;
                        continue;
                    }
                    this.connection = HConnectionManager.createConnection((Configuration)this.getConf());
                    Class<? extends Test> cmdClass = this.determineCommandClass(cmd);
                    if (cmdClass != null) {
                        this.getArgs(i + 1, args);
                        this.runTest(cmdClass);
                        errCode = 0;
                    } else {
                        this.printUsage();
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return errCode;
    }

    private Class<? extends Test> determineCommandClass(String cmd) {
        CmdDescriptor descriptor = this.commands.get(cmd);
        return descriptor != null ? descriptor.getCmdClass() : null;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Tool)new PerformanceEvaluation(HBaseConfiguration.create()), (String[])args);
        System.exit(res);
    }

    static class FilteredScanTest
    extends Test {
        protected static final Log LOG = LogFactory.getLog((String)FilteredScanTest.class.getName());

        FilteredScanTest(Configuration conf, TestOptions options, Status status) {
            super(conf, options, status);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void testRow(int i) throws IOException {
            byte[] value = PerformanceEvaluation.generateValue(this.rand);
            Scan scan = this.constructScan(value);
            ResultScanner scanner = null;
            try {
                scanner = this.table.getScanner(scan);
                while (scanner.next() != null) {
                }
            }
            finally {
                if (scanner != null) {
                    scanner.close();
                }
            }
        }

        protected Scan constructScan(byte[] valuePrefix) throws IOException {
            SingleColumnValueFilter filter = new SingleColumnValueFilter(FAMILY_NAME, QUALIFIER_NAME, CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new BinaryComparator(valuePrefix));
            Scan scan = new Scan();
            scan.addColumn(FAMILY_NAME, QUALIFIER_NAME);
            scan.setFilter((Filter)filter);
            return scan;
        }
    }

    static class SequentialWriteTest
    extends Test {
        SequentialWriteTest(Configuration conf, TestOptions options, Status status) {
            super(conf, options, status);
        }

        @Override
        void testRow(int i) throws IOException {
            Put put = new Put(PerformanceEvaluation.format(i));
            byte[] value = PerformanceEvaluation.generateValue(this.rand);
            put.add(FAMILY_NAME, QUALIFIER_NAME, value);
            put.setDurability(this.writeToWAL ? Durability.SYNC_WAL : Durability.SKIP_WAL);
            this.table.put(put);
        }
    }

    static class SequentialReadTest
    extends Test {
        SequentialReadTest(Configuration conf, TestOptions options, Status status) {
            super(conf, options, status);
        }

        @Override
        void testRow(int i) throws IOException {
            Get get = new Get(PerformanceEvaluation.format(i));
            get.addColumn(FAMILY_NAME, QUALIFIER_NAME);
            this.table.get(get);
        }
    }

    static class ScanTest
    extends Test {
        private ResultScanner testScanner;

        ScanTest(Configuration conf, TestOptions options, Status status) {
            super(conf, options, status);
        }

        @Override
        void testTakedown() throws IOException {
            if (this.testScanner != null) {
                this.testScanner.close();
            }
            super.testTakedown();
        }

        @Override
        void testRow(int i) throws IOException {
            if (this.testScanner == null) {
                Scan scan = new Scan(PerformanceEvaluation.format(this.startRow));
                scan.setCaching(30);
                scan.addColumn(FAMILY_NAME, QUALIFIER_NAME);
                this.testScanner = this.table.getScanner(scan);
            }
            this.testScanner.next();
        }
    }

    static class RandomWriteTest
    extends Test {
        RandomWriteTest(Configuration conf, TestOptions options, Status status) {
            super(conf, options, status);
        }

        @Override
        void testRow(int i) throws IOException {
            byte[] row = PerformanceEvaluation.getRandomRow(this.rand, this.totalRows);
            Put put = new Put(row);
            byte[] value = PerformanceEvaluation.generateValue(this.rand);
            put.add(FAMILY_NAME, QUALIFIER_NAME, value);
            put.setDurability(this.writeToWAL ? Durability.SYNC_WAL : Durability.SKIP_WAL);
            this.table.put(put);
        }
    }

    static class RandomReadTest
    extends Test {
        private final int everyN = (int)((float)this.totalRows / ((float)this.totalRows * this.sampleRate));
        private final boolean reportLatency;
        private final float[] times;
        int idx = 0;

        RandomReadTest(Configuration conf, TestOptions options, Status status) {
            super(conf, options, status);
            LOG.info((Object)("Sampling 1 every " + this.everyN + " out of " + this.perClientRunRows + " total rows."));
            this.reportLatency = options.isReportLatency();
            this.times = (float[])(this.reportLatency ? new float[(int)Math.ceil((float)this.perClientRunRows * this.sampleRate)] : null);
        }

        @Override
        void testRow(int i) throws IOException {
            if (i % this.everyN == 0) {
                Get get = new Get(PerformanceEvaluation.getRandomRow(this.rand, this.totalRows));
                get.addColumn(FAMILY_NAME, QUALIFIER_NAME);
                long start = System.nanoTime();
                this.table.get(get);
                if (this.reportLatency) {
                    this.times[this.idx++] = (float)((double)(System.nanoTime() - start) / 1000000.0);
                }
            }
        }

        @Override
        protected int getReportingPeriod() {
            int period = this.perClientRunRows / 100;
            return period == 0 ? this.perClientRunRows : period;
        }

        @Override
        protected void testTakedown() throws IOException {
            super.testTakedown();
            if (this.reportLatency) {
                LOG.info((Object)("randomRead latency log (ms): " + Arrays.toString(this.times)));
            }
        }
    }

    static class RandomScanWithRange10000Test
    extends RandomScanWithRangeTest {
        RandomScanWithRange10000Test(Configuration conf, TestOptions options, Status status) {
            super(conf, options, status);
        }

        @Override
        protected Pair<byte[], byte[]> getStartAndStopRow() {
            return this.generateStartAndStopRows(10000);
        }
    }

    static class RandomScanWithRange1000Test
    extends RandomScanWithRangeTest {
        RandomScanWithRange1000Test(Configuration conf, TestOptions options, Status status) {
            super(conf, options, status);
        }

        @Override
        protected Pair<byte[], byte[]> getStartAndStopRow() {
            return this.generateStartAndStopRows(1000);
        }
    }

    static class RandomScanWithRange100Test
    extends RandomScanWithRangeTest {
        RandomScanWithRange100Test(Configuration conf, TestOptions options, Status status) {
            super(conf, options, status);
        }

        @Override
        protected Pair<byte[], byte[]> getStartAndStopRow() {
            return this.generateStartAndStopRows(100);
        }
    }

    static class RandomScanWithRange10Test
    extends RandomScanWithRangeTest {
        RandomScanWithRange10Test(Configuration conf, TestOptions options, Status status) {
            super(conf, options, status);
        }

        @Override
        protected Pair<byte[], byte[]> getStartAndStopRow() {
            return this.generateStartAndStopRows(10);
        }
    }

    static abstract class RandomScanWithRangeTest
    extends Test {
        RandomScanWithRangeTest(Configuration conf, TestOptions options, Status status) {
            super(conf, options, status);
        }

        @Override
        void testRow(int i) throws IOException {
            Result rr;
            Pair<byte[], byte[]> startAndStopRow = this.getStartAndStopRow();
            Scan scan = new Scan((byte[])startAndStopRow.getFirst(), (byte[])startAndStopRow.getSecond());
            scan.addColumn(FAMILY_NAME, QUALIFIER_NAME);
            ResultScanner s = this.table.getScanner(scan);
            int count = 0;
            while ((rr = s.next()) != null) {
                ++count;
            }
            if (i % 100 == 0) {
                LOG.info((Object)String.format("Scan for key range %s - %s returned %s rows", Bytes.toString((byte[])((byte[])startAndStopRow.getFirst())), Bytes.toString((byte[])((byte[])startAndStopRow.getSecond())), count));
            }
            s.close();
        }

        protected abstract Pair<byte[], byte[]> getStartAndStopRow();

        protected Pair<byte[], byte[]> generateStartAndStopRows(int maxRange) {
            int start = this.rand.nextInt(Integer.MAX_VALUE) % this.totalRows;
            int stop = start + maxRange;
            return new Pair((Object)PerformanceEvaluation.format(start), (Object)PerformanceEvaluation.format(stop));
        }

        @Override
        protected int getReportingPeriod() {
            int period = this.perClientRunRows / 100;
            return period == 0 ? this.perClientRunRows : period;
        }
    }

    static class RandomSeekScanTest
    extends Test {
        RandomSeekScanTest(Configuration conf, TestOptions options, Status status) {
            super(conf, options, status);
        }

        @Override
        void testRow(int i) throws IOException {
            Result rr;
            Scan scan = new Scan(PerformanceEvaluation.getRandomRow(this.rand, this.totalRows));
            scan.addColumn(FAMILY_NAME, QUALIFIER_NAME);
            scan.setFilter((Filter)new WhileMatchFilter((Filter)new PageFilter(120L)));
            ResultScanner s = this.table.getScanner(scan);
            while ((rr = s.next()) != null) {
            }
            s.close();
        }

        @Override
        protected int getReportingPeriod() {
            int period = this.perClientRunRows / 100;
            return period == 0 ? this.perClientRunRows : period;
        }
    }

    static abstract class Test {
        private static final Random randomSeed = new Random(System.currentTimeMillis());
        protected final Random rand = new Random(Test.nextRandomSeed());
        protected final int startRow;
        protected final int perClientRunRows;
        protected final int totalRows;
        protected final float sampleRate;
        private final Status status;
        protected TableName tableName;
        protected HTableInterface table;
        protected volatile Configuration conf;
        protected boolean flushCommits;
        protected boolean writeToWAL;
        protected boolean reportLatency;
        protected HConnection connection;

        private static long nextRandomSeed() {
            return randomSeed.nextLong();
        }

        Test(Configuration conf, TestOptions options, Status status) {
            this.startRow = options.getStartRow();
            this.perClientRunRows = options.getPerClientRunRows();
            this.totalRows = options.getTotalRows();
            this.sampleRate = options.getSampleRate();
            this.status = status;
            this.tableName = options.getTableName();
            this.table = null;
            this.conf = conf;
            this.flushCommits = options.isFlushCommits();
            this.writeToWAL = options.isWriteToWAL();
            this.reportLatency = options.isReportLatency();
            this.connection = options.getConnection();
        }

        private String generateStatus(int sr, int i, int lr) {
            return sr + "/" + i + "/" + lr;
        }

        protected int getReportingPeriod() {
            int period = this.perClientRunRows / 10;
            return period == 0 ? this.perClientRunRows : period;
        }

        void testSetup() throws IOException {
            this.table = this.connection.getTable(this.tableName);
            this.table.setAutoFlush(false, true);
        }

        void testTakedown() throws IOException {
            if (this.flushCommits) {
                this.table.flushCommits();
            }
            this.table.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long test() throws IOException {
            this.testSetup();
            LOG.info((Object)("Timed test starting in thread " + Thread.currentThread().getName()));
            long startTime = System.nanoTime();
            try {
                this.testTimed();
            }
            finally {
                this.testTakedown();
            }
            return (System.nanoTime() - startTime) / 1000000L;
        }

        void testTimed() throws IOException {
            int lastRow = this.startRow + this.perClientRunRows;
            for (int i = this.startRow; i < lastRow; ++i) {
                this.testRow(i);
                if (this.status == null || i <= 0 || i % this.getReportingPeriod() != 0) continue;
                this.status.setStatus(this.generateStatus(this.startRow, i, lastRow));
            }
        }

        abstract void testRow(int var1) throws IOException;
    }

    static class TestOptions {
        private int startRow;
        private int perClientRunRows;
        private int totalRows;
        private float sampleRate;
        private int numClientThreads;
        private TableName tableName;
        private boolean flushCommits;
        private boolean writeToWAL = true;
        private boolean reportLatency;
        private HConnection connection;

        TestOptions(int startRow, int perClientRunRows, int totalRows, float sampleRate, int numClientThreads, TableName tableName, boolean flushCommits, boolean writeToWAL, boolean reportLatency, HConnection connection) {
            this.startRow = startRow;
            this.perClientRunRows = perClientRunRows;
            this.totalRows = totalRows;
            this.sampleRate = sampleRate;
            this.numClientThreads = numClientThreads;
            this.tableName = tableName;
            this.flushCommits = flushCommits;
            this.writeToWAL = writeToWAL;
            this.reportLatency = reportLatency;
            this.connection = connection;
        }

        public int getStartRow() {
            return this.startRow;
        }

        public int getPerClientRunRows() {
            return this.perClientRunRows;
        }

        public int getTotalRows() {
            return this.totalRows;
        }

        public float getSampleRate() {
            return this.sampleRate;
        }

        public int getNumClientThreads() {
            return this.numClientThreads;
        }

        public TableName getTableName() {
            return this.tableName;
        }

        public boolean isFlushCommits() {
            return this.flushCommits;
        }

        public boolean isWriteToWAL() {
            return this.writeToWAL;
        }

        public boolean isReportLatency() {
            return this.reportLatency;
        }

        public HConnection getConnection() {
            return this.connection;
        }
    }

    static class CmdDescriptor {
        private Class<? extends Test> cmdClass;
        private String name;
        private String description;

        CmdDescriptor(Class<? extends Test> cmdClass, String name, String description) {
            this.cmdClass = cmdClass;
            this.name = name;
            this.description = description;
        }

        public Class<? extends Test> getCmdClass() {
            return this.cmdClass;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static class EvaluationMapTask
    extends Mapper<NullWritable, PeInputSplit, LongWritable, LongWritable> {
        public static final String CMD_KEY = "EvaluationMapTask.command";
        public static final String PE_KEY = "EvaluationMapTask.performanceEvalImpl";
        private Class<? extends Test> cmd;
        private PerformanceEvaluation pe;

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.cmd = this.forName(context.getConfiguration().get(CMD_KEY), Test.class);
            Class<PerformanceEvaluation> peClass = this.forName(context.getConfiguration().get(PE_KEY), PerformanceEvaluation.class);
            try {
                this.pe = peClass.getConstructor(Configuration.class).newInstance(context.getConfiguration());
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not instantiate PE instance", e);
            }
        }

        private <Type> Class<? extends Type> forName(String className, Class<Type> type) {
            Class<Type> clazz = null;
            try {
                clazz = Class.forName(className).asSubclass(type);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Could not find class for name: " + className, e);
            }
            return clazz;
        }

        protected void map(NullWritable key, PeInputSplit value, final Mapper.Context context) throws IOException, InterruptedException {
            Status status = new Status(){

                @Override
                public void setStatus(String msg) {
                    context.setStatus(msg);
                }
            };
            this.pe.tableName = value.getTableName();
            long elapsedTime = this.pe.runOneClient(this.cmd, value.getStartRow(), value.getRows(), value.getTotalRows(), value.getSampleRate(), value.isFlushCommits(), value.isWriteToWAL(), value.isReportLatency(), HConnectionManager.createConnection((Configuration)context.getConfiguration()), status);
            context.getCounter((Enum)Counter.ELAPSED_TIME).increment(elapsedTime);
            context.getCounter((Enum)Counter.ROWS).increment((long)value.rows);
            context.write((Object)new LongWritable((long)value.startRow), (Object)new LongWritable(elapsedTime));
            context.progress();
        }
    }

    public static class PeInputFormat
    extends FileInputFormat<NullWritable, PeInputSplit> {
        public List<InputSplit> getSplits(JobContext job) throws IOException {
            ArrayList<InputSplit> splitList = new ArrayList<InputSplit>();
            for (FileStatus file : this.listStatus(job)) {
                Text lineText;
                if (file.isDir()) continue;
                Path path = file.getPath();
                FileSystem fs = path.getFileSystem(job.getConfiguration());
                FSDataInputStream fileIn = fs.open(path);
                LineReader in = new LineReader((InputStream)fileIn, job.getConfiguration());
                int lineLen = 0;
                while ((lineLen = in.readLine(lineText = new Text())) > 0) {
                    Matcher m = LINE_PATTERN.matcher(lineText.toString());
                    if (m == null || !m.matches()) continue;
                    TableName tableName = TableName.valueOf((String)m.group(1));
                    int startRow = Integer.parseInt(m.group(2));
                    int rows = Integer.parseInt(m.group(3));
                    int totalRows = Integer.parseInt(m.group(4));
                    float sampleRate = Float.parseFloat(m.group(5));
                    int clients = Integer.parseInt(m.group(6));
                    boolean flushCommits = Boolean.parseBoolean(m.group(7));
                    boolean writeToWAL = Boolean.parseBoolean(m.group(8));
                    boolean reportLatency = Boolean.parseBoolean(m.group(9));
                    LOG.debug((Object)("tableName=" + tableName + " split[" + splitList.size() + "] " + " startRow=" + startRow + " rows=" + rows + " totalRows=" + totalRows + " sampleRate=" + sampleRate + " clients=" + clients + " flushCommits=" + flushCommits + " writeToWAL=" + writeToWAL + " reportLatency=" + reportLatency));
                    PeInputSplit newSplit = new PeInputSplit(tableName, startRow, rows, totalRows, sampleRate, clients, flushCommits, writeToWAL, reportLatency);
                    splitList.add(newSplit);
                }
                in.close();
            }
            LOG.info((Object)("Total # of splits: " + splitList.size()));
            return splitList;
        }

        public RecordReader<NullWritable, PeInputSplit> createRecordReader(InputSplit split, TaskAttemptContext context) {
            return new PeRecordReader();
        }

        public static class PeRecordReader
        extends RecordReader<NullWritable, PeInputSplit> {
            private boolean readOver = false;
            private PeInputSplit split = null;
            private NullWritable key = null;
            private PeInputSplit value = null;

            public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
                this.readOver = false;
                this.split = (PeInputSplit)split;
            }

            public boolean nextKeyValue() throws IOException, InterruptedException {
                if (this.readOver) {
                    return false;
                }
                this.key = NullWritable.get();
                this.value = this.split;
                this.readOver = true;
                return true;
            }

            public NullWritable getCurrentKey() throws IOException, InterruptedException {
                return this.key;
            }

            public PeInputSplit getCurrentValue() throws IOException, InterruptedException {
                return this.value;
            }

            public float getProgress() throws IOException, InterruptedException {
                if (this.readOver) {
                    return 1.0f;
                }
                return 0.0f;
            }

            public void close() throws IOException {
            }
        }
    }

    public static class PeInputSplit
    extends InputSplit
    implements Writable {
        private TableName tableName = TABLE_NAME;
        private int startRow = 0;
        private int rows = 0;
        private int totalRows = 0;
        private float sampleRate = 1.0f;
        private int clients = 0;
        private boolean flushCommits = false;
        private boolean writeToWAL = true;
        private boolean reportLatency = false;

        public PeInputSplit() {
        }

        public PeInputSplit(TableName tableName, int startRow, int rows, int totalRows, float sampleRate, int clients, boolean flushCommits, boolean writeToWAL, boolean reportLatency) {
            this.tableName = tableName;
            this.startRow = startRow;
            this.rows = rows;
            this.totalRows = totalRows;
            this.sampleRate = sampleRate;
            this.clients = clients;
            this.flushCommits = flushCommits;
            this.writeToWAL = writeToWAL;
            this.reportLatency = reportLatency;
        }

        public void readFields(DataInput in) throws IOException {
            int tableNameLen = in.readInt();
            byte[] name = new byte[tableNameLen];
            in.readFully(name);
            this.tableName = TableName.valueOf((byte[])name);
            this.startRow = in.readInt();
            this.rows = in.readInt();
            this.totalRows = in.readInt();
            this.sampleRate = in.readFloat();
            this.clients = in.readInt();
            this.flushCommits = in.readBoolean();
            this.writeToWAL = in.readBoolean();
            this.reportLatency = in.readBoolean();
        }

        public void write(DataOutput out) throws IOException {
            byte[] name = this.tableName.toBytes();
            out.writeInt(name.length);
            out.write(name);
            out.writeInt(this.startRow);
            out.writeInt(this.rows);
            out.writeInt(this.totalRows);
            out.writeFloat(this.sampleRate);
            out.writeInt(this.clients);
            out.writeBoolean(this.flushCommits);
            out.writeBoolean(this.writeToWAL);
            out.writeBoolean(this.reportLatency);
        }

        public long getLength() throws IOException, InterruptedException {
            return 0L;
        }

        public String[] getLocations() throws IOException, InterruptedException {
            return new String[0];
        }

        public TableName getTableName() {
            return this.tableName;
        }

        public int getStartRow() {
            return this.startRow;
        }

        public int getRows() {
            return this.rows;
        }

        public int getTotalRows() {
            return this.totalRows;
        }

        public float getSampleRate() {
            return this.sampleRate;
        }

        public int getClients() {
            return this.clients;
        }

        public boolean isFlushCommits() {
            return this.flushCommits;
        }

        public boolean isWriteToWAL() {
            return this.writeToWAL;
        }

        public boolean isReportLatency() {
            return this.reportLatency;
        }
    }

    static interface Status {
        public void setStatus(String var1) throws IOException;
    }

    protected static enum Counter {
        ELAPSED_TIME,
        ROWS;

    }
}

