/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.catalog;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaEditor;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestMetaReaderEditor {
    private static final Log LOG = LogFactory.getLog(TestMetaReaderEditor.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static ZooKeeperWatcher zkw;
    private static CatalogTracker CT;
    private static final Abortable ABORTABLE;

    @BeforeClass
    public static void beforeClass() throws Exception {
        UTIL.startMiniCluster(3);
        Configuration c = new Configuration(UTIL.getConfiguration());
        c.setLong("hbase.client.pause", 1000L);
        c.setInt(HConstants.HBASE_CLIENT_RETRIES_NUMBER, 10);
        zkw = new ZooKeeperWatcher(c, "TestMetaReaderEditor", ABORTABLE);
        CT = new CatalogTracker(zkw, c, ABORTABLE);
        CT.start();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        ABORTABLE.abort("test ending", null);
        CT.stop();
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testRetrying() throws IOException, InterruptedException {
        TableName name = TableName.valueOf((String)"testRetrying");
        LOG.info((Object)("Started " + name));
        HTable t = UTIL.createTable(name, HConstants.CATALOG_FAMILY);
        int regionCount = UTIL.createMultiRegions(t, HConstants.CATALOG_FAMILY);
        final List<HRegionInfo> regions = TestMetaReaderEditor.testGettingTableRegions(CT, name, regionCount);
        MetaTask reader = new MetaTask(CT, "reader"){

            @Override
            void metaTask() throws Throwable {
                TestMetaReaderEditor.testGetRegion(this.ct, (HRegionInfo)regions.get(0));
                LOG.info((Object)("Read " + ((HRegionInfo)regions.get(0)).getEncodedName()));
            }
        };
        MetaTask writer = new MetaTask(CT, "writer"){

            @Override
            void metaTask() throws Throwable {
                MetaEditor.addRegionToMeta((CatalogTracker)this.ct, (HRegionInfo)((HRegionInfo)regions.get(0)));
                LOG.info((Object)("Wrote " + ((HRegionInfo)regions.get(0)).getEncodedName()));
            }
        };
        reader.start();
        writer.start();
        long timeOut = 180000L;
        long startTime = System.currentTimeMillis();
        try {
            Assert.assertTrue((boolean)reader.isProgressing());
            Assert.assertTrue((boolean)writer.isProgressing());
            for (int i = 0; i < 2; ++i) {
                LOG.info((Object)("Restart=" + i));
                UTIL.ensureSomeRegionServersAvailable(2);
                int index = -1;
                while ((index = UTIL.getMiniHBaseCluster().getServerWithMeta()) == -1 && startTime + 180000L < System.currentTimeMillis()) {
                }
                if (index == -1) continue;
                UTIL.getMiniHBaseCluster().abortRegionServer(index);
                UTIL.getMiniHBaseCluster().waitOnRegionServer(index);
            }
            Assert.assertTrue((String)("reader: " + reader.toString()), (boolean)reader.isProgressing());
            Assert.assertTrue((String)("writer: " + writer.toString()), (boolean)writer.isProgressing());
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            reader.stop = true;
            writer.stop = true;
            reader.join();
            writer.join();
            t.close();
        }
        long exeTime = System.currentTimeMillis() - startTime;
        Assert.assertTrue((String)("Timeout: test took " + exeTime / 1000L + " sec"), (exeTime < 180000L ? 1 : 0) != 0);
    }

    @Test
    public void testGetRegionsCatalogTables() throws IOException, InterruptedException {
        List regions = MetaReader.getTableRegions((CatalogTracker)CT, (TableName)TableName.META_TABLE_NAME);
        Assert.assertTrue((regions.size() >= 1 ? 1 : 0) != 0);
        Assert.assertTrue((MetaReader.getTableRegionsAndLocations((CatalogTracker)CT, (TableName)TableName.META_TABLE_NAME).size() >= 1 ? 1 : 0) != 0);
    }

    @Test
    public void testTableExists() throws IOException {
        TableName name = TableName.valueOf((String)"testTableExists");
        Assert.assertFalse((boolean)MetaReader.tableExists((CatalogTracker)CT, (TableName)name));
        UTIL.createTable(name, HConstants.CATALOG_FAMILY);
        Assert.assertTrue((boolean)MetaReader.tableExists((CatalogTracker)CT, (TableName)name));
        HBaseAdmin admin = UTIL.getHBaseAdmin();
        admin.disableTable(name);
        admin.deleteTable(name);
        Assert.assertFalse((boolean)MetaReader.tableExists((CatalogTracker)CT, (TableName)name));
        Assert.assertTrue((boolean)MetaReader.tableExists((CatalogTracker)CT, (TableName)TableName.META_TABLE_NAME));
    }

    @Test
    public void testGetRegion() throws IOException, InterruptedException {
        String name = "testGetRegion";
        LOG.info((Object)"Started testGetRegion");
        Pair pair = MetaReader.getRegion((CatalogTracker)CT, (byte[])Bytes.toBytes((String)"nonexistent-region"));
        Assert.assertNull((Object)pair);
        LOG.info((Object)"Finished testGetRegion");
    }

    @Test
    public void testScanMetaForTable() throws IOException, InterruptedException {
        TableName name = TableName.valueOf((String)"testScanMetaForTable");
        LOG.info((Object)("Started " + name));
        UTIL.createTable(name, HConstants.CATALOG_FAMILY);
        TableName greaterName = TableName.valueOf((String)"testScanMetaForTablf");
        UTIL.createTable(greaterName, HConstants.CATALOG_FAMILY);
        Assert.assertEquals((long)1L, (long)MetaReader.getTableRegions((CatalogTracker)CT, (TableName)name).size());
        Assert.assertEquals((long)1L, (long)MetaReader.getTableRegions((CatalogTracker)CT, (TableName)greaterName).size());
    }

    private static List<HRegionInfo> testGettingTableRegions(CatalogTracker ct, TableName name, int regionCount) throws IOException, InterruptedException {
        List regions = MetaReader.getTableRegions((CatalogTracker)ct, (TableName)name);
        Assert.assertEquals((long)regionCount, (long)regions.size());
        Pair pair = MetaReader.getRegion((CatalogTracker)ct, (byte[])((HRegionInfo)regions.get(0)).getRegionName());
        Assert.assertEquals((Object)((HRegionInfo)regions.get(0)).getEncodedName(), (Object)((HRegionInfo)pair.getFirst()).getEncodedName());
        return regions;
    }

    private static void testGetRegion(CatalogTracker ct, HRegionInfo region) throws IOException, InterruptedException {
        Pair pair = MetaReader.getRegion((CatalogTracker)ct, (byte[])region.getRegionName());
        Assert.assertEquals((Object)region.getEncodedName(), (Object)((HRegionInfo)pair.getFirst()).getEncodedName());
    }

    static {
        ABORTABLE = new Abortable(){
            private final AtomicBoolean abort = new AtomicBoolean(false);

            public void abort(String why, Throwable e) {
                LOG.info((Object)why, e);
                this.abort.set(true);
            }

            public boolean isAborted() {
                return this.abort.get();
            }
        };
    }

    static abstract class MetaTask
    extends Thread {
        boolean stop = false;
        int count = 0;
        Throwable t = null;
        final CatalogTracker ct;

        MetaTask(CatalogTracker ct, String name) {
            super(name);
            this.ct = ct;
        }

        @Override
        public void run() {
            try {
                while (!this.stop) {
                    LOG.info((Object)("Before " + this.getName() + ", count=" + this.count));
                    this.metaTask();
                    ++this.count;
                    LOG.info((Object)("After " + this.getName() + ", count=" + this.count));
                    Thread.sleep(100L);
                }
            }
            catch (Throwable t) {
                LOG.info((Object)(this.getName() + " failed"), t);
                this.t = t;
            }
        }

        boolean isProgressing() throws InterruptedException {
            int currentCount = this.count;
            while (currentCount == this.count) {
                if (!this.isAlive()) {
                    return false;
                }
                if (this.t != null) {
                    return false;
                }
                Thread.sleep(10L);
            }
            return true;
        }

        @Override
        public String toString() {
            return "count=" + this.count + ", t=" + (this.t == null ? "null" : this.t.toString());
        }

        abstract void metaTask() throws Throwable;
    }
}

