/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestResult
extends TestCase {
    private static final Log LOG = LogFactory.getLog((String)TestResult.class.getName());
    static final byte[] row = Bytes.toBytes((String)"row");
    static final byte[] family = Bytes.toBytes((String)"family");
    static final byte[] value = Bytes.toBytes((String)"value");

    static KeyValue[] genKVs(byte[] row, byte[] family, byte[] value, long timestamp, int cols) {
        KeyValue[] kvs = new KeyValue[cols];
        for (int i = 0; i < cols; ++i) {
            kvs[i] = new KeyValue(row, family, Bytes.toBytes((int)i), timestamp, Bytes.add((byte[])value, (byte[])Bytes.toBytes((int)i)));
        }
        return kvs;
    }

    public void testBasicGetColumn() throws Exception {
        KeyValue[] kvs = TestResult.genKVs(row, family, value, 1L, 100);
        Arrays.sort(kvs, KeyValue.COMPARATOR);
        Result r = Result.create((Cell[])kvs);
        for (int i = 0; i < 100; ++i) {
            byte[] qf = Bytes.toBytes((int)i);
            List ks = r.getColumnCells(family, qf);
            TestResult.assertEquals((int)1, (int)ks.size());
            TestResult.assertTrue((boolean)CellUtil.matchingQualifier((Cell)((Cell)ks.get(0)), (byte[])qf));
            TestResult.assertEquals(ks.get(0), (Object)r.getColumnLatestCell(family, qf));
        }
    }

    public void testMultiVersionGetColumn() throws Exception {
        KeyValue[] kvs1 = TestResult.genKVs(row, family, value, 1L, 100);
        KeyValue[] kvs2 = TestResult.genKVs(row, family, value, 200L, 100);
        KeyValue[] kvs = new KeyValue[kvs1.length + kvs2.length];
        System.arraycopy(kvs1, 0, kvs, 0, kvs1.length);
        System.arraycopy(kvs2, 0, kvs, kvs1.length, kvs2.length);
        Arrays.sort(kvs, KeyValue.COMPARATOR);
        Result r = Result.create((Cell[])kvs);
        for (int i = 0; i < 100; ++i) {
            byte[] qf = Bytes.toBytes((int)i);
            List ks = r.getColumnCells(family, qf);
            TestResult.assertEquals((int)2, (int)ks.size());
            TestResult.assertTrue((boolean)CellUtil.matchingQualifier((Cell)((Cell)ks.get(0)), (byte[])qf));
            TestResult.assertEquals((long)200L, (long)((Cell)ks.get(0)).getTimestamp());
            TestResult.assertEquals(ks.get(0), (Object)r.getColumnLatestCell(family, qf));
        }
    }

    public void testBasicGetValue() throws Exception {
        KeyValue[] kvs = TestResult.genKVs(row, family, value, 1L, 100);
        Arrays.sort(kvs, KeyValue.COMPARATOR);
        Result r = Result.create((Cell[])kvs);
        for (int i = 0; i < 100; ++i) {
            byte[] qf = Bytes.toBytes((int)i);
            HBaseTestCase.assertByteEquals(Bytes.add((byte[])value, (byte[])Bytes.toBytes((int)i)), r.getValue(family, qf));
            TestResult.assertTrue((boolean)r.containsColumn(family, qf));
        }
    }

    public void testMultiVersionGetValue() throws Exception {
        KeyValue[] kvs1 = TestResult.genKVs(row, family, value, 1L, 100);
        KeyValue[] kvs2 = TestResult.genKVs(row, family, value, 200L, 100);
        KeyValue[] kvs = new KeyValue[kvs1.length + kvs2.length];
        System.arraycopy(kvs1, 0, kvs, 0, kvs1.length);
        System.arraycopy(kvs2, 0, kvs, kvs1.length, kvs2.length);
        Arrays.sort(kvs, KeyValue.COMPARATOR);
        Result r = Result.create((Cell[])kvs);
        for (int i = 0; i < 100; ++i) {
            byte[] qf = Bytes.toBytes((int)i);
            HBaseTestCase.assertByteEquals(Bytes.add((byte[])value, (byte[])Bytes.toBytes((int)i)), r.getValue(family, qf));
            TestResult.assertTrue((boolean)r.containsColumn(family, qf));
        }
    }

    public void testBasicLoadValue() throws Exception {
        KeyValue[] kvs = TestResult.genKVs(row, family, value, 1L, 100);
        Arrays.sort(kvs, KeyValue.COMPARATOR);
        Result r = Result.create((Cell[])kvs);
        ByteBuffer loadValueBuffer = ByteBuffer.allocate(1024);
        for (int i = 0; i < 100; ++i) {
            byte[] qf = Bytes.toBytes((int)i);
            loadValueBuffer.clear();
            r.loadValue(family, qf, loadValueBuffer);
            loadValueBuffer.flip();
            TestResult.assertEquals((Object)ByteBuffer.wrap(Bytes.add((byte[])value, (byte[])Bytes.toBytes((int)i))), (Object)loadValueBuffer);
            TestResult.assertEquals((Object)ByteBuffer.wrap(Bytes.add((byte[])value, (byte[])Bytes.toBytes((int)i))), (Object)r.getValueAsByteBuffer(family, qf));
        }
    }

    public void testMultiVersionLoadValue() throws Exception {
        KeyValue[] kvs1 = TestResult.genKVs(row, family, value, 1L, 100);
        KeyValue[] kvs2 = TestResult.genKVs(row, family, value, 200L, 100);
        KeyValue[] kvs = new KeyValue[kvs1.length + kvs2.length];
        System.arraycopy(kvs1, 0, kvs, 0, kvs1.length);
        System.arraycopy(kvs2, 0, kvs, kvs1.length, kvs2.length);
        Arrays.sort(kvs, KeyValue.COMPARATOR);
        ByteBuffer loadValueBuffer = ByteBuffer.allocate(1024);
        Result r = Result.create((Cell[])kvs);
        for (int i = 0; i < 100; ++i) {
            byte[] qf = Bytes.toBytes((int)i);
            loadValueBuffer.clear();
            r.loadValue(family, qf, loadValueBuffer);
            loadValueBuffer.flip();
            TestResult.assertEquals((Object)ByteBuffer.wrap(Bytes.add((byte[])value, (byte[])Bytes.toBytes((int)i))), (Object)loadValueBuffer);
            TestResult.assertEquals((Object)ByteBuffer.wrap(Bytes.add((byte[])value, (byte[])Bytes.toBytes((int)i))), (Object)r.getValueAsByteBuffer(family, qf));
        }
    }

    public void testCompareResults() throws Exception {
        byte[] value1 = Bytes.toBytes((String)"value1");
        byte[] qual = Bytes.toBytes((String)"qual");
        KeyValue kv1 = new KeyValue(row, family, qual, value);
        KeyValue kv2 = new KeyValue(row, family, qual, value1);
        Result r1 = Result.create((Cell[])new KeyValue[]{kv1});
        Result r2 = Result.create((Cell[])new KeyValue[]{kv2});
        Result.compareResults((Result)r1, (Result)r1);
        try {
            Result.compareResults((Result)r1, (Result)r2);
            TestResult.fail();
        }
        catch (Exception x) {
            TestResult.assertTrue((boolean)x.getMessage().startsWith("This result was different:"));
        }
    }

    public void doReadBenchmark() throws Exception {
        int n = 5;
        int m = 100000000;
        StringBuilder valueSB = new StringBuilder();
        for (int i = 0; i < 100; ++i) {
            valueSB.append((byte)(Math.random() * 10.0));
        }
        StringBuilder rowSB = new StringBuilder();
        for (int i = 0; i < 50; ++i) {
            rowSB.append((byte)(Math.random() * 10.0));
        }
        KeyValue[] kvs = TestResult.genKVs(Bytes.toBytes((String)rowSB.toString()), family, Bytes.toBytes((String)valueSB.toString()), 1L, 5);
        Arrays.sort(kvs, KeyValue.COMPARATOR);
        ByteBuffer loadValueBuffer = ByteBuffer.allocate(1024);
        Result r = Result.create((Cell[])kvs);
        byte[][] qfs = new byte[5][4];
        for (int i = 0; i < 5; ++i) {
            System.arraycopy(qfs[i], 0, Bytes.toBytes((int)i), 0, 4);
        }
        for (int k = 0; k < 100000; ++k) {
            for (int i = 0; i < 5; ++i) {
                r.getValue(family, qfs[i]);
                loadValueBuffer.clear();
                r.loadValue(family, qfs[i], loadValueBuffer);
                loadValueBuffer.flip();
            }
        }
        System.gc();
        long start = System.nanoTime();
        for (int k = 0; k < 100000000; ++k) {
            for (int i = 0; i < 5; ++i) {
                loadValueBuffer.clear();
                r.loadValue(family, qfs[i], loadValueBuffer);
                loadValueBuffer.flip();
            }
        }
        long stop = System.nanoTime();
        System.out.println("loadValue(): " + (stop - start));
        System.gc();
        start = System.nanoTime();
        for (int k = 0; k < 100000000; ++k) {
            for (int i = 0; i < 5; ++i) {
                r.getValue(family, qfs[i]);
            }
        }
        stop = System.nanoTime();
        System.out.println("getValue():  " + (stop - start));
    }

    public static void main(String[] args) {
        TestResult testResult = new TestResult();
        try {
            testResult.doReadBenchmark();
        }
        catch (Exception e) {
            LOG.error((Object)"Unexpected exception", (Throwable)e);
        }
    }
}

