/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTestConst;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.ColumnPrefixFilter;
import org.apache.hadoop.hbase.filter.ColumnRangeFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.RegionStates;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestScannersFromClientSide {
    private static final Log LOG = LogFactory.getLog(TestScannersFromClientSide.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static byte[] ROW = Bytes.toBytes((String)"testRow");
    private static byte[] FAMILY = Bytes.toBytes((String)"testFamily");
    private static byte[] QUALIFIER = Bytes.toBytes((String)"testQualifier");
    private static byte[] VALUE = Bytes.toBytes((String)"testValue");

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(3);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testScanBatch() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testScanBatch");
        byte[][] QUALIFIERS = HTestConst.makeNAscii(QUALIFIER, 8);
        HTable ht = TEST_UTIL.createTable(TABLE, FAMILY);
        boolean toLog = true;
        Put put = new Put(ROW);
        for (int i = 0; i < QUALIFIERS.length; ++i) {
            KeyValue kv = new KeyValue(ROW, FAMILY, QUALIFIERS[i], (long)i, VALUE);
            put.add((Cell)kv);
        }
        ht.put(put);
        put = new Put(ROW);
        KeyValue kv = new KeyValue(ROW, FAMILY, QUALIFIERS[6], 2L, VALUE);
        put.add((Cell)kv);
        ht.put(put);
        Delete delete = new Delete(ROW);
        delete.deleteFamily(FAMILY, 3L);
        ht.delete(delete);
        Scan scan = new Scan(ROW);
        scan.setMaxVersions();
        ResultScanner scanner = ht.getScanner(scan);
        ArrayList<Object> kvListExp = new ArrayList<Cell>();
        kvListExp.add(new KeyValue(ROW, FAMILY, QUALIFIERS[4], 4L, VALUE));
        kvListExp.add(new KeyValue(ROW, FAMILY, QUALIFIERS[5], 5L, VALUE));
        kvListExp.add(new KeyValue(ROW, FAMILY, QUALIFIERS[6], 6L, VALUE));
        kvListExp.add(new KeyValue(ROW, FAMILY, QUALIFIERS[7], 7L, VALUE));
        Result result = scanner.next();
        TestScannersFromClientSide.verifyResult(result, kvListExp, toLog, "Testing first batch of scan");
        scan = new Scan(ROW);
        scan.setMaxVersions();
        scan.setBatch(2);
        scanner = ht.getScanner(scan);
        kvListExp = new ArrayList();
        kvListExp.add((Cell)new KeyValue(ROW, FAMILY, QUALIFIERS[4], 4L, VALUE));
        kvListExp.add(new KeyValue(ROW, FAMILY, QUALIFIERS[5], 5L, VALUE));
        result = scanner.next();
        TestScannersFromClientSide.verifyResult(result, kvListExp, toLog, "Testing first batch of scan");
        kvListExp = new ArrayList();
        kvListExp.add((Cell)new KeyValue(ROW, FAMILY, QUALIFIERS[6], 6L, VALUE));
        kvListExp.add(new KeyValue(ROW, FAMILY, QUALIFIERS[7], 7L, VALUE));
        result = scanner.next();
        TestScannersFromClientSide.verifyResult(result, kvListExp, toLog, "Testing second batch of scan");
    }

    @Test
    public void testGetMaxResults() throws Exception {
        KeyValue kv;
        int i;
        byte[] TABLE = Bytes.toBytes((String)"testGetMaxResults");
        byte[][] FAMILIES = HTestConst.makeNAscii(FAMILY, 3);
        byte[][] QUALIFIERS = HTestConst.makeNAscii(QUALIFIER, 20);
        HTable ht = TEST_UTIL.createTable(TABLE, FAMILIES);
        boolean toLog = true;
        ArrayList<Object> kvListExp = new ArrayList<Cell>();
        Put put = new Put(ROW);
        for (i = 0; i < 10; ++i) {
            kv = new KeyValue(ROW, FAMILIES[0], QUALIFIERS[i], 1L, VALUE);
            put.add((Cell)kv);
            kvListExp.add((Cell)kv);
        }
        ht.put(put);
        Get get = new Get(ROW);
        Result result = ht.get(get);
        TestScannersFromClientSide.verifyResult(result, kvListExp, toLog, "Testing without setting maxResults");
        get = new Get(ROW);
        get.setMaxResultsPerColumnFamily(2);
        result = ht.get(get);
        kvListExp = new ArrayList();
        kvListExp.add((Cell)new KeyValue(ROW, FAMILIES[0], QUALIFIERS[0], 1L, VALUE));
        kvListExp.add(new KeyValue(ROW, FAMILIES[0], QUALIFIERS[1], 1L, VALUE));
        TestScannersFromClientSide.verifyResult(result, kvListExp, toLog, "Testing basic setMaxResults");
        get = new Get(ROW);
        get.setMaxResultsPerColumnFamily(5);
        get.setFilter((Filter)new ColumnRangeFilter(QUALIFIERS[2], true, QUALIFIERS[5], true));
        result = ht.get(get);
        kvListExp = new ArrayList();
        kvListExp.add((Cell)new KeyValue(ROW, FAMILIES[0], QUALIFIERS[2], 1L, VALUE));
        kvListExp.add(new KeyValue(ROW, FAMILIES[0], QUALIFIERS[3], 1L, VALUE));
        kvListExp.add(new KeyValue(ROW, FAMILIES[0], QUALIFIERS[4], 1L, VALUE));
        kvListExp.add(new KeyValue(ROW, FAMILIES[0], QUALIFIERS[5], 1L, VALUE));
        TestScannersFromClientSide.verifyResult(result, kvListExp, toLog, "Testing single CF with CRF");
        put = new Put(ROW);
        for (i = 0; i < QUALIFIERS.length; ++i) {
            kv = new KeyValue(ROW, FAMILIES[2], QUALIFIERS[i], 1L, VALUE);
            put.add((Cell)kv);
        }
        ht.put(put);
        put = new Put(ROW);
        for (i = 0; i < 10; ++i) {
            kv = new KeyValue(ROW, FAMILIES[1], QUALIFIERS[i], 1L, VALUE);
            put.add((Cell)kv);
        }
        ht.put(put);
        get = new Get(ROW);
        get.setMaxResultsPerColumnFamily(12);
        get.addFamily(FAMILIES[1]);
        get.addFamily(FAMILIES[2]);
        result = ht.get(get);
        kvListExp = new ArrayList();
        for (i = 0; i < 10; ++i) {
            kvListExp.add((Cell)new KeyValue(ROW, FAMILIES[1], QUALIFIERS[i], 1L, VALUE));
        }
        for (i = 0; i < 2; ++i) {
            kvListExp.add(new KeyValue(ROW, FAMILIES[2], QUALIFIERS[i], 1L, VALUE));
        }
        for (i = 10; i < 20; ++i) {
            kvListExp.add(new KeyValue(ROW, FAMILIES[2], QUALIFIERS[i], 1L, VALUE));
        }
        TestScannersFromClientSide.verifyResult(result, kvListExp, toLog, "Testing multiple CFs");
        get = new Get(ROW);
        get.setMaxResultsPerColumnFamily(3);
        get.setFilter((Filter)new ColumnRangeFilter(QUALIFIERS[2], true, null, true));
        result = ht.get(get);
        kvListExp = new ArrayList();
        for (i = 2; i < 5; ++i) {
            kvListExp.add((Cell)new KeyValue(ROW, FAMILIES[0], QUALIFIERS[i], 1L, VALUE));
        }
        for (i = 2; i < 5; ++i) {
            kvListExp.add(new KeyValue(ROW, FAMILIES[1], QUALIFIERS[i], 1L, VALUE));
        }
        for (i = 2; i < 5; ++i) {
            kvListExp.add(new KeyValue(ROW, FAMILIES[2], QUALIFIERS[i], 1L, VALUE));
        }
        TestScannersFromClientSide.verifyResult(result, kvListExp, toLog, "Testing multiple CFs + CRF");
        get = new Get(ROW);
        get.setMaxResultsPerColumnFamily(7);
        get.setFilter((Filter)new ColumnPrefixFilter(QUALIFIERS[1]));
        result = ht.get(get);
        kvListExp = new ArrayList();
        kvListExp.add((Cell)new KeyValue(ROW, FAMILIES[0], QUALIFIERS[1], 1L, VALUE));
        kvListExp.add(new KeyValue(ROW, FAMILIES[1], QUALIFIERS[1], 1L, VALUE));
        kvListExp.add(new KeyValue(ROW, FAMILIES[2], QUALIFIERS[1], 1L, VALUE));
        for (i = 10; i < 16; ++i) {
            kvListExp.add(new KeyValue(ROW, FAMILIES[2], QUALIFIERS[i], 1L, VALUE));
        }
        TestScannersFromClientSide.verifyResult(result, kvListExp, toLog, "Testing multiple CFs + PFF");
    }

    @Test
    public void testScanMaxResults() throws Exception {
        Result result;
        byte[] TABLE = Bytes.toBytes((String)"testScanLimit");
        byte[][] ROWS = HTestConst.makeNAscii(ROW, 2);
        byte[][] FAMILIES = HTestConst.makeNAscii(FAMILY, 3);
        byte[][] QUALIFIERS = HTestConst.makeNAscii(QUALIFIER, 10);
        HTable ht = TEST_UTIL.createTable(TABLE, FAMILIES);
        boolean toLog = true;
        ArrayList<Cell> kvListExp = new ArrayList<Cell>();
        for (int r = 0; r < ROWS.length; ++r) {
            Put put = new Put(ROWS[r]);
            for (int c = 0; c < FAMILIES.length; ++c) {
                for (int q = 0; q < QUALIFIERS.length; ++q) {
                    KeyValue kv = new KeyValue(ROWS[r], FAMILIES[c], QUALIFIERS[q], 1L, VALUE);
                    put.add((Cell)kv);
                    if (q >= 4) continue;
                    kvListExp.add((Cell)kv);
                }
            }
            ht.put(put);
        }
        Scan scan = new Scan();
        scan.setMaxResultsPerColumnFamily(4);
        ResultScanner scanner = ht.getScanner(scan);
        ArrayList<Cell> kvListScan = new ArrayList<Cell>();
        while ((result = scanner.next()) != null) {
            for (Cell kv : result.listCells()) {
                kvListScan.add(kv);
            }
        }
        result = Result.create(kvListScan);
        TestScannersFromClientSide.verifyResult(result, kvListExp, toLog, "Testing scan with maxResults");
    }

    @Test
    public void testGetRowOffset() throws Exception {
        int i;
        byte[] TABLE = Bytes.toBytes((String)"testGetRowOffset");
        byte[][] FAMILIES = HTestConst.makeNAscii(FAMILY, 3);
        byte[][] QUALIFIERS = HTestConst.makeNAscii(QUALIFIER, 20);
        HTable ht = TEST_UTIL.createTable(TABLE, FAMILIES);
        boolean toLog = true;
        ArrayList<Object> kvListExp = new ArrayList<Cell>();
        Put put = new Put(ROW);
        for (i = 0; i < 10; ++i) {
            KeyValue kv = new KeyValue(ROW, FAMILIES[0], QUALIFIERS[i], 1L, VALUE);
            put.add((Cell)kv);
            if (i < 2) continue;
            kvListExp.add((Cell)kv);
        }
        ht.put(put);
        Get get = new Get(ROW);
        get.setRowOffsetPerColumnFamily(2);
        Result result = ht.get(get);
        TestScannersFromClientSide.verifyResult(result, kvListExp, toLog, "Testing basic setRowOffset");
        get = new Get(ROW);
        get.setRowOffsetPerColumnFamily(20);
        result = ht.get(get);
        kvListExp = new ArrayList();
        TestScannersFromClientSide.verifyResult(result, kvListExp, toLog, "Testing offset > #kvs");
        get = new Get(ROW);
        get.setRowOffsetPerColumnFamily(4);
        get.setMaxResultsPerColumnFamily(5);
        result = ht.get(get);
        kvListExp = new ArrayList();
        for (i = 4; i < 9; ++i) {
            kvListExp.add((Cell)new KeyValue(ROW, FAMILIES[0], QUALIFIERS[i], 1L, VALUE));
        }
        TestScannersFromClientSide.verifyResult(result, kvListExp, toLog, "Testing offset + setMaxResultsPerCF");
        get = new Get(ROW);
        get.setRowOffsetPerColumnFamily(1);
        get.setFilter((Filter)new ColumnRangeFilter(QUALIFIERS[2], true, QUALIFIERS[5], true));
        result = ht.get(get);
        kvListExp = new ArrayList();
        kvListExp.add((Cell)new KeyValue(ROW, FAMILIES[0], QUALIFIERS[3], 1L, VALUE));
        kvListExp.add(new KeyValue(ROW, FAMILIES[0], QUALIFIERS[4], 1L, VALUE));
        kvListExp.add(new KeyValue(ROW, FAMILIES[0], QUALIFIERS[5], 1L, VALUE));
        TestScannersFromClientSide.verifyResult(result, kvListExp, toLog, "Testing offset with CRF");
        for (int j = 2; j > 0; --j) {
            put = new Put(ROW);
            for (int i2 = 0; i2 < 10; ++i2) {
                KeyValue kv = new KeyValue(ROW, FAMILIES[j], QUALIFIERS[i2], 1L, VALUE);
                put.add((Cell)kv);
            }
            ht.put(put);
        }
        get = new Get(ROW);
        get.setRowOffsetPerColumnFamily(4);
        get.setMaxResultsPerColumnFamily(2);
        get.addFamily(FAMILIES[1]);
        get.addFamily(FAMILIES[2]);
        result = ht.get(get);
        kvListExp = new ArrayList();
        kvListExp.add((Cell)new KeyValue(ROW, FAMILIES[1], QUALIFIERS[4], 1L, VALUE));
        kvListExp.add(new KeyValue(ROW, FAMILIES[1], QUALIFIERS[5], 1L, VALUE));
        kvListExp.add(new KeyValue(ROW, FAMILIES[2], QUALIFIERS[4], 1L, VALUE));
        kvListExp.add(new KeyValue(ROW, FAMILIES[2], QUALIFIERS[5], 1L, VALUE));
        TestScannersFromClientSide.verifyResult(result, kvListExp, toLog, "Testing offset + multiple CFs + maxResults");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScanOnReopenedRegion() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testScanOnReopenedRegion");
        byte[][] QUALIFIERS = HTestConst.makeNAscii(QUALIFIER, 2);
        HTable ht = TEST_UTIL.createTable(TABLE, FAMILY);
        boolean toLog = false;
        Put put = new Put(ROW);
        for (int i = 0; i < QUALIFIERS.length; ++i) {
            KeyValue kv = new KeyValue(ROW, FAMILY, QUALIFIERS[i], (long)i, VALUE);
            put.add((Cell)kv);
        }
        ht.put(put);
        Scan scan = new Scan(ROW);
        ResultScanner scanner = ht.getScanner(scan);
        HRegionLocation loc = ht.getRegionLocation(ROW);
        HRegionInfo hri = loc.getRegionInfo();
        MiniHBaseCluster cluster = TEST_UTIL.getMiniHBaseCluster();
        byte[] regionName = hri.getRegionName();
        int i = cluster.getServerWith(regionName);
        HRegionServer rs = cluster.getRegionServer(i);
        ProtobufUtil.closeRegion((AdminProtos.AdminService.BlockingInterface)rs, (byte[])regionName, (boolean)false);
        long startTime = EnvironmentEdgeManager.currentTimeMillis();
        long timeOut = 300000L;
        while (rs.getOnlineRegion(regionName) != null) {
            Assert.assertTrue((String)"Timed out in closing the testing region", (EnvironmentEdgeManager.currentTimeMillis() < startTime + timeOut ? 1 : 0) != 0);
            Thread.sleep(500L);
        }
        ZooKeeperWatcher zkw = TEST_UTIL.getZooKeeperWatcher();
        try {
            HMaster master = cluster.getMaster();
            RegionStates states = master.getAssignmentManager().getRegionStates();
            states.regionOffline(hri);
            states.updateRegionState(hri, RegionState.State.OPENING);
            ZKAssign.createNodeOffline((ZooKeeperWatcher)zkw, (HRegionInfo)hri, (ServerName)loc.getServerName());
            ProtobufUtil.openRegion((AdminProtos.AdminService.BlockingInterface)rs, (HRegionInfo)hri);
            startTime = EnvironmentEdgeManager.currentTimeMillis();
            while (rs.getOnlineRegion(regionName) == null) {
                Assert.assertTrue((String)"Timed out in open the testing region", (EnvironmentEdgeManager.currentTimeMillis() < startTime + timeOut ? 1 : 0) != 0);
                Thread.sleep(500L);
            }
        }
        finally {
            ZKAssign.deleteNodeFailSilent((ZooKeeperWatcher)zkw, (HRegionInfo)hri);
        }
        ArrayList<Cell> kvListExp = new ArrayList<Cell>();
        kvListExp.add((Cell)new KeyValue(ROW, FAMILY, QUALIFIERS[0], 0L, VALUE));
        kvListExp.add((Cell)new KeyValue(ROW, FAMILY, QUALIFIERS[1], 1L, VALUE));
        Result result = scanner.next();
        TestScannersFromClientSide.verifyResult(result, kvListExp, toLog, "Testing scan on re-opened region");
    }

    static void verifyResult(Result result, List<Cell> expKvList, boolean toLog, String msg) {
        LOG.info((Object)msg);
        LOG.info((Object)("Expected count: " + expKvList.size()));
        LOG.info((Object)("Actual count: " + result.size()));
        if (expKvList.size() == 0) {
            return;
        }
        int i = 0;
        for (Cell kv : result.rawCells()) {
            if (i >= expKvList.size()) break;
            Cell kvExp = expKvList.get(i++);
            if (toLog) {
                LOG.info((Object)("get kv is: " + kv.toString()));
                LOG.info((Object)("exp kv is: " + kvExp.toString()));
            }
            Assert.assertTrue((String)"Not equal", (boolean)kvExp.equals(kv));
        }
        Assert.assertEquals((long)expKvList.size(), (long)result.size());
    }
}

