/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.constraint;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.constraint.AllPassConstraint;
import org.apache.hadoop.hbase.constraint.BaseConstraint;
import org.apache.hadoop.hbase.constraint.CheckConfigurationConstraint;
import org.apache.hadoop.hbase.constraint.Constraint;
import org.apache.hadoop.hbase.constraint.ConstraintProcessor;
import org.apache.hadoop.hbase.constraint.Constraints;
import org.apache.hadoop.hbase.constraint.TestConstraint;
import org.apache.hadoop.hbase.constraint.WorksConstraint;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestConstraints {
    @Test
    public void testSimpleReadWrite() throws Throwable {
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)"table"));
        Constraints.add((HTableDescriptor)desc, (Class[])new Class[]{WorksConstraint.class});
        List constraints = Constraints.getConstraints((HTableDescriptor)desc, (ClassLoader)this.getClass().getClassLoader());
        Assert.assertEquals((long)1L, (long)constraints.size());
        Assert.assertEquals(WorksConstraint.class, ((Constraint)constraints.get(0)).getClass());
        Constraints.add((HTableDescriptor)desc, (Class[])new Class[]{AlsoWorks.class, WorksConstraint.NameConstraint.class});
        constraints = Constraints.getConstraints((HTableDescriptor)desc, (ClassLoader)this.getClass().getClassLoader());
        Assert.assertEquals((long)3L, (long)constraints.size());
        Assert.assertEquals(WorksConstraint.class, ((Constraint)constraints.get(0)).getClass());
        Assert.assertEquals(AlsoWorks.class, ((Constraint)constraints.get(1)).getClass());
        Assert.assertEquals(WorksConstraint.NameConstraint.class, ((Constraint)constraints.get(2)).getClass());
    }

    @Test
    public void testReadWriteWithConf() throws Throwable {
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)"table"));
        Constraints.add((HTableDescriptor)desc, (Pair[])new Pair[]{new Pair(CheckConfigurationConstraint.class, (Object)CheckConfigurationConstraint.getConfiguration())});
        List c = Constraints.getConstraints((HTableDescriptor)desc, (ClassLoader)this.getClass().getClassLoader());
        Assert.assertEquals((long)1L, (long)c.size());
        Assert.assertEquals(CheckConfigurationConstraint.class, ((Constraint)c.get(0)).getClass());
        Constraints.add((HTableDescriptor)desc, (Pair[])new Pair[]{new Pair(CheckConfigurationConstraint.class, (Object)new Configuration(false))});
        try {
            Constraints.getConstraints((HTableDescriptor)desc, (ClassLoader)this.getClass().getClassLoader());
            Assert.fail((String)"No exception thrown  - configuration not overwritten");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testEnableDisableRemove() throws Exception {
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)"table"));
        Constraints.add((HTableDescriptor)desc, (Class[])new Class[]{AllPassConstraint.class});
        Assert.assertTrue((boolean)Constraints.enabled((HTableDescriptor)desc, AllPassConstraint.class));
        Assert.assertTrue((boolean)desc.hasCoprocessor(ConstraintProcessor.class.getName()));
        Constraints.disable((HTableDescriptor)desc);
        Assert.assertFalse((boolean)desc.hasCoprocessor(ConstraintProcessor.class.getName()));
        Assert.assertTrue((boolean)Constraints.enabled((HTableDescriptor)desc, AllPassConstraint.class));
        Constraints.remove((HTableDescriptor)desc, AllPassConstraint.class);
        Assert.assertFalse((boolean)Constraints.has((HTableDescriptor)desc, AllPassConstraint.class));
        Constraints.add((HTableDescriptor)desc, (Class[])new Class[]{AllPassConstraint.class});
        Constraints.remove((HTableDescriptor)desc);
        Assert.assertFalse((boolean)desc.hasCoprocessor(ConstraintProcessor.class.getName()));
        Assert.assertFalse((boolean)Constraints.has((HTableDescriptor)desc, AllPassConstraint.class));
    }

    @Test
    public void testUpdateConstraint() throws Exception {
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)"table"));
        Constraints.add((HTableDescriptor)desc, (Class[])new Class[]{CheckConfigurationConstraint.class, TestConstraint.CheckWasRunConstraint.class});
        Constraints.setConfiguration((HTableDescriptor)desc, CheckConfigurationConstraint.class, (Configuration)CheckConfigurationConstraint.getConfiguration());
        List constraints = Constraints.getConstraints((HTableDescriptor)desc, (ClassLoader)this.getClass().getClassLoader());
        Assert.assertEquals((long)2L, (long)constraints.size());
        Assert.assertEquals(CheckConfigurationConstraint.class, ((Constraint)constraints.get(0)).getClass());
        Assert.assertEquals(TestConstraint.CheckWasRunConstraint.class, ((Constraint)constraints.get(1)).getClass());
    }

    @Test
    public void testRemoveUnsetConstraint() throws Throwable {
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)"table"));
        Constraints.remove((HTableDescriptor)desc);
        Constraints.remove((HTableDescriptor)desc, AlsoWorks.class);
    }

    @Test
    public void testConfigurationPreserved() throws Throwable {
        Configuration conf = new Configuration();
        conf.setBoolean("_ENABLED", false);
        conf.setLong("_PRIORITY", 10L);
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)"table"));
        Constraints.add((HTableDescriptor)desc, AlsoWorks.class, (Configuration)conf);
        Constraints.add((HTableDescriptor)desc, (Class[])new Class[]{WorksConstraint.class});
        Assert.assertFalse((boolean)Constraints.enabled((HTableDescriptor)desc, AlsoWorks.class));
        List constraints = Constraints.getConstraints((HTableDescriptor)desc, (ClassLoader)this.getClass().getClassLoader());
        for (Constraint c : constraints) {
            Configuration storedConf = c.getConf();
            if (c instanceof AlsoWorks) {
                Assert.assertEquals((long)10L, (long)storedConf.getLong("_PRIORITY", -1L));
                continue;
            }
            Assert.assertEquals((long)2L, (long)storedConf.getLong("_PRIORITY", -1L));
        }
    }

    public static class AlsoWorks
    extends BaseConstraint {
        public void check(Put p) {
        }
    }
}

