/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.SimpleRegionObserver;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestRegionServerCoprocessorExceptionWithAbort {
    static final Log LOG = LogFactory.getLog(TestRegionServerCoprocessorExceptionWithAbort.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] ROW = Bytes.toBytes((String)"aaa");
    private static final TableName TABLE_NAME = TableName.valueOf((String)"observed_table");

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setInt(HConstants.HBASE_CLIENT_RETRIES_NUMBER, 2);
        conf.set("hbase.coprocessor.region.classes", BuggyRegionObserver.class.getName());
        conf.set("hbase.coprocessor.abortonerror", "true");
        TEST_UTIL.startMiniCluster(3);
    }

    @AfterClass
    public static void teardownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testExceptionFromCoprocessorDuringPut() throws IOException, InterruptedException {
        TableName TEST_TABLE = TABLE_NAME;
        byte[] TEST_FAMILY = Bytes.toBytes((String)"aaa");
        HTable table = TEST_UTIL.createTable(TEST_TABLE, TEST_FAMILY);
        TEST_UTIL.createMultiRegions(table, TEST_FAMILY);
        TEST_UTIL.waitUntilAllRegionsAssigned(TEST_TABLE);
        HRegionServer regionServer = TEST_UTIL.getRSForFirstRegionInTable(TEST_TABLE);
        Put put = new Put(ROW);
        put.add(TEST_FAMILY, ROW, ROW);
        Assert.assertFalse((String)"The region server should be available", (boolean)regionServer.isAborted());
        try {
            LOG.info((Object)("Running put " + put));
            table.put(put);
            Assert.fail((String)"The put should have failed, as the coprocessor is buggy");
        }
        catch (IOException ignored) {
            // empty catch block
        }
        Assert.assertTrue((String)"The region server should have aborted", (boolean)regionServer.isAborted());
        table.close();
    }

    public static class BuggyRegionObserver
    extends SimpleRegionObserver {
        @Override
        public void prePut(ObserverContext<RegionCoprocessorEnvironment> c, Put put, WALEdit edit, Durability durability) {
            TableName tableName = ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion().getRegionInfo().getTable();
            if (TABLE_NAME.equals((Object)tableName) && Bytes.equals((byte[])put.getRow(), (byte[])ROW)) {
                throw new NullPointerException("Buggy coprocessor: " + put);
            }
        }
    }
}

