/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.coprocessor.SampleRegionWALObserver;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogFactory;
import org.apache.hadoop.hbase.regionserver.wal.HLogSplitter;
import org.apache.hadoop.hbase.regionserver.wal.WALCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestWALObserver {
    private static final Log LOG = LogFactory.getLog(TestWALObserver.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static byte[] TEST_TABLE = Bytes.toBytes((String)"observedTable");
    private static byte[][] TEST_FAMILY = new byte[][]{Bytes.toBytes((String)"fam1"), Bytes.toBytes((String)"fam2"), Bytes.toBytes((String)"fam3")};
    private static byte[][] TEST_QUALIFIER = new byte[][]{Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"q2"), Bytes.toBytes((String)"q3")};
    private static byte[][] TEST_VALUE = new byte[][]{Bytes.toBytes((String)"v1"), Bytes.toBytes((String)"v2"), Bytes.toBytes((String)"v3")};
    private static byte[] TEST_ROW = Bytes.toBytes((String)"testRow");
    private Configuration conf;
    private FileSystem fs;
    private Path dir;
    private Path hbaseRootDir;
    private String logName;
    private Path oldLogDir;
    private Path logDir;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.set("hbase.coprocessor.wal.classes", SampleRegionWALObserver.class.getName());
        conf.set("hbase.coprocessor.region.classes", SampleRegionWALObserver.class.getName());
        conf.setBoolean("dfs.support.append", true);
        conf.setInt("dfs.client.block.recovery.retries", 2);
        TEST_UTIL.startMiniCluster(1);
        Path hbaseRootDir = TEST_UTIL.getDFSCluster().getFileSystem().makeQualified(new Path("/hbase"));
        LOG.info((Object)("hbase.rootdir=" + hbaseRootDir));
        FSUtils.setRootDir((Configuration)conf, (Path)hbaseRootDir);
    }

    @AfterClass
    public static void teardownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        this.conf = HBaseConfiguration.create((Configuration)TEST_UTIL.getConfiguration());
        this.fs = TEST_UTIL.getDFSCluster().getFileSystem();
        this.hbaseRootDir = FSUtils.getRootDir((Configuration)this.conf);
        this.dir = new Path(this.hbaseRootDir, TestWALObserver.class.getName());
        this.oldLogDir = new Path(this.hbaseRootDir, "oldWALs");
        this.logDir = new Path(this.hbaseRootDir, "WALs");
        this.logName = "WALs";
        if (TEST_UTIL.getDFSCluster().getFileSystem().exists(this.hbaseRootDir)) {
            TEST_UTIL.getDFSCluster().getFileSystem().delete(this.hbaseRootDir, true);
        }
    }

    @After
    public void tearDown() throws Exception {
        TEST_UTIL.getDFSCluster().getFileSystem().delete(this.hbaseRootDir, true);
    }

    @Test
    public void testWALObserverWriteToWAL() throws Exception {
        HRegionInfo hri = this.createBasic3FamilyHRegionInfo(Bytes.toString((byte[])TEST_TABLE));
        HTableDescriptor htd = this.createBasic3FamilyHTD(Bytes.toString((byte[])TEST_TABLE));
        Path basedir = new Path(this.hbaseRootDir, Bytes.toString((byte[])TEST_TABLE));
        this.deleteDir(basedir);
        this.fs.mkdirs(new Path(basedir, hri.getEncodedName()));
        HLog log = HLogFactory.createHLog((FileSystem)this.fs, (Path)this.hbaseRootDir, (String)TestWALObserver.class.getName(), (Configuration)this.conf);
        SampleRegionWALObserver cp = this.getCoprocessor(log);
        cp.setTestValues(TEST_TABLE, TEST_ROW, TEST_FAMILY[0], TEST_QUALIFIER[0], TEST_FAMILY[1], TEST_QUALIFIER[1], TEST_FAMILY[2], TEST_QUALIFIER[2]);
        Assert.assertFalse((boolean)cp.isPreWALWriteCalled());
        Assert.assertFalse((boolean)cp.isPostWALWriteCalled());
        Put p = this.creatPutWith2Families(TEST_ROW);
        NavigableMap familyMap = p.getFamilyCellMap();
        WALEdit edit = new WALEdit();
        this.addFamilyMapToWALEdit(familyMap, edit);
        boolean foundFamily0 = false;
        boolean foundFamily2 = false;
        boolean modifiedFamily1 = false;
        ArrayList kvs = edit.getKeyValues();
        for (KeyValue kv : kvs) {
            if (Arrays.equals(kv.getFamily(), TEST_FAMILY[0])) {
                foundFamily0 = true;
            }
            if (Arrays.equals(kv.getFamily(), TEST_FAMILY[2])) {
                foundFamily2 = true;
            }
            if (!Arrays.equals(kv.getFamily(), TEST_FAMILY[1]) || Arrays.equals(kv.getValue(), TEST_VALUE[1])) continue;
            modifiedFamily1 = true;
        }
        Assert.assertTrue((boolean)foundFamily0);
        Assert.assertFalse((boolean)foundFamily2);
        Assert.assertFalse((boolean)modifiedFamily1);
        long now = EnvironmentEdgeManager.currentTimeMillis();
        log.append(hri, hri.getTable(), edit, now, htd);
        foundFamily0 = false;
        foundFamily2 = false;
        modifiedFamily1 = false;
        for (KeyValue kv : kvs) {
            if (Arrays.equals(kv.getFamily(), TEST_FAMILY[0])) {
                foundFamily0 = true;
            }
            if (Arrays.equals(kv.getFamily(), TEST_FAMILY[2])) {
                foundFamily2 = true;
            }
            if (!Arrays.equals(kv.getFamily(), TEST_FAMILY[1]) || Arrays.equals(kv.getValue(), TEST_VALUE[1])) continue;
            modifiedFamily1 = true;
        }
        Assert.assertFalse((boolean)foundFamily0);
        Assert.assertTrue((boolean)foundFamily2);
        Assert.assertTrue((boolean)modifiedFamily1);
        Assert.assertTrue((boolean)cp.isPreWALWriteCalled());
        Assert.assertTrue((boolean)cp.isPostWALWriteCalled());
    }

    @Test
    public void testWALCoprocessorReplay() throws Exception {
        TableName tableName = TableName.valueOf((String)"testWALCoprocessorReplay");
        final HTableDescriptor htd = this.getBasic3FamilyHTableDescriptor(tableName);
        final HRegionInfo hri = new HRegionInfo(tableName, null, null);
        Path basedir = FSUtils.getTableDir((Path)this.hbaseRootDir, (TableName)tableName);
        this.deleteDir(basedir);
        this.fs.mkdirs(new Path(basedir, hri.getEncodedName()));
        final Configuration newConf = HBaseConfiguration.create((Configuration)this.conf);
        HLog wal = this.createWAL(this.conf);
        WALEdit edit = new WALEdit();
        long now = EnvironmentEdgeManager.currentTimeMillis();
        int countPerFamily = 1000;
        for (HColumnDescriptor hcd : htd.getFamilies()) {
            this.addWALEdits(tableName, hri, TEST_ROW, hcd.getName(), 1000, EnvironmentEdgeManager.getDelegate(), wal, htd);
        }
        wal.append(hri, tableName, edit, now, htd);
        wal.sync();
        User user = HBaseTestingUtility.getDifferentUser(newConf, ".replay.wal.secondtime");
        user.runAs(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                Path p = TestWALObserver.this.runWALSplit(newConf);
                LOG.info((Object)("WALSplit path == " + p));
                FileSystem newFS = FileSystem.get((Configuration)newConf);
                HLog wal2 = TestWALObserver.this.createWAL(newConf);
                HRegion region = HRegion.openHRegion((Configuration)newConf, (FileSystem)FileSystem.get((Configuration)newConf), (Path)TestWALObserver.this.hbaseRootDir, (HRegionInfo)hri, (HTableDescriptor)htd, (HLog)wal2, (RegionServerServices)TEST_UTIL.getHBaseCluster().getRegionServer(0), null);
                long seqid2 = region.getOpenSeqNum();
                SampleRegionWALObserver cp2 = (SampleRegionWALObserver)region.getCoprocessorHost().findCoprocessor(SampleRegionWALObserver.class.getName());
                Assert.assertNotNull((Object)((Object)cp2));
                Assert.assertTrue((boolean)cp2.isPreWALRestoreCalled());
                Assert.assertTrue((boolean)cp2.isPostWALRestoreCalled());
                region.close();
                wal2.closeAndDelete();
                return null;
            }
        });
    }

    @Test
    public void testWALObserverLoaded() throws Exception {
        HLog log = HLogFactory.createHLog((FileSystem)this.fs, (Path)this.hbaseRootDir, (String)TestWALObserver.class.getName(), (Configuration)this.conf);
        Assert.assertNotNull((Object)((Object)this.getCoprocessor(log)));
    }

    private SampleRegionWALObserver getCoprocessor(HLog wal) throws Exception {
        WALCoprocessorHost host = wal.getCoprocessorHost();
        Coprocessor c = host.findCoprocessor(SampleRegionWALObserver.class.getName());
        return (SampleRegionWALObserver)c;
    }

    private HRegionInfo createBasic3FamilyHRegionInfo(String tableName) {
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)tableName));
        for (int i = 0; i < TEST_FAMILY.length; ++i) {
            HColumnDescriptor a = new HColumnDescriptor(TEST_FAMILY[i]);
            htd.addFamily(a);
        }
        return new HRegionInfo(htd.getTableName(), null, null, false);
    }

    private void deleteDir(Path p) throws IOException {
        if (this.fs.exists(p) && !this.fs.delete(p, true)) {
            throw new IOException("Failed remove of " + p);
        }
    }

    private Put creatPutWith2Families(byte[] row) throws IOException {
        Put p = new Put(row);
        for (int i = 0; i < TEST_FAMILY.length - 1; ++i) {
            p.add(TEST_FAMILY[i], TEST_QUALIFIER[i], TEST_VALUE[i]);
        }
        return p;
    }

    private void addFamilyMapToWALEdit(Map<byte[], List<Cell>> familyMap, WALEdit walEdit) {
        for (List<Cell> edits : familyMap.values()) {
            for (Cell cell : edits) {
                walEdit.add((KeyValue)cell);
            }
        }
    }

    private Path runWALSplit(Configuration c) throws IOException {
        List splits = HLogSplitter.split((Path)this.hbaseRootDir, (Path)this.logDir, (Path)this.oldLogDir, (FileSystem)FileSystem.get((Configuration)c), (Configuration)c);
        Assert.assertEquals((long)1L, (long)splits.size());
        Assert.assertTrue((boolean)this.fs.exists((Path)splits.get(0)));
        LOG.info((Object)("Split file=" + splits.get(0)));
        return (Path)splits.get(0);
    }

    private HLog createWAL(Configuration c) throws IOException {
        return HLogFactory.createHLog((FileSystem)FileSystem.get((Configuration)c), (Path)this.hbaseRootDir, (String)this.logName, (Configuration)c);
    }

    private void addWALEdits(TableName tableName, HRegionInfo hri, byte[] rowName, byte[] family, int count, EnvironmentEdge ee, HLog wal, HTableDescriptor htd) throws IOException {
        String familyStr = Bytes.toString((byte[])family);
        for (int j = 0; j < count; ++j) {
            byte[] qualifierBytes = Bytes.toBytes((String)Integer.toString(j));
            byte[] columnBytes = Bytes.toBytes((String)(familyStr + ":" + Integer.toString(j)));
            WALEdit edit = new WALEdit();
            edit.add(new KeyValue(rowName, family, qualifierBytes, ee.currentTimeMillis(), columnBytes));
            wal.append(hri, tableName, edit, ee.currentTimeMillis(), htd);
        }
    }

    private HTableDescriptor getBasic3FamilyHTableDescriptor(TableName tableName) {
        HTableDescriptor htd = new HTableDescriptor(tableName);
        for (int i = 0; i < TEST_FAMILY.length; ++i) {
            HColumnDescriptor a = new HColumnDescriptor(TEST_FAMILY[i]);
            htd.addFamily(a);
        }
        return htd;
    }

    private HTableDescriptor createBasic3FamilyHTD(String tableName) {
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)tableName));
        HColumnDescriptor a = new HColumnDescriptor(Bytes.toBytes((String)"a"));
        htd.addFamily(a);
        HColumnDescriptor b = new HColumnDescriptor(Bytes.toBytes((String)"b"));
        htd.addFamily(b);
        HColumnDescriptor c = new HColumnDescriptor(Bytes.toBytes((String)"c"));
        htd.addFamily(c);
        return htd;
    }
}

