/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.filter.RandomRowFilter;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestRandomRowFilter {
    protected RandomRowFilter quarterChanceFilter;

    @Before
    public void setUp() throws Exception {
        this.quarterChanceFilter = new RandomRowFilter(0.25f);
    }

    @Test
    public void testBasics() throws Exception {
        int included = 0;
        int max = 1000000;
        for (int i = 0; i < max; ++i) {
            if (this.quarterChanceFilter.filterRowKey(Bytes.toBytes((String)"row"), 0, Bytes.toBytes((String)"row").length)) continue;
            ++included;
        }
        int epsilon = max / 100;
        Assert.assertTrue((String)"Roughly 25% should pass the filter", (Math.abs(included - max / 4) < epsilon ? 1 : 0) != 0);
    }

    @Test
    public void testSerialization() throws Exception {
        RandomRowFilter newFilter = this.serializationTest(this.quarterChanceFilter);
        Assert.assertTrue((String)"float should be equal", (Math.abs(newFilter.getChance() - this.quarterChanceFilter.getChance()) < 1.0E-6f ? 1 : 0) != 0);
    }

    private RandomRowFilter serializationTest(RandomRowFilter filter) throws Exception {
        byte[] buffer = filter.toByteArray();
        RandomRowFilter newFilter = RandomRowFilter.parseFrom((byte[])buffer);
        return newFilter;
    }
}

