/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.io.HalfStoreFileReader;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestHalfStoreFileReader {
    private static HBaseTestingUtility TEST_UTIL;
    static final int SIZE = 1000;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        TEST_UTIL = new HBaseTestingUtility();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.cleanupTestDir();
    }

    @Test
    public void testHalfScanAndReseek() throws IOException {
        String root_dir = TEST_UTIL.getDataTestDir().toString();
        Path p = new Path(root_dir, "test");
        Configuration conf = TEST_UTIL.getConfiguration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        CacheConfig cacheConf = new CacheConfig(conf);
        HFile.Writer w = HFile.getWriterFactory((Configuration)conf, (CacheConfig)cacheConf).withPath(fs, p).withBlockSize(1024).create();
        List<KeyValue> items = this.genSomeKeys();
        for (KeyValue kv : items) {
            w.append(kv);
        }
        w.close();
        HFile.Reader r = HFile.createReader((FileSystem)fs, (Path)p, (CacheConfig)cacheConf);
        r.loadFileInfo();
        byte[] midkey = r.midkey();
        KeyValue midKV = KeyValue.createKeyValueFromKey((byte[])midkey);
        midkey = midKV.getRow();
        Reference bottom = new Reference(midkey, Reference.Range.bottom);
        this.doTestOfScanAndReseek(p, fs, bottom, cacheConf);
        Reference top = new Reference(midkey, Reference.Range.top);
        this.doTestOfScanAndReseek(p, fs, top, cacheConf);
        r.close();
    }

    private void doTestOfScanAndReseek(Path p, FileSystem fs, Reference bottom, CacheConfig cacheConf) throws IOException {
        KeyValue curr;
        HalfStoreFileReader halfreader = new HalfStoreFileReader(fs, p, cacheConf, bottom);
        halfreader.loadFileInfo();
        HFileScanner scanner = halfreader.getScanner(false, false);
        scanner.seekTo();
        do {
            curr = scanner.getKeyValue();
            KeyValue reseekKv = this.getLastOnCol(curr);
            int ret = scanner.reseekTo(reseekKv.getKey());
            Assert.assertTrue((String)("reseek to returned: " + ret), (ret > 0 ? 1 : 0) != 0);
        } while (scanner.next());
        int ret = scanner.reseekTo(this.getLastOnCol(curr).getKey());
        Assert.assertTrue((ret > 0 ? 1 : 0) != 0);
        halfreader.close(true);
    }

    @Test
    public void testHalfScanner() throws IOException {
        String root_dir = TEST_UTIL.getDataTestDir().toString();
        Path p = new Path(root_dir, "test");
        Configuration conf = TEST_UTIL.getConfiguration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        CacheConfig cacheConf = new CacheConfig(conf);
        HFile.Writer w = HFile.getWriterFactory((Configuration)conf, (CacheConfig)cacheConf).withPath(fs, p).withBlockSize(1024).create();
        List<KeyValue> items = this.genSomeKeys();
        for (KeyValue kv : items) {
            w.append(kv);
        }
        w.close();
        HFile.Reader r = HFile.createReader((FileSystem)fs, (Path)p, (CacheConfig)cacheConf);
        r.loadFileInfo();
        byte[] midkey = r.midkey();
        KeyValue midKV = KeyValue.createKeyValueFromKey((byte[])midkey);
        midkey = midKV.getRow();
        Reference bottom = new Reference(midkey, Reference.Range.bottom);
        Reference top = new Reference(midkey, Reference.Range.top);
        KeyValue beforeMidKey = null;
        for (KeyValue item : items) {
            if (item.equals((Object)midKV)) break;
            beforeMidKey = item;
        }
        KeyValue foundKeyValue = this.doTestOfSeekBefore(p, fs, bottom, midKV, cacheConf);
        Assert.assertEquals((Object)beforeMidKey, (Object)foundKeyValue);
        foundKeyValue = this.doTestOfSeekBefore(p, fs, top, items.get(items.size() - 1), cacheConf);
        Assert.assertEquals((Object)items.get(items.size() - 2), (Object)foundKeyValue);
        foundKeyValue = this.doTestOfSeekBefore(p, fs, bottom, items.get(items.size() - 1), cacheConf);
        Assert.assertEquals((Object)beforeMidKey, (Object)foundKeyValue);
        foundKeyValue = this.doTestOfSeekBefore(p, fs, top, items.get(0), cacheConf);
        Assert.assertNull((Object)foundKeyValue);
        foundKeyValue = this.doTestOfSeekBefore(p, fs, bottom, items.get(0), cacheConf);
        Assert.assertNull((Object)foundKeyValue);
        foundKeyValue = this.doTestOfSeekBefore(p, fs, top, items.get(1), cacheConf);
        Assert.assertNull((Object)foundKeyValue);
        foundKeyValue = this.doTestOfSeekBefore(p, fs, bottom, items.get(1), cacheConf);
        Assert.assertEquals((Object)items.get(0), (Object)foundKeyValue);
        foundKeyValue = this.doTestOfSeekBefore(p, fs, top, midKV, cacheConf);
        Assert.assertNull((Object)foundKeyValue);
    }

    private KeyValue doTestOfSeekBefore(Path p, FileSystem fs, Reference bottom, KeyValue seekBefore, CacheConfig cacheConfig) throws IOException {
        HalfStoreFileReader halfreader = new HalfStoreFileReader(fs, p, cacheConfig, bottom);
        halfreader.loadFileInfo();
        HFileScanner scanner = halfreader.getScanner(false, false);
        scanner.seekBefore(seekBefore.getKey());
        return scanner.getKeyValue();
    }

    private KeyValue getLastOnCol(KeyValue curr) {
        return KeyValue.createLastOnRow((byte[])curr.getBuffer(), (int)curr.getRowOffset(), (int)curr.getRowLength(), (byte[])curr.getBuffer(), (int)curr.getFamilyOffset(), (int)curr.getFamilyLength(), (byte[])curr.getBuffer(), (int)curr.getQualifierOffset(), (int)curr.getQualifierLength());
    }

    static byte[] _b(String s) {
        return Bytes.toBytes((String)s);
    }

    List<KeyValue> genSomeKeys() {
        ArrayList<KeyValue> ret = new ArrayList<KeyValue>(1000);
        for (int i = 0; i < 1000; ++i) {
            KeyValue kv = new KeyValue(TestHalfStoreFileReader._b(String.format("row_%04d", i)), TestHalfStoreFileReader._b("family"), TestHalfStoreFileReader._b("qualifier"), 1000L, TestHalfStoreFileReader._b("value"));
            ret.add(kv);
        }
        return ret;
    }
}

