/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.io.hfile.FixedFileTrailer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={SmallTests.class})
public class TestFixedFileTrailer {
    private static final Log LOG = LogFactory.getLog(TestFixedFileTrailer.class);
    private static final int[] NUM_FIELDS_BY_VERSION = new int[]{14};
    private HBaseTestingUtility util = new HBaseTestingUtility();
    private FileSystem fs;
    private ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private int version;

    public TestFixedFileTrailer(int version) {
        this.version = version;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        ArrayList<Object[]> versionsToTest = new ArrayList<Object[]>();
        for (int v = 2; v <= 2; ++v) {
            versionsToTest.add(new Integer[]{v});
        }
        return versionsToTest;
    }

    @Before
    public void setUp() throws IOException {
        this.fs = FileSystem.get((Configuration)this.util.getConfiguration());
    }

    @Test
    public void testTrailer() throws IOException {
        FixedFileTrailer t = new FixedFileTrailer(this.version, 0);
        t.setDataIndexCount(3);
        t.setEntryCount(0x80000000L);
        t.setLastDataBlockOffset(291L);
        t.setNumDataIndexLevels(3);
        t.setComparatorClass(KeyValue.COMPARATOR.getClass());
        t.setFirstDataBlockOffset(9081723123L);
        t.setUncompressedDataIndexSize(827398717L);
        t.setLoadOnOpenOffset(128L);
        t.setMetaIndexCount(7);
        t.setTotalUncompressedBytes(129731987L);
        DataOutputStream dos = new DataOutputStream(this.baos);
        t.serialize(dos);
        dos.flush();
        Assert.assertEquals((long)dos.size(), (long)FixedFileTrailer.getTrailerSize((int)this.version));
        byte[] bytes = this.baos.toByteArray();
        this.baos.reset();
        Assert.assertEquals((long)bytes.length, (long)FixedFileTrailer.getTrailerSize((int)this.version));
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        DataInputStream dis = new DataInputStream(bais);
        FixedFileTrailer t2 = new FixedFileTrailer(this.version, 0);
        t2.deserialize(dis);
        Assert.assertEquals((long)-1L, (long)bais.read());
        this.checkLoadedTrailer(this.version, t, t2);
        Path trailerPath = new Path(this.util.getDataTestDir(), "trailer_" + this.version);
        byte[] arr$ = new byte[]{1, 3};
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            byte invalidVersion;
            bytes[bytes.length - 1] = invalidVersion = arr$[i$];
            this.writeTrailer(trailerPath, null, bytes);
            try {
                this.readTrailer(trailerPath);
                Assert.fail((String)"Exception expected");
                continue;
            }
            catch (IllegalArgumentException ex) {
                String msg = ex.getMessage();
                String cleanMsg = msg.replaceAll("^(java(\\.[a-zA-Z]+)+:\\s+)?|\\s+\\(.*\\)\\s*$", "");
                Assert.assertEquals((String)("Actual exception message is \"" + msg + "\".\n" + "Cleaned-up message"), (Object)("Invalid HFile version: " + invalidVersion), (Object)cleanMsg);
                LOG.info((Object)("Got an expected exception: " + msg));
            }
        }
        this.writeTrailer(trailerPath, t, null);
        FixedFileTrailer t4 = this.readTrailer(trailerPath);
        this.checkLoadedTrailer(this.version, t, t4);
        String trailerStr = t.toString();
        Assert.assertEquals((String)("Invalid number of fields in the string representation of the trailer: " + trailerStr), (long)NUM_FIELDS_BY_VERSION[this.version - 2], (long)trailerStr.split(", ").length);
        Assert.assertEquals((Object)trailerStr, (Object)t4.toString());
    }

    private FixedFileTrailer readTrailer(Path trailerPath) throws IOException {
        FSDataInputStream fsdis = this.fs.open(trailerPath);
        FixedFileTrailer trailerRead = FixedFileTrailer.readFromStream((FSDataInputStream)fsdis, (long)this.fs.getFileStatus(trailerPath).getLen());
        fsdis.close();
        return trailerRead;
    }

    private void writeTrailer(Path trailerPath, FixedFileTrailer t, byte[] useBytesInstead) throws IOException {
        assert (t == null != (useBytesInstead == null));
        FSDataOutputStream fsdos = this.fs.create(trailerPath);
        fsdos.write(135);
        if (useBytesInstead != null) {
            fsdos.write(useBytesInstead);
        } else {
            t.serialize((DataOutputStream)fsdos);
        }
        fsdos.close();
    }

    private void checkLoadedTrailer(int version, FixedFileTrailer expected, FixedFileTrailer loaded) throws IOException {
        Assert.assertEquals((long)version, (long)loaded.getMajorVersion());
        Assert.assertEquals((long)expected.getDataIndexCount(), (long)loaded.getDataIndexCount());
        Assert.assertEquals((long)Math.min(expected.getEntryCount(), version == 1 ? Integer.MAX_VALUE : Long.MAX_VALUE), (long)loaded.getEntryCount());
        if (version == 1) {
            Assert.assertEquals((long)expected.getFileInfoOffset(), (long)loaded.getFileInfoOffset());
        }
        if (version == 2) {
            Assert.assertEquals((long)expected.getLastDataBlockOffset(), (long)loaded.getLastDataBlockOffset());
            Assert.assertEquals((long)expected.getNumDataIndexLevels(), (long)loaded.getNumDataIndexLevels());
            Assert.assertEquals((Object)expected.createComparator().getClass().getName(), (Object)loaded.createComparator().getClass().getName());
            Assert.assertEquals((long)expected.getFirstDataBlockOffset(), (long)loaded.getFirstDataBlockOffset());
            Assert.assertTrue((boolean)(expected.createComparator() instanceof KeyValue.KVComparator));
            Assert.assertEquals((long)expected.getUncompressedDataIndexSize(), (long)loaded.getUncompressedDataIndexSize());
        }
        Assert.assertEquals((long)expected.getLoadOnOpenDataOffset(), (long)loaded.getLoadOnOpenDataOffset());
        Assert.assertEquals((long)expected.getMetaIndexCount(), (long)loaded.getMetaIndexCount());
        Assert.assertEquals((long)expected.getTotalUncompressedBytes(), (long)loaded.getTotalUncompressedBytes());
    }

    static {
        assert (NUM_FIELDS_BY_VERSION.length == 1);
    }
}

