/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultEncodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockEncodingContext;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoderImpl;
import org.apache.hadoop.hbase.io.hfile.LruBlockCache;
import org.apache.hadoop.hbase.util.ChecksumType;
import org.apache.hadoop.hbase.util.test.RedundantKVGenerator;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={SmallTests.class})
public class TestHFileDataBlockEncoder {
    private HFileDataBlockEncoderImpl blockEncoder;
    private RedundantKVGenerator generator = new RedundantKVGenerator();
    private boolean includesMemstoreTS;

    public TestHFileDataBlockEncoder(HFileDataBlockEncoderImpl blockEncoder, boolean includesMemstoreTS) {
        this.blockEncoder = blockEncoder;
        this.includesMemstoreTS = includesMemstoreTS;
        System.err.println("Encoding: " + blockEncoder.getDataBlockEncoding() + ", includesMemstoreTS: " + includesMemstoreTS);
    }

    @Test
    public void testEncodingWithCache() throws IOException {
        HFileBlock block = this.getSampleHFileBlock();
        LruBlockCache blockCache = new LruBlockCache(0x800000L, 32768L);
        HFileBlock cacheBlock = this.createBlockOnDisk(block);
        BlockCacheKey cacheKey = new BlockCacheKey("test", 0L);
        blockCache.cacheBlock(cacheKey, (Cacheable)cacheBlock);
        Cacheable heapSize = blockCache.getBlock(cacheKey, false, false);
        Assert.assertTrue((boolean)(heapSize instanceof HFileBlock));
        HFileBlock returnedBlock = (HFileBlock)heapSize;
        if (this.blockEncoder.getDataBlockEncoding() == DataBlockEncoding.NONE) {
            Assert.assertEquals((Object)block.getBufferWithHeader(), (Object)returnedBlock.getBufferWithHeader());
        } else {
            if (BlockType.ENCODED_DATA != returnedBlock.getBlockType()) {
                System.out.println(this.blockEncoder);
            }
            Assert.assertEquals((Object)BlockType.ENCODED_DATA, (Object)returnedBlock.getBlockType());
        }
    }

    @Test
    public void testHeaderSizeInCacheWithoutChecksum() throws Exception {
        int headerSize = 24;
        ByteBuffer keyValues = RedundantKVGenerator.convertKvToByteBuffer((List)this.generator.generateTestKeyValues(60), (boolean)this.includesMemstoreTS);
        int size = keyValues.limit();
        ByteBuffer buf = ByteBuffer.allocate(size + headerSize);
        buf.position(headerSize);
        keyValues.rewind();
        buf.put(keyValues);
        HFileBlock block = new HFileBlock(BlockType.DATA, size, size, -1L, buf, true, 0L, this.includesMemstoreTS, 0, 0, ChecksumType.NULL.getCode(), 0);
        HFileBlock cacheBlock = this.createBlockOnDisk(block);
        Assert.assertEquals((long)headerSize, (long)cacheBlock.getDummyHeaderForVersion().length);
    }

    private HFileBlock createBlockOnDisk(HFileBlock block) throws IOException {
        HFileBlockDefaultEncodingContext context = new HFileBlockDefaultEncodingContext(Compression.Algorithm.NONE, this.blockEncoder.getDataBlockEncoding(), HConstants.HFILEBLOCK_DUMMY_HEADER);
        context.setDummyHeader(block.getDummyHeaderForVersion());
        this.blockEncoder.beforeWriteToDisk(block.getBufferWithoutHeader(), this.includesMemstoreTS, (HFileBlockEncodingContext)context, block.getBlockType());
        byte[] encodedBytes = context.getUncompressedBytesWithHeader();
        int size = encodedBytes.length - block.getDummyHeaderForVersion().length;
        return new HFileBlock(context.getBlockType(), size, size, -1L, ByteBuffer.wrap(encodedBytes), true, 0L, this.includesMemstoreTS, block.getMinorVersion(), block.getBytesPerChecksum(), block.getChecksumType(), block.getOnDiskDataSizeWithHeader());
    }

    @Test
    public void testEncodingWritePath() throws IOException {
        HFileBlock block = this.getSampleHFileBlock();
        HFileBlock blockOnDisk = this.createBlockOnDisk(block);
        if (this.blockEncoder.getDataBlockEncoding() != DataBlockEncoding.NONE) {
            Assert.assertEquals((Object)BlockType.ENCODED_DATA, (Object)blockOnDisk.getBlockType());
            Assert.assertEquals((long)this.blockEncoder.getDataBlockEncoding().getId(), (long)blockOnDisk.getDataBlockEncodingId());
        } else {
            Assert.assertEquals((Object)BlockType.DATA, (Object)blockOnDisk.getBlockType());
        }
    }

    private HFileBlock getSampleHFileBlock() {
        ByteBuffer keyValues = RedundantKVGenerator.convertKvToByteBuffer((List)this.generator.generateTestKeyValues(60), (boolean)this.includesMemstoreTS);
        int size = keyValues.limit();
        ByteBuffer buf = ByteBuffer.allocate(size + 33);
        buf.position(33);
        keyValues.rewind();
        buf.put(keyValues);
        HFileBlock b = new HFileBlock(BlockType.DATA, size, size, -1L, buf, true, 0L, this.includesMemstoreTS, 3, 0, ChecksumType.NULL.getCode(), 0);
        return b;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getAllConfigurations() {
        ArrayList<Object[]> configurations = new ArrayList<Object[]>();
        for (DataBlockEncoding diskAlgo : DataBlockEncoding.values()) {
            for (boolean includesMemstoreTS : new boolean[]{false, true}) {
                configurations.add(new Object[]{new HFileDataBlockEncoderImpl(diskAlgo), new Boolean(includesMemstoreTS)});
            }
        }
        return configurations;
    }
}

