/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestReseekTo {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @Test
    public void testReseekTo() throws Exception {
        long start;
        String value;
        Integer key;
        int i;
        Path ncTFile = new Path(TEST_UTIL.getDataTestDir(), "basic.hfile");
        FSDataOutputStream fout = TEST_UTIL.getTestFileSystem().create(ncTFile);
        CacheConfig cacheConf = new CacheConfig(TEST_UTIL.getConfiguration());
        HFile.Writer writer = HFile.getWriterFactory((Configuration)TEST_UTIL.getConfiguration(), (CacheConfig)cacheConf).withOutputStream(fout).withBlockSize(4000).withComparator((KeyValue.KVComparator)new KeyValue.RawBytesComparator()).create();
        int numberOfKeys = 1000;
        String valueString = "Value";
        ArrayList<Integer> keyList = new ArrayList<Integer>();
        ArrayList<String> valueList = new ArrayList<String>();
        for (int key2 = 0; key2 < numberOfKeys; ++key2) {
            String value2 = valueString + key2;
            keyList.add(key2);
            valueList.add(value2);
            writer.append(Bytes.toBytes((int)key2), Bytes.toBytes((String)value2));
        }
        writer.close();
        fout.close();
        HFile.Reader reader = HFile.createReader((FileSystem)TEST_UTIL.getTestFileSystem(), (Path)ncTFile, (CacheConfig)cacheConf);
        reader.loadFileInfo();
        HFileScanner scanner = reader.getScanner(false, true);
        scanner.seekTo();
        for (i = 0; i < keyList.size(); ++i) {
            key = (Integer)keyList.get(i);
            value = (String)valueList.get(i);
            start = System.nanoTime();
            scanner.seekTo(Bytes.toBytes((int)key));
            Assert.assertEquals((Object)value, (Object)scanner.getValueString());
        }
        scanner.seekTo();
        for (i = 0; i < keyList.size(); i += 10) {
            key = (Integer)keyList.get(i);
            value = (String)valueList.get(i);
            start = System.nanoTime();
            scanner.reseekTo(Bytes.toBytes((int)key));
            Assert.assertEquals((String)("i is " + i), (Object)value, (Object)scanner.getValueString());
        }
        reader.close();
    }
}

