/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.Collection;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.LargeTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.mapreduce.LoadIncrementalHFiles;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestLoadIncrementalHFiles {
    private static final byte[] QUALIFIER = Bytes.toBytes((String)"myqual");
    private static final byte[] FAMILY = Bytes.toBytes((String)"myfam");
    static final String EXPECTED_MSG_FOR_NON_EXISTING_FAMILY = "Unmatched family names found";
    static final int MAX_FILES_PER_REGION_PER_FAMILY = 4;
    private static final byte[][] SPLIT_KEYS = new byte[][]{Bytes.toBytes((String)"ddd"), Bytes.toBytes((String)"ppp")};
    public static int BLOCKSIZE = 65536;
    public static String COMPRESSION = Compression.Algorithm.NONE.getName();
    static HBaseTestingUtility util = new HBaseTestingUtility();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        util.getConfiguration().setInt("hbase.mapreduce.bulkload.max.hfiles.perRegion.perFamily", 4);
        util.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        util.shutdownMiniCluster();
    }

    @Test
    public void testSimpleLoad() throws Exception {
        this.runTest("testSimpleLoad", BloomType.NONE, new byte[][][]{new byte[][]{Bytes.toBytes((String)"aaaa"), Bytes.toBytes((String)"cccc")}, new byte[][]{Bytes.toBytes((String)"ddd"), Bytes.toBytes((String)"ooo")}});
    }

    @Test
    public void testRegionCrossingLoad() throws Exception {
        this.runTest("testRegionCrossingLoad", BloomType.NONE, new byte[][][]{new byte[][]{Bytes.toBytes((String)"aaaa"), Bytes.toBytes((String)"eee")}, new byte[][]{Bytes.toBytes((String)"fff"), Bytes.toBytes((String)"zzz")}});
    }

    @Test
    public void testRegionCrossingRowBloom() throws Exception {
        this.runTest("testRegionCrossingLoadRowBloom", BloomType.ROW, new byte[][][]{new byte[][]{Bytes.toBytes((String)"aaaa"), Bytes.toBytes((String)"eee")}, new byte[][]{Bytes.toBytes((String)"fff"), Bytes.toBytes((String)"zzz")}});
    }

    @Test
    public void testRegionCrossingRowColBloom() throws Exception {
        this.runTest("testRegionCrossingLoadRowColBloom", BloomType.ROWCOL, new byte[][][]{new byte[][]{Bytes.toBytes((String)"aaaa"), Bytes.toBytes((String)"eee")}, new byte[][]{Bytes.toBytes((String)"fff"), Bytes.toBytes((String)"zzz")}});
    }

    private void runTest(String testName, BloomType bloomType, byte[][][] hfileRanges) throws Exception {
        Path dir = util.getDataTestDirOnTestFS(testName);
        FileSystem fs = util.getTestFileSystem();
        dir = dir.makeQualified(fs);
        Path familyDir = new Path(dir, Bytes.toString((byte[])FAMILY));
        int hfileIdx = 0;
        for (byte[][] range : hfileRanges) {
            byte[] from = range[0];
            byte[] to = range[1];
            TestLoadIncrementalHFiles.createHFile(util.getConfiguration(), fs, new Path(familyDir, "hfile_" + hfileIdx++), FAMILY, QUALIFIER, from, to, 1000);
        }
        int expectedRows = hfileIdx * 1000;
        byte[] TABLE = Bytes.toBytes((String)("mytable_" + testName));
        HBaseAdmin admin = new HBaseAdmin(util.getConfiguration());
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((byte[])TABLE));
        HColumnDescriptor familyDesc = new HColumnDescriptor(FAMILY);
        familyDesc.setBloomFilterType(bloomType);
        htd.addFamily(familyDesc);
        admin.createTable(htd, SPLIT_KEYS);
        HTable table = new HTable(util.getConfiguration(), TABLE);
        util.waitTableEnabled(TABLE);
        LoadIncrementalHFiles loader = new LoadIncrementalHFiles(util.getConfiguration());
        loader.doBulkLoad(dir, table);
        Assert.assertEquals((long)expectedRows, (long)util.countRows(table));
    }

    @Test
    public void testNonexistentColumnFamilyLoad() throws Exception {
        String testName = "testNonexistentColumnFamilyLoad";
        byte[][][] hfileRanges = new byte[][][]{new byte[][]{Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"ccc")}, new byte[][]{Bytes.toBytes((String)"ddd"), Bytes.toBytes((String)"ooo")}};
        Path dir = util.getDataTestDirOnTestFS(testName);
        FileSystem fs = util.getTestFileSystem();
        dir = dir.makeQualified(fs);
        Path familyDir = new Path(dir, Bytes.toString((byte[])FAMILY));
        int hfileIdx = 0;
        for (byte[][] range : hfileRanges) {
            byte[] from = range[0];
            byte[] to = range[1];
            TestLoadIncrementalHFiles.createHFile(util.getConfiguration(), fs, new Path(familyDir, "hfile_" + hfileIdx++), FAMILY, QUALIFIER, from, to, 1000);
        }
        byte[] TABLE = Bytes.toBytes((String)("mytable_" + testName));
        HBaseAdmin admin = new HBaseAdmin(util.getConfiguration());
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((byte[])TABLE));
        HColumnDescriptor family = new HColumnDescriptor(Bytes.toBytes((String)new String(FAMILY).toUpperCase()));
        htd.addFamily(family);
        admin.createTable(htd, SPLIT_KEYS);
        HTable table = new HTable(util.getConfiguration(), TABLE);
        util.waitTableEnabled(TABLE);
        LoadIncrementalHFiles loader = new LoadIncrementalHFiles(util.getConfiguration());
        try {
            loader.doBulkLoad(dir, table);
            Assert.assertTrue((String)"Loading into table with non-existent family should have failed", (boolean)false);
        }
        catch (Exception e) {
            Assert.assertTrue((String)"IOException expected", (boolean)(e instanceof IOException));
            String errMsg = e.getMessage();
            Assert.assertTrue((String)("Incorrect exception message, expected message: [Unmatched family names found], current message: [" + errMsg + "]"), (boolean)errMsg.contains(EXPECTED_MSG_FOR_NON_EXISTING_FAMILY));
        }
        table.close();
        admin.close();
    }

    private void verifyAssignedSequenceNumber(String testName, byte[][][] hfileRanges, boolean nonZero) throws Exception {
        Path dir = util.getDataTestDir(testName);
        FileSystem fs = util.getTestFileSystem();
        dir = dir.makeQualified(fs);
        Path familyDir = new Path(dir, Bytes.toString((byte[])FAMILY));
        int hfileIdx = 0;
        for (byte[][] range : hfileRanges) {
            byte[] from = range[0];
            byte[] to = range[1];
            TestLoadIncrementalHFiles.createHFile(util.getConfiguration(), fs, new Path(familyDir, "hfile_" + hfileIdx++), FAMILY, QUALIFIER, from, to, 1000);
        }
        byte[] TABLE = Bytes.toBytes((String)("mytable_" + testName));
        HBaseAdmin admin = new HBaseAdmin(util.getConfiguration());
        HTableDescriptor htd = new HTableDescriptor(TABLE);
        HColumnDescriptor familyDesc = new HColumnDescriptor(FAMILY);
        htd.addFamily(familyDesc);
        admin.createTable(htd, SPLIT_KEYS);
        HTable table = new HTable(util.getConfiguration(), TABLE);
        util.waitTableEnabled(TABLE);
        LoadIncrementalHFiles loader = new LoadIncrementalHFiles(util.getConfiguration());
        Put put = new Put(Bytes.toBytes((String)"row"));
        put.add(FAMILY, QUALIFIER, Bytes.toBytes((String)"value"));
        table.put(put);
        loader.doBulkLoad(dir, table);
        Collection files = util.getHBaseCluster().getRegions(TABLE).get(0).getStore(FAMILY).getStorefiles();
        for (StoreFile file : files) {
            file.createReader();
            if (nonZero) {
                Assert.assertTrue((file.getMaxSequenceId() > 0L ? 1 : 0) != 0);
                continue;
            }
            Assert.assertTrue((file.getMaxSequenceId() == -1L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSplitStoreFile() throws IOException {
        Path dir = util.getDataTestDirOnTestFS("testSplitHFile");
        FileSystem fs = util.getTestFileSystem();
        Path testIn = new Path(dir, "testhfile");
        HColumnDescriptor familyDesc = new HColumnDescriptor(FAMILY);
        TestLoadIncrementalHFiles.createHFile(util.getConfiguration(), fs, testIn, FAMILY, QUALIFIER, Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"zzz"), 1000);
        Path bottomOut = new Path(dir, "bottom.out");
        Path topOut = new Path(dir, "top.out");
        LoadIncrementalHFiles.splitStoreFile((Configuration)util.getConfiguration(), (Path)testIn, (HColumnDescriptor)familyDesc, (byte[])Bytes.toBytes((String)"ggg"), (Path)bottomOut, (Path)topOut);
        int rowCount = this.verifyHFile(bottomOut);
        Assert.assertEquals((long)1000L, (long)(rowCount += this.verifyHFile(topOut)));
    }

    private int verifyHFile(Path p) throws IOException {
        Configuration conf = util.getConfiguration();
        HFile.Reader reader = HFile.createReader((FileSystem)p.getFileSystem(conf), (Path)p, (CacheConfig)new CacheConfig(conf));
        reader.loadFileInfo();
        HFileScanner scanner = reader.getScanner(false, false);
        scanner.seekTo();
        int count = 0;
        do {
            ++count;
        } while (scanner.next());
        Assert.assertTrue((count > 0 ? 1 : 0) != 0);
        reader.close();
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void createHFile(Configuration conf, FileSystem fs, Path path, byte[] family, byte[] qualifier, byte[] startKey, byte[] endKey, int numRows) throws IOException {
        HFile.Writer writer = HFile.getWriterFactory((Configuration)conf, (CacheConfig)new CacheConfig(conf)).withPath(fs, path).withBlockSize(BLOCKSIZE).withCompression(COMPRESSION).create();
        long now = System.currentTimeMillis();
        try {
            for (byte[] key : Bytes.iterateOnSplits((byte[])startKey, (byte[])endKey, (int)(numRows - 2))) {
                KeyValue kv = new KeyValue(key, family, qualifier, now, key);
                writer.append(kv);
            }
        }
        finally {
            writer.appendFileInfo(StoreFile.BULKLOAD_TIME_KEY, Bytes.toBytes((long)System.currentTimeMillis()));
            writer.close();
        }
    }

    private void addStartEndKeysForTest(TreeMap<byte[], Integer> map, byte[] first, byte[] last) {
        Integer value = map.containsKey(first) ? map.get(first) : 0;
        map.put(first, value + 1);
        value = map.containsKey(last) ? map.get(last) : 0;
        map.put(last, value - 1);
    }

    @Test
    public void testInferBoundaries() {
        TreeMap<byte[], Integer> map = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        String first = "a";
        String last = "e";
        this.addStartEndKeysForTest(map, first.getBytes(), last.getBytes());
        first = "r";
        last = "s";
        this.addStartEndKeysForTest(map, first.getBytes(), last.getBytes());
        first = "o";
        last = "p";
        this.addStartEndKeysForTest(map, first.getBytes(), last.getBytes());
        first = "g";
        last = "k";
        this.addStartEndKeysForTest(map, first.getBytes(), last.getBytes());
        first = "v";
        last = "x";
        this.addStartEndKeysForTest(map, first.getBytes(), last.getBytes());
        first = "c";
        last = "i";
        this.addStartEndKeysForTest(map, first.getBytes(), last.getBytes());
        first = "m";
        last = "q";
        this.addStartEndKeysForTest(map, first.getBytes(), last.getBytes());
        first = "s";
        last = "t";
        this.addStartEndKeysForTest(map, first.getBytes(), last.getBytes());
        first = "u";
        last = "w";
        this.addStartEndKeysForTest(map, first.getBytes(), last.getBytes());
        byte[][] keysArray = LoadIncrementalHFiles.inferBoundaries(map);
        byte[][] compare = new byte[][]{"m".getBytes(), "r".getBytes(), "u".getBytes()};
        Assert.assertEquals((long)keysArray.length, (long)3L);
        for (int row = 0; row < keysArray.length; ++row) {
            Assert.assertArrayEquals((byte[])keysArray[row], (byte[])compare[row]);
        }
    }

    @Test
    public void testLoadTooMayHFiles() throws Exception {
        Path dir = util.getDataTestDirOnTestFS("testLoadTooMayHFiles");
        FileSystem fs = util.getTestFileSystem();
        dir = dir.makeQualified(fs);
        Path familyDir = new Path(dir, Bytes.toString((byte[])FAMILY));
        byte[] from = Bytes.toBytes((String)"begin");
        byte[] to = Bytes.toBytes((String)"end");
        for (int i = 0; i <= 4; ++i) {
            TestLoadIncrementalHFiles.createHFile(util.getConfiguration(), fs, new Path(familyDir, "hfile_" + i), FAMILY, QUALIFIER, from, to, 1000);
        }
        LoadIncrementalHFiles loader = new LoadIncrementalHFiles(util.getConfiguration());
        String[] args = new String[]{dir.toString(), "mytable_testLoadTooMayHFiles"};
        try {
            loader.run(args);
            Assert.fail((String)"Bulk loading too many files should fail");
        }
        catch (IOException ie) {
            Assert.assertTrue((boolean)ie.getMessage().contains("Trying to load more than 4 hfiles"));
        }
    }
}

