/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.Iterator;
import java.util.NavigableMap;
import org.apache.commons.logging.Log;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableInputFormat;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public abstract class TestTableMapReduceBase {
    protected static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    protected static final byte[] MULTI_REGION_TABLE_NAME = Bytes.toBytes((String)"mrtest");
    protected static final byte[] INPUT_FAMILY = Bytes.toBytes((String)"contents");
    protected static final byte[] OUTPUT_FAMILY = Bytes.toBytes((String)"text");
    protected static final byte[][] columns = new byte[][]{INPUT_FAMILY, OUTPUT_FAMILY};

    protected abstract Log getLog();

    protected abstract void runTestOnTable(HTable var1) throws IOException;

    @BeforeClass
    public static void beforeClass() throws Exception {
        UTIL.startMiniCluster();
        HTable table = UTIL.createTable(MULTI_REGION_TABLE_NAME, (byte[][])new byte[][]{INPUT_FAMILY, OUTPUT_FAMILY});
        UTIL.createMultiRegions(table, INPUT_FAMILY);
        UTIL.loadTable(table, INPUT_FAMILY);
        UTIL.startMiniMapReduceCluster();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        UTIL.shutdownMiniMapReduceCluster();
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testMultiRegionTable() throws IOException {
        this.runTestOnTable(new HTable(UTIL.getConfiguration(), MULTI_REGION_TABLE_NAME));
    }

    @Test
    public void testCombiner() throws IOException {
        Configuration conf = new Configuration(UTIL.getConfiguration());
        conf.setInt("min.num.spills.for.combine", 1);
        this.runTestOnTable(new HTable(conf, MULTI_REGION_TABLE_NAME));
    }

    protected static Put map(ImmutableBytesWritable key, Result value) throws IOException {
        if (value.size() != 1) {
            throw new IOException("There should only be one input column");
        }
        NavigableMap cf = value.getMap();
        if (!cf.containsKey(INPUT_FAMILY)) {
            throw new IOException("Wrong input columns. Missing: '" + Bytes.toString((byte[])INPUT_FAMILY) + "'.");
        }
        String originalValue = Bytes.toString((byte[])value.getValue(INPUT_FAMILY, null));
        StringBuilder newValue = new StringBuilder(originalValue);
        newValue.reverse();
        Put outval = new Put(key.get());
        outval.add(OUTPUT_FAMILY, null, Bytes.toBytes((String)newValue.toString()));
        return outval;
    }

    protected void verify(String tableName) throws IOException {
        HTable table = new HTable(UTIL.getConfiguration(), tableName);
        boolean verified = false;
        long pause = UTIL.getConfiguration().getLong("hbase.client.pause", 5000L);
        int numRetries = UTIL.getConfiguration().getInt(HConstants.HBASE_CLIENT_RETRIES_NUMBER, 5);
        for (int i = 0; i < numRetries; ++i) {
            try {
                this.getLog().info((Object)("Verification attempt #" + i));
                this.verifyAttempt(table);
                verified = true;
                break;
            }
            catch (NullPointerException e) {
                this.getLog().debug((Object)("Verification attempt failed: " + e.getMessage()));
                try {
                    Thread.sleep(pause);
                }
                catch (InterruptedException e2) {
                    // empty catch block
                }
                continue;
            }
        }
        Assert.assertTrue((boolean)verified);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyAttempt(HTable table) throws IOException, NullPointerException {
        Scan scan = new Scan();
        TableInputFormat.addColumns((Scan)scan, (byte[][])columns);
        ResultScanner scanner = table.getScanner(scan);
        try {
            Iterator itr = scanner.iterator();
            Assert.assertTrue((boolean)itr.hasNext());
            while (itr.hasNext()) {
                Result r = (Result)itr.next();
                if (this.getLog().isDebugEnabled() && r.size() > 2) {
                    throw new IOException("Too many results, expected 2 got " + r.size());
                }
                byte[] firstValue = null;
                byte[] secondValue = null;
                int count = 0;
                for (Cell kv : r.listCells()) {
                    if (count == 0) {
                        firstValue = CellUtil.cloneValue((Cell)kv);
                    }
                    if (count == 1) {
                        secondValue = CellUtil.cloneValue((Cell)kv);
                    }
                    if (++count != 2) continue;
                    break;
                }
                if (firstValue == null) {
                    throw new NullPointerException(Bytes.toString((byte[])r.getRow()) + ": first value is null");
                }
                String first = Bytes.toString(firstValue);
                if (secondValue == null) {
                    throw new NullPointerException(Bytes.toString((byte[])r.getRow()) + ": second value is null");
                }
                byte[] secondReversed = new byte[secondValue.length];
                int i = 0;
                int j = secondValue.length - 1;
                while (j >= 0) {
                    secondReversed[i] = secondValue[j];
                    --j;
                    ++i;
                }
                String second = Bytes.toString((byte[])secondReversed);
                if (first.compareTo(second) == 0) continue;
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((Object)("second key is not the reverse of first. row=" + Bytes.toStringBinary((byte[])r.getRow()) + ", first value=" + first + ", second value=" + second));
                }
                Assert.fail();
            }
        }
        finally {
            scanner.close();
        }
    }
}

