/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.LargeTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.mapreduce.TableSnapshotInputFormat;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={LargeTests.class})
public class TestTableSnapshotInputFormat {
    private static final Log LOG = LogFactory.getLog(TestTableSnapshotInputFormat.class);
    private final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final int NUM_REGION_SERVERS = 2;
    private static final String TABLE_NAME_STR = "TestTableSnapshotInputFormat";
    private static final byte[][] FAMILIES = new byte[][]{Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"f2")};
    private static final TableName TABLE_NAME = TableName.valueOf((String)"TestTableSnapshotInputFormat");
    public static byte[] bbb = Bytes.toBytes((String)"bbb");
    public static byte[] yyy = Bytes.toBytes((String)"yyy");
    private FileSystem fs;
    private Path rootDir;

    public void setupCluster() throws Exception {
        TestTableSnapshotInputFormat.setupConf(this.UTIL.getConfiguration());
        this.UTIL.startMiniCluster(2);
        this.rootDir = this.UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getRootDir();
        this.fs = this.rootDir.getFileSystem(this.UTIL.getConfiguration());
    }

    public void tearDownCluster() throws Exception {
        this.UTIL.shutdownMiniCluster();
    }

    private static void setupConf(Configuration conf) {
        conf.setBoolean("hbase.snapshot.enabled", true);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testGetBestLocations() throws IOException {
        TableSnapshotInputFormat tsif = new TableSnapshotInputFormat();
        Configuration conf = this.UTIL.getConfiguration();
        HDFSBlocksDistribution blockDistribution = new HDFSBlocksDistribution();
        Assert.assertEquals((Object)Lists.newArrayList(), (Object)tsif.getBestLocations(conf, blockDistribution));
        blockDistribution.addHostsAndBlockWeight(new String[]{"h1"}, 1L);
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"h1"}), (Object)tsif.getBestLocations(conf, blockDistribution));
        blockDistribution.addHostsAndBlockWeight(new String[]{"h1"}, 1L);
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"h1"}), (Object)tsif.getBestLocations(conf, blockDistribution));
        blockDistribution.addHostsAndBlockWeight(new String[]{"h2"}, 1L);
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"h1"}), (Object)tsif.getBestLocations(conf, blockDistribution));
        blockDistribution = new HDFSBlocksDistribution();
        blockDistribution.addHostsAndBlockWeight(new String[]{"h1"}, 10L);
        blockDistribution.addHostsAndBlockWeight(new String[]{"h2"}, 7L);
        blockDistribution.addHostsAndBlockWeight(new String[]{"h3"}, 5L);
        blockDistribution.addHostsAndBlockWeight(new String[]{"h4"}, 1L);
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"h1"}), (Object)tsif.getBestLocations(conf, blockDistribution));
        blockDistribution.addHostsAndBlockWeight(new String[]{"h2"}, 2L);
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"h1", "h2"}), (Object)tsif.getBestLocations(conf, blockDistribution));
        blockDistribution.addHostsAndBlockWeight(new String[]{"h2"}, 3L);
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"h2", "h1"}), (Object)tsif.getBestLocations(conf, blockDistribution));
        blockDistribution.addHostsAndBlockWeight(new String[]{"h3"}, 6L);
        blockDistribution.addHostsAndBlockWeight(new String[]{"h4"}, 9L);
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"h2", "h3", "h4", "h1"}), (Object)tsif.getBestLocations(conf, blockDistribution));
    }

    public static void createTableAndSnapshot(HBaseTestingUtility util, TableName tableName, String snapshotName, int numRegions) throws Exception {
        try {
            util.deleteTable(tableName);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (numRegions > 1) {
            util.createTable(tableName, FAMILIES, 1, bbb, yyy, numRegions);
        } else {
            util.createTable(tableName, FAMILIES);
        }
        HBaseAdmin admin = util.getHBaseAdmin();
        HTable table = new HTable(util.getConfiguration(), tableName);
        util.loadTable(table, FAMILIES);
        Path rootDir = new Path(util.getConfiguration().get("hbase.rootdir"));
        FileSystem fs = rootDir.getFileSystem(util.getConfiguration());
        SnapshotTestingUtils.createSnapshotAndValidate(admin, tableName, Arrays.asList(FAMILIES), null, snapshotName, rootDir, fs, true);
        byte[] value = Bytes.toBytes((String)"after_snapshot_value");
        util.loadTable(table, FAMILIES, value);
        admin.flush(tableName.toString());
        table.close();
    }

    @Test
    public void testWithMockedMapReduceSingleRegion() throws Exception {
        this.testWithMockedMapReduce(this.UTIL, "testWithMockedMapReduceSingleRegion", 1, 1);
    }

    @Test
    public void testWithMockedMapReduceMultiRegion() throws Exception {
        this.testWithMockedMapReduce(this.UTIL, "testWithMockedMapReduceMultiRegion", 10, 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWithMockedMapReduce(HBaseTestingUtility util, String snapshotName, int numRegions, int expectedNumSplits) throws Exception {
        this.setupCluster();
        TableName tableName = TableName.valueOf((String)"testWithMockedMapReduce");
        try {
            TestTableSnapshotInputFormat.createTableAndSnapshot(util, tableName, snapshotName, numRegions);
            Job job = new Job(util.getConfiguration());
            Path tmpTableDir = util.getDataTestDirOnTestFS(snapshotName);
            Scan scan = new Scan(bbb, yyy);
            TableMapReduceUtil.initTableSnapshotMapperJob((String)snapshotName, (Scan)scan, TestTableSnapshotMapper.class, ImmutableBytesWritable.class, NullWritable.class, (Job)job, (boolean)false, (Path)tmpTableDir);
            this.verifyWithMockedMapReduce(job, numRegions, expectedNumSplits, bbb, yyy);
        }
        finally {
            util.getHBaseAdmin().deleteSnapshot(snapshotName);
            util.deleteTable(tableName);
            this.tearDownCluster();
        }
    }

    private void verifyWithMockedMapReduce(Job job, int numRegions, int expectedNumSplits, byte[] startRow, byte[] stopRow) throws IOException, InterruptedException {
        TableSnapshotInputFormat tsif = new TableSnapshotInputFormat();
        List splits = tsif.getSplits((JobContext)job);
        Assert.assertEquals((long)expectedNumSplits, (long)splits.size());
        HBaseTestingUtility.SeenRowTracker rowTracker = new HBaseTestingUtility.SeenRowTracker(startRow, stopRow);
        for (int i = 0; i < splits.size(); ++i) {
            InputSplit split = (InputSplit)splits.get(i);
            Assert.assertTrue((boolean)(split instanceof TableSnapshotInputFormat.TableSnapshotRegionSplit));
            TaskAttemptContext taskAttemptContext = (TaskAttemptContext)Mockito.mock(TaskAttemptContext.class);
            Mockito.when((Object)taskAttemptContext.getConfiguration()).thenReturn((Object)job.getConfiguration());
            RecordReader rr = tsif.createRecordReader(split, taskAttemptContext);
            rr.initialize(split, taskAttemptContext);
            while (rr.nextKeyValue()) {
                byte[] row = ((ImmutableBytesWritable)rr.getCurrentKey()).get();
                TestTableSnapshotInputFormat.verifyRowFromMap((ImmutableBytesWritable)rr.getCurrentKey(), (Result)rr.getCurrentValue());
                rowTracker.addRow(row);
            }
            rr.close();
        }
        rowTracker.validate();
    }

    public static void verifyRowFromMap(ImmutableBytesWritable key, Result result) throws IOException {
        byte[] row = key.get();
        CellScanner scanner = result.cellScanner();
        while (scanner.advance()) {
            Cell cell = scanner.current();
            Assert.assertEquals((long)0L, (long)Bytes.compareTo((byte[])row, (int)0, (int)row.length, (byte[])cell.getRowArray(), (int)cell.getRowOffset(), (int)cell.getRowLength()));
        }
        for (int j = 0; j < FAMILIES.length; ++j) {
            byte[] actual = result.getValue(FAMILIES[j], null);
            Assert.assertArrayEquals((String)("Row in snapshot does not match, expected:" + Bytes.toString((byte[])row) + " ,actual:" + Bytes.toString((byte[])actual)), (byte[])row, (byte[])actual);
        }
    }

    @Test
    public void testWithMapReduceSingleRegion() throws Exception {
        this.testWithMapReduce(this.UTIL, "testWithMapReduceSingleRegion", 1, 1, false);
    }

    @Test
    public void testWithMapReduceMultiRegion() throws Exception {
        this.testWithMapReduce(this.UTIL, "testWithMapReduceMultiRegion", 10, 8, false);
    }

    @Test
    public void testWithMapReduceAndOfflineHBaseMultiRegion() throws Exception {
        this.testWithMapReduce(this.UTIL, "testWithMapReduceAndOfflineHBaseMultiRegion", 10, 8, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testWithMapReduce(HBaseTestingUtility util, String snapshotName, int numRegions, int expectedNumSplits, boolean shutdownCluster) throws Exception {
        this.setupCluster();
        util.startMiniMapReduceCluster();
        try {
            Path tableDir = util.getDataTestDirOnTestFS(snapshotName);
            TableName tableName = TableName.valueOf((String)"testWithMapReduce");
            TestTableSnapshotInputFormat.doTestWithMapReduce(util, tableName, snapshotName, tableDir, numRegions, expectedNumSplits, shutdownCluster);
        }
        finally {
            util.shutdownMiniMapReduceCluster();
            this.tearDownCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doTestWithMapReduce(HBaseTestingUtility util, TableName tableName, String snapshotName, Path tableDir, int numRegions, int expectedNumSplits, boolean shutdownCluster) throws Exception {
        TestTableSnapshotInputFormat.createTableAndSnapshot(util, tableName, snapshotName, numRegions);
        if (shutdownCluster) {
            util.shutdownMiniHBaseCluster();
        }
        try {
            Job job = new Job(util.getConfiguration());
            Scan scan = new Scan(bbb, yyy);
            job.setJarByClass(((Object)((Object)util)).getClass());
            TableMapReduceUtil.addDependencyJars((Configuration)job.getConfiguration(), (Class[])new Class[]{TestTableSnapshotInputFormat.class});
            TableMapReduceUtil.initTableSnapshotMapperJob((String)snapshotName, (Scan)scan, TestTableSnapshotMapper.class, ImmutableBytesWritable.class, NullWritable.class, (Job)job, (boolean)true, (Path)tableDir);
            job.setReducerClass(TestTableSnapshotReducer.class);
            job.setNumReduceTasks(1);
            job.setOutputFormatClass(NullOutputFormat.class);
            Assert.assertTrue((boolean)job.waitForCompletion(true));
        }
        finally {
            if (!shutdownCluster) {
                util.getHBaseAdmin().deleteSnapshot(snapshotName);
                util.deleteTable(tableName);
            }
        }
    }

    public static class TestTableSnapshotReducer
    extends Reducer<ImmutableBytesWritable, NullWritable, NullWritable, NullWritable> {
        HBaseTestingUtility.SeenRowTracker rowTracker = new HBaseTestingUtility.SeenRowTracker(bbb, yyy);

        protected void reduce(ImmutableBytesWritable key, Iterable<NullWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            this.rowTracker.addRow(key.get());
        }

        protected void cleanup(Reducer.Context context) throws IOException, InterruptedException {
            this.rowTracker.validate();
        }
    }

    public static class TestTableSnapshotMapper
    extends TableMapper<ImmutableBytesWritable, NullWritable> {
        protected void map(ImmutableBytesWritable key, Result value, Mapper.Context context) throws IOException, InterruptedException {
            TestTableSnapshotInputFormat.verifyRowFromMap(key, value);
            context.write((Object)key, (Object)NullWritable.get());
        }
    }

    public static enum TestTableSnapshotCounters {
        VALIDATION_ERROR;

    }
}

