/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoder;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoderImpl;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.regionserver.CompactSplitThread;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.StatefulStoreMockMaker;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionContext;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionProgress;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.regionserver.compactions.Compactor;
import org.apache.hadoop.hbase.regionserver.compactions.RatioBasedCompactionPolicy;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@Category(value={MediumTests.class})
public class TestCompaction {
    @Rule
    public TestName name = new TestName();
    static final Log LOG = LogFactory.getLog((String)TestCompaction.class.getName());
    private static final HBaseTestingUtility UTIL;
    protected Configuration conf = UTIL.getConfiguration();
    private HRegion r = null;
    private HTableDescriptor htd = null;
    private Path compactionDir = null;
    private Path regionCompactionDir = null;
    private static final byte[] COLUMN_FAMILY;
    private final byte[] STARTROW = Bytes.toBytes((String)HBaseTestingUtility.START_KEY);
    private static final byte[] COLUMN_FAMILY_TEXT;
    private int compactionThreshold;
    private byte[] firstRowBytes;
    private byte[] secondRowBytes;
    private byte[] thirdRowBytes;
    private final byte[] col1;
    private final byte[] col2;
    private static final long MAX_FILES_TO_COMPACT = 10L;

    public TestCompaction() {
        this.conf.setInt("hbase.hregion.memstore.flush.size", 0x100000);
        this.conf.setInt("hbase.hregion.memstore.block.multiplier", 100);
        this.compactionThreshold = this.conf.getInt("hbase.hstore.compactionThreshold", 3);
        this.firstRowBytes = HBaseTestingUtility.START_KEY_BYTES;
        this.secondRowBytes = (byte[])HBaseTestingUtility.START_KEY_BYTES.clone();
        int n = HBaseTestingUtility.START_KEY_BYTES.length - 1;
        this.secondRowBytes[n] = (byte)(this.secondRowBytes[n] + 1);
        this.thirdRowBytes = (byte[])HBaseTestingUtility.START_KEY_BYTES.clone();
        int n2 = HBaseTestingUtility.START_KEY_BYTES.length - 1;
        this.thirdRowBytes[n2] = (byte)(this.thirdRowBytes[n2] + 2);
        this.col1 = Bytes.toBytes((String)"column1");
        this.col2 = Bytes.toBytes((String)"column2");
    }

    @Before
    public void setUp() throws Exception {
        this.htd = UTIL.createTableDescriptor(this.name.getMethodName());
        this.r = UTIL.createLocalHRegion(this.htd, null, null);
    }

    @After
    public void tearDown() throws Exception {
        HLog hlog = this.r.getLog();
        this.r.close();
        hlog.closeAndDelete();
    }

    @Test
    public void testMajorCompactingToNoOutput() throws IOException {
        ArrayList results;
        boolean result;
        boolean result2;
        this.createStoreFile(this.r);
        for (int i = 0; i < this.compactionThreshold; ++i) {
            this.createStoreFile(this.r);
        }
        RegionScanner s = this.r.getScanner(new Scan());
        do {
            ArrayList results2 = new ArrayList();
            result2 = s.next(results2);
            this.r.delete(new Delete(CellUtil.cloneRow((Cell)((Cell)results2.get(0)))));
        } while (result2);
        s.close();
        this.r.flushcache();
        this.r.compactStores(true);
        s = this.r.getScanner(new Scan());
        int counter = 0;
        while (result = s.next(results = new ArrayList())) {
            ++counter;
        }
        Assert.assertEquals((long)0L, (long)counter);
    }

    @Test
    public void testMajorCompaction() throws Exception {
        this.majorCompaction();
    }

    @Test
    public void testDataBlockEncodingInCacheOnly() throws Exception {
        this.majorCompactionWithDataBlockEncoding(true);
    }

    @Test
    public void testDataBlockEncodingEverywhere() throws Exception {
        this.majorCompactionWithDataBlockEncoding(false);
    }

    public void majorCompactionWithDataBlockEncoding(boolean inCacheOnly) throws Exception {
        HashMap<HStore, HFileDataBlockEncoder> replaceBlockCache = new HashMap<HStore, HFileDataBlockEncoder>();
        for (Map.Entry pair : this.r.getStores().entrySet()) {
            HStore store = (HStore)pair.getValue();
            HFileDataBlockEncoder blockEncoder = store.getDataBlockEncoder();
            replaceBlockCache.put(store, blockEncoder);
            DataBlockEncoding inCache = DataBlockEncoding.PREFIX;
            DataBlockEncoding onDisk = inCacheOnly ? DataBlockEncoding.NONE : inCache;
            store.setDataBlockEncoderInTest((HFileDataBlockEncoder)new HFileDataBlockEncoderImpl(onDisk));
        }
        this.majorCompaction();
        for (Map.Entry entry : replaceBlockCache.entrySet()) {
            ((HStore)entry.getKey()).setDataBlockEncoderInTest((HFileDataBlockEncoder)entry.getValue());
        }
    }

    private void majorCompaction() throws Exception {
        this.createStoreFile(this.r);
        for (int i = 0; i < this.compactionThreshold; ++i) {
            this.createStoreFile(this.r);
        }
        HBaseTestCase.addContent(new HBaseTestCase.HRegionIncommon(this.r), Bytes.toString((byte[])COLUMN_FAMILY));
        Result result = this.r.get(new Get(this.STARTROW).addFamily(COLUMN_FAMILY_TEXT).setMaxVersions(100));
        Assert.assertEquals((long)this.compactionThreshold, (long)result.size());
        for (Store store : this.r.stores.values()) {
            Assert.assertNull((Object)store.getCompactionProgress());
        }
        this.r.flushcache();
        this.r.compactStores(true);
        int storeCount = 0;
        for (Store store : this.r.stores.values()) {
            CompactionProgress progress = store.getCompactionProgress();
            if (progress != null) {
                ++storeCount;
                Assert.assertTrue((progress.currentCompactedKVs > 0L ? 1 : 0) != 0);
                Assert.assertTrue((progress.totalCompactingKVs > 0L ? 1 : 0) != 0);
            }
            Assert.assertTrue((storeCount > 0 ? 1 : 0) != 0);
        }
        byte[] secondRowBytes = (byte[])HBaseTestingUtility.START_KEY_BYTES.clone();
        int n = HBaseTestingUtility.START_KEY_BYTES.length - 1;
        secondRowBytes[n] = (byte)(secondRowBytes[n] + 1);
        result = this.r.get(new Get(secondRowBytes).addFamily(COLUMN_FAMILY_TEXT).setMaxVersions(100));
        LOG.debug((Object)("Row " + Bytes.toStringBinary((byte[])secondRowBytes) + " after " + "initial compaction: " + result));
        Assert.assertEquals((String)("Invalid number of versions of row " + Bytes.toStringBinary((byte[])secondRowBytes) + "."), (long)this.compactionThreshold, (long)result.size());
        LOG.debug((Object)"Adding deletes to memstore and flushing");
        Delete delete = new Delete(secondRowBytes, System.currentTimeMillis());
        byte[][] famAndQf = new byte[][]{COLUMN_FAMILY, null};
        delete.deleteFamily(famAndQf[0]);
        this.r.delete(delete);
        result = this.r.get(new Get(secondRowBytes).addFamily(COLUMN_FAMILY_TEXT).setMaxVersions(100));
        Assert.assertTrue((String)"Second row should have been deleted", (boolean)result.isEmpty());
        this.r.flushcache();
        result = this.r.get(new Get(secondRowBytes).addFamily(COLUMN_FAMILY_TEXT).setMaxVersions(100));
        Assert.assertTrue((String)"Second row should have been deleted", (boolean)result.isEmpty());
        this.createSmallerStoreFile(this.r);
        this.r.flushcache();
        result = this.r.get(new Get(secondRowBytes).addFamily(COLUMN_FAMILY_TEXT).setMaxVersions(100));
        Assert.assertTrue((String)"Second row should still be deleted", (boolean)result.isEmpty());
        this.r.compactStores(true);
        Assert.assertEquals((long)this.r.getStore(COLUMN_FAMILY_TEXT).getStorefiles().size(), (long)1L);
        result = this.r.get(new Get(secondRowBytes).addFamily(COLUMN_FAMILY_TEXT).setMaxVersions(100));
        Assert.assertTrue((String)"Second row should still be deleted", (boolean)result.isEmpty());
        this.verifyCounts(3, 0);
        int ttl = 1000;
        for (Store hstore : this.r.stores.values()) {
            HStore store = (HStore)hstore;
            ScanInfo old = store.getScanInfo();
            ScanInfo si = new ScanInfo(old.getFamily(), old.getMinVersions(), old.getMaxVersions(), 1000L, old.getKeepDeletedCells(), 0L, old.getComparator());
            store.setScanInfo(si);
        }
        Thread.sleep(1000L);
        this.r.compactStores(true);
        int count = this.count();
        Assert.assertEquals((String)"Should not see anything after TTL has expired", (long)0L, (long)count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimeBasedMajorCompaction() throws Exception {
        int delay = 10000;
        float jitterPct = 0.2f;
        this.conf.setLong("hbase.hregion.majorcompaction", (long)delay);
        this.conf.setFloat("hbase.hregion.majorcompaction.jitter", jitterPct);
        HStore s = (HStore)this.r.getStore(COLUMN_FAMILY);
        s.storeEngine.getCompactionPolicy().setConf(this.conf);
        try {
            this.createStoreFile(this.r);
            this.createStoreFile(this.r);
            this.r.compactStores(true);
            this.createStoreFile(this.r);
            this.r.compactStores(false);
            Assert.assertEquals((long)2L, (long)s.getStorefilesCount());
            RatioBasedCompactionPolicy c = (RatioBasedCompactionPolicy)s.storeEngine.getCompactionPolicy();
            Collection storeFiles = s.getStorefiles();
            long mcTime = c.getNextMajorCompactTime(storeFiles);
            for (int i = 0; i < 10; ++i) {
                Assert.assertEquals((long)mcTime, (long)c.getNextMajorCompactTime(storeFiles));
            }
            long jitter = Math.round((float)delay * jitterPct);
            Assert.assertTrue(((long)delay - jitter <= mcTime && mcTime <= (long)delay + jitter ? 1 : 0) != 0);
            Thread.sleep(mcTime);
            this.r.compactStores(false);
            Assert.assertEquals((long)1L, (long)s.getStorefilesCount());
        }
        finally {
            this.conf.setLong("hbase.hregion.majorcompaction", 86400000L);
            this.conf.setFloat("hbase.hregion.majorcompaction.jitter", 0.2f);
            this.createStoreFile(this.r);
            this.r.compactStores(true);
            Assert.assertEquals((long)1L, (long)s.getStorefilesCount());
        }
    }

    @Test
    public void testMinorCompactionWithDeleteRow() throws Exception {
        Delete deleteRow = new Delete(this.secondRowBytes);
        this.testMinorCompactionWithDelete(deleteRow);
    }

    @Test
    public void testMinorCompactionWithDeleteColumn1() throws Exception {
        Delete dc = new Delete(this.secondRowBytes);
        dc.deleteColumns(HBaseTestingUtility.fam2, this.col2);
        this.testMinorCompactionWithDelete(dc);
    }

    @Test
    public void testMinorCompactionWithDeleteColumn2() throws Exception {
        Delete dc = new Delete(this.secondRowBytes);
        dc.deleteColumn(HBaseTestingUtility.fam2, this.col2);
        this.testMinorCompactionWithDelete(dc, 3);
    }

    @Test
    public void testMinorCompactionWithDeleteColumnFamily() throws Exception {
        Delete deleteCF = new Delete(this.secondRowBytes);
        deleteCF.deleteFamily(HBaseTestingUtility.fam2);
        this.testMinorCompactionWithDelete(deleteCF);
    }

    @Test
    public void testMinorCompactionWithDeleteVersion1() throws Exception {
        Delete deleteVersion = new Delete(this.secondRowBytes);
        deleteVersion.deleteColumns(HBaseTestingUtility.fam2, this.col2, 2L);
        this.testMinorCompactionWithDelete(deleteVersion, 1);
    }

    @Test
    public void testMinorCompactionWithDeleteVersion2() throws Exception {
        Delete deleteVersion = new Delete(this.secondRowBytes);
        deleteVersion.deleteColumn(HBaseTestingUtility.fam2, this.col2, 1L);
        this.testMinorCompactionWithDelete(deleteVersion, 3);
    }

    private void testMinorCompactionWithDelete(Delete delete) throws Exception {
        this.testMinorCompactionWithDelete(delete, 0);
    }

    private void testMinorCompactionWithDelete(Delete delete, int expectedResultsAfterDelete) throws Exception {
        HBaseTestCase.HRegionIncommon loader = new HBaseTestCase.HRegionIncommon(this.r);
        for (int i = 0; i < this.compactionThreshold + 1; ++i) {
            HBaseTestCase.addContent(loader, Bytes.toString((byte[])HBaseTestingUtility.fam1), Bytes.toString((byte[])this.col1), this.firstRowBytes, this.thirdRowBytes, i);
            HBaseTestCase.addContent(loader, Bytes.toString((byte[])HBaseTestingUtility.fam1), Bytes.toString((byte[])this.col2), this.firstRowBytes, this.thirdRowBytes, i);
            HBaseTestCase.addContent(loader, Bytes.toString((byte[])HBaseTestingUtility.fam2), Bytes.toString((byte[])this.col1), this.firstRowBytes, this.thirdRowBytes, i);
            HBaseTestCase.addContent(loader, Bytes.toString((byte[])HBaseTestingUtility.fam2), Bytes.toString((byte[])this.col2), this.firstRowBytes, this.thirdRowBytes, i);
            this.r.flushcache();
        }
        Result result = this.r.get(new Get(this.firstRowBytes).addColumn(HBaseTestingUtility.fam1, this.col1).setMaxVersions(100));
        Assert.assertEquals((long)this.compactionThreshold, (long)result.size());
        result = this.r.get(new Get(this.secondRowBytes).addColumn(HBaseTestingUtility.fam2, this.col2).setMaxVersions(100));
        Assert.assertEquals((long)this.compactionThreshold, (long)result.size());
        this.r.delete(delete);
        result = this.r.get(new Get(this.secondRowBytes).addColumn(HBaseTestingUtility.fam2, this.col2).setMaxVersions(100));
        Assert.assertEquals((long)expectedResultsAfterDelete, (long)result.size());
        result = this.r.get(new Get(this.firstRowBytes).addColumn(HBaseTestingUtility.fam1, this.col1).setMaxVersions(100));
        Assert.assertEquals((long)this.compactionThreshold, (long)result.size());
        this.r.flushcache();
        result = this.r.get(new Get(this.secondRowBytes).addColumn(HBaseTestingUtility.fam2, this.col2).setMaxVersions(100));
        Assert.assertEquals((long)expectedResultsAfterDelete, (long)result.size());
        result = this.r.get(new Get(this.firstRowBytes).addColumn(HBaseTestingUtility.fam1, this.col1).setMaxVersions(100));
        Assert.assertEquals((long)this.compactionThreshold, (long)result.size());
        Store store2 = (Store)this.r.stores.get(HBaseTestingUtility.fam2);
        int numFiles1 = store2.getStorefiles().size();
        Assert.assertTrue((String)"Was expecting to see 4 store files", (numFiles1 > this.compactionThreshold ? 1 : 0) != 0);
        ((HStore)store2).compactRecentForTestingAssumingDefaultPolicy(this.compactionThreshold);
        int numFiles2 = store2.getStorefiles().size();
        Assert.assertTrue((String)"Number of store files should go down", (numFiles1 > numFiles2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Was not supposed to be a major compaction", (numFiles2 > 1 ? 1 : 0) != 0);
        result = this.r.get(new Get(this.secondRowBytes).addColumn(HBaseTestingUtility.fam2, this.col2).setMaxVersions(100));
        Assert.assertEquals((long)expectedResultsAfterDelete, (long)result.size());
        result = this.r.get(new Get(this.firstRowBytes).addColumn(HBaseTestingUtility.fam1, this.col1).setMaxVersions(100));
        Assert.assertEquals((long)this.compactionThreshold, (long)result.size());
    }

    private void verifyCounts(int countRow1, int countRow2) throws Exception {
        int count1 = 0;
        int count2 = 0;
        for (StoreFile f : ((Store)this.r.stores.get(COLUMN_FAMILY_TEXT)).getStorefiles()) {
            HFileScanner scanner = f.getReader().getScanner(false, false);
            scanner.seekTo();
            do {
                byte[] row;
                if (Bytes.equals((byte[])(row = scanner.getKeyValue().getRow()), (byte[])this.STARTROW)) {
                    ++count1;
                    continue;
                }
                if (!Bytes.equals((byte[])row, (byte[])this.secondRowBytes)) continue;
                ++count2;
            } while (scanner.next());
        }
        Assert.assertEquals((long)countRow1, (long)count1);
        Assert.assertEquals((long)countRow2, (long)count2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInterruptCompaction() throws Exception {
        Assert.assertEquals((long)0L, (long)this.count());
        int origWI = HStore.closeCheckInterval;
        HStore.closeCheckInterval = 10000;
        try {
            int jmax = (int)Math.ceil(15.0 / (double)this.compactionThreshold);
            byte[] pad = new byte[1000];
            for (int i = 0; i < this.compactionThreshold; ++i) {
                HBaseTestCase.HRegionIncommon loader = new HBaseTestCase.HRegionIncommon(this.r);
                Put p = new Put(Bytes.add((byte[])this.STARTROW, (byte[])Bytes.toBytes((int)i)));
                p.setDurability(Durability.SKIP_WAL);
                for (int j = 0; j < jmax; ++j) {
                    p.add(COLUMN_FAMILY, Bytes.toBytes((int)j), pad);
                }
                HBaseTestCase.addContent(loader, Bytes.toString((byte[])COLUMN_FAMILY));
                loader.put(p);
                loader.flushcache();
            }
            HRegion spyR = (HRegion)Mockito.spy((Object)this.r);
            ((HRegion)Mockito.doAnswer((Answer)new Answer(){

                public Object answer(InvocationOnMock invocation) throws Throwable {
                    ((TestCompaction)TestCompaction.this).r.writestate.writesEnabled = false;
                    return invocation.callRealMethod();
                }
            }).when((Object)spyR)).doRegionCompactionPrep();
            spyR.compactStores();
            Store s = (Store)this.r.stores.get(COLUMN_FAMILY);
            Assert.assertEquals((long)this.compactionThreshold, (long)s.getStorefilesCount());
            Assert.assertTrue((s.getStorefilesSize() > 15000L ? 1 : 0) != 0);
            FileStatus[] ls = this.r.getFilesystem().listStatus(this.r.getRegionFileSystem().getTempDir());
            Assert.assertEquals((long)0L, (long)ls.length);
            this.r.writestate.writesEnabled = true;
            HStore.closeCheckInterval = origWI;
        }
        catch (Throwable throwable) {
            this.r.writestate.writesEnabled = true;
            HStore.closeCheckInterval = origWI;
            for (int i = 0; i < this.compactionThreshold; ++i) {
                Delete delete = new Delete(Bytes.add((byte[])this.STARTROW, (byte[])Bytes.toBytes((int)i)));
                byte[][] famAndQf = new byte[][]{COLUMN_FAMILY, null};
                delete.deleteFamily(famAndQf[0]);
                this.r.delete(delete);
            }
            this.r.flushcache();
            int ttl = 1000;
            for (Store hstore : this.r.stores.values()) {
                HStore store = (HStore)hstore;
                ScanInfo old = store.getScanInfo();
                ScanInfo si = new ScanInfo(old.getFamily(), old.getMinVersions(), old.getMaxVersions(), 1000L, old.getKeepDeletedCells(), 0L, old.getComparator());
                store.setScanInfo(si);
            }
            Thread.sleep(1000L);
            this.r.compactStores(true);
            Assert.assertEquals((long)0L, (long)this.count());
            throw throwable;
        }
        for (int i = 0; i < this.compactionThreshold; ++i) {
            Delete delete = new Delete(Bytes.add((byte[])this.STARTROW, (byte[])Bytes.toBytes((int)i)));
            byte[][] famAndQf = new byte[][]{COLUMN_FAMILY, null};
            delete.deleteFamily(famAndQf[0]);
            this.r.delete(delete);
        }
        this.r.flushcache();
        int ttl = 1000;
        for (Store hstore : this.r.stores.values()) {
            HStore store = (HStore)hstore;
            ScanInfo old = store.getScanInfo();
            ScanInfo si = new ScanInfo(old.getFamily(), old.getMinVersions(), old.getMaxVersions(), 1000L, old.getKeepDeletedCells(), 0L, old.getComparator());
            store.setScanInfo(si);
        }
        Thread.sleep(1000L);
        this.r.compactStores(true);
        Assert.assertEquals((long)0L, (long)this.count());
    }

    private int count() throws IOException {
        int count = 0;
        for (StoreFile f : ((Store)this.r.stores.get(COLUMN_FAMILY_TEXT)).getStorefiles()) {
            HFileScanner scanner = f.getReader().getScanner(false, false);
            if (!scanner.seekTo()) continue;
            do {
                ++count;
            } while (scanner.next());
        }
        return count;
    }

    private void createStoreFile(HRegion region) throws IOException {
        this.createStoreFile(region, Bytes.toString((byte[])COLUMN_FAMILY));
    }

    private void createStoreFile(HRegion region, String family) throws IOException {
        HBaseTestCase.HRegionIncommon loader = new HBaseTestCase.HRegionIncommon(region);
        HBaseTestCase.addContent(loader, family);
        loader.flushcache();
    }

    private void createSmallerStoreFile(HRegion region) throws IOException {
        HBaseTestCase.HRegionIncommon loader = new HBaseTestCase.HRegionIncommon(region);
        HBaseTestCase.addContent(loader, Bytes.toString((byte[])COLUMN_FAMILY), "bbb".getBytes(), null);
        loader.flushcache();
    }

    @Test
    public void testCompactionWithCorruptResult() throws Exception {
        int nfiles = 10;
        for (int i = 0; i < nfiles; ++i) {
            this.createStoreFile(this.r);
        }
        HStore store = (HStore)this.r.getStore(COLUMN_FAMILY);
        Collection storeFiles = store.getStorefiles();
        Compactor tool = store.storeEngine.getCompactor();
        List newFiles = tool.compactForTesting(storeFiles, false);
        FileSystem fs = store.getFileSystem();
        Path dstPath = store.getRegionFileSystem().createTempName();
        FSDataOutputStream stream = fs.create(dstPath, null, true, 512, (short)3, 1024L, null);
        stream.writeChars("CORRUPT FILE!!!!");
        stream.close();
        Path origPath = store.getRegionFileSystem().commitStoreFile(Bytes.toString((byte[])COLUMN_FAMILY), dstPath);
        try {
            store.moveFileIntoPlace(origPath);
        }
        catch (Exception e) {
            assert (fs.exists(origPath));
            assert (!fs.exists(dstPath));
            System.out.println("testCompactionWithCorruptResult Passed");
            return;
        }
        Assert.fail((String)"testCompactionWithCorruptResult failed since no exception wasthrown while completing a corrupt file");
    }

    @Test
    public void testNonUserMajorCompactionRequest() throws Exception {
        Store store = this.r.getStore(COLUMN_FAMILY);
        this.createStoreFile(this.r);
        int i = 0;
        while ((long)i < 11L) {
            this.createStoreFile(this.r);
            ++i;
        }
        store.triggerMajorCompaction();
        CompactionRequest request = store.requestCompaction(Integer.MIN_VALUE, null).getRequest();
        Assert.assertNotNull((String)"Expected to receive a compaction request", (Object)request);
        Assert.assertEquals((String)"System-requested major compaction should not occur if there are too many store files", (Object)false, (Object)request.isMajor());
    }

    @Test
    public void testUserMajorCompactionRequest() throws IOException {
        Store store = this.r.getStore(COLUMN_FAMILY);
        this.createStoreFile(this.r);
        int i = 0;
        while ((long)i < 11L) {
            this.createStoreFile(this.r);
            ++i;
        }
        store.triggerMajorCompaction();
        CompactionRequest request = store.requestCompaction(1, null).getRequest();
        Assert.assertNotNull((String)"Expected to receive a compaction request", (Object)request);
        Assert.assertEquals((String)"User-requested major compaction should always occur, even if there are too many store files", (Object)true, (Object)request.isMajor());
    }

    @Test
    public void testTrackingCompactionRequest() throws Exception {
        HRegionServer mockServer = (HRegionServer)Mockito.mock(HRegionServer.class);
        Mockito.when((Object)mockServer.getConfiguration()).thenReturn((Object)this.r.getBaseConf());
        CompactSplitThread thread = new CompactSplitThread(mockServer);
        Mockito.when((Object)mockServer.getCompactSplitThread()).thenReturn((Object)thread);
        Store store = this.r.getStore(COLUMN_FAMILY);
        this.createStoreFile(this.r);
        int i = 0;
        while ((long)i < 11L) {
            this.createStoreFile(this.r);
            ++i;
        }
        CountDownLatch latch = new CountDownLatch(1);
        TrackableCompactionRequest request = new TrackableCompactionRequest(latch);
        thread.requestCompaction(this.r, store, "test custom comapction", 1, (CompactionRequest)request);
        latch.await();
        thread.interruptIfNecessary();
    }

    @Test
    public void testMultipleCustomCompactionRequests() throws Exception {
        HRegionServer mockServer = (HRegionServer)Mockito.mock(HRegionServer.class);
        Mockito.when((Object)mockServer.getConfiguration()).thenReturn((Object)this.r.getBaseConf());
        CompactSplitThread thread = new CompactSplitThread(mockServer);
        Mockito.when((Object)mockServer.getCompactSplitThread()).thenReturn((Object)thread);
        int numStores = this.r.getStores().size();
        ArrayList<Pair> requests = new ArrayList<Pair>(numStores);
        CountDownLatch latch = new CountDownLatch(numStores);
        for (Store store : this.r.getStores().values()) {
            this.createStoreFile(this.r, store.getColumnFamilyName());
            this.createStoreFile(this.r, store.getColumnFamilyName());
            this.createStoreFile(this.r, store.getColumnFamilyName());
            requests.add(new Pair((Object)new TrackableCompactionRequest(latch), (Object)store));
        }
        thread.requestCompaction(this.r, "test mulitple custom comapctions", 1, Collections.unmodifiableList(requests));
        latch.await();
        thread.interruptIfNecessary();
    }

    @Test
    public void testCompactionQueuePriorities() throws Exception {
        int i;
        Configuration conf = HBaseConfiguration.create();
        HRegionServer mockServer = (HRegionServer)Mockito.mock(HRegionServer.class);
        Mockito.when((Object)mockServer.isStopped()).thenReturn((Object)false);
        Mockito.when((Object)mockServer.getConfiguration()).thenReturn((Object)conf);
        CompactSplitThread cst = new CompactSplitThread(mockServer);
        Mockito.when((Object)mockServer.getCompactSplitThread()).thenReturn((Object)cst);
        HRegion r = (HRegion)Mockito.mock(HRegion.class);
        Mockito.when((Object)r.compact((CompactionContext)Matchers.any(CompactionContext.class), (Store)Matchers.any(Store.class))).then((Answer)new Answer<Boolean>(){

            public Boolean answer(InvocationOnMock invocation) throws Throwable {
                ((CompactionContext)invocation.getArguments()[0]).compact();
                return true;
            }
        });
        ArrayList<Integer> results = new ArrayList<Integer>();
        StoreMockMaker sm = new StoreMockMaker(results);
        StoreMockMaker sm2 = new StoreMockMaker(results);
        Store store = sm.createStoreMock("store1");
        Store store2 = sm2.createStoreMock("store2");
        BlockingStoreMockMaker blocker = new BlockingStoreMockMaker();
        cst.requestSystemCompaction(r, blocker.createStoreMock(1, "b-pri1"), "b-pri1");
        BlockingStoreMockMaker.BlockingCompactionContext currentBlock = blocker.waitForBlocking();
        for (i = 0; i < 4; ++i) {
            sm.notCompacting.add(TestCompaction.createFile());
        }
        cst.requestSystemCompaction(r, store, "s1-pri3");
        for (i = 0; i < 3; ++i) {
            sm2.notCompacting.add(TestCompaction.createFile());
        }
        cst.requestSystemCompaction(r, store2, "s2-pri4");
        for (i = 0; i < 2; ++i) {
            sm.notCompacting.add(TestCompaction.createFile());
        }
        cst.requestSystemCompaction(r, store, "s1-pri1");
        cst.requestSystemCompaction(r, blocker.createStoreMock(2, "b-pri2"), "b-pri2");
        currentBlock.unblock();
        currentBlock = blocker.waitForBlocking();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)6L, (long)results.get(0).intValue());
        for (i = 0; i < 2; ++i) {
            sm.notCompacting.add(TestCompaction.createFile());
        }
        cst.requestSystemCompaction(r, blocker.createStoreMock(7, "b-pri7"), "b-pri7");
        currentBlock.unblock();
        currentBlock = blocker.waitForBlocking();
        Assert.assertEquals((long)3L, (long)results.size());
        Assert.assertEquals((long)3L, (long)results.get(1).intValue());
        Assert.assertEquals((long)2L, (long)results.get(2).intValue());
        currentBlock.unblock();
        cst.interruptIfNecessary();
    }

    private static StoreFile createFile() throws Exception {
        StoreFile sf = (StoreFile)Mockito.mock(StoreFile.class);
        Mockito.when((Object)sf.getPath()).thenReturn((Object)new Path("file"));
        StoreFile.Reader r = (StoreFile.Reader)Mockito.mock(StoreFile.Reader.class);
        Mockito.when((Object)r.length()).thenReturn((Object)10L);
        Mockito.when((Object)sf.getReader()).thenReturn((Object)r);
        return sf;
    }

    static {
        new HBaseTestingUtility();
        UTIL = HBaseTestingUtility.createLocalHTU();
        COLUMN_FAMILY = HBaseTestingUtility.fam1;
        COLUMN_FAMILY_TEXT = COLUMN_FAMILY;
    }

    public static class TrackableCompactionRequest
    extends CompactionRequest {
        private CountDownLatch done;

        public TrackableCompactionRequest(CountDownLatch finished) {
            this.done = finished;
        }

        public void afterExecute() {
            super.afterExecute();
            this.done.countDown();
        }
    }

    public class BlockingStoreMockMaker
    extends StatefulStoreMockMaker {
        BlockingCompactionContext blocked = null;

        @Override
        public CompactionContext selectCompaction() {
            this.blocked = new BlockingCompactionContext();
            try {
                this.blocked.select(null, false, false, false);
            }
            catch (IOException ex) {
                Assert.fail((String)"Shouldn't happen");
            }
            return this.blocked;
        }

        @Override
        public void cancelCompaction(Object object) {
        }

        @Override
        public int getPriority() {
            return Integer.MIN_VALUE;
        }

        public BlockingCompactionContext waitForBlocking() {
            while (this.blocked == null || !this.blocked.isInCompact) {
                Threads.sleepWithoutInterrupt((long)50L);
            }
            BlockingCompactionContext ctx = this.blocked;
            this.blocked = null;
            return ctx;
        }

        @Override
        public Store createStoreMock(String name) throws Exception {
            return this.createStoreMock(Integer.MIN_VALUE, name);
        }

        public Store createStoreMock(int priority, String name) throws Exception {
            Store s = super.createStoreMock(name);
            Mockito.when((Object)s.getCompactPriority()).thenReturn((Object)priority);
            return s;
        }

        public class BlockingCompactionContext
        extends CompactionContext {
            public volatile boolean isInCompact = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void unblock() {
                BlockingCompactionContext blockingCompactionContext = this;
                synchronized (blockingCompactionContext) {
                    ((Object)((Object)this)).notifyAll();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public List<Path> compact() throws IOException {
                try {
                    this.isInCompact = true;
                    BlockingCompactionContext blockingCompactionContext = this;
                    synchronized (blockingCompactionContext) {
                        ((Object)((Object)this)).wait();
                    }
                }
                catch (InterruptedException e) {
                    Assume.assumeNoException((Throwable)e);
                }
                return new ArrayList<Path>();
            }

            public List<StoreFile> preSelect(List<StoreFile> filesCompacting) {
                return new ArrayList<StoreFile>();
            }

            public boolean select(List<StoreFile> f, boolean i, boolean m, boolean e) throws IOException {
                this.request = new CompactionRequest(new ArrayList());
                return true;
            }
        }
    }

    private class StoreMockMaker
    extends StatefulStoreMockMaker {
        public ArrayList<StoreFile> compacting = new ArrayList();
        public ArrayList<StoreFile> notCompacting = new ArrayList();
        private ArrayList<Integer> results;

        public StoreMockMaker(ArrayList<Integer> results) {
            this.results = results;
        }

        @Override
        public synchronized CompactionContext selectCompaction() {
            TestCompactionContext ctx = new TestCompactionContext(new ArrayList<StoreFile>(this.notCompacting));
            this.compacting.addAll(this.notCompacting);
            this.notCompacting.clear();
            try {
                ctx.select(null, false, false, false);
            }
            catch (IOException ex) {
                Assert.fail((String)"Shouldn't happen");
            }
            return ctx;
        }

        @Override
        public synchronized void cancelCompaction(Object object) {
            TestCompactionContext ctx = (TestCompactionContext)((Object)object);
            this.compacting.removeAll(ctx.selectedFiles);
            this.notCompacting.addAll(ctx.selectedFiles);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void finishCompaction(List<StoreFile> sfs) {
            if (sfs.isEmpty()) {
                return;
            }
            ArrayList<Integer> arrayList = this.results;
            synchronized (arrayList) {
                this.results.add(sfs.size());
            }
            this.compacting.removeAll(sfs);
        }

        @Override
        public int getPriority() {
            return 7 - this.compacting.size() - this.notCompacting.size();
        }

        public class TestCompactionContext
        extends CompactionContext {
            private List<StoreFile> selectedFiles;

            public TestCompactionContext(List<StoreFile> selectedFiles) {
                this.selectedFiles = selectedFiles;
            }

            public List<StoreFile> preSelect(List<StoreFile> filesCompacting) {
                return new ArrayList<StoreFile>();
            }

            public boolean select(List<StoreFile> filesCompacting, boolean isUserCompaction, boolean mayUseOffPeak, boolean forceMajor) throws IOException {
                this.request = new CompactionRequest(this.selectedFiles);
                this.request.setPriority(StoreMockMaker.this.getPriority());
                return true;
            }

            public List<Path> compact() throws IOException {
                StoreMockMaker.this.finishCompaction(this.selectedFiles);
                return new ArrayList<Path>();
            }
        }
    }
}

